/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.business.helper.logisticsbill;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.im.business.helper.logisticsbill.LogisticsBillMatch;
import kd.scmc.mobim.business.helper.logisticsbill.LogisticsModelMatch;

public class LogisticsBillModel {
    private Map<String, Collection<DynamicObject>> settleCfgMap = new HashMap<String, Collection<DynamicObject>>(16);

    private LogisticsBillModel() {
    }

    public static LogisticsBillModel getInstance() {
        return new LogisticsBillModel();
    }

    public void matchLogisticsBill(String formId, Collection<DynamicObject> bills) {
        Collection<DynamicObject> cfgs = this.getSettleCfgs(formId);
        this.match(cfgs, bills, formId);
    }

    public void matchLogisticsBill(DynamicObject bill) {
        MainEntityType dataEntityType = (MainEntityType)bill.getDataEntityType();
        String formId = dataEntityType.getName();
        Collection<DynamicObject> cfgs = this.getSettleCfgs(formId);
        this.match(cfgs, bill);
    }

    private void match(Collection<DynamicObject> cfgs, DynamicObject bill) {
        LogisticsModelMatch match;
        MainEntityType dataEntityType = (MainEntityType)bill.getDataEntityType();
        if (dataEntityType.findProperty("isvirtualbill") != null) {
            Boolean isvirtualbill = bill.getBoolean("isvirtualbill");
            DynamicObject bizType = bill.getDynamicObject("biztype");
            boolean VMIBizType = false;
            if (null != bizType) {
                Object domain = bizType.get("domain");
                VMIBizType = "6".equals(domain);
            }
            if (isvirtualbill.booleanValue() && !VMIBizType) {
                return;
            }
        }
        if ((match = this.getLogisticsCfg(cfgs, bill)) == null) {
            DynamicObjectCollection collection = bill.getDynamicObjectCollection("billentry");
            if (collection == null || collection.isEmpty()) {
                return;
            }
            for (int i = 0; i < collection.size(); ++i) {
                DynamicObject entry = (DynamicObject)collection.get(i);
                entry.set("logisticsbill", (Object)false);
            }
        } else {
            match.execute();
        }
    }

    private void match(Collection<DynamicObject> cfgs, Collection<DynamicObject> bills, String formId) {
        HashMap<Object, LogisticsBillMatch> logisticsMap = new HashMap<Object, LogisticsBillMatch>(bills.size());
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)formId);
        IDataEntityProperty findIsVirtualBill = dataEntityType.findProperty("isvirtualbill");
        IDataEntityProperty findIsChargeOff = dataEntityType.findProperty("ischargeoff");
        for (DynamicObject bill : bills) {
            boolean isCharge = findIsChargeOff != null && bill.getBoolean("ischargeoff");
            boolean isVirt = findIsVirtualBill != null && bill.getBoolean("isvirtualbill");
            DynamicObject bizType = bill.getDynamicObject("biztype");
            boolean VMIBizType = false;
            if (null != bizType) {
                Object domain = bizType.get("domain");
                VMIBizType = "6".equals(domain);
            }
            if (isCharge || isVirt && !VMIBizType) continue;
            this.updateLogisticsMap(cfgs, logisticsMap, bill);
            LogisticsBillMatch match = (LogisticsBillMatch)logisticsMap.get(bill.getPkValue());
            if (match != null) {
                match.execute();
                continue;
            }
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entrys) {
                entry.set("logisticsbill", (Object)false);
            }
        }
    }

    private void updateLogisticsMap(Collection<DynamicObject> cfgs, Map<Object, LogisticsBillMatch> logisticsMap, DynamicObject bill) {
        for (DynamicObject cfg : cfgs) {
            LogisticsBillMatch match = LogisticsBillMatch.getInstance((DynamicObject)cfg, (DynamicObject)bill);
            if (!match.isLogistcsBill()) continue;
            Object pkValue = bill.getPkValue();
            LogisticsBillMatch oldMatch = logisticsMap.get(pkValue);
            if (oldMatch == null) {
                logisticsMap.put(pkValue, match);
                continue;
            }
            if (match.getPriority() >= oldMatch.getPriority()) continue;
            logisticsMap.put(pkValue, match);
        }
    }

    private Collection<DynamicObject> getSettleCfgs(String formId) {
        Collection<Object> cfgs = this.settleCfgMap.get(formId);
        if (cfgs != null) {
            return cfgs;
        }
        QFilter billf = new QFilter("bill", "=", (Object)formId);
        QFilter enablef = new QFilter("enable", "=", (Object)true);
        Map cfgMap = BusinessDataServiceHelper.loadFromCache((String)"ism_interorgsettlecfg", (String)"billfilterstr_tag,priority,balanceorg,ownerorg", (QFilter[])billf.and(enablef).toArray());
        cfgs = cfgMap.values();
        if (!cfgMap.isEmpty()) {
            this.settleCfgMap.put(formId, cfgs);
        }
        return cfgs;
    }

    private LogisticsModelMatch getLogisticsCfg(Collection<DynamicObject> cfgs, DynamicObject bill) {
        LogisticsModelMatch match = null;
        for (DynamicObject cfg : cfgs) {
            LogisticsModelMatch modelMatch = LogisticsModelMatch.getInstance(cfg, bill);
            if (!modelMatch.isLogistcsBill() || match != null && modelMatch.getPriority() >= match.getPriority()) continue;
            match = modelMatch;
        }
        return match;
    }

    public Set<Object> getKeySet(String formId) {
        Collection<DynamicObject> cfgs = this.getSettleCfgs(formId);
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)formId);
        HashSet<Object> keySet = new HashSet<Object>(16);
        for (DynamicObject cfg : cfgs) {
            FilterCondition condition;
            FilterBuilder fb;
            String[] script;
            BOSExpression expr;
            Set vars;
            String filterstr;
            String balanceorg = cfg.getString("balanceorg");
            String ownerorg = cfg.getString("ownerorg");
            balanceorg = this.getOrgKey(balanceorg, entityType);
            ownerorg = this.getOrgKey(ownerorg, entityType);
            if (StringUtils.isNotBlank((CharSequence)balanceorg)) {
                keySet.add(balanceorg);
            }
            if (StringUtils.isNotBlank((CharSequence)ownerorg)) {
                keySet.add(ownerorg);
            }
            if (StringUtils.isEmpty((CharSequence)(filterstr = cfg.getString("billfilterstr_tag"))) || (vars = (expr = new BOSExpression((script = (fb = new FilterBuilder(entityType, condition = (FilterCondition)SerializationUtils.fromJsonString((String)filterstr, FilterCondition.class))).buildFilterScript())[0])).getVars()).isEmpty()) continue;
            for (String var : vars) {
                String[] sp = var.split("\\.");
                IDataEntityProperty property = entityType.findProperty(sp[0]);
                if (property == null || property instanceof EntryProp) continue;
                keySet.add(sp[0]);
            }
        }
        return keySet;
    }

    private String getOrgKey(String orgKey, MainEntityType entityType) {
        if (StringUtils.isBlank((CharSequence)orgKey)) {
            return orgKey;
        }
        String[] sp = orgKey.split("\\.");
        IDataEntityProperty prop = entityType.findProperty(sp[0]);
        if (prop == null) {
            return null;
        }
        if (prop instanceof EntryProp) {
            return sp[1];
        }
        return sp[0];
    }
}

