/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.business.helper.logisticsbill;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;

public class LogisticsModelMatch {
    private DynamicObject cfg;
    private DynamicObject bill;
    private int entrySize = 0;
    private Integer priority;

    private LogisticsModelMatch(DynamicObject cfg, DynamicObject bill) {
        this.bill = bill;
        this.cfg = cfg;
        this.priority = cfg.getInt("priority");
        DynamicObjectCollection collection = bill.getDynamicObjectCollection("billentry");
        if (collection != null && !collection.isEmpty()) {
            this.entrySize = collection.size();
        }
    }

    public static LogisticsModelMatch getInstance(DynamicObject cfg, DynamicObject bill) {
        return new LogisticsModelMatch(cfg, bill);
    }

    public boolean isLogistcsBill() {
        String filterstr = this.cfg.getString("billfilterstr_tag");
        if (StringUtils.isEmpty((CharSequence)filterstr)) {
            return true;
        }
        MainEntityType entityType = (MainEntityType)this.bill.getDynamicObjectType();
        FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)filterstr, FilterCondition.class);
        this.updateFilterCondition(condition);
        FilterBuilder fb = new FilterBuilder(entityType, condition);
        String[] script = fb.buildFilterScript();
        BOSExpression expr = new BOSExpression(script[0]);
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        Set vars = expr.getVars();
        if (vars.isEmpty()) {
            return true;
        }
        for (String var : vars) {
            String[] sp = var.split("\\.");
            IDataEntityProperty property = entityType.findProperty(sp[0]);
            if (property == null || property instanceof EntryProp || property instanceof BillStatusProp) continue;
            if (property instanceof MuliLangTextProp) {
                ctx.put(var, ((OrmLocaleValue)this.bill.get(var)).getLocaleValue());
                continue;
            }
            ctx.put(var, this.getProValue(var));
        }
        boolean exec = (Boolean)FormulaEngine.execExcelFormula((Expr)expr.getExpr(), ctx, null);
        return exec;
    }

    private void updateFilterCondition(FilterCondition condition) {
        List filterRow = condition.getFilterRow();
        Iterator it = filterRow.iterator();
        while (it.hasNext()) {
            SimpleFilterRow next = (SimpleFilterRow)it.next();
            String fieldName = next.getFieldName();
            if (StringUtils.isBlank((CharSequence)fieldName) || !fieldName.contains("billentry") && !fieldName.contains("billstatus")) continue;
            it.remove();
        }
    }

    private Object getProValue(String var) {
        String[] sp = var.split("\\.");
        Object value = null;
        for (int i = 0; i < sp.length; ++i) {
            if (i == 0) {
                value = this.bill.get(sp[i]);
                continue;
            }
            if (value == null) {
                return value;
            }
            value = ((DynamicObject)value).get(sp[i]);
        }
        if (value instanceof OrmLocaleValue) {
            value = ((OrmLocaleValue)value).getLocaleValue();
        }
        return value;
    }

    public void execute() {
        String balanceorg = this.cfg.getString("balanceorg");
        String ownerorg = this.cfg.getString("ownerorg");
        if (StringUtils.isBlank((CharSequence)balanceorg) || StringUtils.isBlank((CharSequence)ownerorg)) {
            return;
        }
        MainEntityType entityType = (MainEntityType)this.bill.getDataEntityType();
        Map<Object, DynamicObject> balanceMap = this.getOrgValueMap(entityType, balanceorg);
        Map<Object, DynamicObject> ownerMap = this.getOrgValueMap(entityType, ownerorg);
        this.match(balanceMap, ownerMap);
    }

    private void match(Map<Object, DynamicObject> balanceMap, Map<Object, DynamicObject> ownerMap) {
        DynamicObjectCollection collection = this.bill.getDynamicObjectCollection("billentry");
        if (collection == null || collection.isEmpty()) {
            return;
        }
        for (int i = 0; i < collection.size(); ++i) {
            DynamicObject balance = balanceMap.get(i);
            DynamicObject owner = ownerMap.get(i);
            DynamicObject entry = (DynamicObject)collection.get(i);
            entry.set("logisticsbill", (Object)(balance != null && owner != null && !this.baseEquals(balance, owner) ? 1 : 0));
        }
    }

    public Integer getPriority() {
        return this.priority;
    }

    private Map<Object, DynamicObject> getOrgValueMap(MainEntityType entityType, String orgKey) {
        HashMap<Object, DynamicObject> orgMap = new HashMap<Object, DynamicObject>(this.entrySize);
        String[] sp = orgKey.split("\\.");
        IDataEntityProperty prop = entityType.findProperty(sp[0]);
        if (prop == null) {
            return orgMap;
        }
        DynamicObjectCollection collection = this.bill.getDynamicObjectCollection("billentry");
        if (collection == null || collection.isEmpty()) {
            return orgMap;
        }
        if (prop instanceof EntryProp) {
            orgKey = orgKey.substring(sp[0].length() + 1, orgKey.length());
            for (int i = 0; i < collection.size(); ++i) {
                DynamicObject entry = (DynamicObject)collection.get(i);
                DynamicObject org = entry.getDynamicObject(orgKey);
                if (!this.isOrgType(org)) continue;
                orgMap.put(i, org);
            }
            return orgMap;
        }
        DynamicObject org = this.bill.getDynamicObject(orgKey);
        if (this.isOrgType(org)) {
            for (int i = 0; i < collection.size(); ++i) {
                orgMap.put(i, org);
            }
        }
        return orgMap;
    }

    private boolean isOrgType(DynamicObject org) {
        return org != null && "bos_org".equals(org.getDataEntityType().getName());
    }

    private boolean baseEquals(DynamicObject arg1, DynamicObject arg2) {
        return arg1.getPkValue().equals(arg2.getPkValue());
    }
}

