/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.business.helper.scan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.mobim.business.helper.MobImBillScanHelper;
import kd.scmc.mobim.business.helper.QFilterHelper;
import kd.scmc.msmob.business.helper.BarcodeParseHelper;
import kd.scmc.msmob.common.enums.CodeTypeEnum;
import kd.scmc.msmob.pojo.QrCodeResult;

public class ImBarCodeHandleHelper {
    private static final List<String> CODE_TYPE = Arrays.asList("material", "warehouse", "location");
    private static final List<String> CODE_ENTITY_TYPE = Arrays.asList("bd_material", "bd_warehouse", "bd_location");

    public static Object getWarehouseIdByBarCode(String pcEntityKey, String code, DynamicObject org, QFilter filter) {
        QrCodeResult result = BarcodeParseHelper.qrCodeParse((String)code);
        ImBarCodeHandleHelper.checkResult(result, CodeTypeEnum.WAREHOUSE);
        if (filter == null) {
            filter = QFilterHelper.getIdentEqFilter();
        }
        Long[] allWhs = MobImBillScanHelper.getAllWarehouseIds(pcEntityKey, Long.valueOf(org.getPkValue().toString()));
        filter.and(new QFilter("id", "in", (Object)allWhs));
        Object number = result.getAttribute("number");
        filter.and("number", "=", number);
        String message = String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u4ed3\u5e93\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u626b\u63cf\u3002", (String)"ImBarCodeHandleHelper_getWarehouseIdByBarCode_0", (String)"scmc-mobim-form", (Object[])new Object[0]), new Object[0]);
        return ImBarCodeHandleHelper.getBaseDataIdByScanResult(filter, result, message);
    }

    public static Object getBaseDataIdByScanResult(QFilter filter, QrCodeResult result, String message) {
        List warehouseIds = QueryServiceHelper.queryPrimaryKeys((String)result.getEntityId(), (QFilter[])filter.toArray(), null, (int)2);
        if (warehouseIds.size() == 1) {
            return warehouseIds.get(0);
        }
        throw new KDBizException(message);
    }

    public static Object getLocationIdByBarCode(String code, DynamicObject warehouse, QFilter filter) {
        QrCodeResult result = BarcodeParseHelper.qrCodeParse((String)code);
        ImBarCodeHandleHelper.checkResult(result, CodeTypeEnum.LOCATION);
        Map warehouseNumber = (Map)result.getAttribute("warehouse");
        if (!warehouseNumber.isEmpty() && warehouseNumber.get("number") != null && !warehouseNumber.get("number").equals(warehouse.get("number"))) {
            String message = ResManager.loadKDString((String)"\u8bc6\u522b\u51fa\u4e0e\u5df2\u586b\u5199\u5185\u5bb9\u4e0d\u540c\u7684\u4ed3\u5e93\u4fe1\u606f\uff0c\u8bf7\u5207\u6362\u4ed3\u5e93\u3002", (String)"ImBarCodeHandleHelper_4", (String)"scmc-mobim-form", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        Object locationNumber = result.getAttribute("number");
        DynamicObjectCollection locationCol = warehouse.getDynamicObjectCollection("entryentity");
        List<Long> ids = ImBarCodeHandleHelper.getLocationIds(locationCol);
        filter.and(new QFilter("id", "in", ids));
        filter.and(new QFilter("number", "=", locationNumber));
        String message = String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u4ed3\u4f4d\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u626b\u63cf\u3002", (String)"ImBarCodeHandleHelper_getLocationIdByBarCode_1", (String)"scmc-mobim-form", (Object[])new Object[0]), new Object[0]);
        return ImBarCodeHandleHelper.getBaseDataIdByScanResult(filter, result, message);
    }

    public static List<Long> getLocationIds(DynamicObjectCollection locationCol) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (locationCol.isEmpty()) {
            return ids;
        }
        for (DynamicObject locDym : locationCol) {
            DynamicObject location = locDym.getDynamicObject("location");
            ids.add(Long.valueOf(location.getPkValue().toString()));
        }
        return ids;
    }

    public static void checkResult(QrCodeResult result, CodeTypeEnum codeTypeEnum) {
        String type = result.getCodeType();
        if (result == null || StringUtils.isBlank((String)result.getQrCode())) {
            String errMsg = ResManager.loadKDString((String)"\u626b\u63cf\u65e0\u7ed3\u679c\u3002", (String)"ImBarCodeHandleHelper_0", (String)"scmc-mobim-form", (Object[])new Object[0]);
            throw new KDBizException(errMsg);
        }
        if (!result.isSuccess()) {
            String errMsg = ResManager.loadKDString((String)"\u626b\u63cf\u89e3\u6790\u5931\u8d25\u3002", (String)"ImBarCodeHandleHelper_1", (String)"scmc-mobim-form", (Object[])new Object[0]);
            throw new KDBizException(errMsg);
        }
        if (StringUtils.isBlank((String)type)) {
            String errMsg = ResManager.loadKDString((String)"\u672a\u5b9a\u4e49\u7801\u7c7b\u578b\uff0c\u8bf7\u524d\u5f80\u914d\u7f6e\u3002", (String)"ImBarCodeHandleHelper_2", (String)"scmc-mobim-form", (Object[])new Object[0]);
            throw new KDBizException(errMsg);
        }
        if (!codeTypeEnum.getValue().equals(type)) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u8bf7\u626b\u63cf%s\u3002", (String)"ImBarCodeHandleHelper_3", (String)"scmc-mobim-form", (Object[])new Object[0]), codeTypeEnum.getName());
            throw new KDBizException(errMsg);
        }
        if (CODE_TYPE.contains(type) && CODE_ENTITY_TYPE.contains(result.getEntityId())) {
            return;
        }
        String errMsg = ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7801\u7c7b\u578b\uff0c\u8bf7\u91cd\u65b0\u626b\u63cf\u3002", (String)"ImBarCodeHandleHelper_6", (String)"scmc-mobim-form", (Object[])new Object[0]);
        throw new KDBizException(errMsg);
    }
}

