/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.business.webservicehelper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.mobim.common.enums.BillTypeEnum;
import kd.scmc.mobim.common.enums.InvStatusEnum;
import kd.scmc.mobim.common.utils.RegExpUtils;

public class SpeechRecognitionHelper {
    private static final String ORG = "bos_org";
    private static final String WAREHOUSE = "bd_warehouse";
    private static final String AUDIT = "C";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String INVENTORY = "fisinventory";
    private static final String ENABLE = "enable";
    private static final String STATUS = "status";
    private static final String ORG_ID = "org";
    private static final String WAREHOUSE_ID = "warehouse";
    private static final String INV_STATUS = "invstatus";
    private static final String MATERIAL = "material";
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";

    public static Map<String, String> getInvOrg() {
        String selectFields = "id,name,number";
        QFilter qFilter = new QFilter(INVENTORY, "=", (Object)Boolean.TRUE);
        qFilter.and(ENABLE, "=", (Object)Boolean.TRUE);
        DynamicObjectCollection invOrgs = QueryServiceHelper.query((String)ORG, (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        HashMap<String, String> invOrgMap = new HashMap<String, String>(invOrgs.size());
        for (DynamicObject org : invOrgs) {
            if (org.get(ID) == null || org.get(NAME) == null || org.get(NUMBER) == null) continue;
            invOrgMap.put(org.getString(NAME), org.getString(ID));
        }
        return invOrgMap;
    }

    public static Map<String, String> getWareHouse() {
        String selectFields = "id,name,number";
        QFilter qFilter = new QFilter(STATUS, "=", (Object)AUDIT);
        qFilter.and(ENABLE, "=", (Object)Boolean.TRUE);
        DynamicObjectCollection wareHouses = QueryServiceHelper.query((String)WAREHOUSE, (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        HashMap<String, String> wareHouseMap = new HashMap<String, String>(wareHouses.size());
        for (DynamicObject warHouse : wareHouses) {
            if (warHouse.get(ID) == null || warHouse.get(NAME) == null || warHouse.get(NUMBER) == null) continue;
            wareHouseMap.put(warHouse.getString(NAME), warHouse.getString(ID));
        }
        return wareHouseMap;
    }

    public static String handleJITInvQueryParam(Map<String, Object> params) {
        String invStatusValue = (String)params.get(INV_STATUS);
        String invStatus = InvStatusEnum.getName(invStatusValue);
        StringBuilder urlParam = new StringBuilder("mobile.html?");
        urlParam.append("form=mobim_invquery&");
        urlParam.append("org=").append(params.get(ORG_ID)).append("&");
        urlParam.append("warehouse=").append(params.get(WAREHOUSE_ID)).append("&");
        if (!StringUtils.isEmpty((String)((String)params.get(MATERIAL)))) {
            urlParam.append("material=").append(params.get(MATERIAL)).append("&");
        }
        urlParam.append("invstatus=").append(invStatus);
        String url = urlParam.toString();
        return url;
    }

    public static String handleInAndOutBillParam(Map<String, Object> params) {
        String billType = (String)params.get("biztype");
        String billNum = BillTypeEnum.getName(billType);
        StringBuilder urlParam = new StringBuilder("mobile.html?");
        urlParam.append("form=").append(billNum).append("&");
        urlParam.append("org=").append(params.get(ORG_ID)).append("&");
        urlParam.append("warehouse=").append(params.get(WAREHOUSE_ID)).append("&");
        urlParam.append("startdate=").append(params.get(START_DATE)).append("&");
        urlParam.append("enddate=").append(params.get(END_DATE));
        String material = (String)params.get(MATERIAL);
        if (!StringUtils.isEmpty((String)material) && RegExpUtils.isNumber(material)) {
            urlParam.append("&material=").append(material);
        }
        String url = urlParam.toString();
        return url;
    }

    public static String getFilterParamName(String baseDataId, String entityName) {
        String selectProperties = "id,name,number";
        QFilter qFilter = new QFilter(ID, "=", (Object)Long.valueOf(baseDataId));
        DynamicObject baseData = BusinessDataServiceHelper.loadSingle((String)entityName, (String)selectProperties, (QFilter[])qFilter.toArray());
        if (baseData != null) {
            return baseData.getString(NAME);
        }
        return null;
    }

    public static List<Long> getFilterParamIdList(String baseDataId, String entityName) {
        ArrayList<Long> idList = new ArrayList<Long>(10);
        String selectProperties = "id,name,number";
        String baseDataName = SpeechRecognitionHelper.getFilterParamName(baseDataId, entityName);
        QFilter qFilter = new QFilter(NAME, "=", (Object)baseDataName);
        DynamicObject[] baseDataColl = BusinessDataServiceHelper.load((String)entityName, (String)selectProperties, (QFilter[])qFilter.toArray());
        if (baseDataColl == null || baseDataColl.length == 0) {
            return idList;
        }
        for (DynamicObject baseData : baseDataColl) {
            idList.add((Long)baseData.getPkValue());
        }
        return idList;
    }
}

