/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.common.design.hompage.region;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.mobim.business.helper.AppHomePermissionHelper;
import kd.scmc.msmob.common.design.homepage.region.CheckPermissionMultipleRegion;
import kd.scmc.msmob.common.utils.DateUtils;
import kd.scmc.msmob.pojo.CardData;

public class MobimToDoBusinessRegion
extends CheckPermissionMultipleRegion {
    public MobimToDoBusinessRegion(String id, String parentId, String homePageId, IFormView view) {
        super(id, parentId, homePageId, view);
    }

    public Map<String, Boolean> checkPermission() {
        Map<String, String> controlMap = this.getControlMap();
        Map<String, Boolean> permissionMap = AppHomePermissionHelper.checkPermission(this.getView());
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(4);
        permissionMap.entrySet().stream().filter(entry -> controlMap.containsKey(entry.getKey())).forEach(item -> {
            Boolean cfr_ignored_0 = (Boolean)result.put((String)controlMap.get(item.getKey()), (Boolean)item.getValue());
        });
        return result;
    }

    public void buildControl(ContainerAp<?> homePageContainer, CardData setting, IFormView view) {
        super.buildControl(homePageContainer, setting, view);
        this.setToDoBusinessCard(this.getOrgId());
    }

    public void setToDoBusinessCard(Long orgId) {
        Date startDate = (Date)this.getView().getModel().getValue("todobusiness_startdate");
        Date endDate = (Date)this.getView().getModel().getValue("todobusiness_enddate");
        Label purRecLab = (Label)this.getView().getControl("submitpurreccount");
        Label purInLab = (Label)this.getView().getControl("submitpurincount");
        Label saleOutLab = (Label)this.getView().getControl("submitsaleoutcount");
        this.setToDoBusinessText(orgId, "im_purreceivebill", startDate, endDate, purRecLab);
        this.setToDoBusinessText(orgId, "im_saloutbill", startDate, endDate, saleOutLab);
        this.setToDoBusinessText(orgId, "im_purinbill", startDate, endDate, purInLab);
    }

    private void setToDoBusinessText(Long orgId, String entityName, Date startDate, Date endDate, Label label) {
        int billCount = this.getBillCount(orgId, entityName, startDate, endDate);
        label.setText(billCount + "");
    }

    private int getBillCount(Long orgId, String entityName, Date startDate, Date endDate) {
        Date custEndDate = DateUtils.getDayEndTime((Date)endDate);
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        qFilter.and(new QFilter("billstatus", "=", (Object)"B"));
        qFilter.and(new QFilter("biztime", ">=", (Object)startDate));
        qFilter.and(new QFilter("biztime", "<=", (Object)custEndDate));
        DataSet billCount = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entityName, (String)"id,billno,createtime", (QFilter[])new QFilter[]{qFilter}, null).distinct();
        int count = billCount.count("id", false);
        return count;
    }

    private Map<String, String> getControlMap() {
        HashMap<String, String> keyMap = new HashMap<String, String>(4);
        keyMap.put("mobim_purreceivebill", "submitpurrecflex");
        keyMap.put("out_order_list", "submitsaleoutflex");
        keyMap.put("mobim_purinbill", "submitpurinflex");
        return keyMap;
    }
}

