/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.common.enums;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;

public enum AdjustBusinessType {
    BILLTYPE_ADJUSTBILL(721675267608688640L, false, true, new String[0]),
    BIZTYPE_MATERIALADJUST(688869505400892416L, true, true, new String[0]){

        @Override
        public List<String> getCopyFieldsOnNewEntry() {
            List<String> copyFieldsOnNewEntry = super.getCopyFieldsOnNewEntry();
            copyFieldsOnNewEntry.addAll(Arrays.asList("project", "configuredcode", "tracknumber"));
            return copyFieldsOnNewEntry;
        }
    }
    ,
    BIZTYPE_OTHERADJUST(688869896687512576L, true, false, new String[]{"material", "qty", "unit", "invtype", "invstatus"}){

        @Override
        public List<String> getCopyFieldsOnNewEntry() {
            List<String> copyFieldsOnNewEntry = super.getCopyFieldsOnNewEntry();
            copyFieldsOnNewEntry.addAll(Arrays.asList(COMMON_JUST_FIELDS));
            copyFieldsOnNewEntry.addAll(Arrays.asList(BIZTYPE_OTHERADJUST_FILEDS));
            return copyFieldsOnNewEntry;
        }
    }
    ,
    BIZTYPE_SNADJUST(726537661078051840L, false, false, new String[]{"material", "qty", "unit", "invtype", "invstatus"}){

        @Override
        public void beforeSelectMaterial(BeforeF7SelectEvent e) {
            super.beforeSelectMaterial(e);
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(new QFilter("enableserial", "=", (Object)Boolean.TRUE));
        }

        @Override
        public List<String> getCopyFieldsOnNewEntry() {
            List<String> copyFieldsOnNewEntry = super.getCopyFieldsOnNewEntry();
            copyFieldsOnNewEntry.addAll(Arrays.asList(COMMON_JUST_FIELDS));
            copyFieldsOnNewEntry.addAll(Arrays.asList(BIZTYPE_SNADJUST_FIELDS));
            return copyFieldsOnNewEntry;
        }
    }
    ,
    BIZTYPE_LOTADJUST(688869647461968896L, false, true, new String[]{"material", "unit", "invtype", "invstatus"}){

        @Override
        public List<String> getCopyFieldsOnNewEntry() {
            List<String> copyFieldsOnNewEntry = super.getCopyFieldsOnNewEntry();
            copyFieldsOnNewEntry.addAll(Arrays.asList(COMMON_JUST_FIELDS));
            copyFieldsOnNewEntry.addAll(Arrays.asList(BIZTYPE_LOTADJUST_LOCKFIELDS));
            return copyFieldsOnNewEntry;
        }
    }
    ,
    BIZTYPE_STATUSADJUST(688869765229636608L, false, false, new String[]{"material", "qty", "unit"}){

        @Override
        public List<String> getCopyFieldsOnNewEntry() {
            List<String> copyFieldsOnNewEntry = super.getCopyFieldsOnNewEntry();
            copyFieldsOnNewEntry.addAll(Arrays.asList(COMMON_JUST_FIELDS));
            copyFieldsOnNewEntry.addAll(Arrays.asList(BIZTYPE_STATUSADJUST_FIELDS));
            return copyFieldsOnNewEntry;
        }
    }
    ,
    BIZTYPE_UNITADJUST(726537973494979584L, false, false, new String[]{"material", "qty", "invtype", "invstatus"}){

        @Override
        public List<String> getCopyFieldsOnNewEntry() {
            List<String> copyFieldsOnNewEntry = super.getCopyFieldsOnNewEntry();
            copyFieldsOnNewEntry.addAll(Arrays.asList(COMMON_JUST_FIELDS));
            copyFieldsOnNewEntry.addAll(Arrays.asList(BIZTYPE_UNITADJUST_FIELDS));
            return copyFieldsOnNewEntry;
        }
    }
    ,
    UNKNOWN(-1L, false, true, new String[0]);

    private static final String[] BIZTYPE_OTHERADJUST_FILEDS;
    private static final String[] BIZTYPE_UNITADJUST_FIELDS;
    private static final String[] BIZTYPE_SNADJUST_FIELDS;
    private static final String[] BIZTYPE_STATUSADJUST_FIELDS;
    private static final String[] BIZTYPE_LOTADJUST_LOCKFIELDS;
    private static final String[] COMMON_JUST_FIELDS;
    private static final String[] COMMON_FIELDS;
    private final long bizTypePkValue;
    private final String[] disabledFields;
    private final boolean supportBizTypeSelect;
    private final boolean allowMultipleAfterEntry;

    public void beforeSelectMaterial(BeforeF7SelectEvent e) {
    }

    public List<String> getCopyFieldsOnNewEntry() {
        ArrayList<String> fieldArray = new ArrayList<String>();
        fieldArray.addAll(Arrays.asList(COMMON_FIELDS));
        return fieldArray;
    }

    public static AdjustBusinessType valueOf(DynamicObject bizType) {
        if (bizType == null) {
            return null;
        }
        if (!bizType.getDataEntityType().getName().equals("bd_biztype")) {
            throw new IllegalArgumentException();
        }
        Long bizTypeId = (Long)bizType.getPkValue();
        for (AdjustBusinessType adjustBusinessType : AdjustBusinessType.values()) {
            if (adjustBusinessType.getBizTypePkValue() != bizTypeId.longValue()) continue;
            return adjustBusinessType;
        }
        return UNKNOWN;
    }

    public static Set<AdjustBusinessType> getSupportedBizTypes() {
        return Arrays.stream(AdjustBusinessType.values()).filter(adjustBusinessType -> adjustBusinessType.supportBizTypeSelect).collect(Collectors.toSet());
    }

    private AdjustBusinessType(long bizTypePkValue, boolean supportBizTypeSelect, boolean allowMultipleAfterEntry, String[] disabledFields) {
        this.bizTypePkValue = bizTypePkValue;
        this.supportBizTypeSelect = supportBizTypeSelect;
        this.allowMultipleAfterEntry = allowMultipleAfterEntry;
        this.disabledFields = disabledFields;
    }

    public long getBizTypePkValue() {
        return this.bizTypePkValue;
    }

    public String[] getDisabledFields() {
        return this.disabledFields;
    }

    public boolean isSupportBizTypeSelect() {
        return this.supportBizTypeSelect;
    }

    public boolean isAllowMultipleAfterEntry() {
        return this.allowMultipleAfterEntry;
    }

    static {
        BIZTYPE_OTHERADJUST_FILEDS = new String[]{"lot", "lotnumber", "invstatus"};
        BIZTYPE_UNITADJUST_FIELDS = new String[]{"lot", "lotnumber", "invstatus", "configuredcode", "tracknumber"};
        BIZTYPE_SNADJUST_FIELDS = new String[]{"lot", "lotnumber", "invstatus", "configuredcode", "tracknumber"};
        BIZTYPE_STATUSADJUST_FIELDS = new String[]{"lotnumber", "lot", "configuredcode", "tracknumber"};
        BIZTYPE_LOTADJUST_LOCKFIELDS = new String[]{"invstatus", "configuredcode", "tracknumber"};
        COMMON_JUST_FIELDS = new String[]{"material", "materialmasterid", "auxpty", "expirydate", "producedate", "project", "unit", "qty", "unit2nd", "qtyunit2nd", "baseunit", "baseqty", "invtype"};
        COMMON_FIELDS = new String[]{"warehouse", "location", "owner", "ownertype", "keeper", "keepertype"};
    }
}

