/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.common.enums;

import kd.scmc.mobim.common.design.strategy.BaseDataStrategy;
import kd.scmc.mobim.common.design.strategy.DateTypeStrategy;
import kd.scmc.mobim.common.design.strategy.IDataTypeStrategy;
import kd.scmc.mobim.common.design.strategy.MulBaseDataStrategy;
import kd.scmc.mobim.common.design.strategy.QtyTypeStrategy;
import kd.scmc.mobim.common.design.strategy.TextTypeStrategy;

public enum DataTypeHandle {
    TEXTTYPESET("text", new TextTypeStrategy()),
    QTYTYPESET("qty", new QtyTypeStrategy()),
    MULIBDTYPESET("multibasedata", new MulBaseDataStrategy()),
    BDTYPESET("basedata", new BaseDataStrategy()),
    DATETYPESET("date", new DateTypeStrategy());

    private IDataTypeStrategy dataTypeStrategy;
    private String dataType;

    private DataTypeHandle(String dataType, IDataTypeStrategy dataTypeStrategy) {
        this.dataType = dataType;
        this.dataTypeStrategy = dataTypeStrategy;
    }

    public IDataTypeStrategy getDataTypeStrategy(String dataType) {
        IDataTypeStrategy toStrategy = null;
        for (DataTypeHandle dataTypeHandle : DataTypeHandle.values()) {
            if (!dataTypeHandle.dataType.equals(dataType)) continue;
            toStrategy = dataTypeHandle.dataTypeStrategy;
            break;
        }
        return toStrategy;
    }
}

