/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scmc.mobim.business.helper.PermissionHelper;
import kd.scmc.mobim.common.enums.BillStatusEnum;
import kd.scmc.msmob.business.helper.BarcodeParseHelper;
import kd.scmc.msmob.business.helper.BotpHelper;
import kd.scmc.msmob.common.utils.MetaUtils;
import kd.scmc.msmob.common.utils.PageUtils;
import kd.scmc.msmob.common.utils.ScanResultParseUtils;
import kd.scmc.msmob.pojo.QrCodeResult;

public class AppHomeClick {
    private static final String SCAN_MENU_ID = "scanMenuId";
    private static final String MOBIM_SCAN_PICK_OUT_LIST = "mobim_scanpickout_list";
    private static final String MOBIM_PRODUCEPICKOUTEDIT = "mobim_producepickoutedit";
    private static final String MOBIM_PRODUCEPICKOUTVIEW = "mobim_producepickoutview";
    private final IFormView view;
    private final AbstractMobBillPlugIn plugin;

    public AppHomeClick(AbstractMobBillPlugIn plugin) {
        this.plugin = plugin;
        this.view = plugin.getView();
    }

    public void click(String key, DynamicObject org) {
        String orgNo = org.getString("number");
        Long orgId = org.getLong("id");
        HashMap<String, Object> customParams = new HashMap<String, Object>(3);
        customParams.put("orgBillNo", orgNo);
        customParams.put("orgid", orgId);
        switch (key) {
            case "out_order_list": {
                PageUtils.showFormPage((IFormView)this.view, (String)"mobim_saloutbilllist", customParams, null);
                break;
            }
            case "mobim_purinbill": {
                PageUtils.showFormPage((IFormView)this.view, (String)"mobim_purinbilllist", customParams, null);
                break;
            }
            case "mobim_purreceivebill": {
                PageUtils.showFormPage((IFormView)this.view, (String)"mobim_purreceivelist", customParams, null);
                break;
            }
            case "mobim_materialreqoutbill": {
                PageUtils.showFormPage((IFormView)this.view, (String)"mobim_materialoutpicklist", customParams, null);
                break;
            }
            case "mobim_materialreqbill": {
                PageUtils.showFormPage((IFormView)this.view, (String)"mobim_materialreqbilllist", customParams, null);
                break;
            }
            case "mobim_productinbill": {
                PageUtils.showFormPage((IFormView)this.view, (String)"mobim_productbillinlist", customParams, null);
                break;
            }
            case "mobim_yunrobot": {
                String url = (String)DispatchServiceHelper.invokeBizService((String)"ai", (String)"cbp", (String)"CbpService", (String)"getH5Url", (Object[])new Object[]{"invQuery", "500700215", "Dzbv3ZZDQi2pUAUh856W"});
                this.view.openUrl(url);
                break;
            }
            case "mobim_invquery": {
                PageUtils.showFormPage((IFormView)this.view, (String)"mobim_invquery", customParams, null);
                break;
            }
            case "purrec_purin_add": {
                PageUtils.showFormPage((IFormView)this.view, (String)"mobim_purrectopurinlist", customParams, null);
                break;
            }
            case "purorder_purinbill_add": {
                PageUtils.showFormPage((IFormView)this.view, (String)"mobim_purordtopurinlist", customParams, null);
                break;
            }
            case "mobim_purreceivebilladd": {
                PageUtils.showFormPage((IFormView)this.view, (String)"mobim_pmpurorderlist", customParams, null);
                break;
            }
            case "mobim_otheroutbill": {
                PageUtils.showFormPage((IFormView)this.view, (String)"mobim_otheroutbilllist", customParams, null);
                break;
            }
            case "mobim_otherinbill": {
                PageUtils.showFormPage((IFormView)this.view, (String)"mobim_otherinbilllist", customParams, null);
                break;
            }
            case "mobim_transinbill": {
                PageUtils.showFormPage((IFormView)this.view, (String)"mobim_transinbilllist", customParams, null);
                break;
            }
            case "mobim_transoutbill": {
                PageUtils.showFormPage((IFormView)this.view, (String)"mobim_transoutbilllist", customParams, null);
                break;
            }
            case "mobim_transdirbill": {
                PageUtils.showFormPage((IFormView)this.view, (String)"mobim_transdirbilllist", customParams, null);
                break;
            }
            case "mobim_locationtransfer": {
                PageUtils.showFormPage((IFormView)this.view, (String)"mobim_locationtranslist", customParams, null);
                break;
            }
            case "mobim_mdc_mftmanuinlist": {
                PageUtils.showFormPage((IFormView)this.view, (String)"mobim_mdc_mftmanuinlist", customParams, null);
                break;
            }
            case "mobim_mdc_mftmanuinadd": {
                PageUtils.showFormPage((IFormView)this.view, (String)"mobim_mdc_mftmanuinadd", customParams, null);
                break;
            }
            case "mobim_producepickout": {
                PageUtils.showFormPage((IFormView)this.view, (String)"mobim_producepickoutlist", customParams, null);
                break;
            }
            case "mobim_transapply": {
                PageUtils.showFormPage((IFormView)this.view, (String)"mobim_transapplybilllist", customParams, null);
                break;
            }
            case "mobim_transapplybillbotp": {
                PageUtils.showFormPage((IFormView)this.view, (String)"mobim_transapplybillbotp", customParams, null);
                break;
            }
            case "mobim_delivertosaloutbotp": {
                PageUtils.showFormPage((IFormView)this.view, (String)"mobim_delivertosaloutbotp", customParams, null);
                break;
            }
            case "mobim_materialreqbillbotp": {
                PageUtils.showFormPage((IFormView)this.view, (String)"mobim_materialreqbillbotp", customParams, null);
                break;
            }
            case "mobim_transoutbillbotp": {
                PageUtils.showFormPage((IFormView)this.view, (String)"mobim_transapplybotptoout", customParams, null);
                break;
            }
            case "mobim_transapplytodirbotp": {
                PageUtils.showFormPage((IFormView)this.view, (String)"mobim_transapplybotptodir", customParams, null);
                break;
            }
            case "mobim_transinbillbotp": {
                PageUtils.showFormPage((IFormView)this.view, (String)"mobim_transoutbotptoin", customParams, null);
                break;
            }
            case "mobim_locationtransnew": {
                PageUtils.showFormPage((IFormView)this.view, (String)"mobim_locationtransedit", customParams, null);
                break;
            }
            case "mobim_adjustbilll": {
                PageUtils.showFormPage((IFormView)this.view, (String)"mobim_adjustbilllist", customParams, null);
                break;
            }
            case "mobim_adjustbillnew": {
                PageUtils.showFormPage((IFormView)this.view, (String)"mobim_adjustbillnew", customParams, null);
                break;
            }
            case "mobim_invagereport": {
                PageUtils.showFormPage((IFormView)this.view, (String)"mobim_invbillage_report", customParams, null);
                break;
            }
            case "mobim_countbill": {
                PageUtils.showFormPage((IFormView)this.view, (String)"mobim_countbilllist", customParams, null);
                break;
            }
            case "scan": {
                this.scanClick(orgId, key);
                break;
            }
            case "mobim_mdc_mftmanuinbill": {
                this.scanBarCode(orgId, "mobim_mdc_mftmanuinbill");
                break;
            }
            case "mobim_scanpickout": {
                this.scanBarCode(orgId, MOBIM_SCAN_PICK_OUT_LIST);
                break;
            }
            case "scan_purrec_purin": {
                this.scanBarCode(orgId, "scan_purrec_purin");
                break;
            }
        }
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String value = e.getEventArgs();
        String key = e.getKey();
        if ("callAppMethod".equals(key) && "scanQRCode".equals(eventName)) {
            Map result = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
            Object codeStr = result.get("qrcode_str");
            String scanKey = this.view.getPageCache().get("scan_key");
            if ("scan".equals(scanKey)) {
                this.handleScan(codeStr);
            }
            if (MOBIM_SCAN_PICK_OUT_LIST.equals(scanKey) || "mobim_mdc_mftmanuinbill".equals(scanKey) || "scan_purrec_purin".equals(scanKey)) {
                if (StringUtils.isBlank((CharSequence)String.valueOf(codeStr))) {
                    this.view.showTipNotification(ResManager.loadKDString((String)"\u626b\u63cf\u7ed3\u679c\u4e3a\u7a7a\u3002", (String)"AppHomePlugin_1", (String)"scmc-mobim-form", (Object[])new Object[0]));
                }
                QrCodeResult qrCodeResult = BarcodeParseHelper.qrCodeParse((String)((String)codeStr));
                switch (scanKey) {
                    case "mobim_scanpickout_list": {
                        this.showBill(qrCodeResult, MOBIM_PRODUCEPICKOUTEDIT, MOBIM_PRODUCEPICKOUTVIEW);
                        break;
                    }
                    case "mobim_mdc_mftmanuinbill": {
                        this.push("mobim_mdc_mftmanuinbill", qrCodeResult, "pom_mftorder", "im_mdc_mftmanuinbill", "mobim_mdc_mftmanuinedit");
                        break;
                    }
                    case "scan_purrec_purin": {
                        this.push("scan_purrec_purin", qrCodeResult, "im_purreceivebill", "im_purinbill", "mobim_purinbilledit");
                        break;
                    }
                }
            }
        }
    }

    private void push(String btnKey, QrCodeResult qrCodeResult, String srcEntityKey, String targetEntityKey, String mobilePageKey) {
        Long orgId = Long.parseLong(this.view.getPageCache().get("orgId"));
        String billNo = "bill".equals(qrCodeResult.getCodeType()) ? (String)qrCodeResult.getAttribute("billno") : (String)qrCodeResult.getAttribute("number");
        if (StringUtils.isBlank((CharSequence)billNo)) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u672a\u89e3\u6790\u5230\u6b63\u786e\u7684\u5355\u636e\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AppHomeCommonMorePlugin_2", (String)"scmc-mobim-form", (Object[])new Object[0]));
            return;
        }
        QFilter filter = new QFilter("billno", "=", (Object)billNo);
        filter.and("org", "=", (Object)orgId);
        DynamicObject dataEntity = BusinessDataServiceHelper.loadSingle((String)srcEntityKey, (String)"id,org,billno", (QFilter[])filter.toArray());
        if (dataEntity == null) {
            String msg = "";
            if ("scan_purrec_purin".equals(btnKey)) {
                msg = ResManager.loadKDString((String)"\u5728\u9996\u9875\u7ec4\u7ec7\u4e0b\uff0c\u672a\u627e\u5230\u7f16\u7801\u4e3a%s\u7684\u91c7\u8d2d\u6536\u8d27\u5355\u3002", (String)"AppHomeCommonMorePlugin_0", (String)"scmc-mobim-form", (Object[])new Object[0]);
            } else if ("mobim_mdc_mftmanuinbill".equals(btnKey)) {
                msg = ResManager.loadKDString((String)"\u5728\u9996\u9875\u7ec4\u7ec7\u4e0b\uff0c\u672a\u627e\u5230\u7f16\u7801\u4e3a%s\u7684\u751f\u4ea7\u5de5\u5355\u3002", (String)"AppHomeCommonMorePlugin_1", (String)"scmc-mobim-form", (Object[])new Object[0]);
            }
            String format = String.format(msg, billNo);
            this.view.showTipNotification(format);
            return;
        }
        List<ListSelectedRow> selectedRows = this.getSelectedRows(dataEntity.getPkValue(), "billentry");
        ConvertOperationResult convertResult = BotpHelper.push((String)srcEntityKey, (String)targetEntityKey, selectedRows);
        HashMap<String, ConvertOperationResult> customParams = new HashMap<String, ConvertOperationResult>(16);
        customParams.put("convertResult", convertResult);
        PageUtils.showFormPage((IFormView)this.view, (String)mobilePageKey, customParams, null);
    }

    public List<ListSelectedRow> getSelectedRows(Object pkValue, String pcEntityEntryKey) {
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(4);
        ListSelectedRow row = new ListSelectedRow();
        row.setPrimaryKeyValue(pkValue);
        row.setEntryEntityKey(pcEntityEntryKey);
        selectedRows.add(row);
        return selectedRows;
    }

    private void showBill(QrCodeResult qrCodeResult, String editBill, String viewBill) {
        String billNo = "bill".equals(qrCodeResult.getCodeType()) ? (String)qrCodeResult.getAttribute("billno") : (String)qrCodeResult.getAttribute("number");
        if (StringUtils.isBlank((CharSequence)billNo)) {
            String msg = ResManager.loadKDString((String)"\u672a\u89e3\u6790\u5230\u6b63\u786e\u7684\u5355\u636e\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AppHomeCommonMorePlugin_2", (String)"scmc-mobim-form", (Object[])new Object[0]);
            this.view.showTipNotification(msg);
            return;
        }
        Long orgId = Long.parseLong(this.view.getPageCache().get("orgId"));
        String scanMenu = this.view.getPageCache().get(SCAN_MENU_ID);
        QFilter filter = new QFilter("billno", "=", (Object)billNo);
        filter.and("org", "=", (Object)orgId);
        DynamicObject pickOutBill = BusinessDataServiceHelper.loadSingle((String)"im_mdc_mftproorder", (String)"org,billstatus,billno,id", (QFilter[])filter.toArray());
        if (pickOutBill == null) {
            this.rescan(billNo, MOBIM_SCAN_PICK_OUT_LIST);
            return;
        }
        StringBuilder errMsg = new StringBuilder();
        RequestContext requestContext = RequestContext.get();
        long userId = requestContext.getCurrUserId();
        DynamicObject org = (DynamicObject)pickOutBill.get("org");
        Long currentOrgId = Long.parseLong(org.get("id").toString());
        boolean isView = PermissionHelper.checkPermission(userId, currentOrgId, MetaUtils.getPcAppId((String)"im_mdc_mftproorder"), "im_mdc_mftproorder", "47150e89000000ac");
        if (!isView) {
            String str = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u2018%s\u2019\u7684\u2018\u67e5\u770b\u2019\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650", (String)"MobBillPermissin_1", (String)"scmc-mobim-form", (Object[])new Object[0]);
            String text = String.format(str, billNo);
            this.view.showConfirm(text, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("unsee"));
            return;
        }
        if (BillStatusEnum.SAVE.getValue().equals(pickOutBill.get("billstatus"))) {
            boolean isModify = PermissionHelper.checkPermission(userId, currentOrgId, MetaUtils.getPcAppId((String)"im_mdc_mftproorder"), "im_mdc_mftproorder", "4715a0df000000ac");
            if (!isModify) {
                this.view.getPageCache().put("orgid", orgId.toString());
                this.view.getPageCache().put("billno", pickOutBill.get("billno").toString());
                this.view.getPageCache().put("billid", Long.toString(pickOutBill.getLong("id")));
                this.view.getPageCache().put("viewbill", viewBill);
                this.view.showConfirm(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u4fee\u6539\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002\u662f\u5426\u8fdb\u5165\u67e5\u770b\u9875\u9762\uff1f", (String)"PermissionHelper_1", (String)"scmc-msmob-form", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("modify"));
                return;
            }
            this.view.getPageCache().put("isFromList", "true");
            boolean networkExclusive = MutexHelper.require((IFormView)this.view, (String)"im_mdc_mftproorder", (Object)pickOutBill.get("id"), (String)"modify", (boolean)true, (StringBuilder)errMsg);
            if (!networkExclusive) {
                String billNum = pickOutBill.get("billno").toString();
                long billId = pickOutBill.getLong("id");
                this.view.getPageCache().put("orgid", orgId.toString());
                this.view.getPageCache().put("billno", billNum);
                this.view.getPageCache().put("billid", Long.toString(billId));
                this.view.getPageCache().put("viewbill", viewBill);
                this.view.showConfirm(String.valueOf(errMsg), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("save"));
                return;
            }
        }
        IPageCache pageCache = this.view.getPageCache();
        pageCache.put("MUTEX_ENTITY_KEY", null);
        pageCache.put("MUTEX_OPER_KEY", null);
        pageCache.put("MUTEX_OBJ_ID", null);
        this.scanSkip(orgId, editBill, viewBill, scanMenu, pickOutBill);
    }

    private void scanSkip(Long orgId, String editBill, String viewBill, String scanMenu, DynamicObject bill) {
        if (bill != null && bill.get("billno") != null && bill.get("billstatus") != null) {
            String billNo = bill.get("billno").toString();
            String billStatus = bill.get("billstatus").toString();
            long billId = bill.getLong("id");
            MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
            if (StringUtils.isNotEmpty((CharSequence)billNo) && orgId != null && StringUtils.isNotEmpty((CharSequence)billStatus)) {
                mobileFormShowParameter.setCustomParam("billstatus", (Object)billStatus);
                mobileFormShowParameter.setCustomParam("billno", (Object)billNo);
                mobileFormShowParameter.setCustomParam("billid", (Object)billId);
                mobileFormShowParameter.setCustomParam("orgid", (Object)orgId);
                mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
                String isFromList = this.view.getPageCache().get("isFromList");
                if (isFromList != null) {
                    mobileFormShowParameter.setCustomParam("isFromList", (Object)Boolean.valueOf(isFromList));
                }
                if (BillStatusEnum.SAVE.getValue().equals(billStatus) && !editBill.equals(viewBill)) {
                    mobileFormShowParameter.setFormId(editBill);
                } else {
                    mobileFormShowParameter.setFormId(viewBill);
                }
                this.view.showForm((FormShowParameter)mobileFormShowParameter);
            }
        } else {
            String msg = ResManager.loadKDString((String)"\u626b\u63cf\u7ed3\u679c\u4e3a\u7a7a\u3002", (String)"AppHomePlugin_1", (String)"scmc-mobim-form", (Object[])new Object[0]);
            this.rescan(msg, scanMenu);
        }
    }

    public void handleScan(Object barCode) {
        DynamicObject org = (DynamicObject)this.view.getModel().getValue("org");
        long orgId = org.getLong("id");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this.plugin, "clickScanCallBack");
        ScanResultParseUtils.scanResultParseByType((IFormView)this.view, (Object)barCode, (Long)orgId, (CloseCallBack)closeCallBack);
    }

    public void scanBarCode(Long orgId, String scanMenuId) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("method", "scanQRCode");
        HashMap<String, Integer> args = new HashMap<String, Integer>(8);
        args.put("needResult", 1);
        map.put("args", args);
        this.view.getPageCache().put(SCAN_MENU_ID, scanMenuId);
        this.view.getPageCache().put("scan_key", scanMenuId);
        this.view.getPageCache().put("orgId", String.valueOf(orgId));
        this.view.executeClientCommand("callYZJApi", new Object[]{map});
    }

    private void scanClick(Long orgId, String key) {
        IPageCache pageCache = this.view.getPageCache();
        pageCache.put("scan_key", key);
        this.view.getPageCache().put("orgId", String.valueOf(orgId));
    }

    private void rescan(String barCode, String scanMenu) {
        MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
        mobileFormShowParameter.setCustomParam("barCode", (Object)barCode);
        mobileFormShowParameter.setCustomParam("scanMenu", (Object)scanMenu);
        mobileFormShowParameter.setFormId("mobim_scanbar_prompt_box");
        mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        mobileFormShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.plugin, "rescan"));
        this.view.showForm((FormShowParameter)mobileFormShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        boolean isRescan;
        String actionId = closedCallBackEvent.getActionId();
        if (closedCallBackEvent.getReturnData() != null && StringUtils.equals((CharSequence)actionId, (CharSequence)"rescan")) {
            String scanMenu = (String)closedCallBackEvent.getReturnData();
            Long orgId = Long.parseLong(this.view.getPageCache().get("orgId"));
            this.scanBarCode(orgId, scanMenu);
        }
        Object returnData = closedCallBackEvent.getReturnData();
        boolean bl = isRescan = "clickScanCallBack".equals(actionId) && "rescan".equals(returnData);
        if (isRescan) {
            Long orgId = Long.parseLong(this.view.getPageCache().get("orgId"));
            this.scanBarCode(orgId, "scan");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        boolean isMutexOrModify;
        String callBackId = messageBoxClosedEvent.getCallBackId();
        boolean bl = isMutexOrModify = "save".equals(callBackId) || "modify".equals(callBackId);
        if (isMutexOrModify && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            String billNo = this.view.getPageCache().get("billno");
            String viewBill = this.view.getPageCache().get("viewbill");
            Long billId = Long.parseLong(this.view.getPageCache().get("billid"));
            Long orgId = Long.parseLong(this.view.getPageCache().get("orgid"));
            if (!StringUtils.isEmpty((CharSequence)billNo) && !StringUtils.isEmpty((CharSequence)viewBill)) {
                MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
                formShowParameter.setCustomParam("billno", (Object)billNo);
                formShowParameter.setCustomParam("billid", (Object)billId);
                formShowParameter.setCustomParam("orgid", (Object)orgId);
                formShowParameter.setCustomParam("permission", (Object)"isView");
                formShowParameter.setFormId(viewBill);
                formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
                this.view.showForm((FormShowParameter)formShowParameter);
            }
        }
    }
}

