/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.ai.util.JsonUtil;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.MobileListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scmc.mobim.business.helper.InvokeScanHelper;
import kd.scmc.mobim.business.helper.OrgHelper;
import kd.scmc.mobim.business.helper.PermissionHelper;
import kd.scmc.mobim.common.enums.BillStatusEnum;
import kd.scmc.mobim.common.utils.PropertyValueUtils;
import kd.scmc.msmob.common.utils.MetaUtils;
import org.apache.commons.lang3.StringUtils;

public class AppHomePlugin
extends AbstractMobFormPlugin
implements BeforeF7SelectListener {
    private static final String INV_APP_ID = "=9Q86DR2P+Q";
    private static final String PM_APP_ID = "/JJVO8XV9MVB";
    private static final String ROUTE_META = "sys.meta";
    private static final String SM_APP_KEY = "sm";
    private static final String USER_ORG_UNIT = "userOrgUnit";
    private static final String ENTITY_NUM = "entityNum";
    private static final String PERM_ITEM_ID = "permItemId";
    private static final String MOBIM_PRODUCEPICKOUTEDIT = "mobim_producepickoutedit";
    private static final String MOBIM_PRODUCEPICKOUTVIEW = "mobim_producepickoutview";
    private static final String SCAN_MENU_ID = "scanMenuId";
    private Map<String, HashSet<String>> menuPerms = new HashMap<String, HashSet<String>>(12);
    private Map<String, Map<String, String>> permItems = new HashMap<String, Map<String, String>>(12);
    private String[] button = new String[]{"out_order_list", "purrec_purin_add", "mobim_purinbill", "purorder_purinbill_add", "mobim_purreceivebill", "mobim_purreceivebilladd", "mobim_invquery", "mobim_materialreqbill", "mobim_otheroutbill", "mobim_otherinbill", "mobim_materialreqoutbill", "mobim_transinbill", "mobim_transoutbill", "mobim_transdirbill", "mobim_productinbill", "mobim_locationtransfer", "mobim_mdc_mftmanuinbill", "mobim_mdc_mftmanuinlist", "mobim_producepickout", "mobim_scanpickout", "mobim_mdc_mftmanuinadd", "mobim_yunrobot", "mobim_transapply", "mobim_transapplybillbotp", "mobim_delivertosaloutbotp", "mobim_materialreqbillbotp", "mobim_transoutbillbotp", "mobim_transinbillbotp", "mobim_adjustbilll", "mobim_adjustbillnew"};
    private static final String MOBIM_SCAN_PICK_OUT_LIST = "mobim_scanpickout_list";

    public void initialize() {
        super.initialize();
        OrgEdit orgF7 = (OrgEdit)this.getControl("org");
        orgF7.setOrgFunc("15");
        this.setCheckPermMenu();
        this.setCheckPerm();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(this.button);
        BasedataEdit f7 = (BasedataEdit)this.getControl("org");
        f7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "org": {
                this.beforeOrg(e);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        if (!PropertyValueUtils.isValueChanged(e, 0)) {
            return;
        }
        switch (key = e.getProperty().getName()) {
            case "org": {
                this.orgChange();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Long orgId = Long.parseLong(this.getPageCache().get("orgId"));
        if (closedCallBackEvent.getReturnData() != null && StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"rescan")) {
            String scanMenu = (String)closedCallBackEvent.getReturnData();
            this.scanBarCode(orgId, scanMenu);
        }
    }

    public void orgChange() {
        Object org = this.getModel().getValue("org");
        if (org != null) {
            Long orgId = (Long)((DynamicObject)org).getPkValue();
            String orgUnit = this.getPageCache().get(USER_ORG_UNIT);
            List userOrgList = (List)JsonUtil.decodeFromString((String)orgUnit, List.class);
            boolean isOwn = false;
            for (Object userOrg : userOrgList) {
                if (!String.valueOf(userOrg).equals(String.valueOf(orgId))) continue;
                isOwn = true;
                break;
            }
            if (!isOwn) {
                this.setOrg();
            }
        }
        this.checkPermission();
    }

    private void beforeOrg(BeforeF7SelectEvent e) {
        FormShowParameter formShowParameter = e.getFormShowParameter();
        RequestContext requestContext = RequestContext.get();
        long userId = Long.parseLong(requestContext.getUserId());
        HasPermOrgResult hasPermOrgs = PermissionServiceHelper.getUserHasPermOrgs((long)userId);
        if (!hasPermOrgs.hasAllOrgPerm()) {
            List orgIdList = hasPermOrgs.getHasPermOrgs();
            formShowParameter.setCustomParam("range", (Object)orgIdList);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"AppHomePluginClick_0", (String)"scmc-mobim-form", (Object[])new Object[0]));
            return;
        }
        String orgNo = org.getString("number");
        Long orgId = org.getLong("id");
        MobileListShowParameter listShowParameter = new MobileListShowParameter();
        MobileFormShowParameter billShowParameter = new MobileFormShowParameter();
        switch (key) {
            case "out_order_list": {
                this.goUrl(orgNo, orgId, billShowParameter, "mobim_saloutbilllist");
                break;
            }
            case "mobim_purinbill": {
                this.goUrl(orgNo, orgId, billShowParameter, "mobim_purinbilllist");
                break;
            }
            case "purrec_purin_add": {
                this.goUrl(orgNo, orgId, billShowParameter, "mobim_purrectopurinlist");
                break;
            }
            case "purorder_purinbill_add": {
                this.goUrl(orgNo, orgId, billShowParameter, "mobim_purordtopurinlist");
                break;
            }
            case "mobim_purreceivebilladd": {
                this.goUrl(orgNo, orgId, billShowParameter, "mobim_pmpurorderlist");
                break;
            }
            case "mobim_purreceivebill": {
                this.goUrl(orgNo, orgId, billShowParameter, "mobim_purreceivelist");
                break;
            }
            case "mobim_otheroutbill": {
                this.goUrl(orgNo, orgId, billShowParameter, "mobim_otheroutbilllist");
                break;
            }
            case "mobim_otherinbill": {
                this.goUrl(orgNo, orgId, billShowParameter, "mobim_otherinbilllist");
                break;
            }
            case "mobim_materialreqoutbill": {
                this.goUrl(orgNo, orgId, billShowParameter, "mobim_materialoutpicklist");
                break;
            }
            case "mobim_transinbill": {
                this.goUrl(orgNo, orgId, billShowParameter, "mobim_transinbilllist");
                break;
            }
            case "mobim_transoutbill": {
                this.goUrl(orgNo, orgId, billShowParameter, "mobim_transoutbilllist");
                break;
            }
            case "mobim_materialreqbill": {
                this.goUrl(orgNo, orgId, billShowParameter, "mobim_materialreqbilllist");
                break;
            }
            case "mobim_transdirbill": {
                this.goUrl(orgNo, orgId, billShowParameter, "mobim_transdirbilllist");
                break;
            }
            case "mobim_productinbill": {
                this.goUrl(orgNo, orgId, billShowParameter, "mobim_productbillinlist");
                break;
            }
            case "mobim_locationtransfer": {
                this.goUrl(orgNo, orgId, billShowParameter, "mobim_locationtranslist");
                break;
            }
            case "mobim_invquery": {
                this.goUrl(orgNo, orgId, billShowParameter, "mobim_invquery");
                break;
            }
            case "mobim_mdc_mftmanuinbill": {
                this.scanBarCode(orgId, "mobim_mdc_mftmanuinbill");
                break;
            }
            case "mobim_mdc_mftmanuinlist": {
                this.goUrl(orgNo, orgId, billShowParameter, "mobim_mdc_mftmanuinlist");
                break;
            }
            case "mobim_mdc_mftmanuinadd": {
                this.goUrl(orgNo, orgId, billShowParameter, "mobim_mdc_mftmanuinadd");
                break;
            }
            case "mobim_producepickout": {
                this.goUrl(orgNo, orgId, billShowParameter, "mobim_producepickoutlist");
                break;
            }
            case "mobim_scanpickout": {
                this.scanBarCode(orgId, MOBIM_SCAN_PICK_OUT_LIST);
                break;
            }
            case "mobim_transapply": {
                this.goUrl(orgNo, orgId, billShowParameter, "mobim_transapplybilllist");
                break;
            }
            case "mobim_yunrobot": {
                String url = (String)DispatchServiceHelper.invokeBizService((String)"ai", (String)"cbp", (String)"CbpService", (String)"getH5Url", (Object[])new Object[]{"invQuery", "500700215", "Dzbv3ZZDQi2pUAUh856W"});
                this.getView().openUrl(url);
                break;
            }
            case "mobim_transapplybillbotp": {
                this.goUrl(orgNo, orgId, billShowParameter, "mobim_transapplybillbotp");
                break;
            }
            case "mobim_delivertosaloutbotp": {
                this.goUrl(orgNo, orgId, billShowParameter, "mobim_delivertosaloutbotp");
                break;
            }
            case "mobim_materialreqbillbotp": {
                this.goUrl(orgNo, orgId, billShowParameter, "mobim_materialreqbillbotp");
                break;
            }
            case "mobim_transoutbillbotp": {
                this.goUrl(orgNo, orgId, billShowParameter, "mobim_transapplybotptoout");
                break;
            }
            case "mobim_transinbillbotp": {
                this.goUrl(orgNo, orgId, billShowParameter, "mobim_transoutbotptoin");
                break;
            }
            case "mobim_adjustbilll": {
                this.goUrl(orgNo, orgId, billShowParameter, "mobim_adjustbilllist");
                break;
            }
            case "mobim_adjustbillnew": {
                this.goUrl(orgNo, orgId, billShowParameter, "mobim_adjustbillnew");
                break;
            }
        }
    }

    private void goUrl(String orgNo, Long orgId, MobileListShowParameter listShowParameter, String purInBill) {
        listShowParameter.setBillFormId(purInBill);
        listShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        listShowParameter.setCustomParam("orgBillNo", (Object)orgNo);
        listShowParameter.setCustomParam("orgid", (Object)orgId);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void goUrl(String orgNo, Long orgId, MobileFormShowParameter formShowParameter, String purInBill) {
        formShowParameter.setFormId(purInBill);
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        formShowParameter.setCustomParam("orgBillNo", (Object)orgNo);
        formShowParameter.setCustomParam("orgid", (Object)orgId);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void afterCreateNewData(EventObject e) {
        this.setOrg();
        this.checkPermission();
    }

    private void checkPermission() {
        Object org = this.getModel().getValue("org");
        if (org != null) {
            Long orgId = (Long)((DynamicObject)org).getPkValue();
            HashMap<String, Boolean> permMap = new HashMap<String, Boolean>(this.permItems.size());
            RequestContext requestContext = RequestContext.get();
            long userId = Long.parseLong(requestContext.getUserId());
            for (Map.Entry<String, Map<String, String>> perms : this.permItems.entrySet()) {
                Map<String, String> perm = perms.getValue();
                String permKey = perms.getKey();
                boolean b = PermissionHelper.checkPermission(userId, orgId, INV_APP_ID, perm.get(ENTITY_NUM), perm.get(PERM_ITEM_ID));
                permMap.put(permKey, b);
            }
            this.handleMenu(permMap);
        }
    }

    private void handleMenu(Map<String, Boolean> permMap) {
        Set keys;
        HashMap<Boolean, HashSet<String>> visibleMap = new HashMap<Boolean, HashSet<String>>(8);
        for (Map.Entry<String, HashSet<String>> perms : this.menuPerms.entrySet()) {
            HashSet<String> items;
            HashSet<String> permSet = perms.getValue();
            String menuKey = perms.getKey();
            Boolean isPerm = Boolean.TRUE;
            Boolean orgType = this.handleMenuOrgType(menuKey);
            if (orgType.booleanValue()) {
                if (!"mobim_invquery".equals(menuKey)) {
                    for (String permKey : permSet) {
                        Boolean permValue = permMap.get(permKey);
                        if (permValue.booleanValue()) continue;
                        isPerm = Boolean.FALSE;
                        break;
                    }
                }
            } else {
                isPerm = orgType;
            }
            if ((items = (HashSet<String>)visibleMap.get(isPerm)) == null) {
                items = new HashSet<String>(8);
            }
            items.add(menuKey);
            visibleMap.put(isPerm, items);
        }
        Set isPermKeys = (Set)visibleMap.get(Boolean.TRUE);
        if (isPermKeys != null && !isPermKeys.isEmpty()) {
            this.getView().setVisible(Boolean.TRUE, isPermKeys.toArray(new String[0]));
        }
        if ((keys = (Set)visibleMap.get(Boolean.FALSE)) != null && !keys.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, ((Set)visibleMap.get(Boolean.FALSE)).toArray(new String[0]));
        }
    }

    private Boolean handleMenuOrgType(String menuKey) {
        Object org = this.getModel().getValue("org");
        Long orgId = (Long)((DynamicObject)org).getPkValue();
        switch (menuKey) {
            case "out_order_list": 
            case "mobim_purinbill": 
            case "purrec_purin_add": 
            case "mobim_purreceivebill": 
            case "mobim_otheroutbill": 
            case "mobim_otherinbill": 
            case "mobim_transoutbill": 
            case "mobim_transinbill": 
            case "mobim_materialreqoutbill": 
            case "mobim_transdirbill": 
            case "mobim_productinbill": 
            case "mobim_locationtransfer": 
            case "mobim_mdc_mftmanuinlist": 
            case "mobim_producepickout": 
            case "mobim_mdc_mftmanuinbill": 
            case "mobim_mdc_mftmanuinadd": 
            case "mobim_materialreqbillbotp": 
            case "mobim_scanpickout": 
            case "mobim_transapplybilllist": 
            case "mobim_transoutbillbotp": 
            case "mobim_transinbillbotp": 
            case "mobim_adjustbilll": 
            case "mobim_adjustbillnew": {
                return this.checkOrgInventory(orgId);
            }
            case "purorder_purinbill_add": 
            case "mobim_purreceivebilladd": {
                return this.checkViewPermOfOrg(orgId, "pm_purorderbill", OrgViewTypeEnum.IS_PURCHASE.getViewType(), PM_APP_ID);
            }
            case "mobim_transapplybillbotp": {
                return this.checkViewPermOfOrg(orgId, "sm_salorder", OrgViewTypeEnum.IS_SALE.getViewType(), SM_APP_KEY);
            }
            case "mobim_delivertosaloutbotp": {
                return this.checkViewPermOfOrg(orgId, "sm_delivernotice", OrgViewTypeEnum.IS_SALE.getViewType(), SM_APP_KEY);
            }
            case "mobim_invquery": {
                return this.checkInvQuery();
            }
        }
        return Boolean.TRUE;
    }

    private Boolean checkInvQuery() {
        String orgUnit = this.getPageCache().get(USER_ORG_UNIT);
        List userOrgList = (List)JsonUtil.decodeFromString((String)orgUnit, List.class);
        RequestContext requestContext = RequestContext.get();
        long userId = Long.parseLong(requestContext.getUserId());
        Boolean isOwn = Boolean.FALSE;
        if (userOrgList != null && userOrgList.size() > 0) {
            for (Object orgId : userOrgList) {
                boolean isPerm = PermissionHelper.checkPermission(userId, Long.parseLong(String.valueOf(orgId)), INV_APP_ID, "im_invaccreport", "47150e89000000ac");
                if (!isPerm) continue;
                isOwn = Boolean.TRUE;
                break;
            }
        }
        return isOwn;
    }

    private Boolean checkViewPermOfOrg(Long orgId, String pcEntityKey, String fromOrgType, String entrustedAppId) {
        Boolean isInv = this.checkOrgInventory(orgId);
        if (!isInv.booleanValue()) {
            return Boolean.FALSE;
        }
        List orgList = OrgUnitServiceHelper.getFromOrgs((String)OrgViewTypeEnum.IS_INVENTORY.getViewType(), (Long)orgId, (String)fromOrgType, (boolean)true);
        if (orgList == null || orgList.isEmpty()) {
            return Boolean.FALSE;
        }
        return this.checkEntrustedOrgPerm(orgList, entrustedAppId, pcEntityKey, "47150e89000000ac");
    }

    private Boolean checkEntrustedOrgPerm(List<Long> entrustedOrgs, String entrustedAppId, String entrustedEntityKey, String permItem) {
        String orgUnit = this.getPageCache().get(USER_ORG_UNIT);
        List userOrgList = (List)JsonUtil.decodeFromString((String)orgUnit, List.class);
        ArrayList<Long> userPermList = new ArrayList<Long>(entrustedOrgs.size());
        for (Long pmOrg : entrustedOrgs) {
            for (Object userOrg : userOrgList) {
                if (!String.valueOf(userOrg).equals(String.valueOf(pmOrg))) continue;
                userPermList.add(pmOrg);
            }
        }
        if (userPermList.isEmpty()) {
            return Boolean.FALSE;
        }
        RequestContext requestContext = RequestContext.get();
        long userId = Long.parseLong(requestContext.getUserId());
        Boolean hasPerm = Boolean.FALSE;
        for (Long permOrgId : userPermList) {
            boolean result = PermissionHelper.checkPermission(userId, permOrgId, entrustedAppId, entrustedEntityKey, permItem);
            if (!result) continue;
            hasPerm = Boolean.TRUE;
            break;
        }
        return hasPerm;
    }

    private Boolean checkOrgInventory(Long orgId) {
        List list = OrgUnitServiceHelper.filterOrgDuty(Collections.singletonList(orgId), (String)"05");
        if (list == null || list.isEmpty()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void setCheckPermMenu() {
        HashSet<String> purInMenu = new HashSet<String>(2);
        purInMenu.add("purinbill_view");
        this.menuPerms.put("mobim_purinbill", purInMenu);
        HashSet<String> purRecMenu = new HashSet<String>(2);
        purRecMenu.add("purrecbill_view");
        this.menuPerms.put("mobim_purreceivebill", purRecMenu);
        HashSet<String> saleOutMenu = new HashSet<String>(2);
        saleOutMenu.add("saleoutbill_view");
        this.menuPerms.put("out_order_list", saleOutMenu);
        HashSet<String> purRecNewMenu = new HashSet<String>(2);
        purRecNewMenu.add("purrecbill_new");
        purRecNewMenu.add("purrecbill_view");
        this.menuPerms.put("mobim_purreceivebilladd", purRecNewMenu);
        HashSet<String> purInByPurRecMenu = new HashSet<String>(2);
        purInByPurRecMenu.add("purrecbill_view");
        purInByPurRecMenu.add("purinbill_new");
        purInByPurRecMenu.add("purinbill_view");
        this.menuPerms.put("purrec_purin_add", purInByPurRecMenu);
        HashSet<String> purInByPurOrderMenu = new HashSet<String>(2);
        purInByPurOrderMenu.add("purinbill_new");
        purInByPurOrderMenu.add("purinbill_view");
        this.menuPerms.put("purorder_purinbill_add", purInByPurOrderMenu);
        HashSet<String> materialReqMenu = new HashSet<String>(2);
        materialReqMenu.add("materialreqbill_view");
        this.menuPerms.put("mobim_materialreqbill", materialReqMenu);
        HashSet<String> otherOutMenu = new HashSet<String>(2);
        otherOutMenu.add("otheroutbill_view");
        this.menuPerms.put("mobim_otheroutbill", otherOutMenu);
        HashSet<String> otherInMenu = new HashSet<String>(2);
        otherInMenu.add("otherinbill_view");
        this.menuPerms.put("mobim_otherinbill", otherInMenu);
        HashSet<String> proInMenu = new HashSet<String>(2);
        proInMenu.add("proinbill_view");
        this.menuPerms.put("mobim_productinbill", proInMenu);
        HashSet<String> materReqOutMenu = new HashSet<String>(2);
        materReqOutMenu.add("materialreqoutbill_view");
        this.menuPerms.put("mobim_materialreqoutbill", materReqOutMenu);
        HashSet<String> transDirMenu = new HashSet<String>(2);
        transDirMenu.add("transdirbill_view");
        this.menuPerms.put("mobim_transdirbill", transDirMenu);
        HashSet<String> transOutMenu = new HashSet<String>(2);
        transOutMenu.add("transoutbill_view");
        transOutMenu.add("transoutbill_new");
        this.menuPerms.put("mobim_transoutbill", transOutMenu);
        HashSet<String> transInMenu = new HashSet<String>(2);
        transInMenu.add("transinbill_view");
        transInMenu.add("transinbill_new");
        this.menuPerms.put("mobim_transinbill", transInMenu);
        HashSet<String> locationTransMenu = new HashSet<String>(2);
        locationTransMenu.add("locationtrans_view");
        this.menuPerms.put("mobim_locationtransfer", locationTransMenu);
        HashSet<String> invAccReportMenu = new HashSet<String>(2);
        invAccReportMenu.add("invaccreport_view");
        this.menuPerms.put("mobim_invquery", invAccReportMenu);
        HashSet<String> manufactureInMenu = new HashSet<String>(2);
        manufactureInMenu.add("manufactureinmenu_view");
        this.menuPerms.put("mobim_mdc_mftmanuinlist", manufactureInMenu);
        HashSet<String> producePickMenu = new HashSet<String>(2);
        producePickMenu.add("producepick_view");
        this.menuPerms.put("mobim_producepickout", producePickMenu);
        HashSet<String> scanPickOutMenu = new HashSet<String>(2);
        scanPickOutMenu.add("producepick_view");
        this.menuPerms.put("mobim_scanpickout", scanPickOutMenu);
        HashSet<String> manufactureInAddMenu = new HashSet<String>(2);
        manufactureInAddMenu.add("manufactureinmenu_new");
        manufactureInAddMenu.add("mftorder_view");
        this.menuPerms.put("mobim_mdc_mftmanuinadd", manufactureInAddMenu);
        HashSet<String> scanManufactureInAddMenu = new HashSet<String>(2);
        scanManufactureInAddMenu.add("manufactureinmenu_new");
        scanManufactureInAddMenu.add("mftorder_view");
        this.menuPerms.put("mobim_mdc_mftmanuinbill", scanManufactureInAddMenu);
        HashSet<String> transApplyBillBotpMenu = new HashSet<String>(2);
        transApplyBillBotpMenu.add("transapplybill_view");
        transApplyBillBotpMenu.add("transapplybill_new");
        this.menuPerms.put("mobim_transapplybillbotp", transApplyBillBotpMenu);
        HashSet<String> deliverToSalOutBotpMenu = new HashSet<String>(16);
        deliverToSalOutBotpMenu.add("saleoutbill_new");
        deliverToSalOutBotpMenu.add("saleoutbill_view");
        this.menuPerms.put("mobim_delivertosaloutbotp", deliverToSalOutBotpMenu);
        HashSet<String> materialReqBillBotpMenu = new HashSet<String>(2);
        materialReqBillBotpMenu.add("materialreqbill_view");
        materialReqBillBotpMenu.add("materialreqoutbill_new");
        materialReqBillBotpMenu.add("materialreqoutbill_view");
        this.menuPerms.put("mobim_materialreqbillbotp", materialReqBillBotpMenu);
        HashSet adjustMenu = new HashSet(2);
        transDirMenu.add("adjustbill_view");
        this.menuPerms.put("mobim_adjustbilll", adjustMenu);
        HashSet adjustNewMenu = new HashSet(2);
        transDirMenu.add("adjustbill_new");
        transDirMenu.add("adjustbill_view");
        this.menuPerms.put("mobim_adjustbillnew", adjustNewMenu);
    }

    private void setCheckPerm() {
        HashMap<String, String> purInPerms = new HashMap<String, String>(3);
        purInPerms.put(ENTITY_NUM, "im_purinbill");
        purInPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        this.permItems.put("purinbill_view", purInPerms);
        HashMap<String, String> purRecPerms = new HashMap<String, String>(3);
        purRecPerms.put(ENTITY_NUM, "im_purreceivebill");
        purRecPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        this.permItems.put("purrecbill_view", purRecPerms);
        HashMap<String, String> saleOutPerms = new HashMap<String, String>(3);
        saleOutPerms.put(ENTITY_NUM, "im_saloutbill");
        saleOutPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        this.permItems.put("saleoutbill_view", saleOutPerms);
        HashMap<String, String> saleOutNewPerms = new HashMap<String, String>(3);
        saleOutNewPerms.put(ENTITY_NUM, "im_saloutbill");
        saleOutNewPerms.put(PERM_ITEM_ID, "47156aff000000ac");
        this.permItems.put("saleoutbill_new", saleOutNewPerms);
        HashMap<String, String> purInNewPerms = new HashMap<String, String>(3);
        purInNewPerms.put(ENTITY_NUM, "im_purinbill");
        purInNewPerms.put(PERM_ITEM_ID, "47156aff000000ac");
        this.permItems.put("purinbill_new", purInNewPerms);
        HashMap<String, String> purRecNewPerms = new HashMap<String, String>(3);
        purRecNewPerms.put(ENTITY_NUM, "im_purreceivebill");
        purRecNewPerms.put(PERM_ITEM_ID, "47156aff000000ac");
        this.permItems.put("purrecbill_new", purRecNewPerms);
        HashMap<String, String> materialReqPerms = new HashMap<String, String>(3);
        materialReqPerms.put(ENTITY_NUM, "im_materialreqbill");
        materialReqPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        this.permItems.put("materialreqbill_view", materialReqPerms);
        HashMap<String, String> otherOutPerms = new HashMap<String, String>(3);
        otherOutPerms.put(ENTITY_NUM, "im_otheroutbill");
        otherOutPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        this.permItems.put("otheroutbill_view", otherOutPerms);
        HashMap<String, String> otherInPerms = new HashMap<String, String>(3);
        otherInPerms.put(ENTITY_NUM, "im_otherinbill");
        otherInPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        this.permItems.put("otherinbill_view", otherInPerms);
        HashMap<String, String> proInPerms = new HashMap<String, String>(3);
        proInPerms.put(ENTITY_NUM, "im_productinbill");
        proInPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        this.permItems.put("proinbill_view", proInPerms);
        HashMap<String, String> materReqOutPerms = new HashMap<String, String>(3);
        materReqOutPerms.put(ENTITY_NUM, "im_materialreqoutbill");
        materReqOutPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        this.permItems.put("materialreqoutbill_view", materReqOutPerms);
        HashMap<String, String> materReqOutNewPerms = new HashMap<String, String>(3);
        materReqOutNewPerms.put(ENTITY_NUM, "im_materialreqoutbill");
        materReqOutNewPerms.put(PERM_ITEM_ID, "47156aff000000ac");
        this.permItems.put("materialreqoutbill_new", materReqOutNewPerms);
        HashMap<String, String> transDirPerms = new HashMap<String, String>(3);
        transDirPerms.put(ENTITY_NUM, "im_transdirbill");
        transDirPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        this.permItems.put("transdirbill_view", transDirPerms);
        HashMap<String, String> transOutPerms = new HashMap<String, String>(3);
        transOutPerms.put(ENTITY_NUM, "im_transoutbill");
        transOutPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        this.permItems.put("transoutbill_view", transOutPerms);
        HashMap<String, String> transInPerms = new HashMap<String, String>(3);
        transInPerms.put(ENTITY_NUM, "im_transinbill");
        transInPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        this.permItems.put("transinbill_view", transInPerms);
        HashMap<String, String> locationTransPerms = new HashMap<String, String>(3);
        locationTransPerms.put(ENTITY_NUM, "im_locationtransfer");
        locationTransPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        this.permItems.put("locationtrans_view", locationTransPerms);
        HashMap<String, String> invAccReportPerms = new HashMap<String, String>(3);
        invAccReportPerms.put(ENTITY_NUM, "im_invaccreport");
        invAccReportPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        this.permItems.put("invaccreport_view", invAccReportPerms);
        HashMap<String, String> manufactureInPerms = new HashMap<String, String>(3);
        manufactureInPerms.put(ENTITY_NUM, "im_mdc_mftmanuinbill");
        manufactureInPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        this.permItems.put("manufactureinmenu_view", manufactureInPerms);
        HashMap<String, String> manufactureNewPerms = new HashMap<String, String>(3);
        manufactureNewPerms.put(ENTITY_NUM, "im_mdc_mftmanuinbill");
        manufactureNewPerms.put(PERM_ITEM_ID, "47156aff000000ac");
        this.permItems.put("manufactureinmenu_new", manufactureNewPerms);
        HashMap<String, String> producePickPerms = new HashMap<String, String>(3);
        producePickPerms.put(ENTITY_NUM, "im_mdc_mftproorder");
        producePickPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        this.permItems.put("producepick_view", producePickPerms);
        HashMap<String, String> mftOrderPerms = new HashMap<String, String>(3);
        mftOrderPerms.put(ENTITY_NUM, "pom_mftorder");
        mftOrderPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        this.permItems.put("mftorder_view", mftOrderPerms);
        HashMap<String, String> transapplyPerms = new HashMap<String, String>(3);
        transapplyPerms.put(ENTITY_NUM, "im_transapply");
        transapplyPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        this.permItems.put("transapplybill_view", transapplyPerms);
        HashMap<String, String> transapplyNewPerms = new HashMap<String, String>(3);
        transapplyNewPerms.put(ENTITY_NUM, "im_transapply");
        transapplyNewPerms.put(PERM_ITEM_ID, "47156aff000000ac");
        this.permItems.put("transapplybill_new", transapplyNewPerms);
        HashMap<String, String> transOutNewPerms = new HashMap<String, String>(3);
        transOutNewPerms.put(ENTITY_NUM, "im_transoutbill");
        transOutNewPerms.put(PERM_ITEM_ID, "47156aff000000ac");
        this.permItems.put("transoutbill_new", transOutNewPerms);
        HashMap<String, String> transInNewPerms = new HashMap<String, String>(3);
        transInNewPerms.put(ENTITY_NUM, "im_transinbill");
        transInNewPerms.put(PERM_ITEM_ID, "47156aff000000ac");
        this.permItems.put("transinbill_new", transInNewPerms);
        HashMap adjustPerms = new HashMap(3);
        transapplyPerms.put(ENTITY_NUM, "im_adjustbill");
        transapplyPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        this.permItems.put("adjustbill_view", adjustPerms);
        HashMap adjustNewPerms = new HashMap(3);
        transapplyPerms.put(ENTITY_NUM, "im_adjustbill");
        transapplyPerms.put(PERM_ITEM_ID, "47156aff000000ac");
        this.permItems.put("adjustbill_new", adjustNewPerms);
    }

    private void setOrg() {
        IDataModel model = this.getModel();
        RequestContext requestContext = RequestContext.get();
        Object org = this.getModel().getValue("org");
        long curOrgId = org == null ? requestContext.getOrgId() : ((Long)((DynamicObject)org).getPkValue()).longValue();
        long userId = Long.parseLong(requestContext.getUserId());
        List<Long> invPermOrgIdList = OrgHelper.getPermInvOrgIds(userId);
        this.getPageCache().put(USER_ORG_UNIT, JsonUtil.encodeToString(invPermOrgIdList));
        Long invOrgId = curOrgId;
        if (invPermOrgIdList.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u6ca1\u6709\u4efb\u4f55\u7ec4\u7ec7\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u4eba\u5458\uff01", (String)"AppHomePluginNewData_0", (String)"scmc-mobim-form", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return;
        }
        DataSet orgFunc = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)ROUTE_META), (String)"SELECT forgfunc FROM t_meta_bizapp where fnumber='mobim'");
        String type = "05";
        for (Row row : orgFunc) {
            String orgType = row.getString("forgfunc");
            if (!StringUtils.isNotBlank((CharSequence)orgType)) continue;
            type = orgType;
        }
        List invPermOrgs = OrgUnitServiceHelper.filterOrgDuty(invPermOrgIdList, (String)type);
        if (invPermOrgs == null || invPermOrgs.isEmpty()) {
            if (!invPermOrgIdList.contains(curOrgId)) {
                invOrgId = invPermOrgIdList.get(0);
            }
        } else if (!invPermOrgs.contains(curOrgId)) {
            invOrgId = (Long)invPermOrgs.get(0);
        }
        model.setValue("org", (Object)invOrgId);
    }

    private void scanBarCode(Long orgId, String scanMenuId) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("method", "scanQRCode");
        HashMap<String, Integer> args = new HashMap<String, Integer>(8);
        args.put("needResult", 1);
        map.put("args", args);
        this.getPageCache().put(SCAN_MENU_ID, scanMenuId);
        this.getPageCache().put("orgId", String.valueOf(orgId));
        this.getView().executeClientCommand("callYZJApi", new Object[]{map});
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String value = e.getEventArgs();
        String key = e.getKey();
        String barcode = null;
        Long orgId = Long.parseLong(this.getPageCache().get("orgId"));
        String scanMenuId = this.getPageCache().get(SCAN_MENU_ID);
        if ("callAppMethod".equals(key) && "scanQRCode".equals(eventName)) {
            Map result = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
            if (result.get("qrcode_str") != null) {
                barcode = (String)result.get("qrcode_str");
                this.handleQrCode(barcode, orgId, scanMenuId);
            } else {
                String msg = ResManager.loadKDString((String)"\u626b\u63cf\u7ed3\u679c\u4e3a\u7a7a\u3002", (String)"AppHomePlugin_1", (String)"scmc-mobim-form", (Object[])new Object[0]);
                this.rescan(msg, scanMenuId);
            }
        }
    }

    public void handleQrCode(String barCode, Long orgId, String scanMenu) {
        if (MOBIM_SCAN_PICK_OUT_LIST.equals(scanMenu)) {
            this.showBill(barCode, orgId, MOBIM_PRODUCEPICKOUTEDIT, MOBIM_PRODUCEPICKOUTVIEW, scanMenu);
        }
        if ("mobim_mdc_mftmanuinbill".equals(scanMenu)) {
            this.invokeScanService(barCode, orgId, "mobim_mdc_mftmanuinedit", "mobim_mdc_mftmanuinview", scanMenu);
        }
    }

    private void invokeScanService(String barcode, Long orgId, String editBill, String viewBill, String scanMenu) {
        Map<String, Object> map = InvokeScanHelper.generateBill(barcode, "pom_mftorder", "im_mdc_mftmanuinbill");
        boolean isSuccess = (Boolean)map.get("isSuccess");
        if (isSuccess) {
            Object outBillId = map.get("outBillId");
            QFilter filter = new QFilter("id", "=", outBillId);
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((String)"im_mdc_mftmanuinbill", (String)"billstatus,billno,id", (QFilter[])filter.toArray());
            this.scanSkip(barcode, orgId, editBill, viewBill, scanMenu, bill);
        } else {
            Object message = map.get("message");
            this.getView().showTipNotification(String.valueOf(message));
        }
    }

    private void showBill(String barCode, Long orgId, String editBill, String viewBill, String scanMenu) {
        QFilter filter = new QFilter("billno", "=", (Object)barCode);
        DynamicObject pickOutbBill = BusinessDataServiceHelper.loadSingle((String)"im_mdc_mftproorder", (String)"org,billstatus,billno,id", (QFilter[])filter.toArray());
        if (pickOutbBill == null) {
            this.rescan(barCode, MOBIM_SCAN_PICK_OUT_LIST);
            return;
        }
        StringBuilder errMsg = new StringBuilder();
        RequestContext requestContext = RequestContext.get();
        long userId = requestContext.getCurrUserId();
        boolean networkExclusive = MutexHelper.require((IFormView)this.getView(), (String)"im_mdc_mftproorder", (Object)pickOutbBill.get("id"), (String)"modify", (boolean)true, (StringBuilder)errMsg);
        DynamicObject org = (DynamicObject)pickOutbBill.get("org");
        Long currentOrgId = Long.parseLong(org.get("id").toString());
        boolean isModify = PermissionHelper.checkPermission(userId, currentOrgId, MetaUtils.getPcAppId((String)"im_mdc_mftproorder"), "im_mdc_mftproorder", "4715a0df000000ac");
        this.getView().getPageCache().put("isFromList", "true");
        boolean isView = PermissionHelper.checkPermission(userId, currentOrgId, MetaUtils.getPcAppId((String)"im_mdc_mftproorder"), "im_mdc_mftproorder", "47150e89000000ac");
        if (!networkExclusive && BillStatusEnum.SAVE.getValue().equals(pickOutbBill.get("billstatus"))) {
            String billNo = pickOutbBill.get("billno").toString();
            long billId = pickOutbBill.getLong("id");
            this.getView().getPageCache().put("orgid", orgId.toString());
            this.getView().getPageCache().put("billno", billNo);
            this.getView().getPageCache().put("billid", Long.toString(billId));
            this.getView().getPageCache().put("viewbill", viewBill);
            this.getView().showConfirm(String.valueOf(errMsg), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("save"));
            return;
        }
        if (!isView) {
            String str = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u2018%s\u2019\u7684\u2018\u67e5\u770b\u2019\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650", (String)"MobBillPermissin_1", (String)"scmc-mobim-form", (Object[])new Object[0]);
            String text = String.format(str, barCode);
            this.getView().showConfirm(text, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("unsee"));
            return;
        }
        if (!isModify) {
            this.scanSkip(barCode, orgId, viewBill, viewBill, scanMenu, pickOutbBill);
            return;
        }
        this.scanSkip(barCode, orgId, editBill, viewBill, scanMenu, pickOutbBill);
    }

    private void scanSkip(String barCode, Long orgId, String editBill, String viewBill, String scanMenu, DynamicObject pickOutbBill) {
        if (pickOutbBill != null && pickOutbBill.get("billno") != null && pickOutbBill.get("billstatus") != null) {
            String billNo = pickOutbBill.get("billno").toString();
            String billStatus = pickOutbBill.get("billStatus").toString();
            long billId = pickOutbBill.getLong("id");
            MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
            if (StringUtils.isNotEmpty((CharSequence)billNo) && orgId != null && StringUtils.isNotEmpty((CharSequence)billStatus)) {
                mobileFormShowParameter.setCustomParam("billstatus", (Object)billStatus);
                mobileFormShowParameter.setCustomParam("billno", (Object)billNo);
                mobileFormShowParameter.setCustomParam("billid", (Object)billId);
                mobileFormShowParameter.setCustomParam("orgid", (Object)orgId);
                mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
                String isFromList = this.getView().getPageCache().get("isFromList");
                if (isFromList != null) {
                    mobileFormShowParameter.setCustomParam("isFromList", (Object)Boolean.valueOf(isFromList));
                }
                if (BillStatusEnum.SAVE.getValue().equals(billStatus) && !editBill.equals(viewBill)) {
                    mobileFormShowParameter.setFormId(editBill);
                } else {
                    mobileFormShowParameter.setFormId(viewBill);
                }
                this.getView().showForm((FormShowParameter)mobileFormShowParameter);
            }
        } else {
            String msg = ResManager.loadKDString((String)"\u626b\u63cf\u7ed3\u679c\u4e3a\u7a7a\u3002", (String)"AppHomePlugin_1", (String)"scmc-mobim-form", (Object[])new Object[0]);
            this.rescan(msg, scanMenu);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("save".equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            String billNo = this.getPageCache().get("billno");
            String viewBill = this.getPageCache().get("viewbill");
            Long billId = Long.parseLong(this.getPageCache().get("billid"));
            Long orgId = Long.parseLong(this.getPageCache().get("orgid"));
            if (!StringUtils.isEmpty((CharSequence)billNo) && !StringUtils.isEmpty((CharSequence)viewBill)) {
                MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
                formShowParameter.setCustomParam("billno", (Object)billNo);
                formShowParameter.setCustomParam("billid", (Object)billId);
                formShowParameter.setCustomParam("orgid", (Object)orgId);
                formShowParameter.setCustomParam("permission", (Object)"isView");
                formShowParameter.setFormId(viewBill);
                formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
                this.getView().showForm((FormShowParameter)formShowParameter);
            }
        }
    }

    private void rescan(String barCode, String scanMenu) {
        MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
        mobileFormShowParameter.setCustomParam("barCode", (Object)barCode);
        mobileFormShowParameter.setCustomParam("scanMenu", (Object)scanMenu);
        mobileFormShowParameter.setFormId("mobim_scanbar_prompt_box");
        mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        mobileFormShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "rescan"));
        this.getView().showForm((FormShowParameter)mobileFormShowParameter);
    }
}

