/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.ai.util.JsonUtil;
import kd.bos.algo.Algo;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.RefreshResultType;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarChart;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.Position;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.mvc.form.MobileFormView;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scmc.mobim.business.helper.InvBillAgeReportHelper;
import kd.scmc.mobim.business.helper.OrgHelper;
import kd.scmc.mobim.common.design.hompage.handle.MobimHomePageBuilder;
import kd.scmc.mobim.plugin.form.AppHomeClick;
import kd.scmc.msmob.common.design.homepage.handle.HomePageBuilder;
import kd.scmc.msmob.common.utils.PageUtils;
import kd.scmc.msmob.plugin.tpl.basetpl.home.AbstractMobAppHomeBaseTplPlugin;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AppHomeV4Plugin
extends AbstractMobAppHomeBaseTplPlugin {
    private static final String ROUTE_META = "sys.meta";
    private String[] buttons = new String[]{"out_order_list", "mobim_purinbill", "mobim_purreceivebill", "mobim_invquery", "mobim_materialreqbill", "mobim_materialreqoutbill", "mobim_yunrobot", "mobim_productinbill", "submitpurrecflex", "submitsaleoutflex", "submitpurinflex", "linktorfmflex", "linktoagereport", "scan"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(this.buttons);
        Chart barChartAp = (Chart)this.getView().getControl("materialagebarchart");
        barChartAp.addClickListener((ClickListener)this);
    }

    public void initEntityPermItem() {
    }

    protected HomePageBuilder getHomePageBuilder() {
        return new MobimHomePageBuilder(this.getView());
    }

    public void refreshData() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            Long orgId = (Long)org.getPkValue();
            this.buildHomePage(orgId);
        }
        ((MobileFormView)this.getView()).setRefreshResult(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f\u3002", (String)"AppHomeV4Plugin_refreshData_0", (String)"scmc-mobim-form", (Object[])new Object[0]), Integer.valueOf(3000), RefreshResultType.Success);
    }

    public Object getChartData() {
        return this.getPageCache().get("datasetid");
    }

    public void buildHomePageChart() {
        Control barChartAp = this.getView().getControl("materialagebarchart");
        BarChart barChart = null;
        if (barChartAp instanceof BarChart) {
            barChart = (BarChart)barChartAp;
        }
        if (barChart == null) {
            return;
        }
        barChart.clearData();
        String dataSetId = this.getPageCache().get("datasetid");
        if (dataSetId == null) {
            return;
        }
        CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)dataSetId);
        Object org = this.getModel().getValue("org");
        DynamicObject filterDyn = InvBillAgeReportHelper.getDynamicObjectByScheme(org);
        List<String> yLabelData = InvBillAgeReportHelper.getGroups(filterDyn);
        List<Integer> xLabelData = this.getXLabelData(cacheDataSet, yLabelData);
        List<String> labelColorList = InvBillAgeReportHelper.getLabelColorList();
        this.buildYAxis(barChart, yLabelData);
        barChart.setMargin(Position.top, "5%");
        barChart.setMargin(Position.right, "10%");
        BarSeries series = barChart.createSeries("");
        int maxValue = 0;
        for (int i = 0; i < yLabelData.size(); ++i) {
            String label = yLabelData.get(i);
            Integer value = xLabelData.get(i);
            maxValue = Math.max(xLabelData.get(i), maxValue);
            String color = i >= 6 ? labelColorList.get(6) : labelColorList.get(i);
            series.addData(label, (Number)value, color);
        }
        series.setBarWidth("24");
        series.setPropValue("barGap", (Object)"0");
        series.setPropValue("barCategoryGap", (Object)"10%");
        this.buildXAxis(barChart, maxValue);
        Label label = new Label();
        label.setShow(true);
        label.setPosition(Position.right);
        label.setBorderRadius("10px");
        String msg = ResManager.loadKDString((String)"\u7269\u6599\u79cd\u7c7b", (String)"AppHomeV4Plugin_0", (String)"scmc-mobim-form", (Object[])new Object[0]);
        label.setFormatter(msg + ":{c}");
        series.setLabel(label);
        label.setColor("#666666");
        label.setFontSize("10");
        series.setLabel(label);
        this.getView().updateView("materialagebarchart");
        cacheDataSet.close();
        this.getPageCache().remove("datasetid");
    }

    public void setToDoBusinessCard(Long orgId) {
    }

    private List<Integer> getXLabelData(CachedDataSet dataSet, List<String> yLabelData) {
        int size = yLabelData.size();
        int rowCount = dataSet.getRowCount();
        List list = dataSet.getList(0, rowCount);
        ArrayList<Integer> xData = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            HashSet<Long> set = new HashSet<Long>(16);
            String sign = "baseqtyrang" + i;
            if (!list.isEmpty()) {
                for (Row row : list) {
                    if (row.getInteger(sign) <= 0) continue;
                    set.add(row.getLong("material"));
                }
            }
            xData.add(set.size());
        }
        return xData;
    }

    public void buildYAxis(BarChart barChart, List<String> yLabelData) {
        Axis yAxis = barChart.createYAxis("", AxisType.category);
        yAxis.setCategorys(yLabelData.toArray(new String[0]));
        HashMap<String, Boolean> axisShowMap = new HashMap<String, Boolean>(3);
        axisShowMap.put("show", Boolean.FALSE);
        yAxis.setPropValue("axisTick", axisShowMap);
        HashMap axisLabelMap = new HashMap(3);
        HashMap<String, Object> textStyleMap = new HashMap<String, Object>(3);
        textStyleMap.put("fontSize", 14);
        textStyleMap.put("color", "#666666");
        axisLabelMap.put("textStyle", textStyleMap);
        yAxis.setPropValue("axisLabel", axisLabelMap);
        HashMap<String, String> lineStyle = new HashMap<String, String>(3);
        lineStyle.put("color", "#E5E5E5");
        lineStyle.put("type", "solid");
        HashMap<String, HashMap<String, String>> axisLine = new HashMap<String, HashMap<String, String>>(3);
        axisLine.put("lineStyle", lineStyle);
        yAxis.setPropValue("axisLine", axisLine);
    }

    public void buildXAxis(BarChart barChart, int maxValue) {
        Axis xAxis = barChart.createXAxis("", AxisType.value);
        xAxis.setPropValue("minInterval", (Object)1);
        HashMap<String, String> lineStyleMap = new HashMap<String, String>(3);
        lineStyleMap.put("type", "dashed");
        HashMap<String, HashMap<String, String>> splitLineMap = new HashMap<String, HashMap<String, String>>(3);
        splitLineMap.put("lineStyle", lineStyleMap);
        xAxis.setPropValue("splitLine", splitLineMap);
        HashMap<String, Boolean> axisShowMap = new HashMap<String, Boolean>(3);
        axisShowMap.put("show", Boolean.FALSE);
        xAxis.setPropValue("axisLine", axisShowMap);
        xAxis.setPropValue("axisTick", axisShowMap);
        xAxis.setPropValue("boundaryGap", (Object)true);
        double value = (double)maxValue + (double)maxValue * 0.25;
        BigDecimal maxBig = BigDecimal.valueOf(value);
        BigDecimal maxCeil = maxBig.setScale(0, 0);
        BigDecimal maxDown = maxCeil.setScale(-1, 0);
        BigDecimal maxUp = maxDown.setScale(-2, 0);
        int max = maxUp.intValue();
        xAxis.setPropValue("max", (Object)max);
    }

    public void setAgEndBusinessDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 0);
        Date endDate = calendar.getTime();
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        calendar.add(2, -3);
        Date startDate = calendar.getTime();
        this.getModel().setValue("todobusiness_startdate", (Object)startDate);
        this.getModel().setValue("todobusiness_enddate", (Object)endDate);
    }

    public void click(EventObject evt) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"AppHomePluginClick_0", (String)"scmc-mobim-form", (Object[])new Object[0]));
            return;
        }
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        String orgNo = org.getString("number");
        Long orgId = org.getLong("id");
        HashMap<String, Object> customParams = new HashMap<String, Object>(3);
        customParams.put("orgBillNo", orgNo);
        customParams.put("orgid", orgId);
        IFormView view = this.getView();
        AppHomeClick appHomeClick = new AppHomeClick((AbstractMobBillPlugIn)this);
        appHomeClick.click(key, org);
        switch (key) {
            case "submitpurrecflex": {
                this.openToDoListPage(view, customParams, "mobim_purreceivelist");
                break;
            }
            case "submitpurinflex": {
                this.openToDoListPage(view, customParams, "mobim_purinbilllist");
                break;
            }
            case "submitsaleoutflex": {
                this.openToDoListPage(view, customParams, "mobim_saloutbilllist");
                break;
            }
            case "linktoagereport": 
            case "linktorfmflex": {
                this.openToDoListPage(view, customParams, "mobim_invbillage_report");
                break;
            }
            case "materialagebarchart": {
                this.openToDoListPage(view, customParams, "mobim_invbillage_report");
                break;
            }
        }
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        AppHomeClick appHomeClick = new AppHomeClick((AbstractMobBillPlugIn)this);
        appHomeClick.customEvent(e);
    }

    public Map<String, Boolean> checkPermission(Long org) {
        return new HashMap<String, Boolean>(0);
    }

    public Long setOrg(Long orgId) {
        IDataModel model = this.getModel();
        List<Long> invPermOrgIdList = AppHomeV4Plugin.getPermissionOrgList();
        this.getPageCache().put("userOrgUnit", JsonUtil.encodeToString(invPermOrgIdList));
        Long invOrgId = this.getInvOrgId(orgId, invPermOrgIdList);
        model.setValue("org", (Object)invOrgId);
        return invOrgId;
    }

    private Long getInvOrgId(long curUserOrgId, List<Long> invPermOrgIdList) {
        List invPermOrgIds = OrgUnitServiceHelper.filterOrgDuty(invPermOrgIdList, (String)this.getFunctionType());
        if (CollectionUtils.isEmpty((Collection)invPermOrgIds)) {
            if (!invPermOrgIdList.contains(curUserOrgId)) {
                return invPermOrgIdList.get(0);
            }
        } else if (!invPermOrgIds.contains(curUserOrgId)) {
            return (Long)invPermOrgIds.get(0);
        }
        return curUserOrgId;
    }

    private static List<Long> getPermissionOrgList() {
        RequestContext requestContext = RequestContext.get();
        long userId = requestContext.getCurrUserId();
        List<Long> invPermOrgIdList = OrgHelper.getPermInvOrgIds(userId);
        if (invPermOrgIdList.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u6ca1\u6709\u4efb\u4f55\u7ec4\u7ec7\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u4eba\u5458\uff01", (String)"AppHomePluginNewData_0", (String)"scmc-mobim-form", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        return invPermOrgIdList;
    }

    private String getFunctionType() {
        DataSet orgFunc = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)ROUTE_META), (String)"SELECT forgfunc FROM t_meta_bizapp where fnumber='mobim'");
        String type = "05";
        for (Row row : orgFunc) {
            String orgType = row.getString("forgfunc");
            if (!StringUtils.isNotBlank((CharSequence)orgType)) continue;
            type = orgType;
        }
        return type;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        AppHomeClick appHomeClick = new AppHomeClick((AbstractMobBillPlugIn)this);
        appHomeClick.closedCallBack(e);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        AppHomeClick appHomeClick = new AppHomeClick((AbstractMobBillPlugIn)this);
        appHomeClick.confirmCallBack(messageBoxClosedEvent);
    }

    public String getShowBillKey() {
        return "mobim_commonapp";
    }

    private void openToDoListPage(IFormView view, Map<String, Object> customParams, String mobListFormKey) {
        customParams.put("todoDate", "todoDate");
        PageUtils.showFormPage((IFormView)view, (String)mobListFormKey, customParams, null);
    }
}

