/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.adjustbill;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.scmc.mobim.common.enums.AdjustBusinessType;
import kd.scmc.mobim.common.utils.FormUtils;
import kd.scmc.mobim.plugin.form.adjustbill.AdjustBillViewPlugin;
import kd.scmc.mobim.plugin.form.adjustbill.IAdjustBillPagePlugin;
import kd.scmc.mobim.plugin.form.adjustbill.handler.AdjustBillEditPropertyChangedHandler;
import kd.scmc.msmob.business.helper.change.DataChangedHandlerHelper;
import kd.scmc.msmob.business.helper.change.handler.IEntryRowAddedHandler;
import kd.scmc.msmob.plugin.tpl.basetpl.IMobBillEditable;

public class AdjustBillEditPlugin
extends AdjustBillViewPlugin
implements IAdjustBillPagePlugin,
IMobBillEditable,
BeforeF7SelectListener {
    private static final String[] F7_FIELD_KEYS = new String[]{"biztype"};

    public AdjustBillEditPlugin() {
        this.registerPropertyChangedHandler(new AdjustBillEditPropertyChangedHandler());
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener(this, F7_FIELD_KEYS);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String mobileFieldName = e.getProperty().getName();
        if (mobileFieldName.equals("biztype")) {
            ChangeData[] changeSet = e.getChangeSet();
            ChangeData changeData = changeSet[0];
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            boolean isEquals = DataChangedHandlerHelper.equals((Object)oldValue, (Object)newValue, (String)mobileFieldName);
            if (!isEquals) {
                DataChangedHandlerHelper.afterEntryAddedOperation((AbstractFormPlugin)this, (IEntryRowAddedHandler)this.getEntryRowAddedHandler(), (String)this.getEntryEntity(), null);
            }
        }
        this.setMainEntryTitle();
    }

    public String getEntryFormKey() {
        String entryKey = this.getEntryEntity();
        return this.getEntryEditFormKey(entryKey);
    }

    public String getViewFormId() {
        return this.getBillViewFormKey();
    }

    @Override
    public String getBillSubEntryEditFormKey() {
        return "mobim_adjustbillsubedit";
    }

    @Override
    protected void newEntrySetValue(DynamicObject newPcEntryRow, DynamicObject pcEntity) {
        super.newEntrySetValue(newPcEntryRow, pcEntity);
        newPcEntryRow.set("keepertype", (Object)"bos_org");
        newPcEntryRow.set("keeper", pcEntity.get("org"));
        newPcEntryRow.set("ownertype", (Object)"bos_org");
        newPcEntryRow.set("owner", this.getOwnerDefValue(pcEntity.getDynamicObject("org").getLong("id")));
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey;
        switch (fieldKey = e.getProperty().getName()) {
            case "biztype": {
                this.beforeSelectBizType(e);
                break;
            }
        }
    }

    protected void beforeSelectBizType(BeforeF7SelectEvent e) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        Set<AdjustBusinessType> supportedBizTypes = AdjustBusinessType.getSupportedBizTypes();
        showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", supportedBizTypes.stream().map(AdjustBusinessType::getBizTypePkValue).collect(Collectors.toSet())));
    }

    private Object getOwnerDefValue(Long toOrgId) {
        Map map;
        if (toOrgId == null || toOrgId.equals(0L)) {
            return 0L;
        }
        ArrayList<Object> orgIds = this.getOwners(toOrgId);
        Object defOwnerId = orgIds.isEmpty() ? ((map = OrgUnitServiceHelper.getCompanyByOrg((Long)toOrgId, (Boolean)false, (Boolean)true)) == null || map.isEmpty() ? Long.valueOf(0L) : map.get("id")) : orgIds.get(0);
        QFilter filter = new QFilter("id", "=", defOwnerId);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (QFilter[])new QFilter[]{filter});
    }

    private ArrayList<Object> getOwners(Long orgId) {
        ArrayList<Object> array = new ArrayList<Object>(10);
        if (orgId == null) {
            return array;
        }
        List ownerOrgs = OrgUnitServiceHelper.getFromOrgs((String)OrgViewTypeEnum.IS_INVENTORY.getViewType(), (Long)orgId, (String)OrgViewTypeEnum.IS_ACCOUNTING.getViewType());
        if (ownerOrgs != null && !ownerOrgs.isEmpty()) {
            for (int i = 0; i < ownerOrgs.size(); ++i) {
                Long ownerOrgId = (Long)ownerOrgs.get(i);
                if (array.contains(ownerOrgId)) continue;
                array.add(ownerOrgs.get(i));
            }
        }
        return array;
    }
}

