/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.adjustbill;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.mobim.business.helper.VisibleAbilityHelper;
import kd.scmc.mobim.common.enums.AdjustBusinessType;
import kd.scmc.mobim.common.utils.FormUtils;
import kd.scmc.mobim.plugin.form.adjustbill.AdjustBillPluginHelper;
import kd.scmc.mobim.plugin.form.adjustbill.IAdjustBillPagePlugin;
import kd.scmc.mobim.plugin.form.adjustbill.handler.AdjustBillEditPropertyChangedHandler;
import kd.scmc.msmob.plugin.tpl.basetpl.EntryEditTplPlugin;
import kd.scmc.msmob.plugin.tpl.basetpl.IMobBillEditable;

public class AdjustBillEntryEditPlugin
extends EntryEditTplPlugin
implements BeforeF7SelectListener,
IAdjustBillPagePlugin,
IMobBillEditable {
    private static final Log LOG = LogFactory.getLog(AdjustBillEntryEditPlugin.class);
    private static final String INV_TYPE = "invtype";
    private static final String INV_STATUS = "invstatus";
    private static final String[] F7_FIELD_KEYS = new String[]{"material", "unit", "warehouse", "location"};
    private static final String[] MODEL_FIELD_KEYS = new String[]{"billid", "pcentitykey", "material", "qty", "unit", "baseunit", "lotnumber", "warehouse", "location", "invtype", "invstatus"};

    public AdjustBillEntryEditPlugin() {
        this.registerPropertyChangedHandler(new AdjustBillEditPropertyChangedHandler());
    }

    public String getEntryEntity() {
        return "entryentity";
    }

    public List<String> getFieldKeys() {
        return Arrays.asList(MODEL_FIELD_KEYS);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener(this, F7_FIELD_KEYS);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        VisibleAbilityHelper visibleAbilityHelper = new VisibleAbilityHelper(this.getView(), this.getModel());
        visibleAbilityHelper.setVisibleAbility();
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey;
        switch (fieldKey = e.getProperty().getName()) {
            case "material": {
                this.beforeSelectMaterial(e);
                break;
            }
            case "unit": {
                this.beforeSelectUnit(e);
                break;
            }
            case "warehouse": {
                this.beforeSelectWareHouse(e);
                break;
            }
            case "location": {
                this.beforeSelectLocation(e);
                break;
            }
        }
    }

    private void beforeSelectMaterial(BeforeF7SelectEvent e) {
        DynamicObject bizType = (DynamicObject)this.getParentView().getModel().getValue("biztype");
        AdjustBusinessType.valueOf(bizType).beforeSelectMaterial(e);
    }

    private void beforeSelectUnit(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        AdjustBillPluginHelper.beforeSelectUnit(e, model);
    }

    private void beforeSelectWareHouse(BeforeF7SelectEvent e) {
        IDataModel model = this.getParentView().getModel();
        String pcEntityKey = this.getPcEntityKey();
        AdjustBillPluginHelper.beforeSelectWarehouse(e, model, pcEntityKey);
    }

    private void beforeSelectLocation(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        AdjustBillPluginHelper.beforeSelectLocation(e, model);
    }
}

