/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.adjustbill;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bd.sbd.enums.EnableStatusEnum;
import kd.bd.sbd.enums.OperatorGrpTypeEnum;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.MutexHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.im.business.helper.BizTypeHelper;
import kd.scmc.mobim.common.consts.InvTypeConst;
import kd.scmc.mobim.plugin.form.adjustbill.AdjustBillEditPlugin;

public class AdjustBillNewPlugin
extends AdjustBillEditPlugin {
    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        switch (operateKey = args.getOperateKey()) {
            case "save": {
                this.afterSave(args, operationResult);
                break;
            }
            case "submit": {
                this.afterSubmit(args, operationResult);
                break;
            }
        }
    }

    private void afterSubmit(AfterDoOperationEventArgs args, OperationResult operationResult) {
        this.editabilityPlugin.afterDoOperation(args);
        if (operationResult.isSuccess()) {
            String pcId = operationResult.getSuccessPkIds().get(0).toString();
            this.getModel().setValue("billid", (Object)Long.valueOf(pcId));
            super.afterSubmit(pcId);
        }
    }

    private void afterSave(AfterDoOperationEventArgs args, OperationResult operationResult) {
        Boolean isModify;
        super.afterDoOperation(args);
        if (operationResult.isSuccess() && Boolean.TRUE.equals(isModify = this.checkModifyPermission())) {
            StringBuilder errMsg = new StringBuilder();
            Object pkId = operationResult.getSuccessPkIds().get(0);
            MutexHelper.require((IFormView)this.getView(), (String)this.getPcEntityKey(), pkId, (String)"modify", (boolean)Boolean.TRUE, (StringBuilder)errMsg);
            this.getPageCache().put("isFromList", "true");
        }
    }

    protected void initDataOfNewPcEntity(DynamicObject newPcEntity) {
        super.initDataOfNewPcEntity(newPcEntity);
        IDataModel model = this.getModel();
        String pcEntityKey = this.getPcEntityKey();
        MobileFormShowParameter param = (MobileFormShowParameter)this.getView().getFormShowParameter();
        Object orgId = param.getCustomParam("orgid");
        if (orgId == null) {
            orgId = RequestContext.get().getOrgId();
        }
        model.setValue("org", orgId);
        newPcEntity.set("org", this.getModel().getValue("org"));
        newPcEntity.set("billstatus", (Object)"A");
        newPcEntity.set("biztime", (Object)new Date());
        newPcEntity.set("bookdate", newPcEntity.get("biztime"));
        QFilter qFilter = new QFilter("billformid", "=", (Object)pcEntityKey);
        qFilter.and(new QFilter("isdefault", "=", (Object)"1"));
        DynamicObject billType = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_billtype", (QFilter[])qFilter.toArray());
        newPcEntity.set("billtype", (Object)billType);
        DynamicObject bizType = BizTypeHelper.getBizTypeByBillType((String)pcEntityKey, (DynamicObject)billType);
        newPcEntity.set("biztype", (Object)bizType);
        long userId = UserServiceHelper.getCurrentUserId();
        model.setValue("creator", (Object)userId);
        newPcEntity.set("creator", model.getValue("creator"));
        Map<Object, DynamicObject> operatorGroupMap = this.getOperatorGroupMap(Long.valueOf(orgId.toString()));
        this.initDept(userId, Long.valueOf(orgId.toString()), operatorGroupMap, newPcEntity);
        this.initOperatorAndGroup(userId, operatorGroupMap, newPcEntity);
    }

    @Override
    protected void newEntrySetValue(DynamicObject newPcEntryRow, DynamicObject pcEntity) {
        super.newEntrySetValue(newPcEntryRow, pcEntity);
        QFilter invTypeFilter = new QFilter("id", "=", (Object)InvTypeConst.INV_TYPE_ORDINARY);
        DynamicObject invType = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_invtype", (QFilter[])invTypeFilter.toArray());
        newPcEntryRow.set("invtype", (Object)invType);
        QFilter invStatusFilter = new QFilter("id", "=", (Object)InvTypeConst.INV_TYPE_AVAILABLE);
        DynamicObject invStatus = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_invstatus", (QFilter[])invStatusFilter.toArray());
        newPcEntryRow.set("invstatus", (Object)invStatus);
    }

    private Map<Object, DynamicObject> getOperatorGroupMap(Long orgId) {
        String operatorGrpType = OperatorGrpTypeEnum.INVENTORYGRP.getValue();
        QFilter qFilter01 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)orgId);
        QFilter qFilter02 = new QFilter("operatorgrouptype", "=", (Object)operatorGrpType);
        qFilter02.and("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (QFilter[])new QFilter[]{qFilter01, qFilter02});
        return map;
    }

    private void initDept(long userId, Long orgId, Map<Object, DynamicObject> operatorGroupMap, DynamicObject newPcEntity) {
        if (operatorGroupMap.size() != 0) {
            QFilter qFilter11 = new QFilter("operatorgrpid", "in", operatorGroupMap.keySet());
            QFilter qFilter12 = new QFilter("operatorid", "=", (Object)userId);
            QFilter qFilter3 = new QFilter("invalid", "=", (Object)"0");
            DynamicObject operator = BusinessDataServiceHelper.loadSingle((String)"bd_operator", (String)"operatorid", (QFilter[])new QFilter[]{qFilter11, qFilter12, qFilter3});
            Long deptId = null == operator ? this.initDeptByOrg(orgId) : this.initDeptByOperator(operator, orgId);
            QFilter qFilter = new QFilter("id", "=", (Object)deptId);
            DynamicObject dept = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (QFilter[])new QFilter[]{qFilter});
            newPcEntity.set("dept", (Object)dept);
        }
    }

    private Long initDeptByOrg(Long orgId) {
        List deptIds = OrgUnitServiceHelper.getAdminOrgRelation(Collections.singletonList(orgId), (boolean)true);
        if (deptIds != null && !deptIds.isEmpty()) {
            return (Long)deptIds.get(0);
        }
        deptIds = OrgUnitServiceHelper.getAllToOrg((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (String)OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType(), (Long)orgId, (boolean)true);
        if (deptIds != null && !deptIds.isEmpty() && deptIds.contains(orgId)) {
            return orgId;
        }
        return null;
    }

    private Long initDeptByOperator(DynamicObject operator, Long orgId) {
        List deptids = OrgUnitServiceHelper.getAllToOrg((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (String)OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType(), (Long)orgId, (boolean)true);
        if (deptids != null && !deptids.isEmpty()) {
            List userDeptIds = UserServiceHelper.getUserDepartment((long)((Long)operator.getDynamicObject("operatorid").getPkValue()), (boolean)Boolean.FALSE);
            if (userDeptIds != null && !userDeptIds.isEmpty()) {
                for (Long deptId : userDeptIds) {
                    if (!deptids.contains(deptId)) continue;
                    return deptId;
                }
            }
        } else {
            List userDeptIds = UserServiceHelper.getUserDepartment((long)((Long)operator.getDynamicObject("operatorid").getPkValue()), (boolean)Boolean.FALSE);
            if (userDeptIds != null && !userDeptIds.isEmpty()) {
                return (Long)userDeptIds.get(0);
            }
        }
        return null;
    }

    private void initOperatorAndGroup(long userId, Map<Object, DynamicObject> operatorGroupMap, DynamicObject newPcEntity) {
        if (operatorGroupMap == null || operatorGroupMap.isEmpty()) {
            return;
        }
        QFilter qFilter = new QFilter("operatorgrpid", "in", operatorGroupMap.keySet());
        qFilter.and(new QFilter("operatorid", "=", (Object)userId));
        qFilter.and(new QFilter("invalid", "=", (Object)"0"));
        DynamicObject operator = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_operator", (QFilter[])new QFilter[]{qFilter});
        if (operator != null) {
            newPcEntity.set("operator", (Object)operator);
            QFilter filter = new QFilter("id", "=", (Object)operator.getLong("operatorgrpid"));
            DynamicObject operatorGroup = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_operatorgroup", (QFilter[])new QFilter[]{filter});
            newPcEntity.set("operatorgroup", (Object)operatorGroup);
        }
    }
}

