/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.adjustbill;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.im.business.helper.WareHouseIsolateHelper;
import kd.scmc.im.business.helper.WarehouseHelper;

public class AdjustBillPluginHelper {
    private static final String BASE_UNIT = "baseunit";

    public static void beforeSelectUnit(BeforeF7SelectEvent e, IDataModel model) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject baseUnit = (DynamicObject)model.getValue(BASE_UNIT);
        Long baseUnitId = baseUnit == null ? Long.valueOf(0L) : (Long)baseUnit.getPkValue();
        DynamicObject material = (DynamicObject)model.getValue("material");
        Long masterMaterialId = 0L;
        if (material != null) {
            masterMaterialId = material.getDynamicObject("masterid").getLong("id");
        }
        List unitIds = BaseDataServiceHelper.getAssistMUListResult((Long)masterMaterialId, (Long)baseUnitId, (String)"1", (Boolean)Boolean.TRUE);
        showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)unitIds));
    }

    public static void beforeSelectWarehouse(BeforeF7SelectEvent e, IDataModel model, String pcEntityKey) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            e.setCancel(true);
        } else {
            Boolean result = WareHouseIsolateHelper.setWareHouseIsolateF7Filter((String)pcEntityKey, (DynamicObject)org, (ListShowParameter)showParameter);
            if (!result.booleanValue()) {
                Long[] allWhs = WarehouseHelper.getAllWarehouseIDs((Long)Long.valueOf(org.getPkValue().toString()));
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)allWhs));
            }
        }
    }

    public static void beforeSelectLocation(BeforeF7SelectEvent e, IDataModel model) {
        DynamicObject warehouse = (DynamicObject)model.getValue("warehouse");
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if (warehouse == null) {
            e.setCancel(true);
        } else {
            DynamicObjectCollection locationCol = warehouse.getDynamicObjectCollection("entryentity");
            List<Object> ids = new ArrayList(10);
            if (locationCol != null && !locationCol.isEmpty()) {
                ids = locationCol.stream().map(dynamicObject -> Long.valueOf(dynamicObject.getDynamicObject("location").getPkValue().toString())).collect(Collectors.toList());
            }
            QFilter qFilter = new QFilter("id", "in", ids);
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }
}

