/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.adjustbill;

import java.util.Arrays;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.scmc.mobim.common.enums.AdjustBusinessType;
import kd.scmc.mobim.plugin.form.adjustbill.AdjustBillSubViewPlugin;
import kd.scmc.mobim.plugin.form.adjustbill.IAdjustBillPagePlugin;
import kd.scmc.mobim.plugin.form.adjustbill.handler.AdjustBillEditPropertyChangedHandler;
import kd.scmc.mobim.plugin.form.adjustbill.handler.AdjustBillNewEntryHandler;
import kd.scmc.msmob.business.helper.change.DataChangedHandlerHelper;
import kd.scmc.msmob.business.helper.change.handler.IEntryRowDeletedHandler;
import kd.scmc.msmob.plugin.tpl.basetpl.IMobBillEditable;

public class AdjustBillSubEditPlugin
extends AdjustBillSubViewPlugin
implements IAdjustBillPagePlugin,
IMobBillEditable {
    public AdjustBillSubEditPlugin() {
        this.registerPropertyChangedHandler(new AdjustBillEditPropertyChangedHandler());
        this.registerEntryRowAddedHandler(new AdjustBillNewEntryHandler());
    }

    public void beforeClick(BeforeClickEvent evt) {
        String ctrlKey;
        super.beforeClick(evt);
        Control ctrl = (Control)evt.getSource();
        switch (ctrlKey = ctrl.getKey()) {
            case "completeop": {
                DataChangedHandlerHelper.purgeUnchangedEntries((AbstractFormPlugin)this, (IEntryRowDeletedHandler)this.getEntryRowDeletedHandler());
                break;
            }
        }
    }

    public void loadCacheDataBeforeUpdateView(DynamicObject pcEntity) {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entryentity.size(); ++i) {
            DynamicObject material;
            DynamicObject afterEntryRow = (DynamicObject)entryentity.get(i);
            String materialName = "";
            DynamicObject materialInventoryInfo = afterEntryRow.getDynamicObject("material");
            if (materialInventoryInfo != null && (material = materialInventoryInfo.getDynamicObject("masterid")) != null) {
                materialName = material.getString("name");
            }
            model.setValue("material2name", (Object)materialName, i);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "newentry": {
                this.newSubEntryRow();
                break;
            }
        }
    }

    private void newSubEntryRow() {
        this.setMainEntryTitle();
        this.setEnableOfBizType();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setEnableOfBizType();
    }

    protected void setEnableOfBizType() {
        boolean qtyDisabled;
        DynamicObject bizType = (DynamicObject)this.getParentView().getModel().getValue("biztype");
        AdjustBusinessType adjustBusinessType = AdjustBusinessType.valueOf(bizType);
        if (adjustBusinessType != null && (qtyDisabled = Arrays.stream(adjustBusinessType.getDisabledFields()).filter(s -> s.equals("qty")).findAny().isPresent())) {
            for (int i = 0; i < this.getModel().getEntryEntity(this.getEntryEntity()).size(); ++i) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"qty"});
            }
        }
    }

    public String getEntryFormKey() {
        String entryKey = this.getEntryEntity();
        return this.getEntryEditFormKey(entryKey);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "newentry": {
                this.checkAllowMultipleAfterEntry(args);
                break;
            }
        }
    }

    private void checkAllowMultipleAfterEntry(BeforeDoOperationEventArgs args) {
        DynamicObject bizType = (DynamicObject)this.getView().getParentView().getModel().getValue("biztype");
        AdjustBusinessType adjustBusinessType = AdjustBusinessType.valueOf(bizType);
        if (!adjustBusinessType.isAllowMultipleAfterEntry() && this.getModel().getEntryEntity(this.getEntryEntity()).size() >= 1) {
            args.setCancel(true);
            String errMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u7c7b\u578b\uff0c\u8f6c\u6362\u540e\u5206\u5f55\u4e0d\u5141\u8bb8\u6709\u591a\u6761\u3002", (String)"AdjustBillSubEditPlugin_0", (String)"scmc-mobim-form", (Object[])new Object[0]), this.getFormKey());
            this.getView().showTipNotification(errMsg);
            return;
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "callback": {
                this.setEnableOfBizType();
                break;
            }
        }
    }
}

