/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.adjustbill.cache;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.operation.CustOperationParameter;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.scmc.mobim.business.helper.MobInvQueryHelper;
import kd.scmc.msmob.business.helper.DataSourceConfigHelper;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import kd.scmc.msmob.business.helper.PermissionHelper;
import kd.scmc.msmob.business.helper.change.DataSourceHelper;
import kd.scmc.msmob.business.helper.change.IMobilePage;
import kd.scmc.msmob.common.consts.MobInvQueryConst;
import kd.scmc.msmob.common.consts.SCMCBaseBillMobConst;
import kd.scmc.msmob.common.utils.MetaUtils;
import kd.scmc.msmob.common.utils.PageUtils;
import kd.scmc.msmob.plugin.tpl.basetpl.MobBizBillInfoTplPlugin;
import kd.scmc.msmob.pojo.DataSourceConfig;
import kd.scmc.msmob.pojo.EntryMappingRelationship;
import kd.scmc.msmob.pojo.InvQueryConfig;
import kd.scmc.msmob.pojo.InvQueryFieldMappingRelation;
import kd.scmc.msmob.pojo.ParameterSetting;
import kd.scmc.msmob.pojo.PropertyNode;
import kd.scmc.msmob.service.mservice.baseset.impl.DataSourceConfigServiceImpl;
import kd.scmc.sbs.business.reservation.ReserveHelper;

public abstract class MobBizBillTplCachePlugin
extends MobBizBillInfoTplPlugin {
    private static final String INV_QUERY_OP_TYPE_KEY = "scmcinvquery";
    private static final Set<String> NOT_UPDATE_FIELDKEYS = new HashSet<String>(Arrays.asList("baseunit", "unit", "unit2nd", "lotnum", "producedate", "expirydate", "baseqty", "qty", "qty2nd", "avbbaseqty", "avbqty", "avbqty2nd", "lockbaseqty", "lockqty", "lockqty2nd"));

    public Long getBillId() {
        IDataModel model = this.getModel();
        Object billId = model.getValue("billid");
        if (billId == null || billId.equals(0L)) {
            IFormView view = this.getView();
            FormShowParameter formShowParameter = view.getFormShowParameter();
            Map customParams = formShowParameter.getCustomParams();
            billId = customParams.get("billid");
        }
        return billId == null ? 0L : Long.parseLong(billId.toString());
    }

    private DynamicObject[] getPcEntityObject() {
        Long billId = this.getBillId();
        if (!billId.equals(0L)) {
            DynamicObject singleData = BusinessDataServiceHelper.loadSingle((Object)billId, (String)this.getPcEntityKey());
            return new DynamicObject[]{singleData};
        }
        return new DynamicObject[0];
    }

    private DynamicObject[] createPcEntityArr() {
        DynamicObject pcEntityById = this.createPcEntityObject();
        return new DynamicObject[]{pcEntityById};
    }

    private boolean isNew() {
        Long billId = this.getBillId();
        return billId.equals(0L);
    }

    public DynamicObject getPcEntityById(String pcId) {
        return this.isNew() ? this.createPcEntityObject() : super.getPcEntityById(pcId);
    }

    private DynamicObject createPcEntityObject() {
        String pcEntityKey = this.getPcEntityKey();
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)pcEntityKey);
        DynamicObject newPcEntity = new DynamicObject((DynamicObjectType)dataEntityType);
        long id = DB.genLongId((String)pcEntityKey);
        newPcEntity.set("id", (Object)id);
        this.initDataOfNewPcEntity(newPcEntity);
        this.newDefaultEntryRow(newPcEntity);
        return newPcEntity;
    }

    protected final DynamicObject getPcEntityFromCache() {
        return EntityCacheHelper.getPcEntityFromCache((IMobilePage)this);
    }

    protected final void updateEntityCache(MainEntityType dataEntityType, DynamicObject pcEntity) {
        if (pcEntity == null || dataEntityType == null) {
            return;
        }
        DataSourceHelper.loadPcEntityToMobilePage((AbstractFormPlugin)this, (DynamicObject)pcEntity, (boolean)true);
    }

    protected final void clickMobInvQueryOp(String operationKey, String invQueryOpItemKey, String materialKey) {
        Boolean isSubEntry;
        IDataModel model = this.getModel();
        IFormView currentView = this.getView();
        IPageCache pageCache = this.getPageCache();
        InvQueryConfig invQueryConfig = this.getInvQueryConfig(invQueryOpItemKey);
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        customParams.put("invQueryParentViewId", this.getView().getEntityId());
        boolean isEditable = this.isEditable();
        customParams.put("invQueryItemKey", invQueryOpItemKey);
        customParams.put("isEditable", isEditable);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "clickMobInvQueryOpCallBack");
        String mobEntryKey = this.matchEntryKey(operationKey);
        int currentRowIndex = model.getEntryCurrentRowIndex(mobEntryKey);
        pageCache.put("currEntryKeyOfInvQuery", mobEntryKey);
        pageCache.put("currEntryRowIndexOfInvQuery", String.valueOf(currentRowIndex));
        IDataEntityProperty materialProp = model.getProperty(materialKey);
        if (materialProp == null) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u67e5\u8be2\u5931\u8d25\uff0c\u5206\u5f55\u201c%1$s\u201d\u4e0a\u6ca1\u6709\u5b9a\u4e49\u5b57\u6bb5\u6807\u8bc6\u201c%2$s\u201d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MobBizBillTplCachePlugin_clickMobInvQueryOp_0", (String)"scmc-mobim-form", (Object[])new Object[0]), mobEntryKey, materialKey);
            currentView.showErrorNotification(errMsg);
            return;
        }
        String pcEntryKey = this.getPageCache().get(mobEntryKey);
        String subStrOfEntryKey = pcEntryKey.contains(".") ? StringUtils.substringAfter((String)pcEntryKey, (String)".") : pcEntryKey;
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)this.getPcEntityKey());
        EntityType entityType = (EntityType)dataEntityType.getAllEntities().get(subStrOfEntryKey);
        Boolean bl = isSubEntry = entityType instanceof SubEntryType ? Boolean.TRUE : Boolean.FALSE;
        if (isSubEntry.booleanValue()) {
            IFormView parentView = currentView.getParentView();
            IDataModel parentModel = parentView.getModel();
            String mobFromKeyOfMainPage = parentView.getEntityId();
            int currMainEntryRowIndex = parentModel.getEntryCurrentRowIndex(mobEntryKey);
            customParams.put("mobFormKeyOfSubPage", this.getFormKey());
            customParams.put("currSubEntryRowIndex", String.valueOf(currentRowIndex));
            customParams.put("mobFormKeyOfMainPage", mobFromKeyOfMainPage);
            customParams.put("currMainEntryRowIndex", String.valueOf(currMainEntryRowIndex));
        } else {
            customParams.put("mobFormKeyOfMainPage", this.getFormKey());
            customParams.put("currMainEntryRowIndex", String.valueOf(currentRowIndex));
        }
        customParams.put("isSubEntry", isSubEntry);
        DynamicObject material = (DynamicObject)model.getValue(materialKey, currentRowIndex);
        DynamicObject currEntityObject = this.getPcEntityFromCache();
        String invQueryConfigStr = SerializationUtils.toJsonString((Object)invQueryConfig);
        pageCache.put("invQueryConfigCache", invQueryConfigStr);
        String pcEntityStr = DynamicObjectSerializeUtil.serialize((Object[])new DynamicObject[]{currEntityObject}, (DynamicObjectType)dataEntityType);
        customParams.put("invQueryConfig", invQueryConfigStr);
        customParams.put("datasource", pcEntityStr);
        customParams.put("pcEntityKey", this.getPcEntityKey());
        if (material == null) {
            customParams.put("srcFilterFrom", "msmob_invquerycondition");
            PageUtils.showFormPage((IFormView)currentView, (String)"msmob_invquerycondition", (Map)customParams, (CloseCallBack)closeCallBack);
        } else {
            QFilter qFilter = this.createInvRealBalanceFilter(currEntityObject, currentRowIndex, invQueryConfig);
            customParams.put("filterCondition", qFilter.toSerializedString());
            customParams.put("srcFilterFrom", "mob_bizbill");
            this.showInvQueryResultList(customParams, closeCallBack);
        }
    }

    private void showInvQueryResultList(Map<String, Object> customParams, CloseCallBack closeCallBack) {
        IDataModel model = this.getModel();
        IFormView currentView = this.getView();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org != null) {
            Long orgId = Long.valueOf(org.getPkValue().toString());
            boolean isView = PermissionHelper.checkPermission((Long)orgId, (String)MetaUtils.getPcAppId((String)"im_inv_realbalance"), (String)"im_inv_realbalance", (String)"47150e89000000ac");
            if (isView) {
                PageUtils.showFormPage((IFormView)currentView, (String)"msmob_invqueryresult", customParams, (CloseCallBack)closeCallBack);
            } else {
                String errMsg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5373\u65f6\u5e93\u5b58\u4f59\u989d\u8868\u7684\u67e5\u8be2\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MobBizBillInfoTplPlugin_INVQUERY_PERMVIEW", (String)"scmc-msmob-form", (Object[])new Object[0]);
                currentView.showErrorNotification(errMsg);
            }
        }
    }

    private InvQueryConfig getInvQueryConfig(String invQueryOpItemKey) {
        String entityId = MetadataDao.getIdByNumber((String)this.getPcEntityKey(), (MetaCategory)MetaCategory.Entity);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        List items = entityMetadata.getItems();
        String opParameter = this.getOperationParameter(items, invQueryOpItemKey);
        InvQueryConfig invQueryConfig = this.parseOpParameter(opParameter);
        return invQueryConfig;
    }

    private InvQueryConfig parseOpParameter(String opParameter) {
        Map paramDictionary = (Map)SerializationUtils.fromJsonString((String)opParameter, Map.class);
        Map settingParam = (Map)paramDictionary.get("settingparam");
        List fieldMappings = (List)paramDictionary.get("fielddata");
        InvQueryConfig invQueryConfig = this.createInvQueryConfig(settingParam, fieldMappings);
        return invQueryConfig;
    }

    private InvQueryConfig createInvQueryConfig(Map<String, Object> settingParam, List<Map<String, Object>> invQueryFieldMappings) {
        InvQueryConfig invQueryConfig = new InvQueryConfig();
        ParameterSetting parameterSetting = this.createParameterSetting(settingParam);
        List<InvQueryFieldMappingRelation> invQueryFieldMappingList = this.createInvQueryFieldMappings(invQueryFieldMappings);
        invQueryConfig.setParameterSetting(parameterSetting);
        invQueryConfig.setInvQueryFieldMappingRelations(invQueryFieldMappingList);
        return invQueryConfig;
    }

    private ParameterSetting createParameterSetting(Map<String, Object> settingParam) {
        ParameterSetting parameterSetting = new ParameterSetting();
        if (settingParam != null && settingParam.size() > 0) {
            String returnType = (String)settingParam.get("returntype");
            String dealType = (String)settingParam.get("dealtype");
            String proQtyField = (String)settingParam.get("proqtyfield");
            String qtyRule = (String)settingParam.get("qtyrule");
            Boolean newDeal = (Boolean)settingParam.get("newdeal");
            String actionId = (String)settingParam.get("actionid");
            String pluginName = (String)settingParam.get("pluginname");
            parameterSetting.setReturnType(returnType);
            parameterSetting.setDealType(dealType);
            parameterSetting.setSupplyQtyField(proQtyField);
            parameterSetting.setQtyRule(qtyRule);
            parameterSetting.setNewDeal(newDeal);
            parameterSetting.setActionId(actionId);
            parameterSetting.setPluginName(pluginName);
        }
        return parameterSetting;
    }

    private List<InvQueryFieldMappingRelation> createInvQueryFieldMappings(List<Map<String, Object>> invQueryFieldMappings) {
        ArrayList<InvQueryFieldMappingRelation> fieldMappingConfigs = new ArrayList<InvQueryFieldMappingRelation>(10);
        if (invQueryFieldMappings == null || invQueryFieldMappings.isEmpty()) {
            return fieldMappingConfigs;
        }
        Map<String, PropertyNode> fieldMapping = this.getFieldMappingOfQueryCondition();
        for (Map.Entry<String, PropertyNode> fieldMappingEntry : fieldMapping.entrySet()) {
            InvQueryFieldMappingRelation invQueryFieldMapping = new InvQueryFieldMappingRelation();
            String invFilterFieldkey = fieldMappingEntry.getKey();
            PropertyNode realBalFieldNode = fieldMappingEntry.getValue();
            String realBalFieldKey = realBalFieldNode.getFieldKey();
            for (Map<String, Object> fieldMappingInfo : invQueryFieldMappings) {
                String invRealBalFieldKey = (String)fieldMappingInfo.get("metadatakey");
                String pcFieldKey = (String)fieldMappingInfo.get("currentmetadatakey");
                Boolean isFilter = (Boolean)fieldMappingInfo.get("qfilter");
                Boolean isUpdate = (Boolean)fieldMappingInfo.get("update");
                Boolean isMatch = (Boolean)fieldMappingInfo.get("match");
                if (!realBalFieldKey.equals(invRealBalFieldKey) || StringUtils.isEmpty((CharSequence)pcFieldKey)) continue;
                isMatch = isMatch == null ? Boolean.FALSE : isMatch;
                isFilter = isFilter == null ? Boolean.FALSE : isFilter;
                isUpdate = isUpdate == null ? Boolean.FALSE : isUpdate;
                invQueryFieldMapping.setMatch(isMatch);
                invQueryFieldMapping.setFilter(isFilter);
                invQueryFieldMapping.setUpdate(isUpdate);
                invQueryFieldMapping.setPcFieldKey(pcFieldKey);
                invQueryFieldMapping.setRealBalFieldKey(realBalFieldKey);
                invQueryFieldMapping.setInvFilterFieldKey(invFilterFieldkey);
                fieldMappingConfigs.add(invQueryFieldMapping);
            }
        }
        return fieldMappingConfigs;
    }

    private Map<String, PropertyNode> getFieldMappingOfQueryCondition() {
        DataSourceConfigServiceImpl dataSourceConfigService = new DataSourceConfigServiceImpl();
        DataSourceConfig dataSourceConfig = dataSourceConfigService.getDataSourceConfig("msmob_invquerycondition");
        Map fieldMapping = dataSourceConfig.getFieldMapping();
        return fieldMapping;
    }

    private String getOperationParameter(List<EntityItem<?>> items, String invQueryOpKey) {
        String pcEntityKey = this.getPcEntityKey();
        for (EntityItem<?> item : items) {
            String itemKey = item.getKey();
            if (!pcEntityKey.equals(itemKey)) continue;
            List operations = ((BillEntity)item).getOperations();
            for (Operation operation : operations) {
                String key = operation.getKey();
                String operationType = operation.getOperationType();
                if (!INV_QUERY_OP_TYPE_KEY.equals(operationType) || !key.equals(invQueryOpKey)) continue;
                CustOperationParameter operationParameter = (CustOperationParameter)operation.getParameter();
                String parameter = operationParameter.getParameter();
                return parameter;
            }
        }
        return "";
    }

    private QFilter createInvRealBalanceFilter(DynamicObject currEntityObject, int entryRowIndex, InvQueryConfig invQueryConfig) {
        QFilter invRealBalanceFilter = new QFilter("1", "=", (Object)SCMCBaseBillMobConst.IDENT_EQ_VAL);
        List invQueryFieldMappingRelations = invQueryConfig.getInvQueryFieldMappingRelations();
        for (InvQueryFieldMappingRelation invQueryFieldMapping : invQueryFieldMappingRelations) {
            Boolean isFilter = invQueryFieldMapping.getFilter();
            if (!isFilter.booleanValue()) continue;
            String pcFieldKey = invQueryFieldMapping.getPcFieldKey();
            String tempPcFieldKey = pcFieldKey.contains(".") ? pcFieldKey.substring(pcFieldKey.lastIndexOf(".") + 1) : pcFieldKey;
            IDataEntityProperty property = ((BillEntityType)currEntityObject.getDynamicObjectType()).findProperty(tempPcFieldKey);
            Object fieldValue = null;
            if (this.isHeadProp(property)) {
                fieldValue = currEntityObject.get(pcFieldKey);
            } else if (this.isSubEntryProp(property)) {
                IDataEntityType parent = property.getParent();
                IDataEntityType entry = parent.getParent();
                String pcEntryKey = entry.getName();
                String pcSubEntryKey = parent.getName();
                fieldValue = this.getSubEntryFieldValue(currEntityObject, pcEntryKey, pcSubEntryKey, pcFieldKey, entryRowIndex);
            } else if (this.isEntryProp(property)) {
                String entryKey = property.getParent().getName();
                fieldValue = this.getEntryFieldValue(currEntityObject, entryKey, pcFieldKey, entryRowIndex);
            }
            if (fieldValue == null || "".equals(fieldValue)) continue;
            String realBalFieldKey = invQueryFieldMapping.getRealBalFieldKey();
            if (fieldValue instanceof DynamicObject) {
                IDataEntityProperty masterIdProp = ((RefEntityType)((DynamicObject)fieldValue).getDynamicObjectType()).findProperty("masterid");
                if (masterIdProp instanceof BasedataProp) {
                    fieldValue = ((DynamicObject)fieldValue).get("masterid");
                }
                Long id = ((DynamicObject)fieldValue).getLong("id");
                StringBuilder newFieldKey = new StringBuilder();
                newFieldKey.append(realBalFieldKey);
                newFieldKey.append('.');
                newFieldKey.append("id");
                invRealBalanceFilter.and(newFieldKey.toString(), "=", (Object)id);
                continue;
            }
            if (fieldValue instanceof Object[]) {
                invRealBalanceFilter.and(realBalFieldKey, "in", fieldValue);
                continue;
            }
            invRealBalanceFilter.and(realBalFieldKey, "=", fieldValue);
        }
        return invRealBalanceFilter;
    }

    protected Object getSubEntryFieldValue(DynamicObject currEntityObject, String pcEntryKey, String pcSubEntryKey, String pcSubEntryFieldKey, int subEntryRowIndex) {
        String errMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u6682\u4e0d\u652f\u6301\u5b50\u5206\u5f55\u5b57\u6bb5\u503c\u7684\u83b7\u53d6\uff0c\u8bf7\u91cd\u5199MobBizBillInfoTplPlugin.getSubEntryFieldValue\u65b9\u6cd5\u3002", (String)"MobBizBillInfoTplPlugin_getSubEntryFieldValue", (String)"scmc-msmob-form", (Object[])new Object[0]), new Object[0]);
        throw new KDBizException(errMsg);
    }

    private Object getEntryFieldValue(DynamicObject currEntityObject, String pcEntryKey, String pcEntryFieldKey, int entryRowIndex) {
        IDataModel model = this.getModel();
        DataSourceConfig dataSourceConfig = this.getDataSourceConfig();
        EntryMappingRelationship entryMappingRelationship = DataSourceConfigHelper.getEntryMappingRelationship((DataSourceConfig)dataSourceConfig, (String)pcEntryKey);
        String mobEntryIdKey = entryMappingRelationship.getMobEntryIdKey();
        Long mobEntryId = (Long)model.getValue(mobEntryIdKey, entryRowIndex);
        DynamicObjectCollection entryRowColl = currEntityObject.getDynamicObjectCollection(pcEntryKey);
        DynamicObject currEntryRow = entryRowColl.stream().filter(entryRow -> entryRow.getPkValue().equals(mobEntryId)).findFirst().get();
        pcEntryFieldKey = pcEntryFieldKey.contains(".") ? pcEntryFieldKey.substring(pcEntryFieldKey.lastIndexOf(".") + 1) : pcEntryFieldKey;
        Object fieldValue = currEntryRow.get(pcEntryFieldKey);
        return fieldValue;
    }

    private boolean isHeadProp(IDataEntityProperty property) {
        return property == null ? false : property.getParent() instanceof MainEntityType;
    }

    private boolean isSubEntryProp(IDataEntityProperty property) {
        return property == null ? false : property.getParent() instanceof SubEntryType;
    }

    private boolean isEntryProp(IDataEntityProperty property) {
        return !this.isSubEntryProp(property) && property != null && property.getParent() instanceof EntryType;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "clickMobInvQueryOpCallBack": {
                String returnData = (String)closedCallBackEvent.getReturnData();
                List pcEntityIds = (List)JSON.parseObject((String)returnData, List.class);
                MobInvQueryHelper.mobInvQueryCloseCallBack(this, pcEntityIds);
                this.setMainEntryTitle();
                break;
            }
        }
        String entryKey = this.getEntryEntity();
        this.getView().updateView(entryKey);
    }

    protected IPageCache getMainPageCache() {
        return this.getPageCache();
    }

    protected DynamicObject dealWithInvRealBalance(DynamicObject pcEntityFromCache, DynamicObject invRealBalance) {
        this.updateQtyInfoOfInvRealBalance(invRealBalance);
        IPageCache pageCache = this.getPageCache();
        String currMobEntryKey = pageCache.get("currEntryKeyOfInvQuery");
        String pcEntryKey = pageCache.get(currMobEntryKey);
        DynamicObject currPcEntryRow = this.getCurrEntryRow(pcEntityFromCache, pcEntryKey);
        if (currPcEntryRow == null) {
            return pcEntityFromCache;
        }
        String invQueryConfigCache = pageCache.get("invQueryConfigCache");
        InvQueryConfig invQueryConfig = (InvQueryConfig)SerializationUtils.fromJsonString((String)invQueryConfigCache, InvQueryConfig.class);
        List invQueryFieldMappingRelations = invQueryConfig.getInvQueryFieldMappingRelations();
        boolean isMatchAll = this.isMatchAll(currPcEntryRow, invRealBalance, invQueryFieldMappingRelations);
        if (!isMatchAll) {
            return pcEntityFromCache;
        }
        this.setLineType(currPcEntryRow);
        HashMap<String, String> invQtyMap = new HashMap<String, String>(16);
        HashMap<String, BigDecimal> qtyMap = new HashMap<String, BigDecimal>(16);
        HashMap<String, BigDecimal> avbQtyMap = new HashMap<String, BigDecimal>(16);
        List qtyFields = MobInvQueryConst.INV_REAL_BALANCE_QTY_FIELDS;
        List avbQtyFields = MobInvQueryConst.INV_REAL_BALANCE_AVBQTY_FIELDS;
        ParameterSetting parameterSetting = invQueryConfig.getParameterSetting();
        String qtyRule = parameterSetting.getQtyRule();
        for (InvQueryFieldMappingRelation fieldMappingRelation : invQueryFieldMappingRelations) {
            Object invRealBalFieldValue;
            Boolean isUpdate = fieldMappingRelation.getUpdate();
            if (!isUpdate.booleanValue()) continue;
            String pcFieldKey = fieldMappingRelation.getPcFieldKey();
            String setValuePcFieldKey = this.getPcFieldKeyOfSettingValue(pcFieldKey);
            String invRealBalanceFieldKey = fieldMappingRelation.getRealBalFieldKey();
            if ("material".equals(invRealBalanceFieldKey)) {
                DynamicObject org = (DynamicObject)invRealBalance.get("org");
                DynamicObject material = (DynamicObject)invRealBalance.get(invRealBalanceFieldKey);
                Long orgId = org.getLong("id");
                String orgNumber = org.getString("number");
                invRealBalFieldValue = this.getMaterialInvInfo(material, orgId, orgNumber, setValuePcFieldKey, pcEntityFromCache);
            } else if (invRealBalanceFieldKey.contains("qty")) {
                invQtyMap.put(invRealBalanceFieldKey, setValuePcFieldKey);
                BigDecimal reqQty = currPcEntryRow.getBigDecimal(setValuePcFieldKey);
                BigDecimal supplyQty = invRealBalance.getBigDecimal(invRealBalanceFieldKey);
                invRealBalFieldValue = reqQty != null && reqQty.compareTo(BigDecimal.ZERO) != 0 && "minrule".equals(qtyRule) ? (reqQty.compareTo(supplyQty) > 0 ? supplyQty : reqQty) : ("reqqty".equals(qtyRule) ? reqQty : supplyQty);
                if (avbQtyFields.contains(invRealBalanceFieldKey)) {
                    avbQtyMap.put(setValuePcFieldKey, (BigDecimal)invRealBalFieldValue);
                } else if (qtyFields.contains(invRealBalanceFieldKey)) {
                    qtyMap.put(setValuePcFieldKey, (BigDecimal)invRealBalFieldValue);
                }
            } else {
                invRealBalFieldValue = invRealBalance.get(invRealBalanceFieldKey);
            }
            currPcEntryRow.set(setValuePcFieldKey, invRealBalFieldValue);
            if (!"lotnum".equals(invRealBalanceFieldKey)) continue;
            this.setLotValue(pcEntityFromCache, invRealBalance, currPcEntryRow, pcEntryKey, pcFieldKey);
        }
        boolean updateZeroToQty2nd = this.isUpdateZeroToQty2nd(currPcEntryRow, invQueryFieldMappingRelations);
        this.setBillQtyByDirFromQty(currPcEntryRow, qtyMap, invQtyMap, updateZeroToQty2nd, "qty", "qty2nd");
        this.setBillQtyByDirFromQty(currPcEntryRow, avbQtyMap, invQtyMap, updateZeroToQty2nd, "avbqty", "avbqty2nd");
        Long entryId = Long.valueOf(currPcEntryRow.getPkValue().toString());
        return pcEntityFromCache;
    }

    private void setFieldValueOfPc(DynamicObject currPcEntryRow, String pcFieldKey, Object pcFieldValue, String invRealBalFieldKey) {
        if (invRealBalFieldKey == null || NOT_UPDATE_FIELDKEYS.contains(invRealBalFieldKey)) {
            currPcEntryRow.set(pcFieldKey, pcFieldValue);
        }
    }

    private void setBillQtyByDirFromQty(DynamicObject currPcEntryRow, Map<String, BigDecimal> qtyMap, Map<String, String> invQtyMap, boolean updateZeroToQty2nd, String qtyKey, String qty2ndKey) {
        this.setBillQty(currPcEntryRow, qtyMap, invQtyMap, qtyKey);
        String qty2ndKeyOfPc = invQtyMap.get(qty2ndKey);
        if (qty2ndKeyOfPc == null) {
            return;
        }
        if (updateZeroToQty2nd) {
            this.setFieldValueOfPc(currPcEntryRow, qty2ndKeyOfPc, BigDecimal.ZERO, qty2ndKey);
        } else if (qty2ndKeyOfPc != null) {
            BigDecimal avbqty2ndValue = qtyMap.get(qty2ndKeyOfPc).compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : qtyMap.get(qty2ndKeyOfPc);
            this.setFieldValueOfPc(currPcEntryRow, qty2ndKeyOfPc, avbqty2ndValue, qty2ndKey);
        }
    }

    protected final DynamicObject getCurrEntryRow(DynamicObject pcEntityFromCache, String pcEntryKey) {
        IPageCache pageCache = this.getMainPageCache();
        int currEntryRowIndex = Integer.parseInt(pageCache.get("currEntryRowIndexOfInvQuery"));
        DynamicObjectCollection entryRowColl = pcEntityFromCache.getDynamicObjectCollection(pcEntryKey);
        if (entryRowColl == null || entryRowColl.isEmpty()) {
            return null;
        }
        return (DynamicObject)entryRowColl.get(currEntryRowIndex);
    }

    protected final void updateQtyInfoOfInvRealBalance(DynamicObject invRealBalance) {
        QFilter qFilter = new QFilter("id", "=", invRealBalance.getPkValue());
        DataSet invaccAvbBaseqty = ReserveHelper.getInvaccAvbbaseqty((QFilter[])qFilter.toArray());
        while (invaccAvbBaseqty.hasNext()) {
            Row row = invaccAvbBaseqty.next();
            Object invRealBalanceIdFromReserve = row.get("id");
            Object invRealBalanceId = invRealBalance.getPkValue();
            if (!invRealBalanceId.equals(invRealBalanceIdFromReserve)) continue;
            invRealBalance.set("avbqty", row.get("avbbqty"));
            invRealBalance.set("avbbaseqty", row.get("avbbaseqty"));
            invRealBalance.set("avbqty2nd", row.get("avbbtndqty"));
            invRealBalance.set("lockqty", row.get("reserveqty"));
            invRealBalance.set("lockbaseqty", row.get("reservebaseqty"));
            invRealBalance.set("lockqty2nd", row.get("reserveunit2ndqty"));
            break;
        }
    }

    private boolean isUpdateZeroToQty2nd(DynamicObject currPcEntryRow, List<InvQueryFieldMappingRelation> invQueryFieldMappingRelations) {
        ArrayList<InvQueryFieldMappingRelation> matchFieldMappings = new ArrayList<InvQueryFieldMappingRelation>(10);
        ArrayList<InvQueryFieldMappingRelation> updateFieldMappings = new ArrayList<InvQueryFieldMappingRelation>(10);
        ArrayList<InvQueryFieldMappingRelation> updateOrMatchFieldMappings = new ArrayList<InvQueryFieldMappingRelation>(10);
        for (InvQueryFieldMappingRelation fieldMappingRelation : invQueryFieldMappingRelations) {
            Boolean isUpdate = fieldMappingRelation.getUpdate();
            Boolean isMatch = fieldMappingRelation.getMatch();
            if (isUpdate.booleanValue()) {
                updateFieldMappings.add(fieldMappingRelation);
            }
            if (!isMatch.booleanValue()) continue;
            matchFieldMappings.add(fieldMappingRelation);
        }
        updateOrMatchFieldMappings.addAll(updateFieldMappings);
        updateOrMatchFieldMappings.addAll(matchFieldMappings);
        Map<String, String> qtyKeyMap = this.getBillQtyAndQty2ndKey(updateOrMatchFieldMappings);
        boolean updateQty2nd = false;
        String qtyUnit2ndKey = qtyKeyMap.get("qtyunit2nd");
        String qtyKey = qtyKeyMap.get("qty");
        if (StringUtils.isNotBlank((CharSequence)qtyUnit2ndKey) && StringUtils.isNotBlank((CharSequence)qtyKey)) {
            BigDecimal pageQty2nd = currPcEntryRow.getBigDecimal(qtyUnit2ndKey);
            BigDecimal pageQty = currPcEntryRow.getBigDecimal(qtyKey);
            updateQty2nd = pageQty != null && pageQty.compareTo(BigDecimal.ZERO) != 0 && (pageQty2nd == null || pageQty2nd.compareTo(BigDecimal.ZERO) == 0);
        }
        return updateQty2nd;
    }

    private Map<String, String> getBillQtyAndQty2ndKey(List<InvQueryFieldMappingRelation> updateOrMatchFieldMappings) {
        HashMap<String, String> keyMap = new HashMap<String, String>(16);
        for (InvQueryFieldMappingRelation fieldMappingRelation : updateOrMatchFieldMappings) {
            String pcFieldKey = fieldMappingRelation.getPcFieldKey();
            String realBalFieldKey = fieldMappingRelation.getRealBalFieldKey();
            pcFieldKey = this.getPcFieldKeyOfSettingValue(pcFieldKey);
            if ("avbqty".equals(realBalFieldKey) || "qty".equals(realBalFieldKey)) {
                keyMap.put("qty", pcFieldKey);
            }
            if (!"avbqty2nd".equals(realBalFieldKey) && !"qty2nd".equals(realBalFieldKey)) continue;
            keyMap.put("qtyunit2nd", pcFieldKey);
        }
        return keyMap;
    }

    protected final String getPcFieldKeyOfSettingValue(String pcFieldKey) {
        int index;
        int n = index = StringUtils.isEmpty((CharSequence)pcFieldKey) ? -1 : pcFieldKey.lastIndexOf(46);
        if (index != -1) {
            pcFieldKey = pcFieldKey.substring(index + 1);
        }
        return pcFieldKey;
    }

    private void setBillQty(DynamicObject currPcEntryRow, Map<String, BigDecimal> qtyMap, Map<String, String> invQtyMap, String invRealBalQtyKey) {
        String pcFieldKey = invQtyMap.get(invRealBalQtyKey);
        if (pcFieldKey != null) {
            BigDecimal qtyValue = qtyMap.get(invQtyMap.get(invRealBalQtyKey));
            currPcEntryRow.set(pcFieldKey, (Object)qtyValue);
        }
    }

    protected void setLotValue(DynamicObject pcEntityFromCache, DynamicObject invRealBalance, DynamicObject currPcEntryRow, String pcEntryKey, String pcEntryFieldKey) {
        Long lotMainFileId;
        Boolean isUseLotMf = (Boolean)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"isUseLotMainFile", (Object[])new Object[0]);
        if (isUseLotMf.booleanValue() && (lotMainFileId = this.getLotMainFileId(invRealBalance)) != null) {
            this.setLotValue(currPcEntryRow, pcEntityFromCache, pcEntryKey, pcEntryFieldKey, lotMainFileId);
        }
    }

    private Long getLotMainFileId(DynamicObject invRealBalance) {
        Long lotId;
        HashMap<Long, Long> realBalanceTolot = new HashMap<Long, Long>(16);
        RowMeta billentryRowMeta = new RowMeta(new Field[]{new Field("id", (DataType)DataType.LongType), new Field("matPK", (DataType)DataType.LongType), new Field("orgId", (DataType)DataType.LongType), new Field("lotnum", (DataType)DataType.StringType)});
        DataSetBuilder billentryDsBuilder = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSetBuilder(billentryRowMeta);
        Object orgId = invRealBalance.getDynamicObject("org").getPkValue();
        Object matPK = invRealBalance.getDynamicObject("material").getPkValue();
        Object invRealBalanceId = invRealBalance.getPkValue();
        String lotnum = invRealBalance.getString("lotnum");
        billentryDsBuilder.append(new Object[]{invRealBalanceId, matPK, orgId, lotnum});
        DataSet billentryDataSet = billentryDsBuilder.build();
        DataSet lotMainFileDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_lot", (String)"id as mainfileid,number as mflotnumber, material as mfmaterialid,createorg as mfinvorg", (QFilter[])new QFilter("number", "=", (Object)lotnum).toArray(), (String)"");
        JoinDataSet tempDataSet = billentryDataSet.leftJoin(lotMainFileDataSet).on("lotnum", "mflotnumber");
        Integer unqCtrl = (Integer)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"getUnqctrl", (Object[])new Object[0]);
        if (unqCtrl == 2 || unqCtrl == 4) {
            tempDataSet.on("matPK", "mfmaterialid");
        }
        if (unqCtrl == 3 || unqCtrl == 4) {
            tempDataSet.on("orgId", "mfinvorg");
        }
        DataSet billLotRelWithMatDataSet = tempDataSet.select(billentryDataSet.getRowMeta().getFieldNames(), lotMainFileDataSet.getRowMeta().getFieldNames()).finish();
        while (billLotRelWithMatDataSet.hasNext()) {
            Row row = billLotRelWithMatDataSet.next();
            Long realBalanceId = row.getLong("id");
            lotId = row.getLong("mainfileid");
            realBalanceTolot.put(realBalanceId, lotId);
        }
        long realBalanceId = invRealBalance.getLong("id");
        lotId = (Long)realBalanceTolot.get(realBalanceId);
        return lotId;
    }

    private void setLotValue(DynamicObject currPcEntryRow, DynamicObject pcEntityCache, String pcEntryKey, String pcEntryFieldKey, Long lotMainFileId) {
        String pcEntityKey = this.getPcEntityKey();
        Set cfgDynamicObject = (Set)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"getLotMainFileBillConfigByBillAndLotNum", (Object[])new Object[]{pcEntityKey, pcEntryKey, pcEntityCache, pcEntryFieldKey});
        if (cfgDynamicObject == null || cfgDynamicObject.size() == 0) {
            return;
        }
        ArrayList listCfgDynamicObject = new ArrayList(cfgDynamicObject);
        String entryLotKey = ((DynamicObject)listCfgDynamicObject.get(0)).getString("lotidfield");
        if (entryLotKey.indexOf(46) != -1) {
            String[] keys = entryLotKey.split("\\.");
            entryLotKey = keys[keys.length - 1];
        }
        currPcEntryRow.set(entryLotKey + "_id", (Object)lotMainFileId);
    }

    protected final void setLineType(DynamicObject currPcEntryRow) {
        DynamicProperty lineTypeProp = currPcEntryRow.getDynamicObjectType().getProperty("linetype");
        if (lineTypeProp == null) {
            return;
        }
        QFilter filter = new QFilter("number", "=", (Object)"010");
        DynamicObject lineType = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_linetype", (QFilter[])filter.toArray());
        lineType.set("linetype", (Object)lineType);
    }

    protected final boolean isMatchAll(DynamicObject currPcEntryRow, DynamicObject invRealBalance, List<InvQueryFieldMappingRelation> invQueryFieldMappingRelations) {
        for (InvQueryFieldMappingRelation fieldMappingRelation : invQueryFieldMappingRelations) {
            boolean match;
            boolean isEmptyRealBalFieldValue;
            Boolean isMatch = fieldMappingRelation.getMatch();
            if (!isMatch.booleanValue()) continue;
            String pcFieldKey = fieldMappingRelation.getPcFieldKey();
            String realBalFieldKey = fieldMappingRelation.getRealBalFieldKey();
            String setValueFieldKey = this.getPcFieldKeyOfSettingValue(pcFieldKey);
            DynamicProperty property = currPcEntryRow.getDynamicObjectType().getProperty(setValueFieldKey);
            if (property == null) continue;
            Object entryFieldValue = currPcEntryRow.get(setValueFieldKey);
            Object realBalFieldValue = invRealBalance.get(realBalFieldKey);
            if (pcFieldKey != null && "material".equals(realBalFieldKey) && entryFieldValue == null) {
                return true;
            }
            boolean isEmptyBillFieldValue = entryFieldValue == null || "".equals(entryFieldValue);
            boolean bl = isEmptyRealBalFieldValue = realBalFieldValue == null || "".equals(realBalFieldValue);
            if (isEmptyBillFieldValue) {
                match = true;
            } else {
                if (isEmptyRealBalFieldValue) {
                    return false;
                }
                match = this.isMatchNotNull(entryFieldValue, realBalFieldValue);
            }
            if (match) continue;
            return false;
        }
        return true;
    }

    private boolean isMatchNotNull(Object entryFieldValue, Object realBalFieldValue) {
        if (entryFieldValue instanceof DynamicObject) {
            IDataEntityProperty masterIdProp = ((RefEntityType)((DynamicObject)entryFieldValue).getDynamicObjectType()).findProperty("masterid");
            if (masterIdProp instanceof BasedataProp) {
                entryFieldValue = ((DynamicObject)entryFieldValue).get("masterid");
            }
            return ((DynamicObject)entryFieldValue).getPkValue().equals(((DynamicObject)realBalFieldValue).getPkValue());
        }
        if (entryFieldValue instanceof Object[]) {
            Object[] entryFieldValueArr = (Object[])entryFieldValue;
            Object[] realBalFieldValueArr = (Object[])realBalFieldValue;
            return Arrays.deepEquals(entryFieldValueArr, realBalFieldValueArr);
        }
        return entryFieldValue.equals(realBalFieldValue);
    }

    protected final DynamicObject getMaterialInvInfo(DynamicObject material, Long orgId, String orgNumber, String pcFieldKey, DynamicObject pcEntity) {
        Long materialId = material.getLong("id");
        String materialNumber = material.getString("number");
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)orgId);
        QFilter masterFilter = new QFilter("masterid", "=", (Object)materialId);
        baseDataFilter.and(masterFilter);
        MainEntityType pcMainEntityType = (MainEntityType)pcEntity.getDynamicObjectType();
        BasedataProp basedataProp = (BasedataProp)pcMainEntityType.findProperty(pcFieldKey);
        Map invMaterial = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)((DynamicObjectType)basedataProp.getComplexType((Object)pcEntity)), (QFilter[])baseDataFilter.toArray());
        if (invMaterial == null || invMaterial.size() == 0) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u901a\u8fc7\u7f16\u7801\u4e3a\u3010%1$s\u3011\u7684\u7269\u6599\u548c\u7f16\u7801\u4e3a\u3010%2$s\u3011\u7684\u5e93\u5b58\u7ec4\u7ec7\u5339\u914d\u5230\u7684\u5e93\u5b58\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MobBizBillTplCachePlugin_getMaterialInvInfo_0", (String)"scmc-mobim-form", (Object[])new Object[0]), materialNumber, orgNumber);
            throw new KDBizException(errMsg);
        }
        ArrayList invMaterials = new ArrayList(invMaterial.values());
        return (DynamicObject)invMaterials.get(0);
    }
}

