/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.adjustbill.cache;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.mobim.plugin.form.adjustbill.cache.MobBizBillTplCachePlugin;
import kd.scmc.msmob.business.helper.DataSourceConfigHelper;
import kd.scmc.msmob.business.helper.change.DataChangedHandlerHelper;
import kd.scmc.msmob.business.helper.change.handler.IEntryRowDeletedHandler;
import kd.scmc.msmob.pojo.DataSourceConfig;

public abstract class MobBizBillTplNewPlugin
extends MobBizBillTplCachePlugin {
    private static final Log LOG = LogFactory.getLog(MobBizBillTplNewPlugin.class);

    public MobBizBillTplNewPlugin() {
        this.registerEntryRowAddedHandler(context -> this.newEntrySetValue(context.getNewEntryRowData(), context.getCalculatedResult()));
    }

    private void deleteEntryRow() {
        IDataModel model = this.getModel();
        String mobEntryKey = this.getEntryEntity();
        int deleteRow = model.getEntryCurrentRowIndex(mobEntryKey);
        DataChangedHandlerHelper.deleteEntry((AbstractFormPlugin)this, (IEntryRowDeletedHandler)this.getEntryRowDeletedHandler(), (String)mobEntryKey, (int)deleteRow);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("deleteEntryRowCfirmCB".equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            this.deleteEntryRow();
        } else if ("beforeCloseConfirmCallBack".equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            this.getView().close();
        }
    }

    public void updateData() {
        DynamicObject pcEntityCache = this.getPcEntityFromCache();
        this.curData = new DynamicObject[]{pcEntityCache};
        this.setModelValue();
    }

    protected final void refreshPageData() {
        Long billId = this.getBillId();
        if (billId != null && !billId.equals(0L)) {
            DynamicObject singleData = BusinessDataServiceHelper.loadSingle((Object)billId, (String)this.getPcEntityKey());
            this.curData = new DynamicObject[]{singleData};
            this.setModelValue();
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)this.getPcEntityKey());
            this.updateEntityCache(dataEntityType, singleData);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "save": 
            case "submit": {
                if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
                    this.updateBillId(args);
                    this.refreshPageData();
                } else {
                    this.updateData();
                }
                this.setMainEntryTitle();
                break;
            }
        }
        super.afterDoOperation(args);
    }

    private void updateBillId(AfterDoOperationEventArgs args) {
        List successPkIds = args.getOperationResult().getSuccessPkIds();
        if (!successPkIds.isEmpty()) {
            Long currBillId = Long.valueOf(successPkIds.get(0).toString());
            IDataModel model = this.getModel();
            IPageCache pageCache = this.getPageCache();
            model.setValue("billid", (Object)currBillId);
            pageCache.put("pcId", String.valueOf(currBillId));
        }
    }

    protected void newDefaultEntryRow(DynamicObject newPcEntity) {
        IDataModel model = this.getModel();
        String pcEntryKey = DataSourceConfigHelper.getPcEntryKey((DataSourceConfig)this.getDataSourceConfig(), (String)this.getEntryEntity());
        DynamicObjectCollection newPcEntryCollection = newPcEntity.getDynamicObjectCollection(pcEntryKey);
        DynamicObject newPcEntryRow = newPcEntryCollection.addNew();
        long entryId = DB.genLongId((String)this.getPcEntityKey());
        newPcEntryRow.set("id", (Object)entryId);
        newPcEntryRow.set("seq", (Object)1);
        String mobEntryKey = this.getEntryEntity();
        model.batchCreateNewEntryRow(mobEntryKey, 1);
        int currEntryRowCount = model.getEntryCurrentRowIndex(mobEntryKey);
        int nextEntryRowSeq = currEntryRowCount + 1;
        model.beginInit();
        model.setValue("mobentryid", (Object)entryId, nextEntryRowSeq - 1);
        model.endInit();
        this.newEntrySetValue(newPcEntryRow, newPcEntity);
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)this.getPcEntityKey());
        this.updateEntityCache(mainEntityType, newPcEntity);
    }

    protected void newEntrySetValue(DynamicObject newPcEntry, DynamicObject pcEntity) {
    }
}

