/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.applybill;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.scmc.mobim.plugin.form.applybill.MaterialReqBillPagePlugin;
import kd.scmc.mobim.plugin.form.applybill.MaterialReqBillViewPlugin;
import kd.scmc.mobim.plugin.form.applybill.handler.MaterialBillPropertyChangedHandler;
import kd.scmc.mobim.plugin.form.materialpickoutbill.InventoryChangedHandler;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import kd.scmc.msmob.plugin.tpl.basetpl.IMobBillEditable;
import kd.scmc.msmob.pojo.EntryMappingRelationship;

public class MaterialReqBillEditPlugin
extends MaterialReqBillViewPlugin
implements MaterialReqBillPagePlugin,
IMobBillEditable {
    public MaterialReqBillEditPlugin() {
        this.registerPropertyChangedHandler(new InventoryChangedHandler());
        this.registerPropertyChangedHandler(new MaterialBillPropertyChangedHandler());
    }

    public Long getBillId() {
        IDataModel model = this.getModel();
        Object billId = model.getValue("billid");
        if (billId == null || billId.equals(0L)) {
            IFormView view = this.getView();
            FormShowParameter formShowParameter = view.getFormShowParameter();
            Map customParams = formShowParameter.getCustomParams();
            billId = customParams.get("billid");
        }
        return billId == null ? 0L : Long.parseLong(billId.toString());
    }

    @Override
    public String getEntryFormKey() {
        String entryKey = this.getEntryEntity();
        return this.getEntryEditFormKey(entryKey);
    }

    public String getViewFormId() {
        return this.getBillViewFormKey();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setAuditUnit();
    }

    private void setAuditUnit() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entity = model.getEntryEntity("entryentity");
        for (int i = 0; i < entity.size(); ++i) {
            Object value = ((DynamicObject)entity.get(i)).get("unit");
            if (value == null) {
                model.setValue("auditunit", (Object)"", i);
                return;
            }
            ILocaleString name = ((DynamicObject)value).getLocaleString("name");
            if (name == null) {
                model.setValue("auditunit", (Object)"", i);
                return;
            }
            String localeValue = name.getLocaleValue();
            String auditUnit = localeValue == null ? "" : localeValue;
            model.setValue("auditunit", (Object)auditUnit, i);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    public void propertyChangedEntity(DynamicObject pcEntity, String mobFieldKey, String pcFieldKey, ChangeData[] valueSet) {
        pcEntity.set(pcFieldKey, valueSet[0].getDataEntity().get(pcFieldKey));
    }

    public DynamicObject propChangeEntityOfPc(String fieldKey, DynamicObject pcEntity, String pcFieldKey) {
        return pcEntity;
    }

    public DynamicObject propChangeEntryOfPc(String fieldKey, DynamicObject pcEntity, DynamicObject pcEntry, String pcFieldKey) {
        return pcEntity;
    }

    public void propertyChangedEntry(DynamicObject pcEntry, String mobFieldKey, String pcFieldKey, ChangeData changeData) {
        pcEntry.set(pcFieldKey, changeData.getNewValue());
        if ("qty".equals(mobFieldKey)) {
            pcEntry.set("auditqty", changeData.getNewValue());
        }
    }

    private String getPcEntryKey(String mobEntryKey) {
        List entryMappingRelationships = this.getEntryMappingRelationships();
        if (StringUtils.isEmpty((CharSequence)mobEntryKey) || entryMappingRelationships == null || entryMappingRelationships.isEmpty()) {
            return "";
        }
        for (EntryMappingRelationship entryMappingRelationship : entryMappingRelationships) {
            String mEntryKey = entryMappingRelationship.getMobEntryKey();
            if (!mobEntryKey.equals(mEntryKey)) continue;
            return entryMappingRelationship.getPcEntryKey();
        }
        return "";
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "newentry": {
                DynamicObject pcEntityFromCache = EntityCacheHelper.getPcEntityFromCache((IFormView)this.getView(), (String)this.getPcEntityKey());
                String pcEntryEntityKey = this.getView().getPageCache().get(this.getEntryEntity());
                DynamicObject newPcEntryRow = (DynamicObject)pcEntityFromCache.getDynamicObjectCollection(pcEntryEntityKey).get(this.getModel().getEntryCurrentRowIndex(this.getEntryEntity()));
                this.newEntrySetValue(newPcEntryRow, pcEntityFromCache);
                break;
            }
            case "save": 
            case "submit": {
                OperationResult operationResult = args.getOperationResult();
                if (!this.isPush() || !operationResult.isSuccess()) break;
                Long billId = (Long)operationResult.getSuccessPkIds().get(0);
                DynamicObject pushedPcEntity = EntityCacheHelper.getPcEntityObject((Long)billId, (String)this.getPcEntityKey());
                EntityCacheHelper.savePcEntityToPageCache((IFormView)this.getView(), (DynamicObject)pushedPcEntity);
                break;
            }
        }
    }

    protected void newEntrySetValue(DynamicObject newPcEntryRow, DynamicObject pcEntity) {
    }
}

