/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.applybill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.scmc.im.business.helper.WareHouseIsolateHelper;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.mobim.plugin.form.applybill.handler.MaterialBillPropertyChangedHandler;
import kd.scmc.mobim.plugin.form.materialpickoutbill.InventoryChangedHandler;
import kd.scmc.mobim.plugin.form.transdirbill.ITransApplyBillPagePlugin;
import kd.scmc.msmob.common.utils.FormUtils;
import kd.scmc.msmob.common.utils.LabelAndToolUtils;
import kd.scmc.msmob.plugin.tpl.basetpl.EntryEditTplPlugin;
import kd.scmc.msmob.plugin.tpl.basetpl.IMobBillEditable;

public class MaterialReqEntryEditPlugin
extends EntryEditTplPlugin
implements BeforeF7SelectListener,
ITransApplyBillPagePlugin,
IMobBillEditable {
    private static final Log LOG = LogFactory.getLog(MaterialReqEntryEditPlugin.class);
    private static final String MATERIAL = "material";
    private static final String AUDITQTY = "auditqty";
    private static final String AUDITUNIT = "auditunit";
    private static final String[] MODEL_FIELD_KEYS = new String[]{"billid", "org", "pcentitykey", "material", "qty", "unit", "auditqty", "warehouse", "location"};
    private static final String[] F7_FIELD_KEYS = new String[]{"location", "warehouse"};

    public MaterialReqEntryEditPlugin() {
        this.registerPropertyChangedHandler(new InventoryChangedHandler());
        this.registerPropertyChangedHandler(new MaterialBillPropertyChangedHandler());
    }

    public String getEntryEntity() {
        return "entryentity";
    }

    public List<String> getFieldKeys() {
        return Arrays.asList(MODEL_FIELD_KEYS);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((AbstractFormPlugin)this, (String[])F7_FIELD_KEYS);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        LabelAndToolUtils.selBasedataEditLabelValue((IFormView)this.getView(), (String)"unit", (String)AUDITUNIT);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setAuditUnit();
    }

    private void setAuditUnit() {
        Label auditLabel = (Label)this.getView().getControl(AUDITUNIT);
        IDataModel model = this.getModel();
        Object value = model.getValue("unit");
        if (value == null) {
            auditLabel.setText("");
            return;
        }
        ILocaleString name = ((DynamicObject)value).getLocaleString("name");
        if (name == null) {
            auditLabel.setText("");
            return;
        }
        String localeValue = name.getLocaleValue();
        String auditUnit = localeValue == null ? "" : localeValue;
        auditLabel.setText(auditUnit);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (fieldKey) {
            case "warehouse": {
                DynamicObject org = (DynamicObject)model.getValue("org");
                if (org == null) {
                    e.setCancel(true);
                    break;
                }
                Boolean result = WareHouseIsolateHelper.setWareHouseIsolateF7Filter((String)this.getPcEntityKey(), (DynamicObject)org, (ListShowParameter)showParameter);
                this.commonWareHouseFilter(result, Long.valueOf(org.getPkValue().toString()), showParameter);
                break;
            }
            case "location": {
                DynamicObject warehouse = (DynamicObject)this.getModel().getValue("warehouse");
                if (warehouse == null) {
                    e.setCancel(true);
                    break;
                }
                this.commonLocationFilter(warehouse, showParameter);
                break;
            }
        }
    }

    public DynamicObject getBill() {
        String pcEntityNewCache = this.getParentPageCache().getBigObject("pcEntityCache");
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)this.getPcEntityKey());
        Object[] pcEntityCaches = DynamicObjectSerializeUtil.deserialize((String)pcEntityNewCache, (DynamicObjectType)dataEntityType);
        return (DynamicObject)pcEntityCaches[0];
    }

    private void commonWareHouseFilter(Boolean result, Long orgId, ListShowParameter showParameter) {
        if (!result.booleanValue()) {
            Long[] allWhs = WarehouseHelper.getAllWarehouseIDs((Long)orgId);
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)allWhs));
        }
    }

    private void commonLocationFilter(DynamicObject warehouse, ListShowParameter showParameter) {
        DynamicObjectCollection locationCol = warehouse.getDynamicObjectCollection("entryentity");
        List<Long> ids = this.getLoactionIds(locationCol, "location");
        QFilter qFilter = new QFilter("id", "in", ids);
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    private List<Long> getLoactionIds(DynamicObjectCollection locationCol, String locationkey) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (locationCol == null || locationCol.size() == 0) {
            return ids;
        }
        for (DynamicObject locDym : locationCol) {
            DynamicObject location = locDym.getDynamicObject(locationkey);
            ids.add(Long.valueOf(location.getPkValue().toString()));
        }
        return ids;
    }
}

