/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.applybill;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scmc.im.business.helper.NewInvOrgHelper;
import kd.scmc.im.business.helper.WareHouseIsolateHelper;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.im.utils.CommonUtils;

public class TransBillCommonBeforeF7SelectListener {
    public void beforeF7Select(BeforeF7SelectEvent e, DynamicObject bill) {
        String fieldKey;
        switch (fieldKey = e.getProperty().getName()) {
            case "outorg": {
                this.beforeSelectOutOrg(e, bill);
                break;
            }
            case "inorg": {
                this.beforeSelectInOrg(e, bill);
                break;
            }
            case "warehouse": {
                this.beforeSelectWarehouse(e, bill);
                break;
            }
        }
    }

    public void beforeSelectWarehouse(BeforeF7SelectEvent e, DynamicObject bill) {
        DynamicObject inOrg = (DynamicObject)bill.get("org");
        this.commonWareHouseFilter(inOrg, e, bill);
    }

    private void commonWareHouseFilter(DynamicObject org, BeforeF7SelectEvent e, DynamicObject bill) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if (CommonUtils.isNull((Object)org)) {
            e.setCancel(true);
        } else {
            String formId = bill.getDataEntityType().getName();
            Boolean result = WareHouseIsolateHelper.setWareHouseIsolateF7Filter((String)formId, (DynamicObject)org, (ListShowParameter)showParameter);
            if (Boolean.FALSE.equals(result)) {
                Long[] allWhs = WarehouseHelper.getAllWarehouseIDs((Long)Long.valueOf(org.getPkValue().toString()));
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)allWhs));
            }
        }
    }

    public void beforeSelectOutOrg(BeforeF7SelectEvent e, DynamicObject bill) {
        String formid = bill.getDataEntityType().getName();
        Object[] orgIdList = NewInvOrgHelper.getHasPermissionAndStartedInvOrgIds((String)formid);
        QFilter filter = new QFilter("id", "in", (Object)orgIdList);
        DynamicObject org = (DynamicObject)bill.get("org");
        if (org != null) {
            filter.and("id", "!=", org.getPkValue());
        }
        List qFilters = e.getCustomQFilters();
        qFilters.add(filter);
        e.setCustomQFilters(qFilters);
    }

    public void beforeSelectInOrg(BeforeF7SelectEvent e, DynamicObject bill) {
        QFilter filter = null;
        DynamicObject org = (DynamicObject)bill.get("org");
        if (org != null) {
            filter = new QFilter("id", "!=", org.getPkValue());
        }
        List qFilters = e.getCustomQFilters();
        qFilters.add(filter);
        e.setCustomQFilters(qFilters);
    }
}

