/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.applybill.handler;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.scmc.im.business.helper.MaterialHelper;
import kd.scmc.msmob.business.helper.change.context.PropertyChangedContext;
import kd.scmc.msmob.business.helper.change.handler.IPropertyChangedHandler;

public class MaterialBillPropertyChangedHandler
implements IPropertyChangedHandler {
    private static final String MATERIAL = "material";

    public void onPropertyChanged(PropertyChangedContext context) {
        if (context.isMain()) {
            return;
        }
        DynamicObject calculatedResult = context.getCalculatedResult();
        String pcFieldName = context.getPcFieldName();
        context.getPropertyChangedArgs().getChangeSet();
        DynamicObjectCollection entryList = calculatedResult.getDynamicObjectCollection(context.getPcEntryName());
        DynamicObject changeEntry = (DynamicObject)entryList.get(context.getRowIndex());
        switch (pcFieldName) {
            case "qty": {
                BigDecimal newValue = (BigDecimal)context.getNewValue();
                BigDecimal oldValue = (BigDecimal)context.getOldValue();
                if (newValue == null) {
                    newValue = BigDecimal.ZERO;
                }
                if (oldValue != null && newValue.compareTo(oldValue) != 0) {
                    changeEntry.set("auditqty", (Object)newValue);
                }
                if (BigDecimal.ZERO.compareTo(newValue) > 0) {
                    changeEntry.set("qty", (Object)BigDecimal.ZERO);
                    changeEntry.set("auditqty", (Object)BigDecimal.ZERO);
                    break;
                }
                changeEntry.set("auditqty", (Object)newValue);
                break;
            }
            case "location": {
                Object newLocationValue = context.getNewValue();
                Object oldLocationValue = context.getOldValue();
                if (newLocationValue == null) {
                    changeEntry.set("location", null);
                    return;
                }
                Long newLocationId = 0L;
                Long oldLocationId = 0L;
                if (newLocationValue != null) {
                    DynamicObject newLocation = (DynamicObject)newLocationValue;
                    newLocationId = (Long)newLocation.getPkValue();
                }
                if (oldLocationValue != null) {
                    DynamicObject oldLocation = (DynamicObject)oldLocationValue;
                    oldLocationId = (Long)oldLocation.getPkValue();
                }
                if (newLocationId.compareTo(oldLocationId) == 0) {
                    return;
                }
                changeEntry.set("location", newLocationValue);
                break;
            }
            case "warehouse": {
                Object newWareHouseValue = context.getNewValue();
                Object oldWareHouseValue = context.getOldValue();
                if (newWareHouseValue == null) {
                    return;
                }
                Long newWareHouseId = 0L;
                Long oldWareHouseId = 0L;
                if (newWareHouseValue != null) {
                    DynamicObject newWareHouse = (DynamicObject)newWareHouseValue;
                    newWareHouseId = (Long)newWareHouse.getPkValue();
                }
                if (oldWareHouseValue != null) {
                    DynamicObject oldWareHouse = (DynamicObject)oldWareHouseValue;
                    oldWareHouseId = (Long)oldWareHouse.getPkValue();
                }
                if (newWareHouseId.compareTo(oldWareHouseId) == 0) {
                    return;
                }
                changeEntry.set("warehouse", newWareHouseValue);
                changeEntry.set("location", null);
                break;
            }
            case "material": {
                DynamicObject material = (DynamicObject)changeEntry.get(MATERIAL);
                DynamicObject unit = MaterialHelper.getMaterialBizUnit((DynamicObject)material);
                changeEntry.set("unit", (Object)unit);
                break;
            }
        }
    }
}

