/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.countbill;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bd.sbd.enums.OperatorGrpTypeEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.OrgProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.im.business.helper.AppParameterHelper;
import kd.scmc.im.enums.InvalidEnum;
import kd.scmc.mobim.business.helper.CountBillHelper;
import kd.scmc.mobim.plugin.form.countbill.ICountBillPagePlugin;
import kd.scmc.mobim.plugin.form.handler.countbill.CountBillChangeHandler;
import kd.scmc.mobim.plugin.form.handler.countbill.CountBillNewEntryHandler;
import kd.scmc.msmob.business.helper.BarcodeParseHelper;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import kd.scmc.msmob.business.helper.change.DataChangedHandlerHelper;
import kd.scmc.msmob.business.helper.change.DataSourceHelper;
import kd.scmc.msmob.business.helper.change.IMobilePage;
import kd.scmc.msmob.business.helper.change.handler.IEntryRowDeletedHandler;
import kd.scmc.msmob.common.utils.FormUtils;
import kd.scmc.msmob.common.utils.PageUtils;
import kd.scmc.msmob.plugin.tpl.basetpl.IMobBillEditable;
import kd.scmc.msmob.plugin.tpl.basetpl.MobPushTargetBillInfoPlugin;
import kd.scmc.msmob.pojo.QrCodeResult;

public class CountBillEditPlugin
extends MobPushTargetBillInfoPlugin
implements ICountBillPagePlugin,
IMobBillEditable,
BeforeF7SelectListener {
    private static final String[] F7_FIELD_KEYS = new String[]{"checker"};
    private static final String INVALID = "invalid";
    private static final String CALL_BACK = "callback";
    private static final String SCAN = "scan";

    public CountBillEditPlugin() {
        this.registerPropertyChangedHandler(new CountBillChangeHandler());
        this.registerEntryRowAddedHandler(new CountBillNewEntryHandler());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"profitlossdetails"});
        this.addClickListeners(new String[]{"newentryop"});
        this.addClickListeners(new String[]{"deletebtn"});
        FormUtils.addF7Listener((AbstractFormPlugin)this, (String[])F7_FIELD_KEYS);
    }

    public void loadCacheDataBeforeUpdateView(DynamicObject pcEntity) {
        this.setUnit();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject bill = this.curData[0];
        DynamicObject billType = bill.getDynamicObject("billtype");
        if (billType != null) {
            IPageCache pageCache = this.getPageCache();
            Object pkValue = billType.getPkValue();
            pageCache.put("billtype", String.valueOf(pkValue));
        }
        this.setChecker();
        DynamicObject sort = this.entrySort(bill);
        DataSourceHelper.loadPcEntityToMobilePage((AbstractFormPlugin)this, (DynamicObject)sort, (boolean)true);
        this.setUnit();
    }

    public void click(EventObject e) {
        String key;
        super.click(e);
        Control control = (Control)e.getSource();
        switch (key = control.getKey()) {
            case "profitlossdetails": {
                this.profitLossDetailsClick();
                break;
            }
            case "newentryop": {
                this.addEntry();
                break;
            }
            case "deletebtn": {
                this.confirmDelEntryRow("deletebtn");
                break;
            }
            case "scanbtn": {
                this.scanBtnClick(key);
                break;
            }
        }
    }

    protected void scanBtnClick(String key) {
        this.getPageCache().put(SCAN, key);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (key) {
            case "checker": {
                this.handleCheckerF7SelectEvent(showParameter);
                break;
            }
        }
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String value = e.getEventArgs();
        String key = e.getKey();
        if ("callAppMethod".equals(key) && "scanQRCode".equals(eventName)) {
            Map result = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
            Object codeStr = result.get("qrcode_str");
            String scanKey = this.getPageCache().get(SCAN);
            if ("scanbtn".equals(scanKey)) {
                this.handleQrCode(codeStr);
            }
        }
    }

    public void handleQrCode(Object code) {
        QrCodeResult qrCodeResult = BarcodeParseHelper.qrCodeParse((String)String.valueOf(code));
        if (CountBillHelper.verifyParsingBarCode(this.getView(), qrCodeResult)) {
            HashMap<String, String> customParams = new HashMap<String, String>(3);
            customParams.put("barcodeParseResult", SerializationUtils.toJsonString((Object)qrCodeResult));
            MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
            formShowParameter.setFormId("mobim_scancontent");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParams(customParams);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "scanbtn"));
            this.getView().showForm((FormShowParameter)formShowParameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u626b\u63cf\u65e0\u7ed3\u679c\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"MobBillListTplPlugin_scan", (String)"scmc-mobim-form", (Object[])new Object[0]));
        }
    }

    private void setChecker() {
        Object checker = this.getModel().getValue("checker");
        if (checker == null) {
            long userId = UserServiceHelper.getCurrentUserId();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            Object operatorGroupIsolate = AppParameterHelper.getAppParameterByFormId((String)"im_invcountbill", (Long)((Long)org.getPkValue()), (String)"foperatorgroupisolate");
            ArrayList<QFilter> filterList = new ArrayList<QFilter>(3);
            filterList.add(new QFilter("operatorid", "=", (Object)userId));
            filterList.add(new QFilter(INVALID, "=", (Object)InvalidEnum.NO.getValue()));
            if (operatorGroupIsolate instanceof Boolean && Boolean.TRUE.equals(operatorGroupIsolate)) {
                filterList.add(new QFilter("operatorgrpid", "in", this.getOperatorGroupByUser(userId, org)));
                filterList.add(new QFilter("opergrptype", "=", (Object)this.getOperatorGroupType()));
            } else {
                filterList.add(new QFilter("operatorgrpid", "in", this.getOperatorGroupByOrg((Long)org.getPkValue())));
                filterList.add(new QFilter("opergrptype", "=", (Object)this.getOperatorGroupType()));
            }
            DynamicObject user = BusinessDataServiceHelper.loadSingle((String)"bd_operator", (String)"id", (QFilter[])filterList.toArray(new QFilter[0]));
            DynamicObject bill = this.curData[0];
            bill.set("checker", (Object)user);
        }
    }

    private void handleCheckerF7SelectEvent(ListShowParameter showParameter) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            showParameter.getListFilterParameter().setFilter(new QFilter("1", "=", (Object)2));
            return;
        }
        long userId = UserServiceHelper.getCurrentUserId();
        Object operatorGroupIsolate = AppParameterHelper.getAppParameterByFormId((String)"im_invcountbill", (Long)((Long)org.getPkValue()), (String)"foperatorgroupisolate");
        if (operatorGroupIsolate instanceof Boolean && Boolean.TRUE.equals(operatorGroupIsolate)) {
            QFilter qFilter1 = new QFilter("operatorgrpid", "in", this.getOperatorGroupByUser(userId, org));
            QFilter qFilter2 = new QFilter("opergrptype", "=", (Object)this.getOperatorGroupType());
            QFilter qFilter3 = new QFilter(INVALID, "=", (Object)InvalidEnum.NO.getValue());
            showParameter.getListFilterParameter().setQFilters(Arrays.asList(qFilter1, qFilter2, qFilter3));
        } else {
            QFilter qFilter1 = new QFilter("operatorgrpid", "in", this.getOperatorGroupByOrg((Long)org.getPkValue()));
            QFilter qFilter2 = new QFilter("opergrptype", "=", (Object)this.getOperatorGroupType());
            QFilter qFilter3 = new QFilter(INVALID, "=", (Object)InvalidEnum.NO.getValue());
            showParameter.getListFilterParameter().setQFilters(Arrays.asList(qFilter1, qFilter2, qFilter3));
        }
    }

    private ArrayList<Long> getOperatorGroupByUser(long userId, DynamicObject org) {
        String formId = "im_invcountbill";
        ArrayList<Long> operatorGroupList = new ArrayList<Long>(16);
        QFilter qFilter1 = new QFilter("operatorid", "=", (Object)userId);
        QFilter qFilter2 = new QFilter("opergrptype", "=", (Object)this.getOperatorGroupType(formId, this.getOrgViewType()));
        qFilter2.and(new QFilter(INVALID, "=", (Object)"0"));
        QFilter qFilter3 = new QFilter("operatorgrpid", "in", this.getOperatorGroupByOrg((Long)org.getPkValue()));
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operator", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3});
        if (map != null && map.size() > 0) {
            ArrayList list = new ArrayList(map.values());
            for (int i = 0; i < list.size(); ++i) {
                operatorGroupList.add(((DynamicObject)list.get(i)).getLong("operatorgrpid"));
            }
        }
        return operatorGroupList;
    }

    private String getOrgViewType() {
        String orgViewType = null;
        String formId = "im_invcountbill";
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)formId);
        OrgProp org = (OrgProp)dataEntityType.getProperty("org");
        orgViewType = org.getOrgFunc();
        return orgViewType;
    }

    private String getOperatorGroupType() {
        return OperatorGrpTypeEnum.INVENTORYGRP.getValue();
    }

    private String getOperatorGroupType(String formId, String orgFunc) {
        if (orgFunc == null || orgFunc.isEmpty()) {
            FormConfig formConfig = FormMetadataCache.getFormConfig((String)formId);
            AppInfo appInfo = AppMetadataCache.getAppInfo((String)formConfig.getAppId());
            orgFunc = appInfo.getOrgFunc();
        }
        String operatorGrpType = null;
        if ("02".equals(orgFunc)) {
            operatorGrpType = OperatorGrpTypeEnum.PURCHASEGRP.getValue();
        } else if ("03".equals(orgFunc)) {
            operatorGrpType = OperatorGrpTypeEnum.SALEGRP.getValue();
        } else if ("05".equals(orgFunc)) {
            operatorGrpType = OperatorGrpTypeEnum.INVENTORYGRP.getValue();
        }
        return operatorGrpType;
    }

    private ArrayList<Long> getOperatorGroupByOrg(long orgId) {
        QFilter operatorFilter;
        QFilter enableFilter;
        QFilter qFilter2;
        String formId = "im_invcountbill";
        ArrayList<Long> operatorGroupList = new ArrayList<Long>();
        QFilter qFilter1 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)orgId);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (QFilter[])new QFilter[]{qFilter1, qFilter2 = new QFilter("operatorgrouptype", "=", (Object)this.getOperatorGroupType(formId, this.getOrgViewType())), enableFilter = new QFilter("enable", "=", (Object)"1"), operatorFilter = new QFilter("entryentity.operator.enable", "=", (Object)"1")});
        if (map != null && map.size() > 0) {
            ArrayList list = new ArrayList(map.values());
            for (int i = 0; i < list.size(); ++i) {
                operatorGroupList.add((Long)((DynamicObject)list.get(i)).getPkValue());
            }
        }
        return operatorGroupList;
    }

    private void confirmDelEntryRow(String key) {
        String msg;
        int index;
        IDataModel model = this.getModel();
        DynamicObject material = (DynamicObject)model.getValue("material", index = model.getEntryCurrentRowIndex("entryentity"));
        if (material != null) {
            String materialName = material.getString("masterid.name");
            msg = String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u3010\u201c%s\u201d\u3011\u7269\u6599\u660e\u7ec6\u884c\uff1f", (String)"delMaterial_0", (String)"scmc-mobim-form", (Object[])new Object[0]), materialName);
        } else {
            msg = String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u7269\u6599\u660e\u7ec6\u7b2c\u3010%s\u3011\u884c\uff1f", (String)"delMaterial_1", (String)"scmc-mobim-form", (Object[])new Object[0]), index + 1);
        }
        int count = this.getModel().getEntryRowCount("entryentity");
        if (count <= 1) {
            String errMsg = ResManager.loadKDString((String)"\u9700\u81f3\u5c11\u4fdd\u7559\u4e00\u6761\u8bb0\u5f55\u3002", (String)"MobBillEditTplPlugin_delFirstEntryRow", (String)"scmc-mobim-form", (Object[])new Object[0]);
            throw new KDBizException(errMsg);
        }
        this.getView().showConfirm(msg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(key), null, String.valueOf(index));
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        MessageBoxResult result = e.getResult();
        String customValue = e.getCustomVaule();
        switch (callBackId) {
            case "deletebtn": {
                this.delEntryRow(result, customValue);
                break;
            }
        }
    }

    private void delEntryRow(MessageBoxResult result, String customValue) {
        if (MessageBoxResult.Yes.equals((Object)result)) {
            IDataModel model = this.getModel();
            String mobileEntryKey = this.getEntryEntity();
            int deleteRow = model.getEntryCurrentRowIndex(mobileEntryKey);
            DataChangedHandlerHelper.deleteEntry((AbstractFormPlugin)this, (IEntryRowDeletedHandler)this.getEntryRowDeletedHandler(), (String)mobileEntryKey, (int)deleteRow);
        }
    }

    private void addEntry() {
        HashMap customParams = new HashMap(3);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, CALL_BACK);
        PageUtils.showFormPage((IFormView)this.getView(), (String)"mobim_countbillentryedit", customParams, (CloseCallBack)callBack);
    }

    protected void profitLossDetailsClick() {
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection(this.getEntryEntity());
        List<Map<String, Object>> profitLossData = CountBillHelper.getProfitLossData(dynamicObjectCollection);
        this.getPageCache().put("mobim_profitlossdetails", JSON.toJSONString(profitLossData));
        PageUtils.showFormPage((IFormView)this.getView(), (String)"mobim_profitlossdetails", null, null);
    }

    protected void setUnit() {
        DynamicObjectCollection entry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        IDataModel model = this.getModel();
        for (int i = 0; i < entry.size(); ++i) {
            ILocaleString name;
            Object unit = model.getValue("unit", i);
            this.getModel().beginInit();
            model.setValue("qtyaccunit", (Object)"", i);
            if (unit != null && (name = ((DynamicObject)unit).getLocaleString("name")) != null) {
                String localeValue = name.getLocaleValue();
                String auditUnit = localeValue == null ? "" : localeValue;
                model.setValue("qtyaccunit", (Object)auditUnit, i);
            }
            model.endInit();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        this.setUnit();
        if (CALL_BACK.equals(actionId) || "scanbtn".equals(actionId)) {
            DynamicObject dynamicObject = this.entrySort(null);
            EntityCacheHelper.savePcEntityToPageCache((IFormView)this.getPcEntityStorageView(), (DynamicObject)dynamicObject);
            DataSourceHelper.loadPcEntityToMobilePage((AbstractFormPlugin)this, (DynamicObject)dynamicObject, (boolean)true);
            this.setMainEntryTitle();
        }
    }

    public DynamicObject entrySort(DynamicObject bill) {
        if (bill == null) {
            bill = EntityCacheHelper.getPcEntityFromCache((IMobilePage)this);
        }
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("billentry");
        Comparator<DynamicObject> comparator = CountBillEditPlugin.getComparator();
        entry.sort(comparator);
        for (int i = 0; i < entry.size(); ++i) {
            DynamicObject dyn = (DynamicObject)entry.get(i);
            dyn.set("seq", (Object)(i + 1));
        }
        return bill;
    }

    public static Comparator<DynamicObject> getComparator() {
        return (o1, o2) -> {
            long masterId;
            DynamicObject masterDyn;
            DynamicObject location2;
            long locationId2;
            DynamicObject warehouse2;
            long warehouseId2;
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            DynamicObject warehouse = o1.getDynamicObject("warehouse");
            long warehouseId1 = warehouse == null ? 0L : Long.parseLong(String.valueOf(warehouse.getPkValue()));
            long warehouseId = warehouseId1 - (warehouseId2 = (warehouse2 = o2.getDynamicObject("warehouse")) == null ? 0L : Long.parseLong(String.valueOf(warehouse2.getPkValue())));
            if (warehouseId != 0L) {
                return warehouseId > 0L ? 1 : -1;
            }
            DynamicObject location = o1.getDynamicObject("location");
            long locationId1 = location == null ? 0L : Long.parseLong(String.valueOf(location.getPkValue()));
            long locationIdId = locationId1 - (locationId2 = (location2 = o2.getDynamicObject("location")) == null ? 0L : Long.parseLong(String.valueOf(location2.getPkValue())));
            if (locationIdId != 0L) {
                return locationIdId > 0L ? 1 : -1;
            }
            DynamicObject material = o1.getDynamicObject("material");
            long masterId1 = 0L;
            if (material != null && (masterDyn = material.getDynamicObject("masterid")) != null) {
                masterId1 = Long.parseLong(String.valueOf(masterDyn.getPkValue()));
            }
            DynamicObject material2 = o2.getDynamicObject("material");
            long masterId2 = 0L;
            if (material2 != null) {
                DynamicObject masterDyn2 = material2.getDynamicObject("masterid");
                masterId2 = Long.parseLong(String.valueOf(masterDyn2.getPkValue()));
            }
            if ((masterId = masterId1 - masterId2) != 0L) {
                return masterId > 0L ? 1 : -1;
            }
            BigDecimal qty = o1.getBigDecimal("qty");
            qty = qty == null ? new BigDecimal("0") : qty;
            BigDecimal qty2 = o2.getBigDecimal("qty");
            BigDecimal bigDecimal = qty2 = qty2 == null ? new BigDecimal("0") : qty2;
            if (qty.compareTo(qty2) != 0) {
                return qty.compareTo(qty2) > 0 ? 1 : -1;
            }
            BigDecimal qtyAcc = o1.getBigDecimal("qtyacc");
            qtyAcc = qtyAcc == null ? new BigDecimal("0") : qtyAcc;
            BigDecimal qtyAcc2 = o2.getBigDecimal("qtyacc");
            qtyAcc2 = qtyAcc2 == null ? new BigDecimal("0") : qtyAcc2;
            return qtyAcc.compareTo(qtyAcc2);
        };
    }

    public String getEntryFormKey() {
        return this.getEntryEditFormKey(this.getEntryEntity());
    }

    public String getViewFormId() {
        return "mobim_countbillview";
    }
}

