/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.countbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Label;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.im.business.helper.MaterialHelper;
import kd.scmc.im.business.helper.OwnerHelper;
import kd.scmc.im.business.helper.WareHouseIsolateHelper;
import kd.scmc.im.business.helper.WarehouseHelper;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.mobim.business.helper.CountBillHelper;
import kd.scmc.mobim.common.utils.PageUpdateUtils;
import kd.scmc.mobim.plugin.form.countbill.ICountBillPagePlugin;
import kd.scmc.mobim.plugin.form.handler.WarehouseChangeResetLocationHandler;
import kd.scmc.mobim.plugin.form.handler.countbill.CountBillChangeHandler;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import kd.scmc.msmob.business.helper.change.DataChangedHandlerHelper;
import kd.scmc.msmob.business.helper.change.EntryMappingIndex;
import kd.scmc.msmob.business.helper.change.IMobilePage;
import kd.scmc.msmob.business.helper.change.VisitingContext;
import kd.scmc.msmob.business.helper.change.handler.IPropertyChangedHandler;
import kd.scmc.msmob.common.utils.FormUtils;
import kd.scmc.msmob.plugin.tpl.basetpl.EntryEditTplPlugin;
import kd.scmc.msmob.plugin.tpl.basetpl.IMobBillEditable;

public class CountBillEntryEditPlugin
extends EntryEditTplPlugin
implements BeforeF7SelectListener,
ICountBillPagePlugin,
IMobBillEditable {
    private static final String[] MODEL_FIELD_KEYS = new String[]{"material", "unit", "qty", "warehouse", "location", "lotnumber", "billid", "pcentitykey", "org", "adjustqty", "qtyacc", "gainqty", "lossqty", "ownertype", "keepertype", "invtype", "invstatus", "keeper", "owner"};
    private static final String[] F7_FIELD_KEYS = new String[]{"warehouse", "location", "owner"};

    public CountBillEntryEditPlugin() {
        this.registerPropertyChangedHandler(new CountBillChangeHandler());
        this.registerPropertyChangedHandler(new WarehouseChangeResetLocationHandler());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((AbstractFormPlugin)this, (String[])F7_FIELD_KEYS);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setVisibleAbility();
        this.handleEnable();
        this.setUnit();
        String[] fields = new String[]{"keeper", "owner"};
        String pcEntryName = this.getPcEntryName();
        IPageCache pageCache = this.getView().getPageCache();
        int row = this.getRow(pageCache);
        PageUpdateUtils.showEntryMulPropValue(this.getView(), (IMobilePage)this, pcEntryName, fields, row);
    }

    public int getRow(IPageCache pageCache) {
        int row = Integer.parseInt(pageCache.get("row"));
        if (!this.isFormMainEditPage()) {
            row = (Integer)this.getParentView().getModel().getValue("parentseq", row) - 1;
        }
        return row;
    }

    public IFormView getPcEntityStorageView() {
        if (this.isFormMainEditPage()) {
            return super.getPcEntityStorageView();
        }
        return this.getParentView().getParentView();
    }

    public VisitingContext getVisitingContext() {
        if (this.isFormMainEditPage()) {
            return super.getVisitingContext();
        }
        VisitingContext visitingContext = new VisitingContext();
        int visitingEntryIndex = EntityCacheHelper.getVisitingEntryIndex((IFormView)this.getView());
        Integer parentseq = (Integer)this.getParentView().getModel().getValue("parentseq", visitingEntryIndex);
        IFormView pcEntityStorageView = this.getPcEntityStorageView();
        DynamicObjectCollection billentry = pcEntityStorageView.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        int index = 0;
        for (int i = 0; i < billentry.size(); ++i) {
            int seq = (Integer)((DynamicObject)billentry.get(i)).get("seq");
            if (seq != parentseq) continue;
            index = i;
        }
        visitingContext.addEntryMappingIndex(new EntryMappingIndex(this.getPcEntryName(), index));
        return visitingContext;
    }

    private boolean isFormMainEditPage() {
        String parentName = this.getView().getParentView().getModel().getDataEntityType().getName();
        return !"mobim_scancontent".equals(parentName);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        int row = this.getRow(this.getPageCache());
        DataChangedHandlerHelper.onEntryPagePropertyChanged((AbstractMobFormPlugin)this, (IPropertyChangedHandler)this.propertyChangedHandler, (PropertyChangedArgs)e, (int)row);
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        Boolean triggerChangeEventLocal = (Boolean)DataChangeHelper.triggerChangeEventLocal.get();
        if (triggerChangeEventLocal != null && !triggerChangeEventLocal.booleanValue()) {
            return;
        }
        switch (key = e.getProperty().getName()) {
            case "material": {
                this.changeMaterial(newValue);
                break;
            }
            case "qty": 
            case "qtyacc": {
                this.changQty();
                break;
            }
            case "warehouse": {
                this.changeWarehouse(newValue);
                break;
            }
            case "ownertype": {
                this.changeOwnerAndKeeperType(newValue, "owner");
                break;
            }
            case "keepertype": {
                this.changeOwnerAndKeeperType(newValue, "keeper");
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject org = (DynamicObject)this.getView().getParentView().getModel().getValue("org");
        switch (key) {
            case "owner": {
                this.handleOwnerF7SelectEvent(showParameter, org);
                break;
            }
            case "warehouse": {
                this.handleWarehouseF7SelectEvent(showParameter, org);
                break;
            }
            case "location": {
                this.handleLocationF7SelectEvent(showParameter);
                break;
            }
        }
    }

    private void handleLocationF7SelectEvent(ListShowParameter showParameter) {
        DynamicObject warehouse = (DynamicObject)this.getModel().getValue("warehouse");
        if (warehouse == null) {
            this.getView().showTipNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getSELECT_WAREHOUSE(), (Object[])new Object[]{new String[0]}));
        } else {
            DynamicObjectCollection locationCol = warehouse.getDynamicObjectCollection("entryentity");
            List<Long> ids = this.getLocationIds(locationCol);
            QFilter qFilter1 = new QFilter("id", "in", ids);
            showParameter.getListFilterParameter().setFilter(qFilter1);
        }
    }

    private List<Long> getLocationIds(DynamicObjectCollection locationCol) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (locationCol == null || locationCol.size() == 0) {
            return ids;
        }
        for (DynamicObject locDym : locationCol) {
            DynamicObject location = locDym.getDynamicObject("location");
            ids.add(Long.valueOf(String.valueOf(location.getPkValue())));
        }
        return ids;
    }

    private void handleWarehouseF7SelectEvent(ListShowParameter showParameter, DynamicObject org) {
        Boolean result = WareHouseIsolateHelper.setWareHouseIsolateF7Filter((String)"im_invcountbill", (DynamicObject)org, (ListShowParameter)showParameter);
        if (!result.booleanValue()) {
            Long[] allFinishInitWarehouseIDs = WarehouseHelper.getAllFinishInitWarehouseIDs((Long)((Long)org.getPkValue()));
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)allFinishInitWarehouseIDs));
        }
    }

    private void handleOwnerF7SelectEvent(ListShowParameter showParameter, DynamicObject org) {
        String ownerType;
        Object ownerTypeObj = this.getModel().getValue("ownertype");
        switch (ownerType = String.valueOf(ownerTypeObj)) {
            case "bd_customer": 
            case "bd_supplier": {
                return;
            }
        }
        IPageCache pageCache = this.getView().getParentView().getPageCache();
        String billType = pageCache.get("billtype");
        ArrayList array = OwnerHelper.getOwners((Long)((Long)org.getPkValue()), (Long)Long.valueOf(billType));
        if (!array.isEmpty()) {
            QFilter ownerFilter = new QFilter("id", "in", (Object)array);
            showParameter.getListFilterParameter().setFilter(ownerFilter);
        }
    }

    private void changeOwnerAndKeeperType(Object newValue, String field) {
        if ("bos_org".equals(newValue)) {
            DynamicObject org = (DynamicObject)this.getView().getParentView().getModel().getValue("org");
            this.dealOwnerAndKeeper(org, field);
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{field});
        }
    }

    private void dealOwnerAndKeeper(DynamicObject org, String field) {
        Object type;
        String typeField = "ownertype";
        if ("keeper".equals(field)) {
            typeField = "keepertype";
        }
        if ("bos_org".equals(type = this.getModel().getValue(typeField)) && "keeper".equals(field)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{field});
        }
    }

    private void changeWarehouse(Object newValue) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"location"});
        if (newValue != null) {
            boolean isOpenLocation = ((DynamicObject)newValue).getBoolean("isopenlocation");
            this.getView().setVisible(Boolean.valueOf(isOpenLocation), new String[]{"location"});
        }
    }

    private void changeMaterial(Object newValue) {
        if (newValue != null) {
            this.setUnit();
            this.setVisibleAbility();
        }
    }

    private void changQty() {
        Object materialInvInfo = this.getModel().getValue("material");
        if (materialInvInfo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u4fe1\u606f", (String)"CountBillEntryEditPlugin_0", (String)"scmc-mobim-form", (Object[])new Object[0]));
        }
        DynamicObject material = MaterialHelper.getMaterialByMatBiz((DynamicObject)((DynamicObject)materialInvInfo));
        if (material == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u4fe1\u606f", (String)"CountBillEntryEditPlugin_0", (String)"scmc-mobim-form", (Object[])new Object[0]));
        }
        this.setVisibleAbility();
    }

    private void setUnit() {
        Label adjustLabel = (Label)this.getControl("adjustqtyunit");
        Label gainLabel = (Label)this.getControl("gainqtyunit");
        Label accLabel = (Label)this.getControl("qtyaccunit");
        Label lossLabel = (Label)this.getControl("lossqtyunit");
        ArrayList<Label> labels = new ArrayList<Label>(4);
        labels.add(adjustLabel);
        labels.add(gainLabel);
        labels.add(accLabel);
        labels.add(lossLabel);
        Object unit = this.getModel().getValue("unit");
        CountBillHelper.setUnit("", labels);
        if (unit != null) {
            String name = ((DynamicObject)unit).getString("name");
            CountBillHelper.setUnit(name, labels);
        }
    }

    private void handleEnable() {
        boolean isAdd = this.isAddEntry();
        this.getView().setEnable(Boolean.FALSE, MODEL_FIELD_KEYS);
        if (isAdd) {
            List<String> addModifyFieldKeys = this.getAddModifyFieldKeys();
            this.getView().setEnable(Boolean.TRUE, addModifyFieldKeys.toArray(new String[0]));
        } else {
            List<String> modifyFieldKeys = this.getModifyFieldKeys();
            this.getView().setEnable(Boolean.TRUE, modifyFieldKeys.toArray(new String[0]));
        }
    }

    private boolean isAddEntry() {
        int row;
        String pcEntryName;
        boolean isAdd = false;
        String isAddFlag = "1";
        IFormView view = this.getPcEntityStorageView();
        DynamicObject pcBill = EntityCacheHelper.getPcEntityFromCache((IFormView)view, (String)"im_invcountbill");
        DynamicObjectCollection collection = pcBill.getDynamicObjectCollection(pcEntryName = this.getPcEntryName());
        DynamicObject entry = (DynamicObject)collection.get(row = this.getRow(this.getPageCache()));
        String sourceFlag = entry.getString("sourceflag");
        if (isAddFlag.equals(sourceFlag)) {
            isAdd = true;
        }
        return isAdd;
    }

    private void setVisibleAbility() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Object material = model.getValue("material");
        boolean isNotEmptyModelNum = material != null && StringUtils.isNotEmpty((CharSequence)((DynamicObject)material).getString("masterid.modelnum"));
        boolean isEnableLot = material != null && ((DynamicObject)material).getBoolean("enablelot");
        view.setVisible(Boolean.valueOf(isEnableLot), new String[]{"lotnumber"});
        view.setVisible(Boolean.valueOf(isNotEmptyModelNum), new String[]{"model"});
        BigDecimal adjustQty = (BigDecimal)model.getValue("adjustqty");
        BigDecimal lossQty = (BigDecimal)model.getValue("lossqty");
        BigDecimal gainQty = (BigDecimal)model.getValue("gainqty");
        view.setVisible(Boolean.FALSE, new String[]{"adjustqtyflex", "lossqtyflex", "gainqtyflex"});
        if (BigDecimal.ZERO.compareTo(adjustQty) != 0) {
            view.setVisible(Boolean.TRUE, new String[]{"adjustqtyflex"});
        }
        if (BigDecimal.ZERO.compareTo(lossQty) != 0) {
            view.setVisible(Boolean.TRUE, new String[]{"lossqtyflex"});
        }
        if (BigDecimal.ZERO.compareTo(gainQty) != 0) {
            view.setVisible(Boolean.TRUE, new String[]{"gainqtyflex"});
        }
    }

    public String getEntryEntity() {
        return "entryentity";
    }

    public List<String> getFieldKeys() {
        return Arrays.asList(MODEL_FIELD_KEYS);
    }

    public List<String> getAddModifyFieldKeys() {
        ArrayList<String> keys = new ArrayList<String>(16);
        keys.add("material");
        keys.add("qty");
        keys.add("unit");
        keys.add("warehouse");
        keys.add("location");
        keys.add("lotnumber");
        keys.add("billid");
        keys.add("pcentitykey");
        keys.add("adjustqty");
        keys.add("qtyacc");
        keys.add("gainqty");
        keys.add("ownertype");
        keys.add("keepertype");
        keys.add("invtype");
        keys.add("invstatus");
        keys.add("keeper");
        keys.add("owner");
        return keys;
    }

    public List<String> getModifyFieldKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("qty");
        return keys;
    }
}

