/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.countbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.scmc.mobim.business.helper.CountBillHelper;
import kd.scmc.mobim.common.utils.PageUpdateUtils;
import kd.scmc.msmob.business.helper.change.IMobilePage;
import kd.scmc.msmob.plugin.tpl.basetpl.EntryEditTplPlugin;

public class CountBillEntryViewPlugin
extends EntryEditTplPlugin {
    private static final String[] MODEL_FIELD_KEYS = new String[]{"material", "unit", "qty", "warehouse", "location", "lotnumber", "billid", "pcentitykey", "adjustqty", "qtyacc", "gainqty", "lossqty", "ownertype", "keepertype", "invtype", "invstatus", "keeper", "owner"};

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setVisibleAbility();
        this.setUnit();
        String[] fields = new String[]{"keeper", "owner"};
        String pcEntryName = this.getPcEntryName();
        PageUpdateUtils.showEntryMulPropValue(this.getView(), (IMobilePage)this, pcEntryName, fields);
    }

    private void setVisibleAbility() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Object material = model.getValue("material");
        boolean isNotEmptyModelNum = material != null && StringUtils.isNotEmpty((CharSequence)((DynamicObject)material).getString("masterid.modelnum"));
        boolean isEnableLot = material != null && ((DynamicObject)material).getBoolean("enablelot");
        view.setVisible(Boolean.valueOf(isEnableLot), new String[]{"lotnumber"});
        view.setVisible(Boolean.valueOf(isNotEmptyModelNum), new String[]{"model"});
        BigDecimal adjustQty = (BigDecimal)model.getValue("adjustqty");
        BigDecimal lossQty = (BigDecimal)model.getValue("lossqty");
        BigDecimal gainQty = (BigDecimal)model.getValue("gainqty");
        view.setVisible(Boolean.FALSE, new String[]{"adjustqtyflex", "lossqtyflex", "gainqtyflex"});
        if (BigDecimal.ZERO.compareTo(adjustQty) != 0) {
            view.setVisible(Boolean.TRUE, new String[]{"adjustqtyflex"});
        }
        if (BigDecimal.ZERO.compareTo(lossQty) != 0) {
            view.setVisible(Boolean.TRUE, new String[]{"lossqtyflex"});
        }
        if (BigDecimal.ZERO.compareTo(gainQty) != 0) {
            view.setVisible(Boolean.TRUE, new String[]{"gainqtyflex"});
        }
    }

    private void setUnit() {
        Label adjustLabel = (Label)this.getControl("adjustqtyunit");
        Label gainLabel = (Label)this.getControl("gainqtyunit");
        Label accLabel = (Label)this.getControl("qtyaccunit");
        Label lossLabel = (Label)this.getControl("lossqtyunit");
        ArrayList<Label> labels = new ArrayList<Label>(4);
        labels.add(adjustLabel);
        labels.add(gainLabel);
        labels.add(accLabel);
        labels.add(lossLabel);
        Object unit = this.getModel().getValue("unit");
        CountBillHelper.setUnit("", labels);
        if (unit != null) {
            String name = ((DynamicObject)unit).getString("name");
            CountBillHelper.setUnit(name, labels);
        }
    }

    public String getEntryEntity() {
        return "entryentity";
    }

    public List<String> getFieldKeys() {
        return Arrays.asList(MODEL_FIELD_KEYS);
    }
}

