/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.countbill;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.scmc.mobim.business.helper.CountBillHelper;
import kd.scmc.mobim.plugin.form.countbill.ICountBillPagePlugin;
import kd.scmc.msmob.common.enums.BillStatusEnum;
import kd.scmc.msmob.common.utils.PageUtils;
import kd.scmc.msmob.plugin.tpl.basetpl.MobPushTargetBillInfoPlugin;

public class CountBillViewPlugin
extends MobPushTargetBillInfoPlugin
implements ICountBillPagePlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"profitlossdetails"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setUnit();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.handleVisible();
    }

    private void handleVisible() {
        String billStatus = (String)this.getModel().getValue("billstatus");
        this.getView().setVisible(Boolean.FALSE, new String[]{"buttonunaudit"});
        if (BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"buttonunaudit"});
        }
    }

    public void click(EventObject e) {
        String key;
        super.click(e);
        Control control = (Control)e.getSource();
        switch (key = control.getKey()) {
            case "profitlossdetails": {
                this.profitLossDetailsClick();
                break;
            }
        }
    }

    protected void profitLossDetailsClick() {
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection(this.getEntryEntity());
        List<Map<String, Object>> profitLossData = CountBillHelper.getProfitLossData(dynamicObjectCollection);
        this.getPageCache().put("mobim_profitlossdetails", JSON.toJSONString(profitLossData));
        PageUtils.showFormPage((IFormView)this.getView(), (String)"mobim_profitlossdetails", null, null);
    }

    private void setUnit() {
        DynamicObjectCollection entry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        for (int i = 0; i < entry.size(); ++i) {
            ILocaleString name;
            IDataModel model = this.getModel();
            Object unit = model.getValue("unit", i);
            model.beginInit();
            model.setValue("qtyaccunit", (Object)"", i);
            if (unit != null && (name = ((DynamicObject)unit).getLocaleString("name")) != null) {
                String localeValue = name.getLocaleValue();
                String auditUnit = localeValue == null ? "" : localeValue;
                model.setValue("qtyaccunit", (Object)auditUnit, i);
            }
            model.endInit();
        }
    }

    @Override
    public String getEntryViewFormKey(String entryKey) {
        return "mobim_countbillentryview";
    }

    public String getEditFormId() {
        return "mobim_countbilledit";
    }
}

