/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.countbill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.mobim.business.helper.CountBillHelper;
import kd.scmc.mobim.plugin.form.handler.countbill.CountBillChangeHandler;
import kd.scmc.msmob.business.helper.BarcodeParseHelper;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import kd.scmc.msmob.business.helper.change.DataChangedHandlerHelper;
import kd.scmc.msmob.business.helper.change.DataSourceHelper;
import kd.scmc.msmob.business.helper.change.IMobilePage;
import kd.scmc.msmob.business.helper.change.handler.IEntryRowDeletedHandler;
import kd.scmc.msmob.business.helper.change.handler.IPropertyChangedHandler;
import kd.scmc.msmob.business.helper.scan.IScanBusiness;
import kd.scmc.msmob.business.helper.scan.impl.ScanBusinessImpl;
import kd.scmc.msmob.pojo.DataSourceConfig;
import kd.scmc.msmob.pojo.QrCodeResult;
import kd.scmc.msmob.service.mservice.baseset.impl.DataSourceConfigServiceImpl;
import org.apache.commons.lang3.StringUtils;

public class CountScanFilterPlugin
extends AbstractMobBillPlugIn
implements IMobilePage {
    private static final String PARENT_SEQ = "parentseq";
    private static final String EDIT_CLOSE = "editClose";
    private static final String SCAN_ENTITY = "scanentity";
    private static final String SCAN_FILTER = "scanFilter";
    private List<IEntryRowDeletedHandler> entryRowDeletedHandlers = new ArrayList<IEntryRowDeletedHandler>();
    private List<IPropertyChangedHandler> propertyChangedHandlers = new ArrayList<IPropertyChangedHandler>();

    public CountScanFilterPlugin() {
        this.registerPropertyChangedHandler(new CountBillChangeHandler());
    }

    public final void registerPropertyChangedHandler(IPropertyChangedHandler propertyChangedHandler) {
        this.propertyChangedHandlers.add(propertyChangedHandler);
    }

    public final IPropertyChangedHandler getPropertyChangedHandler() {
        return context -> this.propertyChangedHandlers.forEach(iPropertyChangedHandler -> iPropertyChangedHandler.onPropertyChanged(context));
    }

    public final IEntryRowDeletedHandler getEntryRowDeletedHandler() {
        return context -> this.entryRowDeletedHandlers.forEach(handler -> handler.onEntryRowDeleted(context));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"editop"});
        this.addClickListeners(new String[]{"deletebtn"});
        this.addClickListeners(new String[]{"scanbtn"});
    }

    public void afterCreateNewData(EventObject e) {
        MobileFormShowParameter param = (MobileFormShowParameter)this.getView().getFormShowParameter();
        String barcodeParseResultStr = (String)param.getCustomParam("barcodeParseResult");
        QrCodeResult qrCodeResult = (QrCodeResult)SerializationUtils.fromJsonString((String)barcodeParseResultStr, QrCodeResult.class);
        boolean verifyResult = CountBillHelper.verifyParsingBarCode(this.getView(), qrCodeResult);
        if (verifyResult) {
            List<QrCodeResult> filter = this.getFilter(qrCodeResult);
            this.initData(filter, qrCodeResult);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setUnit();
    }

    protected void setUnit() {
        DynamicObjectCollection entry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        IDataModel model = this.getModel();
        for (int i = 0; i < entry.size(); ++i) {
            ILocaleString name;
            Object unit = model.getValue("unit", i);
            this.getModel().beginInit();
            model.setValue("qtyaccunit", (Object)"", i);
            if (unit != null && (name = ((DynamicObject)unit).getLocaleString("name")) != null) {
                String localeValue = name.getLocaleValue();
                String auditUnit = localeValue == null ? "" : localeValue;
                model.setValue("qtyaccunit", (Object)auditUnit, i);
            }
            model.endInit();
        }
        this.getView().updateView("entryentity");
    }

    public void initData(List<QrCodeResult> filter, QrCodeResult qrCodeResult) {
        DynamicObject pcEntity = EntityCacheHelper.getPcEntityFromCache((IFormView)this.getPcEntityStorageView(), (String)"im_invcountbill");
        DynamicObjectCollection collection = pcEntity.getDynamicObjectCollection("billentry");
        this.filterEntry(collection, filter);
        this.setModelValue(collection);
        this.filterDec(qrCodeResult);
    }

    private List<QrCodeResult> getFilter(QrCodeResult qrCodeResult) {
        IPageCache pageCache = this.getView().getPageCache();
        String filter = pageCache.get(SCAN_FILTER);
        ArrayList<QrCodeResult> filterColl = StringUtils.isNotEmpty((CharSequence)filter) ? SerializationUtils.fromJsonStringToList((String)filter, QrCodeResult.class) : new ArrayList<QrCodeResult>(8);
        filterColl.add(qrCodeResult);
        pageCache.put(SCAN_FILTER, SerializationUtils.toJsonString(filterColl));
        return filterColl;
    }

    private void filterDec(QrCodeResult barcodeParseResult) {
        String codeType;
        if (barcodeParseResult == null) {
            return;
        }
        switch (codeType = barcodeParseResult.getCodeType()) {
            case "material": 
            case "location": 
            case "warehouse": {
                this.filterDecByScan(barcodeParseResult, codeType);
                break;
            }
            default: {
                this.defaultFilterDec(barcodeParseResult);
            }
        }
    }

    protected void defaultFilterDec(QrCodeResult qrCodeResult) {
        ScanBusinessImpl scanBusinessImpl = new ScanBusinessImpl();
        PluginProxy pluginProxy = PluginProxy.create((Object)scanBusinessImpl, IScanBusiness.class, (String)"mpscmm.msmob.extension.scan", null);
        pluginProxy.callReplaceIfPresent(p -> {
            p.scanFilterDec(qrCodeResult);
            return null;
        });
    }

    private void filterDecByScan(QrCodeResult qrCodeResult, String propKey) {
        String name = this.queryBaseDataName(qrCodeResult);
        LocaleString displayName = this.getModel().getProperty(propKey).getDisplayName();
        String localeValue = displayName.getLocaleValue();
        IDataModel model = this.getModel();
        int newEntryRow = model.createNewEntryRow(SCAN_ENTITY);
        IFormView view = this.getView();
        view.getModel();
        model.beginInit();
        model.setValue("num", (Object)(newEntryRow + 1), newEntryRow);
        model.setValue("scancontent", (Object)(localeValue + ":" + name), newEntryRow);
        if ("material".equals(propKey)) {
            String msg = ResManager.loadKDString((String)"\u7269\u6599\u540d\u79f0", (String)"material_name", (String)"scmc-mobim-form", (Object[])new Object[0]);
            model.setValue("scancontent", (Object)(msg + ":" + name), newEntryRow);
        }
        model.endInit();
        this.getView().updateView(SCAN_ENTITY);
    }

    private String queryBaseDataName(QrCodeResult qrCodeResult) {
        String num;
        QFilter qFilter;
        String entityId = qrCodeResult.getEntityId();
        DynamicObject baseData = BusinessDataServiceHelper.loadSingleFromCache((String)entityId, (String)"name", (QFilter[])(qFilter = new QFilter("number", "=", (Object)(num = (String)qrCodeResult.getAttribute("number")))).toArray());
        if (baseData != null) {
            String name = baseData.getString("name");
            return name;
        }
        return "";
    }

    private void filterEntry(DynamicObjectCollection entryCollection, List<QrCodeResult> filter) {
        if (filter != null && !filter.isEmpty()) {
            Iterator collIterator = entryCollection.iterator();
            DynamicObjectCollection removeCollection = new DynamicObjectCollection();
            while (collIterator.hasNext()) {
                DynamicObject entry = (DynamicObject)collIterator.next();
                this.removeEntry(removeCollection, filter, entry);
            }
            entryCollection.removeAll((Collection)removeCollection);
        } else {
            entryCollection.clear();
        }
    }

    private void removeEntry(DynamicObjectCollection removeCollection, List<QrCodeResult> data, DynamicObject entry) {
        block9: for (QrCodeResult qrCodeResult : data) {
            String filterKey;
            switch (filterKey = qrCodeResult.getCodeType()) {
                case "material": {
                    this.filterMasterIdNumberByScan(removeCollection, entry, qrCodeResult);
                    continue block9;
                }
                case "location": 
                case "warehouse": {
                    this.filterNumberByScan(removeCollection, entry, qrCodeResult);
                    continue block9;
                }
            }
            this.defaultFilter(removeCollection, entry, qrCodeResult);
        }
    }

    protected void defaultFilter(DynamicObjectCollection removeCollection, DynamicObject entry, QrCodeResult qrCodeResult) {
        ScanBusinessImpl scanBusinessImpl = new ScanBusinessImpl();
        PluginProxy pluginProxy = PluginProxy.create((Object)scanBusinessImpl, IScanBusiness.class, (String)"mpscmm.msmob.extension.scan", null);
        pluginProxy.callReplaceIfPresent(p -> {
            p.scanFilterEntry(removeCollection, entry, qrCodeResult);
            return null;
        });
    }

    private void filterNumberByScan(DynamicObjectCollection removeCollection, DynamicObject entry, QrCodeResult qrCodeResult) {
        String propertyType = qrCodeResult.getCodeType();
        String number = (String)qrCodeResult.getAttribute("number");
        DynamicObject property = entry.getDynamicObject(propertyType);
        if (property == null) {
            removeCollection.add((Object)entry);
            return;
        }
        String aNumber = property.getString("number");
        if (!aNumber.equals(number)) {
            removeCollection.add((Object)entry);
        }
    }

    private void filterMasterIdNumberByScan(DynamicObjectCollection removeCollection, DynamicObject entry, QrCodeResult qrCodeResult) {
        String propertyType = qrCodeResult.getCodeType();
        String number = (String)qrCodeResult.getAttribute("number");
        DynamicObject property = entry.getDynamicObject(propertyType);
        if (property == null) {
            removeCollection.add((Object)entry);
            return;
        }
        DynamicObject masterId = property.getDynamicObject("masterid");
        String aNumber = masterId.getString("number");
        if (!aNumber.equals(number)) {
            removeCollection.add((Object)entry);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        DataChangedHandlerHelper.onPropertyChanged((AbstractFormPlugin)this, (IPropertyChangedHandler)this.getPropertyChangedHandler(), (PropertyChangedArgs)e);
    }

    public void click(EventObject e) {
        String key;
        super.click(e);
        Control control = (Control)e.getSource();
        switch (key = control.getKey()) {
            case "editop": {
                this.editClick();
                break;
            }
            case "deletebtn": {
                this.confirmDelEntryRow("deletebtn");
                break;
            }
            case "scanbtn": {
                this.scanClick("scanbtn");
                break;
            }
        }
    }

    private void scanClick(String scanBtn) {
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put("scan_key", scanBtn);
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String value = e.getEventArgs();
        String key = e.getKey();
        if ("callAppMethod".equals(key) && "scanQRCode".equals(eventName)) {
            Map result = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
            Object codeStr = result.get("qrcode_str");
            String scanKey = this.getPageCache().get("scan_key");
            if ("scanbtn".equals(scanKey)) {
                this.handleQrCode(codeStr);
            }
        }
    }

    private void handleQrCode(Object codeStr) {
        QrCodeResult qrCodeResult = BarcodeParseHelper.qrCodeParse((String)String.valueOf(codeStr));
        boolean verifyResult = CountBillHelper.verifyParsingBarCode(this.getView(), qrCodeResult);
        if (verifyResult) {
            List<QrCodeResult> filter = this.getFilter(qrCodeResult);
            this.initData(filter, qrCodeResult);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u626b\u63cf\u65e0\u7ed3\u679c\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"MobBillListTplPlugin_scan", (String)"scmc-mobim-form", (Object[])new Object[0]));
        }
    }

    private void editClick() {
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        formShowParameter.setFormId("mobim_countbillentryedit");
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EDIT_CLOSE));
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (EDIT_CLOSE.equals(actionId)) {
            this.refreshPageData();
        }
    }

    public void refreshPageData() {
        IPageCache pageCache = this.getPageCache();
        String filter = pageCache.get(SCAN_FILTER);
        List filterList = null;
        if (StringUtils.isNotEmpty((CharSequence)filter)) {
            filterList = SerializationUtils.fromJsonStringToList((String)filter, QrCodeResult.class);
        }
        this.initData(filterList, null);
    }

    private void confirmDelEntryRow(String key) {
        String msg = ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5220\u9664\u5417\uff1f", (String)"CountBillEditPlugin_0", (String)"scmc-mobim-form", (Object[])new Object[0]);
        int index = this.getModel().getEntryCurrentRowIndex("entryentity");
        this.getView().showConfirm(msg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(key), null, String.valueOf(index));
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        MessageBoxResult result = e.getResult();
        String customValue = e.getCustomVaule();
        switch (callBackId) {
            case "deletebtn": {
                this.delEntryRow(result, customValue);
                break;
            }
        }
    }

    private void delEntryRow(MessageBoxResult result, String customValue) {
        if (MessageBoxResult.Yes.equals((Object)result)) {
            int index = Integer.parseInt(customValue);
            DataSourceConfig dataSourceConfig = DataSourceHelper.getDataSourceConfig((IMobilePage)this);
            DataChangedHandlerHelper.deleteEntry((AbstractFormPlugin)this, (IEntryRowDeletedHandler)this.getEntryRowDeletedHandler(), (String)"entryentity", (int)index, (DataSourceConfig)dataSourceConfig);
            this.refreshPageData();
        }
    }

    public void setModelValue(DynamicObjectCollection collection) {
        IDataModel model = this.getModel();
        IDataModel parentModel = this.getView().getParentView().getModel();
        model.setValue("billid", parentModel.getValue("billid"));
        model.setValue("org", parentModel.getValue("org"));
        model.setValue("invscheme", parentModel.getValue("invscheme"));
        if (collection != null && !collection.isEmpty()) {
            model.deleteEntryData("entryentity");
            int size = collection.size();
            model.batchCreateNewEntryRow("entryentity", size);
            DataSourceConfigServiceImpl dataSourceConfigService = new DataSourceConfigServiceImpl();
            DataSourceConfig dataSourceConfig = dataSourceConfigService.getDataSourceConfig("mobim_countbilledit");
            Map mobEntryKeyToFieldKeys = dataSourceConfig.getMobEntryKeyToFieldKeys();
            List keys = (List)mobEntryKeyToFieldKeys.get("entryentity");
            for (int i = 0; i < size; ++i) {
                DynamicObject dyn = (DynamicObject)collection.get(i);
                for (String key : keys) {
                    model.beginInit();
                    model.setValue(PARENT_SEQ, dyn.get("seq"), i);
                    model.setValue(key, dyn.get(key), i);
                    model.endInit();
                }
            }
        } else {
            model.deleteEntryData("entryentity");
        }
        this.getView().updateView();
    }

    public IFormView getPcEntityStorageView() {
        return this.getView().getParentView();
    }

    public String getDatasourceConfigMobileKey() {
        return this.getPcEntityStorageView().getEntityId();
    }

    public int getIndex(int index) {
        Object seq = this.getModel().getValue(PARENT_SEQ, index);
        String seqStr = String.valueOf(seq);
        int parseInt = Integer.parseInt(seqStr) - 1;
        return parseInt;
    }

    public boolean isLoadPcEntityToMobilePage() {
        return false;
    }

    public void destory() {
        super.destory();
        EntityCacheHelper.onPluginDestroyed((AbstractFormPlugin)this);
    }
}

