/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.handler;

import java.time.ZoneId;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.chargeagainst.util.DateUtils;
import kd.bos.ext.scmc.chargeagainst.util.SystemCallParamHelper;
import kd.bos.inte.api.IInteService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scmc.im.business.helper.AppParameterHelper;
import kd.scmc.im.business.helper.CloseDateHelper;
import kd.scmc.im.business.helper.MetaDataHelper;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.helper.DaysCalcHelper;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.im.utils.IMStringUtils;
import kd.scmc.msmob.business.helper.change.context.PropertyChangedContext;
import kd.scmc.msmob.business.helper.change.handler.IPropertyChangedHandler;

public class ImBillChangedHandler
implements IPropertyChangedHandler {
    private static String[] clearFields = new String[]{"materialmasterid", "auxpty", "producedate", "expirydate", "unit", "qty", "baseunit", "baseqty", "unit2nd", "qtyunit2nd", "lotnumber", "lot", "serialnumber", "mversion", "configuredcode"};

    public void onPropertyChanged(PropertyChangedContext context) {
        if (context.isMain()) {
            this.changeBillHead(context);
            return;
        }
        String mobileFieldName = context.getMobileFieldName();
        Object newValue = context.getNewValue();
        int rowIndex = context.getRowIndex();
        String pcEntityName = context.getPcEntityName();
        DynamicObject calculatedResult = context.getCalculatedResult();
        DynamicObject entryData = (DynamicObject)context.getCalculatedResult().getDynamicObjectCollection(context.getPcEntryName()).get(rowIndex);
        switch (mobileFieldName) {
            case "material": {
                this.changeMaterial(pcEntityName, entryData, (DynamicObject)newValue, calculatedResult);
                break;
            }
        }
    }

    public void changeBillHead(PropertyChangedContext context) {
        String mobileFieldName = context.getMobileFieldName();
        Object newValue = context.getNewValue();
        DynamicObject pcEntity = context.getCalculatedResult();
        switch (mobileFieldName) {
            case "biztime": {
                this.bizDateChange(pcEntity, (Date)newValue);
                break;
            }
        }
    }

    private void bizDateChange(DynamicObject pcEntity, Date bizDate) {
        if (bizDate == null) {
            return;
        }
        String formId = pcEntity.getDataEntityType().getName();
        boolean includeInitBizBill = MetaDataHelper.isExistField((IDataEntityType)EntityMetadataCache.getDataEntityType((String)formId), (String)"isinitbill");
        if ("im_initbill".equals(formId) || includeInitBizBill && ((Boolean)pcEntity.get("isinitbill")).booleanValue()) {
            pcEntity.set("bookdate", (Object)bizDate);
            return;
        }
        DynamicObject org = this.getOrgDyc(pcEntity, null);
        TimeZone orgZone = this.getOrgZone(org);
        if (orgZone == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u201c\u7ec4\u7ec7\u65f6\u533a\u201d\u548c\u201c\u7cfb\u7edf\u65f6\u533a\u201d\u6709\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ImBillChangedHandler_bizDateChange_0", (String)"scmc-mobim-form", (Object[])new Object[0]));
        }
        Date now = new Date();
        int fallowDays = 0;
        int differDays = 0;
        if (now.before(bizDate)) {
            Object beforeDays = AppParameterHelper.getAppParameter((String)"=9Q86DR2P+Q", (String)"05", (Long)((Long)org.getPkValue()), (String)"fallowbeforedays");
            differDays = DaysCalcHelper.differentDays((Date)bizDate, (Date)now, (ZoneId)orgZone.toZoneId());
            differDays = Math.abs(differDays);
            fallowDays = Integer.parseInt(beforeDays == null ? "0" : beforeDays.toString());
        } else if (now.after(bizDate)) {
            Object afterDays = AppParameterHelper.getAppParameter((String)"=9Q86DR2P+Q", (String)"05", (Long)((Long)org.getPkValue()), (String)"fallowafterdays");
            differDays = DaysCalcHelper.differentDays((Date)bizDate, (Date)now, (ZoneId)orgZone.toZoneId());
            differDays = Math.abs(differDays);
            fallowDays = Integer.parseInt(afterDays == null ? "0" : afterDays.toString());
        }
        if (differDays > fallowDays) {
            LocaleString bizTimeName = pcEntity.getDynamicObjectType().getProperty("biztime").getDisplayName();
            throw new KDBizException(IMStringUtils.append((String)bizTimeName.getLocaleValue(), (Object[])new Object[]{ResManager.loadKDString((String)"\u8d85\u51fa\u5141\u8bb8\u671f\u9650\u3002\u5982\u4ecd\u9700\u63d0\u4ea4\u5355\u636e\uff0c\u8bf7\u5230\u7cfb\u7edf\u53c2\u6570\u4e2d\u4fee\u6539\u76f8\u5173\u8bbe\u7f6e\u3002", (String)"ImBillPropChanged_6", (String)"scmc-mobim-form", (Object[])new Object[0])}));
        }
        this.changeBookDate(pcEntity, bizDate);
    }

    protected TimeZone getOrgZone(DynamicObject org) {
        TimeZone timeZone = null;
        DynamicObject timezone = org.getDynamicObject("timezone");
        if (timezone == null) {
            timeZone = this.getSysTimezone();
        } else {
            String timeArea = timezone.getString("number");
            timeZone = TimeZone.getTimeZone(timeArea);
        }
        return timeZone;
    }

    protected TimeZone getSysTimezone() {
        IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
        DynamicObject sysTimezoneMeta = service.getSysTimezone();
        String timeArea = sysTimezoneMeta.getString("number");
        return TimeZone.getTimeZone(timeArea);
    }

    private DynamicObject getOrgDyc(DynamicObject pcEntity, String propName) {
        DynamicObject org = null;
        String fromID = pcEntity.getDataEntityType().getName();
        org = "im_transdirbill".equals(fromID) && "outoperator".equalsIgnoreCase(propName) ? (DynamicObject)pcEntity.get("outorg") : (DynamicObject)pcEntity.get("org");
        if (org == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u3002", (String)"ImBillPropChanged_8", (String)"scmc-mobim-form", (Object[])new Object[0]));
        }
        return org;
    }

    private void changeBookDate(DynamicObject pcEntity, Date bizDate) {
        Date closeDate;
        Date addDate;
        Map closeDateMap;
        String formId = pcEntity.getDataEntityType().getName();
        Date bookDate = bizDate;
        if (!SystemCallParamHelper.isEnable((String)"sbs_scmcapplevelparam", (String)"INV0004") && null != (closeDateMap = CloseDateHelper.getCloseDateMap((String)formId, (DynamicObject)pcEntity)) && bizDate.before(addDate = DateUtils.addOneDay((Date)(closeDate = (Date)closeDateMap.get("closeDate"))))) {
            bookDate = addDate;
        }
        pcEntity.set("bookdate", (Object)bookDate);
    }

    private void changeMaterial(String pcEntityName, DynamicObject entryData, DynamicObject materialInvInfo, DynamicObject entity) {
        this.clearMaterialInfo(entryData);
        if (materialInvInfo != null) {
            this.resetMaterialInfo(pcEntityName, entryData, materialInvInfo, entity);
        }
    }

    private void clearMaterialInfo(DynamicObject entryData) {
        for (String key : clearFields) {
            entryData.set(key, null);
        }
    }

    private void resetMaterialInfo(String pcEntityName, DynamicObject entryData, DynamicObject materialInvInfo, DynamicObject entity) {
        DynamicObject material = null;
        material = materialInvInfo.getDynamicObject("masterid");
        if (material == null) {
            throw new KDBizException(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_MATERIAL(), (Object[])new Object[0]));
        }
        if (!pcEntityName.equals("im_initbill")) {
            String materialName = material.getString("name");
            entryData.set("materialname", (Object)materialName);
        }
        this.resetMaterialUnits(entryData, materialInvInfo, material, entity);
        entryData.set("lotnumber", null);
        entryData.set("lot", null);
        DynamicObject materialDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)material.getPkValue(), (String)"bd_material", (String)"id,name,number,isenablematerialversion");
        boolean isVersionManage = materialDyn.getBoolean("isenablematerialversion");
        if (isVersionManage) {
            this.update2Version(entryData, materialInvInfo);
        }
    }

    private void update2Version(DynamicObject entryData, DynamicObject materialInvInfo) {
        try {
            String versionIdStr = (String)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataService", (String)"getVersionByMaterial", (Object[])new Object[]{materialInvInfo.getLong("masterid_id")});
            Long versionId = null;
            String initVersionId = "0";
            if (StringUtils.isNotBlank((CharSequence)versionIdStr) && !initVersionId.equals(versionIdStr)) {
                versionId = Long.valueOf(versionIdStr);
            }
            DynamicObject mversion = BusinessDataServiceHelper.loadSingleFromCache(versionId, (String)"bd_materialversion");
            entryData.set("mversion", (Object)mversion);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u7269\u6599\u7248\u672c\u670d\u52a1\u9519\u8bef,\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"ImBillChangedHandler_0", (String)"scmc-mobim-form", (Object[])new Object[0]));
        }
    }

    private void resetMaterialUnits(DynamicObject entryData, DynamicObject materialInvInfo, DynamicObject material, DynamicObject entity) {
        Object materialId = material.getPkValue();
        entryData.set("materialmasterid", materialId);
        DynamicObject baseUnit = material.getDynamicObject("baseunit");
        if (baseUnit == null) {
            throw new KDBizException(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_MATERIAL_BASEUNIT(), (Object[])new Object[0]));
        }
        DynamicObject auxptyUnit = material.getDynamicObject("auxptyunit");
        DynamicObject unit = materialInvInfo.getDynamicObject("inventoryunit");
        if (unit == null) {
            throw new KDBizException(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_MATERIAL_BASEUNIT(), (Object[])new Object[0]));
        }
        DynamicObject unitObj = this.getDynamicByType(entity, "unit", unit.getPkValue());
        DynamicObject baseUnitObj = this.getDynamicByType(entity, "baseunit", baseUnit.getPkValue());
        entryData.set("unit", (Object)unitObj);
        entryData.set("baseunit", (Object)baseUnitObj);
        if (auxptyUnit != null) {
            DynamicObject auxptyUnitObj = this.getDynamicByType(entity, "unit2nd", auxptyUnit.getPkValue());
            entryData.set("unit2nd", (Object)auxptyUnitObj);
        }
    }

    private DynamicObject getDynamicByType(DynamicObject dataEntity, String pcFieldKey, Object pkValue) {
        MainEntityType pcMainEntityType = (MainEntityType)dataEntity.getDynamicObjectType();
        BasedataProp basedataProp = (BasedataProp)pcMainEntityType.findProperty(pcFieldKey);
        return BusinessDataServiceHelper.loadSingleFromCache((Object)pkValue, (DynamicObjectType)((DynamicObjectType)basedataProp.getComplexType((Object)dataEntity)));
    }
}

