/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.handler;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.business.helper.LineTypeHelper;
import kd.scmc.mobim.business.helper.invscheme.InvSchemeHelper;
import kd.scmc.mobim.business.helper.invscheme.service.InvSchemeService;
import kd.scmc.mobim.business.helper.invscheme.service.InvSchemeServiceFactory;
import kd.scmc.mobim.business.helper.logisticsbill.LogisticsBillModel;
import kd.scmc.msmob.business.helper.change.context.RowAddedContext;
import kd.scmc.msmob.business.helper.change.handler.IEntryRowAddedHandler;

public class ImBillNewEntryHandler
implements IEntryRowAddedHandler {
    private InvSchemeService invSchemeService = null;

    public void onEntryRowAdded(RowAddedContext context) {
        String pcEntryKey = context.getPcEntryKey();
        String pcEntityKey = context.getPcEntityKey();
        DynamicObject newEntryRowData = context.getNewEntryRowData();
        DynamicObject bill = context.getCalculatedResult();
        this.afterAddRow(pcEntityKey, pcEntryKey, bill, newEntryRowData);
    }

    public void afterAddRow(String formId, String entryKey, DynamicObject bill, DynamicObject entry) {
        if (!this.noInvScheme(formId) && "billentry".equals(entryKey)) {
            this.initNewEntryScheme(formId, bill, entry);
            if (!"im_initbill".equals(formId)) {
                this.initNewEntryLineType(bill, entry);
            }
        }
        ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>(2);
        bills.add(bill);
        LogisticsBillModel logisticsBillModel = LogisticsBillModel.getInstance();
        logisticsBillModel.matchLogisticsBill(formId, bills);
    }

    private void initNewEntryLineType(DynamicObject bill, DynamicObject entry) {
        DynamicObject bizType = bill.getDynamicObject("biztype");
        if (bizType == null) {
            return;
        }
        Long bizTypeId = bizType.getLong("id");
        DynamicObject lineType = entry.getDynamicObject("linetype");
        if (lineType == null) {
            Long lineTypeId = LineTypeHelper.getDefaultLineType((Long)bizTypeId);
            QFilter filter = new QFilter("id", "=", (Object)lineTypeId);
            MainEntityType pcMainEntityType = (MainEntityType)bill.getDynamicObjectType();
            BasedataProp basedataProp = (BasedataProp)pcMainEntityType.findProperty("linetype");
            Map lineTypeMap = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)((DynamicObjectType)basedataProp.getComplexType((Object)bill)), (QFilter[])filter.toArray());
            lineType = (DynamicObject)lineTypeMap.values().iterator().next();
        }
        entry.set("linetype", (Object)lineType);
    }

    private boolean noInvScheme(String formId) {
        return "im_initbill".equalsIgnoreCase(formId) || "im_locationtransfer".equalsIgnoreCase(formId);
    }

    private void initNewEntryScheme(String formId, DynamicObject bill, DynamicObject entry) {
        if (this.noInvScheme(formId)) {
            return;
        }
        DynamicObject invScheme = bill.getDynamicObject("invscheme");
        InvSchemeHelper.initEntryValue(bill, entry, invScheme);
        InvSchemeService service = this.getInvSchemeService(bill);
        InvSchemeHelper.setDefaultOwnerAndKeeper(service, bill, entry);
    }

    protected InvSchemeService getInvSchemeService(DynamicObject bill) {
        if (this.invSchemeService == null) {
            this.invSchemeService = InvSchemeServiceFactory.getService(bill);
        }
        return this.invSchemeService;
    }
}

