/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.handler;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.scmc.msmob.business.helper.change.context.PropertyChangedContext;
import kd.scmc.msmob.business.helper.change.handler.IPropertyChangedHandler;

public class ManufactureChangedHandler
implements IPropertyChangedHandler {
    public void onPropertyChanged(PropertyChangedContext context) {
        if (context.isMain()) {
            return;
        }
        String pcFieldName = context.getPcFieldName();
        if ("qty".equals(pcFieldName)) {
            this.changeQty(context);
        }
    }

    private void changeQty(PropertyChangedContext context) {
        DynamicObject calculatedResult = context.getCalculatedResult();
        DynamicObject settleCurrency = calculatedResult.getDynamicObject("settlecurrency");
        int precision = settleCurrency.getInt("amtprecision");
        DynamicObjectCollection entryList = calculatedResult.getDynamicObjectCollection(context.getPcEntryName());
        DynamicObject changeEntry = (DynamicObject)entryList.get(context.getRowIndex());
        BigDecimal qty = (BigDecimal)context.getNewValue();
        BigDecimal price = changeEntry.getBigDecimal("price");
        BigDecimal amount = qty.multiply(price);
        amount = amount.setScale(precision, RoundingMode.HALF_UP);
        changeEntry.set("amount", (Object)amount);
    }
}

