/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.handler;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.business.helper.OwnerHelper;
import kd.scmc.mobim.plugin.form.handler.ImBillNewEntryHandler;
import kd.scmc.msmob.business.helper.change.context.RowAddedContext;

public class TransBillNewEntryHandler
extends ImBillNewEntryHandler {
    @Override
    public void onEntryRowAdded(RowAddedContext context) {
        super.onEntryRowAdded(context);
        DynamicObject newEntryRowData = context.getNewEntryRowData();
        DynamicObject pcEntity = context.getCalculatedResult();
        this.dealKeeper(pcEntity, newEntryRowData, "keepertype");
        this.dealKeeper(pcEntity, newEntryRowData, "outkeepertype");
        this.dealOwner(pcEntity, newEntryRowData, "ownertype");
        this.dealOwner(pcEntity, newEntryRowData, "outownertype");
    }

    protected void dealOwner(DynamicObject pcEntity, DynamicObject newEntryRowData, String field) {
        Object ownerType = newEntryRowData.get(field);
        DynamicObject org = null;
        String ownerkey = null;
        switch (field) {
            case "ownertype": {
                org = pcEntity.getDynamicObject(this.getTransInOrgKey(pcEntity.getDataEntityType().getName()));
                ownerkey = "owner";
                break;
            }
            case "outownertype": {
                org = pcEntity.getDynamicObject(this.getTransOutOrgKey(pcEntity.getDataEntityType().getName()));
                ownerkey = "outowner";
                break;
            }
        }
        if (!"bos_org".equals(ownerType)) {
            return;
        }
        if (org == null) {
            newEntryRowData.set(ownerkey, (Object)null);
            return;
        }
        Long orgId = (Long)org.getPkValue();
        Object ownerId = this.getDefaultOwner(pcEntity, ownerkey, orgId);
        DynamicObject owner = BusinessDataServiceHelper.loadSingleFromCache((Object)ownerId, (String)"bos_org");
        newEntryRowData.set(ownerkey, (Object)owner);
    }

    private Object getDefaultOwner(DynamicObject pcEntity, String ownerKey, Long defOrgId) {
        String formId;
        Object ownerID = null;
        switch (formId = pcEntity.getDataEntityType().getName()) {
            case "im_transoutbill": {
                if ("A".equals(pcEntity.get("transit")) && "owner".equals(ownerKey)) {
                    DynamicObject outOrg = pcEntity.getDynamicObject(this.getTransOutOrgKey(pcEntity.getDataEntityType().getName()));
                    if (outOrg == null) break;
                    ownerID = OwnerHelper.getOwnerDefValue((Long)((Long)outOrg.getPkValue()));
                    break;
                }
                ownerID = OwnerHelper.getOwnerDefValue((Long)defOrgId);
                break;
            }
            case "im_transinbill": {
                if ("B".equals(pcEntity.get("transit")) && "outowner".equals(ownerKey)) {
                    DynamicObject inOrg = pcEntity.getDynamicObject(this.getTransInOrgKey(pcEntity.getDataEntityType().getName()));
                    if (inOrg == null) break;
                    ownerID = OwnerHelper.getOwnerDefValue((Long)((Long)inOrg.getPkValue()));
                    break;
                }
                ownerID = OwnerHelper.getOwnerDefValue((Long)defOrgId);
                break;
            }
            default: {
                ownerID = OwnerHelper.getOwnerDefValue((Long)defOrgId);
            }
        }
        return ownerID;
    }

    protected void dealKeeper(DynamicObject pcEntity, DynamicObject entryData, String field) {
        this.dealKeeper(pcEntity, entryData, field, true);
    }

    protected void dealKeeper(DynamicObject pcEntity, DynamicObject entryData, String field, boolean isSetValue) {
        String keeper = "";
        DynamicObject org = null;
        if (field == null) {
            return;
        }
        switch (field) {
            case "outkeepertype": {
                keeper = "outkeeper";
                if ("im_transinbill".equals(pcEntity.getDataEntityType().getName()) && "B".equals(pcEntity.get("transit"))) {
                    org = (DynamicObject)pcEntity.get(this.getTransInOrgKey(pcEntity.getDataEntityType().getName()));
                    break;
                }
                org = (DynamicObject)pcEntity.get(this.getTransOutOrgKey(pcEntity.getDataEntityType().getName()));
                break;
            }
            default: {
                keeper = "keeper";
                org = "im_transoutbill".equals(pcEntity.getDataEntityType().getName()) && "A".equals(pcEntity.get("transit")) ? (DynamicObject)pcEntity.get(this.getTransOutOrgKey(pcEntity.getDataEntityType().getName())) : (DynamicObject)pcEntity.get(this.getTransInOrgKey(pcEntity.getDataEntityType().getName()));
            }
        }
        Object keeperTypeObj = entryData.get(field);
        if (keeperTypeObj != null) {
            switch (keeperTypeObj.toString()) {
                case "bos_org": {
                    if (!isSetValue) break;
                    entryData.set(keeper, (Object)org);
                    break;
                }
            }
        } else if (isSetValue) {
            entryData.set(keeper, null);
        }
    }

    public String getTransInOrgKey(String pcEntityKey) {
        String inOrgKey = null;
        switch (pcEntityKey) {
            case "im_transoutbill": {
                inOrgKey = "inorg";
                break;
            }
            case "im_transinbill": {
                inOrgKey = "org";
                break;
            }
            case "im_transdirbill": {
                inOrgKey = "inorg";
                break;
            }
        }
        return inOrgKey;
    }

    public String getTransOutOrgKey(String pcEntityKey) {
        String outOrgKey = null;
        switch (pcEntityKey) {
            case "im_transoutbill": {
                outOrgKey = "org";
                break;
            }
            case "im_transinbill": {
                outOrgKey = "outorg";
                break;
            }
            case "im_transdirbill": {
                outOrgKey = "outorg";
                break;
            }
        }
        return outOrgKey;
    }
}

