/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.handler.countbill;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.business.helper.MaterialHelper;
import kd.scmc.im.business.helper.OwnerHelper;
import kd.scmc.mobim.business.helper.CountBillHelper;
import kd.scmc.msmob.business.helper.change.context.PropertyChangedContext;
import kd.scmc.msmob.business.helper.change.handler.IPropertyChangedHandler;

public class CountBillChangeHandler
implements IPropertyChangedHandler {
    private static final String QUANTITY_FIELD = "qty";
    private static final String QTY_ACC_FIELD = "qtyacc";
    private static final String MATERIAL_FIELD = "material";
    private static final String OWNER_TYPE_FIELD = "ownertype";
    private static final String KEEPER_TYPE_FIELD = "keepertype";

    public void onPropertyChanged(PropertyChangedContext context) {
        String pcFieldName = context.getPcFieldName();
        int rowIndex = context.getRowIndex();
        DynamicObject calculatedResult = context.getCalculatedResult();
        Object newValue = context.getNewValue();
        boolean main = context.isMain();
        if (main) {
            return;
        }
        DynamicObject changedEntry = (DynamicObject)calculatedResult.getDynamicObjectCollection(context.getPcEntryName()).get(rowIndex);
        switch (pcFieldName) {
            case "material": {
                this.changeMaterial(newValue, changedEntry);
                break;
            }
            case "qty": 
            case "qtyacc": {
                this.changQty(changedEntry, calculatedResult);
                break;
            }
            case "ownertype": {
                this.changeOwnerAndKeeperType(newValue, "owner", calculatedResult, changedEntry);
                break;
            }
            case "keepertype": {
                this.changeOwnerAndKeeperType(newValue, "keeper", calculatedResult, changedEntry);
                break;
            }
        }
    }

    private void changeOwnerAndKeeperType(Object newValue, String field, DynamicObject bill, DynamicObject entry) {
        if ("bos_org".equals(newValue)) {
            DynamicObject org = bill.getDynamicObject("org");
            this.dealOwnerAndKeeper(org, field, entry);
        }
    }

    private void dealOwnerAndKeeper(DynamicObject org, String field, DynamicObject entry) {
        Object type;
        String typeField = OWNER_TYPE_FIELD;
        Long orgId = (Long)org.getPkValue();
        Long ownerId = OwnerHelper.getDefaultOwner((Long)orgId);
        if ("keeper".equals(field)) {
            typeField = KEEPER_TYPE_FIELD;
            ownerId = orgId;
        }
        if ("bos_org".equals(type = entry.get(typeField))) {
            DynamicObject bosOrg = BusinessDataServiceHelper.loadSingle((Object)ownerId, (String)"bos_org", (String)"id,name,nubmer");
            entry.set(field, (Object)bosOrg);
        }
    }

    private void changeMaterial(Object newValue, DynamicObject changedEntry) {
        changedEntry.set("unit", null);
        changedEntry.set(QUANTITY_FIELD, null);
        changedEntry.set("lotnumber", null);
        if (newValue != null) {
            CountBillHelper.initDataByMaterial(changedEntry);
        }
    }

    private void changQty(DynamicObject changedEntry, DynamicObject bill) {
        DynamicObject materialInvInfo = changedEntry.getDynamicObject(MATERIAL_FIELD);
        if (materialInvInfo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u4fe1\u606f", (String)"CountBillEntryEditPlugin_0", (String)"scmc-mobim-form", (Object[])new Object[0]));
        }
        DynamicObject material = MaterialHelper.getMaterialByMatBiz((DynamicObject)materialInvInfo);
        if (material == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u4fe1\u606f", (String)"CountBillEntryEditPlugin_0", (String)"scmc-mobim-form", (Object[])new Object[0]));
        }
        boolean enableCheck = bill.getBoolean("enablecheck");
        CountBillHelper.calByQty(changedEntry, enableCheck);
    }
}

