/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.handler.locationbill;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.mobim.plugin.form.handler.ImBillChangedHandler;
import kd.scmc.msmob.business.helper.change.context.PropertyChangedContext;

public class LocationBillChangeHandler
extends ImBillChangedHandler {
    @Override
    public void onPropertyChanged(PropertyChangedContext context) {
        super.onPropertyChanged(context);
        if (context.isMain()) {
            return;
        }
        String mobileFieldName = context.getMobileFieldName();
        int rowIndex = context.getRowIndex();
        DynamicObject pcEntity = context.getCalculatedResult();
        DynamicObject entryData = (DynamicObject)pcEntity.getDynamicObjectCollection(context.getPcEntryName()).get(rowIndex);
        switch (mobileFieldName) {
            case "material": {
                this.setAmount(pcEntity, entryData);
                break;
            }
            case "warehouse": {
                this.setLocationIsEnableByWarehouse(entryData);
                break;
            }
        }
    }

    protected void setLocationIsEnableByWarehouse(DynamicObject entryData) {
        entryData.set("location", null);
        entryData.set("outlocation", null);
    }

    protected void setAmount(DynamicObject pcEntity, DynamicObject entryData) {
        BigDecimal qty = (BigDecimal)entryData.get("qty");
        if (qty == null || BigDecimal.ZERO.compareTo(qty) == 0) {
            entryData.set("amount", (Object)BigDecimal.ZERO);
            entryData.set("price", (Object)BigDecimal.ZERO);
            return;
        }
        BigDecimal price = entryData.getBigDecimal("price");
        int precision = this.getPrecision(pcEntity);
        BigDecimal allAmount = qty.multiply(price);
        BigDecimal amount = allAmount.setScale(precision, 4);
        entryData.set("amount", (Object)amount);
    }

    private int getPrecision(DynamicObject pcEntity) {
        int precision = 2;
        DynamicObject currency = pcEntity.getDynamicObject("settlescurrency");
        if (currency != null) {
            precision = currency.getInt("amtprecision");
        }
        return precision;
    }
}

