/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.handler.locationbill;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.business.helper.OwnerHelper;
import kd.scmc.im.business.helper.linetype.BillTypeMaterialHelper;
import kd.scmc.im.business.helper.linetype.LineTypeParam;
import kd.scmc.mobim.plugin.form.handler.ImBillNewEntryHandler;
import kd.scmc.msmob.business.helper.change.context.RowAddedContext;

public class LocationBillNewEntryHandler
extends ImBillNewEntryHandler {
    @Override
    public void onEntryRowAdded(RowAddedContext context) {
        super.onEntryRowAdded(context);
        DynamicObject newEntryRowData = context.getNewEntryRowData();
        DynamicObject calculatedResult = context.getCalculatedResult();
        DynamicObject org = calculatedResult.getDynamicObject("org");
        this.initEntryRow(calculatedResult, newEntryRowData, org);
    }

    private void initEntryLineType(DynamicObject bizType, DynamicObject entryData) {
        ArrayList<Long> bizTypes = new ArrayList<Long>();
        if (bizType == null) {
            return;
        }
        Long bizTypeId = (Long)bizType.getPkValue();
        Long lineTypeId = null;
        bizTypes.add(bizTypeId);
        Map lineTypeByBillType = BillTypeMaterialHelper.getLineTypeByBillType(bizTypes);
        if (lineTypeByBillType.size() != 0) {
            LineTypeParam lineTypeParam = (LineTypeParam)lineTypeByBillType.get(bizTypeId);
            lineTypeId = lineTypeParam.getDeafaultLineType();
        }
        DynamicObject lineType = BusinessDataServiceHelper.loadSingle(lineTypeId, (String)"bd_linetype");
        entryData.set("linetype", (Object)lineType);
    }

    protected void dealOwner(DynamicObject entryData, DynamicObject org) {
        String field = "ownertype";
        Object ownerType = entryData.get(field);
        String ownerkey = "owner";
        if (!"bos_org".equals(ownerType)) {
            return;
        }
        if (org == null) {
            entryData.set(ownerkey, (Object)null);
            return;
        }
        Long orgId = (Long)org.getPkValue();
        Object ownerID = OwnerHelper.getOwnerDefValue((Long)orgId);
        DynamicObject owner = BusinessDataServiceHelper.loadSingle((Object)ownerID, (String)ownerType.toString());
        entryData.set(ownerkey, (Object)owner);
    }

    public void initEntryRow(DynamicObject pcEntity, DynamicObject entry, DynamicObject org) {
        DynamicObject bizType = (DynamicObject)pcEntity.get("biztype");
        this.initEntryLineType(bizType, entry);
        entry.set("keepertype", (Object)"bos_org");
        QFilter invTypeFilter = new QFilter("number", "=", (Object)"110");
        DynamicObject invType = BusinessDataServiceHelper.loadSingle((String)"bd_invtype", (QFilter[])invTypeFilter.toArray());
        entry.set("invtype", (Object)invType);
        QFilter invStatusFilter = new QFilter("number", "=", (Object)"110");
        DynamicObject invStatus = BusinessDataServiceHelper.loadSingle((String)"bd_invstatus", (QFilter[])invStatusFilter.toArray());
        entry.set("invstatus", (Object)invStatus);
        entry.set("ownertype", (Object)"bos_org");
        this.dealKeeper(entry, org);
        this.dealOwner(entry, org);
    }

    private void dealKeeper(DynamicObject entryData, DynamicObject org) {
        Object keeperTypeObj = entryData.get("keepertype");
        if (keeperTypeObj != null) {
            switch (keeperTypeObj.toString()) {
                case "bos_org": {
                    entryData.set("keeper", (Object)org);
                    break;
                }
                case "bd_supplier": 
                case "bd_customer": {
                    entryData.set("keeper", null);
                    break;
                }
            }
        } else {
            entryData.set("keeper", null);
        }
    }
}

