/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.handler.productinbill;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scmc.im.business.helper.OwnerHelper;
import kd.scmc.mobim.plugin.form.handler.ImBillNewEntryHandler;
import kd.scmc.msmob.business.helper.change.context.RowAddedContext;

public class ProductInBillNewEntryHandler
extends ImBillNewEntryHandler {
    @Override
    public void onEntryRowAdded(RowAddedContext context) {
        super.onEntryRowAdded(context);
        DynamicObject entry = context.getNewEntryRowData();
        DynamicObject bill = context.getCalculatedResult();
        DynamicObject orgDyc = bill.getDynamicObject("org");
        if (orgDyc == null) {
            return;
        }
        this.handleOwnerOrKeeper(orgDyc, bill, entry);
    }

    private void handleOwnerOrKeeper(DynamicObject org, DynamicObject bill, DynamicObject entry) {
        this.handleOwnerOrKeeperDetail(org, bill, entry, "ownertype", "owner");
        this.handleOwnerOrKeeperDetail(org, bill, entry, "keepertype", "keeper");
        this.handleOwnerOrKeeperDetail(org, bill, entry, "outownertype", "outowner");
        this.handleOwnerOrKeeperDetail(org, bill, entry, "outkeepertype", "outkeeper");
    }

    private void handleOwnerOrKeeperDetail(DynamicObject org, DynamicObject bill, DynamicObject entry, String type, String field) {
        Object typeBaseData = entry.get(type);
        if (type.equals("keepertype") || type.equals("outkeepertype")) {
            if ("bos_org".equals(typeBaseData)) {
                entry.set(field, (Object)org);
            }
        } else if ("bos_org".equals(typeBaseData)) {
            Long orgId = (Long)org.getPkValue();
            Object ownerId = this.getOwner(orgId, bill);
            DynamicObject owner = null;
            if (ownerId != null) {
                owner = BusinessDataServiceHelper.loadSingleFromCache((Object)ownerId, (String)"bos_org");
            }
            entry.set(field, (Object)owner);
        }
    }

    private Object getOwner(Long orgId, DynamicObject bill) {
        DynamicObject billType = bill.getDynamicObject("billtype");
        ArrayList list = OwnerHelper.getOwners((Long)orgId, (Long)((Long)billType.getPkValue()));
        long defaultOwner = OwnerHelper.getDefaultOwner((Long)orgId);
        if (defaultOwner != 0L) {
            list.add(defaultOwner);
        }
        list.add(OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE).get("id"));
        if (list.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u5e93\u5b58\u7ec4\u7ec7\u6ca1\u6709\u76f8\u5173\u8054\u7684\u6838\u7b97\u7ec4\u7ec7\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"ProductInBillNewEntryHandler_1", (String)"scmc-mobim-form", (Object[])new Object[0]));
        }
        return list.get(0);
    }
}

