/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.handler.purinbill;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.scmc.im.business.helper.SupplierHelper;
import kd.scmc.mobim.business.helper.OrgHelper;
import kd.scmc.mobim.plugin.form.handler.ImBillNewEntryHandler;
import kd.scmc.msmob.business.helper.change.context.RowAddedContext;

public class PurInBillNewEntryHandler
extends ImBillNewEntryHandler {
    @Override
    public void onEntryRowAdded(RowAddedContext context) {
        DynamicObject entry = context.getNewEntryRowData();
        DynamicObject bill = context.getCalculatedResult();
        DynamicObject supplier = bill.getDynamicObject("supplier");
        DynamicObject invoiceSupplier = null;
        DynamicObject receivingSupplier = null;
        DynamicObject deliverSupplier = null;
        if (supplier != null) {
            invoiceSupplier = supplier.getDynamicObject("invoicesupplierid");
            receivingSupplier = supplier.getDynamicObject("receivingsupplierid");
            deliverSupplier = supplier.getDynamicObject("deliversupplierid");
        }
        this.initNewEntry(bill, entry, invoiceSupplier, receivingSupplier, deliverSupplier);
        super.onEntryRowAdded(context);
    }

    private void initNewEntry(DynamicObject bill, DynamicObject entry, DynamicObject invoiceSupplier, DynamicObject receivingSupplier, DynamicObject deliverSupplier) {
        this.setDefaultSupplierInfo(invoiceSupplier, receivingSupplier, deliverSupplier, entry);
        this.setDefaultQty(entry);
        DynamicObject bizorg = bill.getDynamicObject("bizorg");
        if (bizorg != null) {
            Long requestOrgId = OrgHelper.getDefaultOrgByDelegation((Long)bizorg.getPkValue(), null, OrgViewTypeEnum.IS_PURCHASE.getViewType(), null);
            DynamicObject requestOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)requestOrgId, (String)"bos_org");
            entry.set("entryreqorg", (Object)requestOrg);
            Long toOrgId = OrgHelper.getDefaultOrgByDelegation((Long)bizorg.getPkValue(), OrgViewTypeEnum.IS_PURCHASE.getViewType(), OrgViewTypeEnum.IS_ACCOUNTING.getViewType(), OrgViewTypeEnum.IS_ACCOUNTING.getViewType());
            DynamicObject toOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)toOrgId, (String)"bos_org");
            entry.set("entrysettleorg", (Object)toOrg);
        }
        entry.set("receivedate", (Object)new Date());
        entry.set("discounttype", (Object)"NULL");
    }

    private void setDefaultQty(DynamicObject entry) {
        entry.set("returnbaseqty", null);
        entry.set("returnqty", null);
        entry.set("remainreturnqty", null);
        entry.set("remainreturnbaseqty", null);
        entry.set("joinpriceqty", null);
        entry.set("remainjoinpriceqty", null);
    }

    private void setDefaultSupplierInfo(DynamicObject invoiceSupplier, DynamicObject receivingSupplier, DynamicObject deliverSupplier, DynamicObject entry) {
        entry.set("providersupplier", (Object)deliverSupplier);
        this.changeProviderSupplier(deliverSupplier, entry);
        entry.set("invoicesupplier", (Object)invoiceSupplier);
        entry.set("receivesupplier", (Object)receivingSupplier);
    }

    private void changeProviderSupplier(DynamicObject providerSupplier, DynamicObject entry) {
        ILocaleString providerAddress = null;
        DynamicObjectCollection linkmans = null;
        if (providerSupplier != null) {
            DynamicObject bd_supplier = BusinessDataServiceHelper.loadSingleFromCache((Object)providerSupplier.getPkValue(), (String)"bd_supplier");
            providerAddress = SupplierHelper.getValidDefaultMultilingualAddress((DynamicObject)bd_supplier);
            linkmans = bd_supplier.getDynamicObjectCollection("entry_linkman");
        }
        DynamicObject supplierLinkman = null;
        if (linkmans != null) {
            for (DynamicObject linkman : linkmans) {
                boolean isDefault = linkman.getBoolean("isdefault_linkman");
                boolean isInvalid = linkman.getBoolean("invalid");
                if (!isDefault || isInvalid) continue;
                supplierLinkman = linkman;
            }
        }
        if (supplierLinkman == null && linkmans != null && linkmans.size() > 0) {
            for (DynamicObject linkman : linkmans) {
                boolean isInvalid = linkman.getBoolean("invalid");
                if (isInvalid) continue;
                supplierLinkman = linkman;
                break;
            }
        }
        entry.set("provideraddress", (Object)providerAddress);
        entry.set("providerlinkman", supplierLinkman);
    }
}

