/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.handler.saloutbill;

import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.mobim.business.helper.DefaultTaxRateHelper;
import kd.scmc.mobim.business.helper.QtyAndUnitHelper;
import kd.scmc.mobim.business.helper.TaxAlgorithmHelper;
import kd.scmc.mobim.plugin.form.handler.ImBillChangedHandler;
import kd.scmc.msmob.business.helper.change.context.PropertyChangedContext;

public class SalOutBillChangedHandler
extends ImBillChangedHandler {
    private static final String QUANTITY_FIELD = "qty";

    @Override
    public void onPropertyChanged(PropertyChangedContext context) {
        super.onPropertyChanged(context);
        if (context.isMain()) {
            return;
        }
        String pcFieldName = context.getPcFieldName();
        int rowIndex = context.getRowIndex();
        DynamicObject calculatedResult = context.getCalculatedResult();
        String pcEntryName = context.getPcEntryName();
        DynamicObject entry = (DynamicObject)context.getCalculatedResult().getDynamicObjectCollection(pcEntryName).get(rowIndex);
        Object newValue = context.getNewValue();
        switch (pcFieldName) {
            case "qty": {
                this.changQty(rowIndex, calculatedResult);
                break;
            }
            case "material": {
                this.materialChanged(calculatedResult, newValue, entry);
                break;
            }
        }
    }

    private void materialChanged(DynamicObject bill, Object material, DynamicObject entry) {
        DynamicObject dynMaterial = material == null ? null : (DynamicObject)material;
        DefaultTaxRateHelper.changeMaterial("customer", bill, dynMaterial, entry);
    }

    private void changQty(int rowIndex, DynamicObject bill) {
        QtyAndUnitHelper unitAndQtyHelper = new QtyAndUnitHelper(bill, "billentry");
        TaxAlgorithmHelper taxAlgorithm = new TaxAlgorithmHelper(bill, "billentry");
        unitAndQtyHelper.calcSalOutEntryInfoByQty(rowIndex);
        taxAlgorithm.calByQty(rowIndex);
    }
}

