/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.ininv;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.mobim.business.helper.OrgHelper;
import kd.scmc.msmob.common.enums.LogicSymbol;
import kd.scmc.msmob.plugin.tpl.basetpl.MobSrcBillBotpListTplPlugin;
import kd.scmc.msmob.pojo.FilterCondition;
import kd.scmc.msmob.pojo.PushParams;

public class PurInAddByPurOrdListPlugin
extends MobSrcBillBotpListTplPlugin {
    public PushParams getPushParams(int selectedRowIndex) {
        PushParams pushParams = new PushParams();
        IDataModel model = this.getModel();
        String orderBillNumber = this.getPcEntityKey();
        String purOrderBillNo = (String)model.getValue("billno", selectedRowIndex);
        QFilter srcFilter = new QFilter("billno", "=", (Object)purOrderBillNo);
        srcFilter.and("billstatus", "=", (Object)"C");
        srcFilter.and("closestatus", "=", (Object)"A");
        srcFilter.and("changestatus", "!=", (Object)"B");
        srcFilter.and("billentry.rowclosestatus", "=", (Object)"A");
        srcFilter.and("billentry.rowterminatestatus", "=", (Object)"A");
        srcFilter.and(QFilter.of((String)"billentry.baseqty > billentry.joinbaseqty", (Object[])new Object[0]));
        srcFilter.and("billentry.material.masterid.materialtype", "!=", (Object)"7");
        ArrayList<String> billTypes = new ArrayList<String>(10);
        billTypes.add("pm_PurOrderBill_Cost_BT_S");
        billTypes.add("pm_PurOrderBill_Asset_BT_S");
        srcFilter.and("billtype.number", "not in", billTypes);
        pushParams.setSrcEntityKey(orderBillNumber);
        pushParams.setSrcMainEntryKey("billentry");
        pushParams.setSrcEntityFilter(srcFilter);
        pushParams.setTargetEntityKey("im_purinbill");
        pushParams.setTargetMobFormKey("mobim_purinbilledit");
        return pushParams;
    }

    public List<FilterCondition> getFilters() {
        List filters = super.getFilters();
        this.addFilter(filters);
        return filters;
    }

    private void addFilter(List<FilterCondition> filters) {
        DynamicObject org;
        MobileFormShowParameter param = (MobileFormShowParameter)this.getView().getFormShowParameter();
        String orgNumber = (String)param.getCustomParam("orgBillNo");
        FilterCondition condition = new FilterCondition("billstatus", "=", (Object)"C");
        condition.and("closestatus", "=", (Object)"A");
        condition.and("changestatus", "!=", (Object)"B");
        if (StringUtils.isNotEmpty((CharSequence)orgNumber) && (org = QueryServiceHelper.queryOne((String)"bos_org", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)orgNumber)})) != null) {
            List<Long> purOrgList = OrgHelper.getPurOrgsFromInvOrg(org.getLong("id"));
            condition.and("org.id", "in", purOrgList);
        }
        ArrayList<String> billTypes = new ArrayList<String>(10);
        billTypes.add("pm_PurOrderBill_Cost_BT_S");
        billTypes.add("pm_PurOrderBill_Asset_BT_S");
        condition.and("billtype.number", "not in", billTypes);
        condition.and("billentry.rowclosestatus", "=", (Object)"A");
        condition.and("billentry.rowterminatestatus", "=", (Object)"A");
        condition.of("billentry.baseqty > billentry.joinbaseqty", LogicSymbol.AND, new Object[0]);
        condition.and("billentry.material.masterid.materialtype", "!=", (Object)"7");
        filters.add(condition);
    }
}

