/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.invquery;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PagerClickEvent;
import kd.bos.form.events.PagerClickListener;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.scmc.mobim.business.helper.QFilterHelper;
import kd.scmc.mobim.business.helper.StyleHelper;
import kd.scmc.mobim.business.helper.invquery.DefaultInvQueryExpand;
import kd.scmc.mobim.common.utils.CollectionUtils;
import kd.scmc.mobim.common.utils.MobileControlUtils;
import kd.sdk.scmc.mobim.extpoint.IInvQueryExpand;
import org.apache.commons.lang3.StringUtils;

public class InvDetailsEditPlugin
extends AbstractMobFormPlugin
implements PagerClickListener {
    private static final String OP_QUERYDETAIL = "querydetail";
    private static final String GROUP_HEADFIELDS = "fmaterialid,forgid,fwarehouseid,fownertype,fownerid,finvstatusid";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"querydetailflexap", "moreflexap", "pickupflexap"});
        CardEntry entry = (CardEntry)this.getControl("invdetailentry");
        entry.addPagerClickListener((PagerClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        int totalRowCount;
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        QFilter qFilter = this.getInitQueryFilter(view);
        this.queryPageHeadData(model, qFilter);
        int currEntryRowCount = model.getEntryRowCount("invdetailentry");
        if (currEntryRowCount > 0) {
            model.deleteEntryData("invdetailentry");
        }
        if ((totalRowCount = this.getInvQueryDataCount(qFilter)) == 0) {
            return;
        }
        model.batchCreateNewEntryRow("invdetailentry", totalRowCount);
        int pageSize = 0;
        String pageSizeTmp = pageCache.get("pageSize");
        if (StringUtils.isEmpty((CharSequence)pageSizeTmp)) {
            pageSize = this.getPageSize();
            pageCache.put("pageSize", String.valueOf(pageSize));
        } else {
            pageSize = Integer.parseInt(pageSizeTmp);
        }
        this.queryAndSetInvDetails(qFilter, this.getQueryFieldSet(), this.getShowFieldSet(), 1, pageSize, totalRowCount);
        pageCache.put("invdetailfilter", qFilter.toString());
        pageCache.put("totalrowcount", String.valueOf(totalRowCount));
        this.initDetailEntryVisible(totalRowCount);
    }

    private int getPageSize() {
        CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
        int pageSize = cardEntry.getPageRow();
        return pageSize;
    }

    public Map<String, String> getGroupByMapFields() {
        LinkedHashMap<String, String> groupByFields = new LinkedHashMap<String, String>(16);
        groupByFields.put("material", "fmaterialid");
        groupByFields.put("org", "forgid");
        groupByFields.put("warehouse", "fwarehouseid");
        groupByFields.put("ownertype", "fownertype");
        groupByFields.put("owner", "fownerid");
        groupByFields.put("invstatus", "finvstatusid");
        DefaultInvQueryExpand defExpand = new DefaultInvQueryExpand();
        PluginProxy pluginProxy = PluginProxy.create((Object)defExpand, IInvQueryExpand.class, (String)"SCMC_MOBIM_INVQUERY_EXPAND_DETAIL_HEAD_FIELDS");
        pluginProxy.callAfter(p -> {
            p.getExpandHeadFields(groupByFields);
            return null;
        });
        return groupByFields;
    }

    private void queryPageHeadData(IDataModel model, QFilter qFilter) {
        Map<String, String> groupByMapFields = this.getGroupByMapFields();
        String groupByFields = CollectionUtils.collectionToStr(groupByMapFields.values());
        String queryHeadFields = groupByFields + ",sum(fbaseqty) as fbaseqty";
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(" select ");
        sqlBuilder.append(queryHeadFields);
        sqlBuilder.append(" from t_im_inv_realbalance ");
        sqlBuilder.append(" where ");
        sqlBuilder.append(qFilter);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Object someFilter = customParams.get("someFilter");
        if (someFilter != null && !"".equals(someFilter.toString())) {
            sqlBuilder.append(" and ");
            sqlBuilder.append(someFilter);
        }
        sqlBuilder.append(" group by ");
        sqlBuilder.append(groupByFields);
        DataSet headDataSet = DB.queryDataSet((String)"InvDetailsMFormPlugin.afterCreateNewData", (DBRoute)new DBRoute("scm"), (String)sqlBuilder.toString());
        if (headDataSet.hasNext()) {
            Row row = headDataSet.next();
            int entryRow = model.createNewEntryRow("entryentity");
            BigDecimal baseQty = row.getBigDecimal("fbaseqty");
            for (Map.Entry<String, String> entry : groupByMapFields.entrySet()) {
                Object value = row.get(entry.getValue());
                if (value == null || value.equals("0L")) continue;
                model.setValue(entry.getKey(), value, entryRow);
            }
            if (baseQty != null) {
                model.setValue("baseqty", (Object)baseQty, entryRow);
            }
        }
    }

    private QFilter getInitQueryFilter(IFormView view) {
        String lotNumStr;
        String txtValueTmp;
        Object lotnumber;
        QFilter qFilter = QFilterHelper.getIdentEqFilter();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Object materialId = customParams.get("material");
        Object orgId = customParams.get("org");
        Object warehouseId = customParams.get("warehouse");
        String ownerType = (String)customParams.get("ownertype");
        Object ownerId = customParams.get("owner");
        Object invStatusId = customParams.get("invstatus");
        Object baseqtyfrom = customParams.get("baseqtyfrom");
        Object baseqtyto = customParams.get("baseqtyto");
        if (this.isNotEmptyId(materialId)) {
            qFilter.and("fmaterialid", "=", materialId);
        }
        if (this.isNotEmptyId(orgId)) {
            qFilter.and("forgid", "=", orgId);
        }
        if (this.isNotEmptyId(warehouseId)) {
            qFilter.and("fwarehouseid", "=", warehouseId);
        }
        if (StringUtils.isNotEmpty((CharSequence)ownerType)) {
            qFilter.and("fownertype", "=", (Object)ownerType);
        }
        if (this.isNotEmptyId(ownerId)) {
            qFilter.and("fownerid", "=", ownerId);
        }
        if (this.isNotEmptyId(invStatusId)) {
            qFilter.and("finvstatusid", "=", invStatusId);
            CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
            MobileControlUtils.setCardEntryRowProperty(cardEntry, "invstatus", 0, StyleHelper.getInvStatusFrontAndBack(invStatusId));
        }
        if ((lotnumber = customParams.get("lotnumber")) != null && !"".equals(lotnumber) && (txtValueTmp = (lotNumStr = lotnumber.toString()).replaceAll(" ", "")).length() != 0) {
            String[] txtValueArr = lotNumStr.split(",");
            qFilter.and("flotnum", "in", (Object)txtValueArr);
        }
        if (baseqtyfrom != null && !"0E-10".equals(baseqtyfrom)) {
            qFilter.and("fbaseqty", ">=", baseqtyfrom);
        }
        if (baseqtyto != null && !"0E-10".equals(baseqtyto)) {
            qFilter.and("fbaseqty", "<=", baseqtyto);
        }
        return qFilter;
    }

    protected void initDetailEntryVisible(int totalRowCount) {
        int pageRow;
        CardEntry entry = (CardEntry)this.getControl("invdetailentry");
        int entryCount = pageRow = entry.getPageRow();
        if (totalRowCount < pageRow) {
            entryCount = totalRowCount;
        }
        for (int i = 0; i < entryCount; ++i) {
            this.setEntryFieldVisible(entry, i, false);
        }
    }

    private Set<String> getQueryFieldSet() {
        LinkedHashSet<String> fieldSet = new LinkedHashSet<String>(16);
        fieldSet.add("fbaseqty base2qty");
        fieldSet.add("fbaseunitid base2unit");
        fieldSet.add("flocationid location");
        fieldSet.add("flotnum lotnumber");
        fieldSet.add("fauxptyid auxpty");
        fieldSet.add("fqty qty");
        fieldSet.add("funitid unit");
        fieldSet.add("fqty2nd qty2nd");
        fieldSet.add("funit2ndid unit2nd");
        fieldSet.add("finvtypeid invtype");
        fieldSet.add("fprojectid project");
        fieldSet.add("fproducedate producedate");
        fieldSet.add("fexpirydate expirydate");
        fieldSet.add("fkeepertype keepertype");
        fieldSet.add("fkeeperid keeper");
        return fieldSet;
    }

    private Set<String> getShowFieldSet() {
        LinkedHashSet<String> fieldSet = new LinkedHashSet<String>(16);
        fieldSet.add("base2qty");
        fieldSet.add("base2unit");
        fieldSet.add("location");
        fieldSet.add("lotnumber");
        fieldSet.add("auxpty");
        fieldSet.add("qty");
        fieldSet.add("unit");
        fieldSet.add("qty2nd");
        fieldSet.add("unit2nd");
        fieldSet.add("invtype");
        fieldSet.add("project");
        fieldSet.add("producedate");
        fieldSet.add("expirydate");
        fieldSet.add("keepertype");
        fieldSet.add("keeper");
        return fieldSet;
    }

    public void queryAndSetInvDetails(Object qFilter, Set<String> allQueryFieldSet, Set<String> showFieldSet, int currPageNum, int pageSize, int totalRowCount) {
        DefaultInvQueryExpand defExpand = new DefaultInvQueryExpand();
        PluginProxy pluginProxy = PluginProxy.create((Object)defExpand, IInvQueryExpand.class, (String)"SCMC_MOBIM_INVQUERY_EXPAND_DETAIL_ENTRY_FIELDS");
        pluginProxy.callAfter(p -> {
            p.getExpandDetailEntryFields(allQueryFieldSet, showFieldSet);
            return null;
        });
        IDataModel model = this.getModel();
        String filter = qFilter == null ? "" : qFilter.toString();
        int startRowIndex = pageSize * (currPageNum - 1);
        StringBuilder sqlBuilder = new StringBuilder();
        String allQueryFields = CollectionUtils.collectionToStr(allQueryFieldSet);
        sqlBuilder.append("select top ");
        sqlBuilder.append(pageSize);
        sqlBuilder.append(',');
        sqlBuilder.append(startRowIndex);
        sqlBuilder.append(' ');
        sqlBuilder.append(allQueryFields);
        sqlBuilder.append(" from ");
        sqlBuilder.append("t_im_inv_realbalance ");
        sqlBuilder.append(" where ");
        if (StringUtils.isNotEmpty((CharSequence)filter)) {
            sqlBuilder.append(filter);
            sqlBuilder.append(" and ");
        }
        sqlBuilder.append(" fbaseqty != 0 ");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Object someFilter = customParams.get("someFilter");
        if (someFilter != null && !"".equals(someFilter.toString())) {
            sqlBuilder.append(" and ");
            sqlBuilder.append(someFilter);
        }
        DataSet realBalanceSet = DB.queryDataSet((String)"InvDetailsMobPlugin.queryAndSetInvDetails", (DBRoute)new DBRoute("scm"), (String)sqlBuilder.toString());
        DynamicObject entryObj = null;
        DynamicObject materialObj = null;
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        if (entryEntity != null && entryEntity.size() > 0) {
            entryObj = (DynamicObject)entryEntity.get(0);
            materialObj = entryObj.getDynamicObject("material");
        }
        Long materialId = materialObj == null ? 0L : materialObj.getLong("id");
        for (int rowIndex = startRowIndex; realBalanceSet.hasNext() && rowIndex <= totalRowCount - 1; ++rowIndex) {
            Row next = realBalanceSet.next();
            if (!materialId.equals(0L)) {
                model.setValue("materielitem", (Object)materialId, rowIndex);
            }
            for (String field : showFieldSet) {
                Object value = next.get(field);
                if (value == null || value.equals(0L)) continue;
                model.setValue(field, value, rowIndex);
            }
        }
    }

    public int getInvQueryDataCount(Object invQueryFilter) {
        StringBuilder sqlBuilder = new StringBuilder();
        String filter = invQueryFilter == null ? "" : invQueryFilter.toString();
        sqlBuilder.append("select ");
        sqlBuilder.append("count(1) as totalrowcount ");
        sqlBuilder.append(" from t_im_inv_realbalance ");
        sqlBuilder.append("where ");
        if (StringUtils.isNotEmpty((CharSequence)filter)) {
            sqlBuilder.append(filter);
            sqlBuilder.append(" and ");
        }
        sqlBuilder.append(" fbaseqty != 0 ");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Object someFilter = customParams.get("someFilter");
        if (someFilter != null && !"".equals(someFilter.toString())) {
            sqlBuilder.append(" and ");
            sqlBuilder.append(someFilter);
        }
        DataSet dataSet = DB.queryDataSet((String)"InvQueryMobPlugin.initInvQueryData", (DBRoute)new DBRoute("scm"), (String)sqlBuilder.toString());
        int totalRowCount = 0;
        if (dataSet.hasNext()) {
            totalRowCount = dataSet.next().getInteger("totalrowcount");
        }
        if (totalRowCount > 1000) {
            totalRowCount = 1000;
        }
        this.setTotalContent(this.getModel(), totalRowCount);
        return totalRowCount;
    }

    private void setTotalContent(IDataModel model, int totalRowCount) {
        String text = String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u6570\u636e", (String)"InvDetailsEditPlugin_setTotalContent_0", (String)"scmc-mobim-form", (Object[])new Object[0]), totalRowCount);
        Label total = (Label)this.getControl("total");
        total.setText(text);
    }

    public void click(EventObject e) {
        super.click(e);
        Control source = (Control)e.getSource();
        String key = source.getKey();
        CardEntry entry = (CardEntry)this.getControl("invdetailentry");
        IDataModel model = this.getModel();
        switch (key) {
            case "querydetailflexap": {
                this.doQueryDetailOp();
                break;
            }
            case "moreflexap": {
                this.doDownOperate(model, entry);
                break;
            }
            case "pickupflexap": {
                this.doUpOperate(model, entry);
                break;
            }
        }
    }

    public void pagerClick(PagerClickEvent e) {
        int currentPageIndex = e.getCurrentPageIndex();
        int pageRows = e.getPageRows();
        IPageCache pageCache = this.getPageCache();
        String invDetailFilter = pageCache.get("invdetailfilter");
        String totalRow = pageCache.get("totalrowcount");
        int totalRowCount = 0;
        if (StringUtils.isEmpty((CharSequence)totalRow)) {
            totalRowCount = this.getInvQueryDataCount(invDetailFilter);
            pageCache.put("totalrowcount", String.valueOf(totalRowCount));
        } else {
            totalRowCount = Integer.parseInt(totalRow);
        }
        int increment = pageRows;
        int startIndex = 0;
        if (totalRowCount < pageRows) {
            increment = totalRowCount;
        } else {
            startIndex = pageRows * (currentPageIndex - 1);
            int currRows = pageRows * currentPageIndex;
            increment = currRows > totalRowCount ? totalRowCount - pageRows : pageRows;
        }
        this.queryAndSetInvDetails(invDetailFilter, this.getQueryFieldSet(), this.getShowFieldSet(), currentPageIndex, pageRows, totalRowCount);
        this.setEntryFieldVisible("invdetailentry", false, startIndex, increment);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        CardEntry entry = (CardEntry)this.getControl("invdetailentry");
        IDataModel model = this.getModel();
        switch (operateKey) {
            case "down": {
                this.doDownOperate(model, entry);
                break;
            }
            case "up": {
                this.doUpOperate(model, entry);
                break;
            }
            case "querydetail": {
                this.doQueryDetailOp();
                break;
            }
        }
    }

    private void doQueryDetailOp() {
        IFormView view = this.getView();
        DynamicObject material = (DynamicObject)this.getModel().getValue("material", 0);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org", 0);
        if (material == null || org == null) {
            return;
        }
        this.openMaterialAuxPage(view, material, org);
    }

    private void doDownOperate(IDataModel model, CardEntry entry) {
        int selectRow = model.getEntryCurrentRowIndex("invdetailentry");
        entry.setChildVisible(false, selectRow, new String[]{"moreflexap"});
        entry.setChildVisible(true, selectRow, new String[]{"pickupflexap"});
        this.setEntryFieldVisible(entry, selectRow, true);
    }

    private void doUpOperate(IDataModel model, CardEntry entry) {
        int selectRow = model.getEntryCurrentRowIndex("invdetailentry");
        entry.setChildVisible(true, selectRow, new String[]{"moreflexap"});
        entry.setChildVisible(false, selectRow, new String[]{"pickupflexap"});
        this.setEntryFieldVisible(entry, selectRow, false);
    }

    private void openMaterialAuxPage(IFormView view, DynamicObject material, DynamicObject org) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        HashMap<String, Object> customerParams = new HashMap<String, Object>();
        Long materialId = material.getLong("id");
        String materialNumber = material.getString("number");
        Long orgId = org.getLong("id");
        String orgNumber = org.getString("number");
        customerParams.put("materialId", materialId);
        customerParams.put("orgId", orgId);
        customerParams.put("materialNumber", materialNumber);
        customerParams.put("orgNumber", orgNumber);
        showParameter.setCustomParams(customerParams);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setFormId("mobim_materialaux");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "querydetailCB"));
        view.showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "querydetailCB": {
                CardEntry entry = (CardEntry)this.getControl("invdetailentry");
                int entryRowCount = this.getModel().getEntryRowCount("invdetailentry");
                for (int i = 0; i < entryRowCount; ++i) {
                    entry.setChildVisible(true, i, new String[]{"moreflexap"});
                }
                this.setEntryFieldVisible(entry, false, 0, entryRowCount);
                break;
            }
        }
    }

    private void setEntryFieldVisible(String entryKey, boolean isVisible, int startIndex, int increment) {
        CardEntry entry = (CardEntry)this.getControl(entryKey);
        this.setEntryFieldVisible(entry, isVisible, startIndex, increment);
    }

    private void setEntryFieldVisible(CardEntry entry, boolean isVisible, int startIndex, int increment) {
        for (int i = startIndex; i < startIndex + increment; ++i) {
            this.setEntryFieldVisible(entry, i, isVisible);
        }
    }

    private void setEntryFieldVisible(CardEntry entry, int rowIndex, boolean isVisible) {
        int size;
        entry.setChildVisible(isVisible, rowIndex, new String[]{"pickupflexap", "defhideflexap"});
        ArrayList<String> hideFields = new ArrayList<String>(10);
        DynamicObject auxpty = (DynamicObject)this.getModel().getValue("auxpty", rowIndex);
        Long auxptyId = auxpty == null ? 0L : auxpty.getLong("id");
        BigDecimal qty2nd = (BigDecimal)this.getModel().getValue("qty2nd", rowIndex);
        if (this.isEmptyId(auxptyId)) {
            hideFields.add("auxptyflexap");
        }
        if (qty2nd == null || qty2nd.compareTo(BigDecimal.ZERO) == 0) {
            hideFields.add("qty2ndflexap");
        }
        if ((size = hideFields.size()) == 0) {
            return;
        }
        entry.setChildVisible(false, rowIndex, hideFields.toArray(new String[size]));
    }

    private boolean isEmptyId(Object id) {
        return id == null || id.equals(0L);
    }

    private boolean isNotEmptyId(Object id) {
        return !this.isEmptyId(id);
    }
}

