/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.invquery;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.ErrorCode;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.MobileSearchCancelListener;
import kd.bos.form.control.events.MobileSearchFocusListener;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PagerClickEvent;
import kd.bos.form.events.PagerClickListener;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.MobileSearch;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QFilterHint;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.mobim.business.helper.PermissionHelper;
import kd.scmc.mobim.business.helper.QFilterHelper;
import kd.scmc.mobim.business.helper.SieveFilterHelper;
import kd.scmc.mobim.business.helper.StyleHelper;
import kd.scmc.mobim.business.helper.invquery.DefaultInvQueryExpand;
import kd.scmc.mobim.business.webservicehelper.SpeechRecognitionHelper;
import kd.scmc.mobim.common.utils.CollectionUtils;
import kd.scmc.mobim.common.utils.MobileControlUtils;
import kd.scmc.mobim.common.utils.RegExpUtils;
import kd.scmc.msmob.common.utils.CommonUtils;
import kd.sdk.scmc.mobim.extpoint.IInvQueryExpand;

public class InvQueryEditPlugin
extends AbstractMobFormPlugin
implements MobileSearchTextChangeListener,
MobileSearchFocusListener,
MobileSearchCancelListener,
PagerClickListener {
    private static final String OP_FIRSTQUERY = "firstquery";
    private static final String OP_SIEVE = "sieve";
    private static final String OP_TYPE = "opType";
    public static final String GET_MORE_DATA_TIP = "flexpanelap_getmore";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"entryrowcontent", OP_SIEVE});
        MobileSearch search = (MobileSearch)this.getControl("searchap");
        search.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
        search.addMobileSearchFocusListener((MobileSearchFocusListener)this);
        search.addMobileSearchCancelListener((MobileSearchCancelListener)this);
        CardEntry entry = (CardEntry)this.getControl("entryentity");
        entry.addPagerClickListener((PagerClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initInvQueryData();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        int size = this.getModel().getEntryEntity("entryentity").size();
        CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
        for (int i = 0; i < size; ++i) {
            cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), i, new String[]{"available", "precheck", "freeze", "discard", "intransit", "bad"});
        }
    }

    private void initInvQueryData() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        FormShowParameter param = view.getFormShowParameter();
        Object orgId = param.getCustomParam("orgid");
        QFilter defInvQueryFilter = QFilterHelper.getDefInvQueryFilter(view, "im_invaccreport", "forgid", "finvstatusid", "finvtypeid");
        String sieveQueryFilter = defInvQueryFilter.toString();
        Long currUserId = UserServiceHelper.getCurrentUserId();
        QFilter sieveFilter = new QFilter("creator", "=", (Object)currUserId);
        QFilter sieveFilterCopy = sieveFilter.copy();
        boolean isExists = QueryServiceHelper.exists((String)"mobim_sieveschemestore", (QFilter[])sieveFilterCopy.toArray());
        if (isExists) {
            pageCache.put("hasscheme", Boolean.TRUE.toString());
        } else {
            pageCache.put("hasscheme", Boolean.FALSE.toString());
        }
        Map<String, Object> filterConditions = this.getFilterFromParameter();
        if (filterConditions != null && filterConditions.size() > 0) {
            QFilter skillFilter = this.getFilterByParam(filterConditions);
            if (orgId != null) {
                skillFilter.and(new QFilter("forgid", "=", orgId));
            }
            sieveQueryFilter = skillFilter.toString();
        } else {
            sieveFilter.and("isselected", "=", (Object)Boolean.TRUE);
            DynamicObject sieveScheme = BusinessDataServiceHelper.loadSingleFromCache((String)"mobim_sieveschemestore", (QFilter[])sieveFilter.toArray());
            if (sieveScheme != null) {
                sieveQueryFilter = SieveFilterHelper.buildQFilter(sieveScheme);
            }
        }
        sieveQueryFilter = this.loadParamToFilter(sieveQueryFilter);
        int totalRowCount = this.pageQuery(model, view, sieveQueryFilter, 1, false);
        this.displayFlexPanelGetMore(1);
        if (filterConditions != null && filterConditions.size() > 0) {
            String message = ResManager.loadKDString((String)"\u626b\u4e00\u626b\u67e5\u8be2\u6210\u529f\u3002", (String)"InvQuerySkill_2", (String)"scmc-mobim-form", (Object[])new Object[0]);
            view.showSuccessNotification(message);
        }
        pageCache.put("sievequeryfilter", sieveQueryFilter);
        pageCache.put("pagequeryfilter", sieveQueryFilter);
        pageCache.put("someFilter", sieveQueryFilter);
        pageCache.put("totalrowcount", String.valueOf(totalRowCount));
    }

    public Map<String, Object> getFilterFromParameter() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        HashMap<String, Object> paramFilter = new HashMap<String, Object>(8);
        Object materialId = formShowParameter.getCustomParam("fmaterialid");
        Object warehouseId = formShowParameter.getCustomParam("fwarehouseid");
        Object locationId = formShowParameter.getCustomParam("flocationid");
        if (materialId != null) {
            paramFilter.put("fmaterialid", materialId);
        }
        if (warehouseId != null) {
            paramFilter.put("fwarehouseid", warehouseId);
        }
        if (locationId != null) {
            paramFilter.put("flocationid", locationId);
        }
        return paramFilter;
    }

    public QFilter getFilterByParam(Map<String, Object> filters) {
        QFilter qFilter = null;
        for (Map.Entry<String, Object> map : filters.entrySet()) {
            if (qFilter == null) {
                qFilter = new QFilter(map.getKey(), "=", map.getValue());
                continue;
            }
            qFilter.and(new QFilter(map.getKey(), "=", map.getValue()));
        }
        return qFilter;
    }

    private String loadParamToFilter(String sieveQueryFilter) {
        MobileFormShowParameter param = (MobileFormShowParameter)this.getView().getFormShowParameter();
        String org = (String)param.getCustomParam("org");
        if (!StringUtils.isEmpty((CharSequence)org) && RegExpUtils.isNumber(org)) {
            QFilter qFilter = new QFilter("forgid", "=", (Object)Long.valueOf(org));
            this.addFilterFromParam(param, qFilter, "warehouse", "fwarehouseid", "bd_warehouse");
            this.addFilterFromParam(param, qFilter, "material", "fmaterialid", "bd_material");
            this.addFilterFromParam(param, qFilter, "invstatus", "finvstatusid", null);
            sieveQueryFilter = qFilter.toString();
        }
        return sieveQueryFilter;
    }

    private void addFilterFromParam(MobileFormShowParameter param, QFilter qFilter, String paramKey, String filterKey, String entityKey) {
        String key = (String)param.getCustomParam(paramKey);
        if (!StringUtils.isEmpty((CharSequence)key) && RegExpUtils.isNumber(key)) {
            if (entityKey == null) {
                qFilter.and(filterKey, "=", (Object)Long.valueOf(key));
            } else {
                List<Long> filterParamIdList = SpeechRecognitionHelper.getFilterParamIdList(key, entityKey);
                if (filterParamIdList.isEmpty()) {
                    qFilter.and(QFilterHelper.getIdentNotEqFilter());
                } else {
                    qFilter.and(filterKey, "in", filterParamIdList);
                }
            }
        }
    }

    public Long getId(DynamicObject dyObj) {
        Long id = 0L;
        if (dyObj != null) {
            id = dyObj.getLong("id");
        }
        return id;
    }

    public int getInvQueryDataCount(String invQueryFilter) {
        StringBuilder sqlBuilder = new StringBuilder();
        String queryFields = "count(1) as datarowcount";
        String groupByFields = CollectionUtils.collectionToStr(this.getGroupByMapFields().values());
        invQueryFilter = invQueryFilter + this.getDefOrgFilter();
        String groupBySql = this.getGroupBySql(queryFields, groupByFields, invQueryFilter);
        sqlBuilder.append(" select ");
        sqlBuilder.append(" count(counttable.datarowcount) as totalrowcount ");
        sqlBuilder.append(" from ");
        sqlBuilder.append(" ( ");
        sqlBuilder.append(groupBySql);
        sqlBuilder.append(" ) as counttable ");
        DataSet dataSet = DB.queryDataSet((String)"InvQueryMobPlugin.initInvQueryData", (DBRoute)new DBRoute("scm"), (String)sqlBuilder.toString());
        int totalRowCount = 0;
        if (dataSet.hasNext()) {
            totalRowCount = dataSet.next().getInteger("totalrowcount");
        }
        this.setTotalContent(this.getModel(), totalRowCount);
        return totalRowCount;
    }

    protected void displayFlexPanelGetMore(int pageIndex) {
        int pageSize = this.getPageSize();
        boolean isLastPage = pageIndex * pageSize >= 1000;
        this.getView().setVisible(Boolean.valueOf(isLastPage), new String[]{GET_MORE_DATA_TIP});
    }

    public Map<String, String> getGroupByMapFields() {
        LinkedHashMap<String, String> groupByFields = new LinkedHashMap<String, String>(16);
        groupByFields.put("material", "fmaterialid");
        groupByFields.put("org", "forgid");
        groupByFields.put("warehouse", "fwarehouseid");
        groupByFields.put("ownertype", "fownertype");
        groupByFields.put("owner", "fownerid");
        groupByFields.put("invstatus", "finvstatusid");
        DefaultInvQueryExpand defExpand = new DefaultInvQueryExpand();
        PluginProxy pluginProxy = PluginProxy.create((Object)defExpand, IInvQueryExpand.class, (String)"SCMC_MOBIM_INVQUERY_EXPAND_LIST_FIELDS");
        pluginProxy.callAfter(p -> {
            p.getExpandListFields(groupByFields);
            return null;
        });
        return groupByFields;
    }

    private int pageQuery(IDataModel model, IFormView view, String queryFilter, int currPageNo, boolean isUpdateView) {
        int totalRowCount;
        int currEntryRowCount = model.getEntryRowCount("entryentity");
        if (currEntryRowCount > 0) {
            model.deleteEntryData("entryentity");
        }
        if (isUpdateView) {
            view.updateView("entryentity");
        }
        if ((totalRowCount = this.getInvQueryDataCount(queryFilter)) == 0) {
            this.setTotalContent(model, 0);
            return 0;
        }
        if (totalRowCount >= 1000) {
            totalRowCount = 1000;
        }
        model.batchCreateNewEntryRow("entryentity", totalRowCount);
        int pageSize = 0;
        IPageCache pageCache = this.getPageCache();
        String pageSizeTmp = pageCache.get("pageSize");
        if (StringUtils.isEmpty((CharSequence)pageSizeTmp)) {
            pageSize = this.getPageSize();
            pageCache.put("pageSize", String.valueOf(pageSize));
        } else {
            pageSize = Integer.parseInt(pageSizeTmp);
        }
        this.queryAndSetInvData(null, queryFilter, this.getGroupByMapFields(), currPageNo, pageSize, totalRowCount);
        return totalRowCount;
    }

    private int getPageSize() {
        CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
        int pageSize = cardEntry.getPageRow();
        return pageSize;
    }

    public void queryAndSetInvData(CardEntry cardEntry, String qFilter, Map<String, String> groupByFields, int currPageNum, int pageSize, int totalRowCount) {
        int startRowIndex = pageSize * (currPageNum - 1);
        String allGroupByFields = CollectionUtils.collectionToStr(groupByFields.values());
        ArrayList<String> queryFields = new ArrayList<String>(groupByFields.values());
        ArrayList<String> queryFieldsTmpTb = new ArrayList<String>(groupByFields.values());
        queryFields.add("fbaseqty");
        String allQueryFields = CollectionUtils.collectionToStr(queryFields);
        queryFieldsTmpTb.add("sum(fbaseqty) fbaseqty");
        String allQueryTmpTbFields = CollectionUtils.collectionToStr(queryFieldsTmpTb);
        qFilter = qFilter + this.getDefOrgFilter();
        String groupBySql = this.getGroupBySql(allQueryTmpTbFields, allGroupByFields, qFilter);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("select top ");
        sqlBuilder.append(pageSize);
        sqlBuilder.append(',');
        sqlBuilder.append(startRowIndex);
        sqlBuilder.append(' ');
        sqlBuilder.append(allQueryFields);
        sqlBuilder.append(" from ");
        sqlBuilder.append('(');
        sqlBuilder.append(groupBySql);
        sqlBuilder.append(") as ct ");
        DataSet realBalanceSet = DB.queryDataSet((String)"InvQueryMobPlugin.queryAndSetDataBySort", (DBRoute)new DBRoute("scm"), (String)sqlBuilder.toString());
        ArrayList<String> renameFields = new ArrayList<String>(10);
        for (Map.Entry<String, String> groupByFieldEntry : groupByFields.entrySet()) {
            String fieldKey = groupByFieldEntry.getKey();
            String fieldName = groupByFieldEntry.getValue();
            if (fieldName.contains("id")) {
                renameFields.add("Cast(" + fieldName + " as Long) as " + fieldKey);
                continue;
            }
            renameFields.add(fieldName + " as " + fieldKey);
        }
        renameFields.add("fbaseqty as baseqty");
        realBalanceSet = realBalanceSet.select(renameFields.toArray(new String[renameFields.size()]));
        ArrayList<String> showFields = new ArrayList<String>(groupByFields.keySet());
        showFields.add("baseqty");
        IDataModel model = this.getModel();
        int rowIndex = startRowIndex;
        if (cardEntry == null) {
            cardEntry = (CardEntry)this.getControl("entryentity");
        }
        HashMap<Integer, Object> rowToInvStatus = new HashMap<Integer, Object>(16);
        while (realBalanceSet.hasNext() && rowIndex <= totalRowCount - 1) {
            Row next = realBalanceSet.next();
            for (String field : showFields) {
                Object value = next.get(field);
                if (value == null || value.equals(0L)) continue;
                if ("invstatus".equals(field)) {
                    rowToInvStatus.put(rowIndex, value);
                }
                model.setValue(field, value, rowIndex);
            }
            model.setValue("seqnumber", (Object)rowIndex, rowIndex);
            ++rowIndex;
        }
        for (Map.Entry rowFieldValue : rowToInvStatus.entrySet()) {
            Integer rowIndexTmp = (Integer)rowFieldValue.getKey();
            Object fieldValue = rowFieldValue.getValue();
            MobileControlUtils.setCardEntryRowProperty(cardEntry, "invstatus", rowIndexTmp, StyleHelper.getInvStatusFrontAndBack(fieldValue));
        }
    }

    private String getGroupBySql(String queryFields, String groupByFields, String qFilter) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(" select ");
        sqlBuilder.append(queryFields);
        sqlBuilder.append(" from t_im_inv_realbalance");
        sqlBuilder.append(" where ");
        sqlBuilder.append(qFilter);
        sqlBuilder.append(" group by ");
        sqlBuilder.append(groupByFields);
        sqlBuilder.append(" having sum(fbaseqty) != 0 ");
        return sqlBuilder.toString();
    }

    public void pagerClick(PagerClickEvent e) {
        int currentPageIndex = e.getCurrentPageIndex();
        int pageRows = e.getPageRows();
        IPageCache pageCache = this.getPageCache();
        String totalRow = pageCache.get("totalrowcount");
        String pageQueryFilter = pageCache.get("pagequeryfilter");
        if (StringUtils.isEmpty((CharSequence)pageQueryFilter)) {
            return;
        }
        int totalRowCount = 0;
        if (StringUtils.isEmpty((CharSequence)totalRow)) {
            totalRowCount = this.getInvQueryDataCount(pageQueryFilter);
            pageCache.put("totalrowcount", String.valueOf(totalRowCount));
        } else {
            totalRowCount = Integer.parseInt(totalRow);
        }
        this.displayFlexPanelGetMore(currentPageIndex);
        this.queryAndSetInvData(null, pageQueryFilter, this.getGroupByMapFields(), currentPageIndex, pageRows, totalRowCount);
    }

    public void beforeClick(BeforeClickEvent e) {
        super.beforeClick(e);
        IFormView view = this.getView();
        boolean checkResult = PermissionHelper.checkInvOrgPermOfUser("im_invaccreport");
        if (!checkResult) {
            view.showErrorNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_USE_INVORG()));
            e.setCancel(true);
        }
    }

    public void click(EventObject e) {
        String key;
        super.click(e);
        Control source = (Control)e.getSource();
        switch (key = source.getKey()) {
            case "entryrowcontent": {
                this.openInvDetailsPage();
                break;
            }
            case "sieve": {
                this.openSieveSchemePage();
                break;
            }
        }
    }

    private void openInvDetailsPage() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        int selectRow = model.getEntryCurrentRowIndex("entryentity");
        DynamicObject material = (DynamicObject)model.getValue("material", selectRow);
        DynamicObject org = (DynamicObject)model.getValue("org", selectRow);
        DynamicObject warehouse = (DynamicObject)model.getValue("warehouse", selectRow);
        String ownerType = (String)model.getValue("ownertype", selectRow);
        DynamicObject owner = (DynamicObject)model.getValue("owner", selectRow);
        DynamicObject invStatus = (DynamicObject)model.getValue("invstatus", selectRow);
        Long materialId = this.getId(material);
        Long orgId = this.getId(org);
        Long warehouseId = this.getId(warehouse);
        Long ownerId = this.getId(owner);
        Long invStatusId = this.getId(invStatus);
        if (materialId.equals(0L) && orgId.equals(0L) && warehouseId.equals(0L) && ownerId.equals(0L) && invStatusId.equals(0L) && StringUtils.isEmpty((CharSequence)ownerType)) {
            return;
        }
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setFormId("mobim_invdetails");
        Map customParams = showParameter.getCustomParams();
        customParams.put("material", materialId);
        customParams.put("org", orgId);
        customParams.put("warehouse", warehouseId);
        customParams.put("ownertype", ownerType);
        customParams.put("owner", ownerId);
        customParams.put("invstatus", invStatusId);
        customParams.put("lotnumber", this.getPageCache().get("lotnumber"));
        customParams.put("baseqtyfrom", this.getPageCache().get("baseqtyfrom"));
        customParams.put("baseqtyto", this.getPageCache().get("baseqtyto"));
        customParams.put("prodatefrom", this.getPageCache().get("prodatefrom"));
        customParams.put("prodateto", this.getPageCache().get("prodateto"));
        customParams.put("expirydatefrom", this.getPageCache().get("expirydatefrom"));
        customParams.put("expirydateto", this.getPageCache().get("expirydateto"));
        customParams.put("someFilter", this.getPageCache().get("someFilter"));
        showParameter.setCustomParams(customParams);
        view.showForm((FormShowParameter)showParameter);
    }

    private void openSieveSchemePage() {
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        String hasScheme = pageCache.get("hasscheme");
        if (Boolean.TRUE.toString().equals(hasScheme)) {
            showParameter.setFormId("mobim_sieveschemes");
        } else {
            Long defInvQueryOrgId = QFilterHelper.getDefInvQueryOrgId(this.getView(), "im_invaccreport");
            showParameter.setCustomParam("orgid", (Object)defInvQueryOrgId);
            showParameter.setCustomParam(OP_TYPE, (Object)OP_FIRSTQUERY);
            showParameter.setFormId("mobim_sievedata");
        }
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "sievecloseback"));
        view.showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        switch (actionId = e.getActionId()) {
            case "sievecloseback": {
                this.doSieveSchemeCB(returnData);
                break;
            }
        }
    }

    private void doSieveSchemeCB(Object returnData) {
        MobileSearch search = (MobileSearch)this.getControl("searchap");
        search.setText("");
        if (returnData == null) {
            return;
        }
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        IPageCache pageCache = this.getPageCache();
        Map filterMap = (Map)returnData;
        String hasScheme = (String)filterMap.get("hasscheme");
        String sieveFilter = (String)filterMap.get("sieveFilter");
        if (StringUtils.isEmpty((CharSequence)sieveFilter)) {
            sieveFilter = QFilterHelper.getDefInvQueryFilter(view, "im_invaccreport", "forgid", "finvstatusid", "finvtypeid").toString();
        }
        int totalRowCount = this.pageQuery(model, view, sieveFilter, 1, true);
        pageCache.put("sievequeryfilter", sieveFilter);
        pageCache.put("pagequeryfilter", sieveFilter);
        pageCache.put("totalrowcount", String.valueOf(totalRowCount));
        pageCache.put("hasscheme", hasScheme);
        pageCache.put("lotnumber", (String)filterMap.get("lotnumber"));
        pageCache.put("baseqtyfrom", (String)filterMap.get("baseqtyfrom"));
        pageCache.put("baseqtyto", (String)filterMap.get("baseqtyto"));
        pageCache.put("prodatefrom", (String)filterMap.get("prodatefrom"));
        pageCache.put("prodateto", (String)filterMap.get("prodateto"));
        pageCache.put("expirydatefrom", (String)filterMap.get("expirydatefrom"));
        pageCache.put("expirydateto", (String)filterMap.get("expirydateto"));
        pageCache.put("someFilter", sieveFilter);
        view.updateView();
    }

    private void setTotalContent(IDataModel model, int totalRowCount) {
        String text = String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u6570\u636e", (String)"InvQueryEditPlugin_1", (String)"scmc-mobim-form", (Object[])new Object[0]), totalRowCount);
        model.setValue("total", (Object)text);
    }

    public void focus() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        MobileSearch search = (MobileSearch)this.getControl("searchap");
        String searchTxt = search.getText();
        this.queryBySearchTxt(view, model, searchTxt);
    }

    public void click(MobileSearchTextChangeEvent e) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String searchTxt = e.getText();
        this.queryBySearchTxt(view, model, searchTxt);
    }

    public void cancel() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        IPageCache pageCache = this.getPageCache();
        String sieveFilter = pageCache.get("sievequeryfilter");
        String sieveQueryFilter = sieveFilter == null ? "" : sieveFilter;
        int totalRowCount = this.pageQuery(model, view, sieveQueryFilter, 1, true);
        pageCache.put("sievequeryfilter", sieveQueryFilter);
        pageCache.put("pagequeryfilter", sieveQueryFilter);
        pageCache.put("totalrowcount", String.valueOf(totalRowCount));
        pageCache.put("searchContent", "");
        view.updateView();
    }

    private void queryBySearchTxt(IFormView view, IDataModel model, String searchTxt) {
        String materialFilter;
        String searchFilter;
        String allSearchFilter = this.getDefaultFilter();
        List<Long> locationIds = this.getBaseDataIdsBySearchTxt(searchTxt, "bd_location");
        List<Long> wareHouseIds = this.getBaseDataIdsBySearchTxt(searchTxt, "bd_warehouse");
        List<Long> materials = this.getMaterialBySearchTxt(searchTxt);
        if (StringUtils.isEmpty((CharSequence)searchTxt) || locationIds.isEmpty() && wareHouseIds.isEmpty() && materials.isEmpty()) {
            allSearchFilter = QFilterHelper.getIdentNotEqFilter().toString();
        }
        if (!StringUtils.isEmpty((CharSequence)(searchFilter = this.getWarehouseAndLocationFilter(materialFilter = this.getMaterialFilter(searchTxt), searchTxt)))) {
            allSearchFilter = allSearchFilter + " and  ( " + searchFilter + " ) ";
        }
        int totalRowCount = this.pageQuery(model, view, allSearchFilter, 1, true);
        IPageCache pageCache = this.getPageCache();
        String sieveQueryFilter = pageCache.get("sievequeryfilter");
        if (sieveQueryFilter != null) {
            pageCache.put("sievequeryfilter", sieveQueryFilter);
        }
        pageCache.put("pagequeryfilter", searchFilter);
        pageCache.put("totalrowcount", String.valueOf(totalRowCount));
        pageCache.put("searchContent", searchTxt);
        view.updateView();
    }

    public String getDefaultFilter() {
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        String allFilter = pageCache.get("sievequeryfilter");
        if (StringUtils.isEmpty((CharSequence)allFilter)) {
            QFilter defInvQueryFilter = QFilterHelper.getDefInvQueryFilter(view, "im_invaccreport", "forgid", "finvstatusid", "finvtypeid");
            allFilter = defInvQueryFilter.toString();
        }
        return allFilter;
    }

    private String getMaterialFilter(String searchTxt) {
        List<Long> materials = this.getMaterialBySearchTxt(searchTxt);
        ArrayList<Long> masterMaterials = new ArrayList<Long>(10);
        if (materials.isEmpty()) {
            return "";
        }
        if (materials.size() < 50) {
            return new QFilter("fmaterialid", "in", materials).toString();
        }
        QFilter masterFilter = QFilterHelper.getIdentNotEqFilter();
        for (Long material : materials) {
            masterMaterials.add(material);
            if (masterMaterials.size() != 50) continue;
            masterFilter = masterFilter.or(new QFilter("fmaterialid", "in", new ArrayList(masterMaterials)));
            masterMaterials.clear();
        }
        if (!masterMaterials.isEmpty()) {
            masterFilter = masterFilter.or(new QFilter("fmaterialid", "in", masterMaterials));
        }
        return masterFilter.toString();
    }

    private String getWarehouseAndLocationFilter(String filter, String searchText) {
        String warehouseAndLocationFilter = filter;
        if (StringUtils.isEmpty((CharSequence)searchText)) {
            return warehouseAndLocationFilter;
        }
        List<Long> locationIds = this.getBaseDataIdsBySearchTxt(searchText, "bd_location");
        warehouseAndLocationFilter = this.combineFilter(locationIds, warehouseAndLocationFilter, "flocationid");
        List<Long> wareHouseIds = this.getBaseDataIdsBySearchTxt(searchText, "bd_warehouse");
        warehouseAndLocationFilter = this.combineFilter(wareHouseIds, warehouseAndLocationFilter, "fwarehouseid");
        if (StringUtils.isEmpty((CharSequence)warehouseAndLocationFilter)) {
            warehouseAndLocationFilter = warehouseAndLocationFilter + QFilterHelper.getIdentNotEqFilter();
            this.getPageCache().remove("searchContent");
        }
        return warehouseAndLocationFilter;
    }

    private String combineFilter(List<Long> baseDataIds, String warehouseAndLocationFilter, String baseDataName) {
        String filter = warehouseAndLocationFilter;
        if (baseDataIds.isEmpty()) {
            return filter;
        }
        if (!StringUtils.isEmpty((CharSequence)filter)) {
            filter = filter + " or ";
        }
        if (baseDataIds.size() < 50) {
            return filter + new QFilter(baseDataName, "in", baseDataIds).toString();
        }
        QFilter masterFilter = QFilterHelper.getIdentNotEqFilter();
        ArrayList<Long> masterLocations = new ArrayList<Long>(10);
        for (Long material : baseDataIds) {
            masterLocations.add(material);
            if (masterLocations.size() != 50) continue;
            masterFilter = masterFilter.or(new QFilter(baseDataName, "in", new ArrayList(masterLocations)));
            masterLocations.clear();
        }
        if (!masterLocations.isEmpty()) {
            masterFilter = masterFilter.or(new QFilter(baseDataName, "in", masterLocations));
        }
        return filter + masterFilter;
    }

    private List<Long> getBaseDataIdsBySearchTxt(String searchTxt, String entityName) {
        ArrayList<Long> locationIds = new ArrayList<Long>(16);
        if (StringUtils.isEmpty((CharSequence)searchTxt)) {
            return locationIds;
        }
        QFilter qFilter = QFilter.ftlike((String)searchTxt, (String[])new String[]{"name"});
        qFilter.setQFilterHint((QFilterHint)QFilterHint.FTLIKE_CONTAINS);
        QFilter[] qFilters = new QFilter[]{qFilter.and(QFilter.isNotNull((String)"name"))};
        DynamicObjectCollection locationSearch = QueryServiceHelper.query((String)entityName, (String)"id,name", (QFilter[])qFilters, (String)"", (int)50000);
        if (null != locationSearch && !locationSearch.isEmpty()) {
            for (DynamicObject search : locationSearch) {
                locationIds.add(search.getLong("id"));
            }
        }
        return locationIds;
    }

    private List<Long> getMaterialBySearchTxt(String searchTxt) {
        ArrayList<Long> materialIds = new ArrayList<Long>(16);
        if (StringUtils.isEmpty((CharSequence)searchTxt)) {
            return materialIds;
        }
        QFilter qfilters = QFilter.ftlike((String)searchTxt, (String[])new String[]{"number", "name", "modelnum"});
        qfilters.setQFilterHint((QFilterHint)QFilterHint.FTLIKE_CONTAINS);
        QFilter[] qFilters = new QFilter[]{qfilters.and(QFilter.isNotNull((String)"name"))};
        DynamicObjectCollection materialSearch = QueryServiceHelper.query((String)"bd_material", (String)"id,name", (QFilter[])qFilters, (String)"", (int)50000);
        if (null != materialSearch && materialSearch.size() != 0) {
            int materialCount = materialSearch.size();
            for (int i = 0; i < materialCount; ++i) {
                materialIds.add(((DynamicObject)materialSearch.get(i)).getLong("id"));
            }
        }
        return materialIds;
    }

    private String getDefOrgFilter() {
        Object[] orgIds = PermissionHelper.getPermissionAndStartedOrgs("im_invaccreport");
        if (orgIds == null || orgIds.length == 0) {
            return "And 1 != 1";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" AND forgid IN(");
        for (Object orgId : orgIds) {
            sb.append(orgId);
            sb.append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(')');
        return sb.toString();
    }
}

