/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.invquery;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.url.UrlService;

public class MaterialAuxEditPlugin
extends AbstractMobFormPlugin {
    private static final String MATERIALNAME = "materialname";
    private static final String MATERIALNUMBER = "materialnumber";
    private static final String MATERIALMODUL = "materialmodul";
    private static final String INVENTRYUNIT = "inventoryunit";
    private static final String ABCTYPE = "abctype";
    private static final String MININVQTY = "mininvqty";
    private static final String MAXINVQTY = "maxinvqty";
    private static final String SAFTYINVQTY = "saftyinvqty";
    private static final String REORDERPOINTQTY = "reorderpointqty";
    private static final String REORDERBATCHQTY = "reorderbatchqty";
    private static final String CONSUMPTION = "consumption";
    private static final String MINPACKQTY = "minpackqty";
    private static final String OUTBOUNDRULES = "outboundrules";
    private static final String LOTCODERULE = "lotcoderule";
    private static final String SHELFLIFE = "shelflife";
    private static final String IMAGEAP = "imageap";
    private static final String PICTUREFIELD = "picturefield";
    private static final String BASEUNITNAME = "baseunitname";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long materialId = (Long)this.getParameter("materialId");
        String materialNumber = (String)this.getParameter("materialNumber");
        Long orgId = (Long)this.getParameter("orgId");
        String orgNumber = (String)this.getParameter("orgNumber");
        if (materialId != null && !materialId.equals(0L) && orgId != null && !orgId.equals(0L)) {
            this.initMaterialDetialInfo(materialId, materialNumber, orgId, orgNumber);
        }
    }

    protected void initMaterialDetialInfo(Long materialId, String materialNumber, Long orgId, String orgNumber) {
        boolean isSetLabelValue;
        DynamicObject invMaterial = this.getMaterialInventory(materialId, materialNumber, orgId, orgNumber);
        IFormView view = this.getView();
        boolean bl = isSetLabelValue = view != null;
        if (isSetLabelValue) {
            Image materialImage = (Image)this.getControl(IMAGEAP);
            if (materialId != null && !materialId.equals(0L)) {
                materialImage.setUrl(this.queryMaterial("id", materialId));
            } else {
                materialImage.setUrl(null);
            }
        }
        if (invMaterial != null) {
            IDataEntityProperty shelfLifeProprty;
            Object shelfLife;
            DynamicObject outBoundRule;
            DynamicObject material = invMaterial.getDynamicObject("masterid");
            if (isSetLabelValue) {
                MaterialAuxEditPlugin.labelSetValue((Label)view.getControl(MATERIALNAME), material.getString("name"));
                MaterialAuxEditPlugin.labelSetValue((Label)view.getControl(MATERIALNUMBER), String.format(ResManager.loadKDString((String)"\u7f16\u7801\uff1a%1$s", (String)"MaterialAuxEditPlugin_0", (String)"scmc-mobim-form", (Object[])new Object[0]), material.get("number")));
                MaterialAuxEditPlugin.labelSetValue((Label)view.getControl(MATERIALMODUL), String.format(ResManager.loadKDString((String)"\u89c4\u683c\u578b\u53f7\uff1a%1$s", (String)"MaterialAuxEditPlugin_1", (String)"scmc-mobim-form", (Object[])new Object[0]), material.get("modelnum")));
            }
            this.setValue("baseunit", material.getDynamicObject("baseunit"));
            this.setValue(INVENTRYUNIT, invMaterial.getDynamicObject(INVENTRYUNIT));
            if (invMaterial.get(ABCTYPE) != null) {
                IDataEntityProperty abcTypeProperty = (IDataEntityProperty)invMaterial.getDataEntityType().getProperties().get((Object)ABCTYPE);
                Object abcType = this.DownValueConversionKey(abcTypeProperty, invMaterial.get(ABCTYPE));
                this.setValue(ABCTYPE, abcType);
            }
            this.setValue(MININVQTY, invMaterial.getBigDecimal(MININVQTY));
            this.setValue(MAXINVQTY, invMaterial.getBigDecimal(MAXINVQTY));
            this.setValue(SAFTYINVQTY, invMaterial.getBigDecimal(SAFTYINVQTY));
            this.setValue(REORDERPOINTQTY, invMaterial.getBigDecimal(REORDERPOINTQTY));
            this.setValue(REORDERBATCHQTY, invMaterial.getBigDecimal(REORDERBATCHQTY));
            this.setValue(CONSUMPTION, invMaterial.getBigDecimal(CONSUMPTION));
            BigDecimal minPackQtyTmp = invMaterial.getBigDecimal(MINPACKQTY);
            if (minPackQtyTmp != null && minPackQtyTmp.compareTo(BigDecimal.ZERO) != 0) {
                String minPackQtyStr = minPackQtyTmp.stripTrailingZeros().toPlainString();
                BigDecimal bigDecimal = new BigDecimal(minPackQtyStr);
                int scale = bigDecimal.scale();
                StringBuilder decimalFormatStr = new StringBuilder();
                decimalFormatStr.append(",###");
                if (scale > 0) {
                    decimalFormatStr.append('.');
                }
                for (int i = 0; i < scale; ++i) {
                    decimalFormatStr.append('#');
                }
                DecimalFormat decimalFt = new DecimalFormat(decimalFormatStr.toString());
                String unitName = material.getDynamicObject("baseunit").get("name").toString();
                Label minPackQtyLabel = (Label)this.getControl(MINPACKQTY);
                Label baseUnitNameL = (Label)this.getControl(BASEUNITNAME);
                String minPackQty = decimalFt.format(bigDecimal);
                if (!"0".equals(minPackQty)) {
                    minPackQtyLabel.setText(minPackQty);
                    baseUnitNameL.setText(unitName);
                }
            }
            if (invMaterial.get(OUTBOUNDRULES) != null) {
                IDataEntityProperty outBoundRulesProprty = (IDataEntityProperty)invMaterial.getDataEntityType().getProperties().get((Object)OUTBOUNDRULES);
                Object outBoundRules = this.DownValueConversionKey(outBoundRulesProprty, invMaterial.get(OUTBOUNDRULES));
                this.setValue(OUTBOUNDRULES, outBoundRules);
            }
            if ((outBoundRule = invMaterial.getDynamicObject("outboundrule")) != null) {
                String name = outBoundRule.getString("name");
                this.setValue(OUTBOUNDRULES, name);
            }
            if (invMaterial.getDynamicObject(LOTCODERULE) != null) {
                this.setValue(LOTCODERULE, invMaterial.getDynamicObject(LOTCODERULE).get("name"));
            }
            if ((shelfLife = this.DownValueConversionKey(shelfLifeProprty = (IDataEntityProperty)invMaterial.getDataEntityType().getProperties().get((Object)"shelflifeunit"), invMaterial.get("shelflifeunit"))) != null && !"".equals(shelfLife)) {
                this.setValue(SHELFLIFE, invMaterial.get(SHELFLIFE).toString() + shelfLife);
            }
        }
    }

    protected DynamicObject getMaterialInventory(Long materialId, String materialNumber, Long orgId, String orgNumber) {
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)orgId);
        QFilter masterFilter = new QFilter("masterid", "=", (Object)materialId);
        baseDataFilter.and(masterFilter);
        Map invMaterial = BusinessDataServiceHelper.loadFromCache((String)"bd_materialinventoryinfo", (QFilter[])baseDataFilter.toArray());
        if (invMaterial == null || invMaterial.size() == 0) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u901a\u8fc7\u7f16\u7801\u4e3a\u3010%1$s\u3011\u7684\u7269\u6599\u548c\u7f16\u7801\u4e3a\u3010%2$s\u3011\u7684\u5e93\u5b58\u7ec4\u7ec7\u5339\u914d\u5230\u7684\u5e93\u5b58\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MaterialAuxEditPlugin_2", (String)"scmc-mobim-form", (Object[])new Object[0]), materialNumber, orgNumber);
            throw new KDBizException(errMsg);
        }
        ArrayList invMaterials = new ArrayList(invMaterial.values());
        return (DynamicObject)invMaterials.get(0);
    }

    private Object DownValueConversionKey(IDataEntityProperty data, Object value) {
        String result = "";
        String name = "";
        ComboProp comboProp = (ComboProp)data;
        List comboItems = comboProp.getComboItems();
        for (ValueMapItem comboItem : comboItems) {
            result = comboItem.getValue();
            if (!result.equals(value)) continue;
            name = comboItem.getName();
            break;
        }
        return name;
    }

    protected Object getParameter(Object value) {
        FormShowParameter parame = this.getView().getFormShowParameter();
        Map customParams = parame.getCustomParams();
        Object paramValue = customParams.get(value);
        if (paramValue instanceof Integer) {
            return Long.valueOf(paramValue.toString());
        }
        return customParams.get(value);
    }

    private String queryMaterial(String property, Object value) {
        QFilter[] qFilters = new QFilter[]{new QFilter(property, "=", value)};
        DynamicObject materialPicturefie = QueryServiceHelper.queryOne((String)"bd_material", (String)PICTUREFIELD, (QFilter[])qFilters);
        if (null != materialPicturefie) {
            String pictureName = "";
            Object picture = materialPicturefie.get(PICTUREFIELD);
            if (picture != null && !"".equals(pictureName = picture.toString())) {
                return UrlService.getImageFullUrl((String)"") + pictureName;
            }
            return null;
        }
        return null;
    }

    protected void setValue(String key, Object value) {
        IDataModel model = this.getModel();
        if (model != null) {
            model.setValue(key, value);
        }
    }

    public static void labelSetValue(Label control, Object value) {
        String text = "";
        if (value instanceof BigDecimal) {
            text = ((BigDecimal)value).stripTrailingZeros().toPlainString();
        } else if (value != null) {
            text = value.toString();
        }
        control.setText(text);
    }
}

