/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.invquery;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.mobim.business.helper.BeforeSelectF7Helper;
import kd.scmc.mobim.business.helper.DefaultValueSetHelper;
import kd.scmc.mobim.business.helper.PermissionHelper;
import kd.scmc.mobim.business.helper.PropChangedHelper;
import kd.scmc.mobim.business.helper.SieveFilterHelper;
import kd.scmc.mobim.business.helper.SieveOpHelper;
import kd.scmc.mobim.common.design.strategy.IDataTypeStrategy;
import kd.scmc.mobim.common.enums.DataTypeHandle;
import kd.scmc.mobim.common.utils.FormUtils;
import org.apache.commons.lang3.StringUtils;

public class SieveDataMFormPlugin
extends AbstractMobFormPlugin
implements BeforeF7SelectListener {
    private static final Log LOG = LogFactory.getLog(AbstractMobFormPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener(this, "org", "accountowner", "warehouse", "location");
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        this.handlePreOpenForm(e, "im_invaccreport");
    }

    private void handlePreOpenForm(PreOpenFormEventArgs e, String formid) {
        MobileFormShowParameter showParameter = (MobileFormShowParameter)e.getSource();
        PermissionHelper.doBillPermission(showParameter, formid);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initData();
    }

    private void initData() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        FormShowParameter showParameter = view.getFormShowParameter();
        String opType = (String)showParameter.getCustomParam("opType");
        IPageCache pageCache = this.getPageCache();
        if ("firstquery".equals(opType) || "add".equals(opType)) {
            this.initDefaultData(model);
        } else if ("update".equals(opType)) {
            Long sieveId = (Long)showParameter.getCustomParam("sieveid");
            String sieveName = (String)showParameter.getCustomParam("schemename");
            model.setValue("schemename", (Object)sieveName);
            Map customParams = showParameter.getCustomParams();
            for (Map.Entry cusParam : customParams.entrySet()) {
                Object params = cusParam.getValue();
                if (!(params instanceof Map)) continue;
                String fieldKey = (String)cusParam.getKey();
                Map paramMap = (Map)params;
                String dataType = (String)paramMap.get("datatype");
                String fieldValue = (String)paramMap.get("value");
                if (StringUtils.isEmpty((CharSequence)fieldValue)) continue;
                for (DataTypeHandle dateTypeHandle : DataTypeHandle.values()) {
                    IDataTypeStrategy strategy = dateTypeHandle.getDataTypeStrategy(dataType);
                    if (strategy == null) continue;
                    strategy.setValue(model, fieldKey, fieldValue);
                }
            }
            pageCache.put("sieveid", String.valueOf(sieveId));
        }
        this.setEnableUI(model, view, opType);
        this.setVisibleUI(model, view, opType);
        pageCache.put("opType", opType);
    }

    private void initDefaultData(IDataModel model) {
        DefaultValueSetHelper.setDefaultPermissionOrg(this.getView(), "org");
        DefaultValueSetHelper.setDefaultInvStatus(model, "invstatus");
        DefaultValueSetHelper.setDefaultInvType(model, "invtype");
    }

    private void setEnableUI(IDataModel model, IFormView view, String opType) {
        this.setOwnerEnable(model, view);
        this.setKeeperEnable(model, view);
    }

    private void setKeeperEnable(IDataModel model, IFormView view) {
        String keeperType = (String)model.getValue("keepertype");
        if (StringUtils.isEmpty((CharSequence)keeperType)) {
            view.setEnable(Boolean.FALSE, new String[]{"invorgkeeper", "supplierkeeper", "customerkeeper"});
        } else {
            view.setEnable(Boolean.TRUE, new String[]{"invorgkeeper", "supplierkeeper", "customerkeeper"});
        }
    }

    private void setOwnerEnable(IDataModel model, IFormView view) {
        String ownerType = (String)model.getValue("ownertype");
        if (StringUtils.isEmpty((CharSequence)ownerType)) {
            view.setEnable(Boolean.FALSE, new String[]{"accountowner", "supplierowner", "customerowner"});
        } else {
            view.setEnable(Boolean.TRUE, new String[]{"accountowner", "supplierowner", "customerowner"});
        }
    }

    private void setVisibleUI(IDataModel model, IFormView view, String opType) {
        String ownerType = (String)model.getValue("ownertype");
        String keeperType = (String)model.getValue("keepertype");
        this.setOwnerVisible(model, view, ownerType);
        this.setKeeperVisible(model, view, keeperType);
        this.setControlVisible(view, opType);
    }

    private void setControlVisible(IFormView view, String opType) {
        if ("firstquery".equals(opType)) {
            view.setVisible(Boolean.FALSE, new String[]{"saveflex"});
            view.setVisible(Boolean.FALSE, new String[]{"editflex"});
            view.setVisible(Boolean.TRUE, new String[]{"saveandqueryflex"});
        } else if ("add".equals(opType)) {
            view.setVisible(Boolean.TRUE, new String[]{"saveflex"});
            view.setVisible(Boolean.FALSE, new String[]{"editflex"});
            view.setVisible(Boolean.FALSE, new String[]{"saveandqueryflex"});
        } else if ("update".equals(opType)) {
            view.setVisible(Boolean.FALSE, new String[]{"saveflex"});
            view.setVisible(Boolean.TRUE, new String[]{"editflex"});
            view.setVisible(Boolean.FALSE, new String[]{"saveandqueryflex"});
        }
    }

    private void setOwnerVisible(IDataModel model, IFormView view, String ownerType) {
        if (StringUtils.isEmpty((CharSequence)ownerType)) {
            view.setVisible(Boolean.TRUE, new String[]{"accountowner"});
            view.setVisible(Boolean.FALSE, new String[]{"supplierowner", "customerowner"});
            return;
        }
        if ("bos_org".equals(ownerType)) {
            view.setVisible(Boolean.TRUE, new String[]{"accountowner"});
            view.setVisible(Boolean.FALSE, new String[]{"supplierowner", "customerowner"});
        } else if ("bd_supplier".equals(ownerType)) {
            view.setVisible(Boolean.TRUE, new String[]{"supplierowner"});
            view.setVisible(Boolean.FALSE, new String[]{"accountowner", "customerowner"});
        } else if ("bd_customer".equals(ownerType)) {
            view.setVisible(Boolean.TRUE, new String[]{"customerowner"});
            view.setVisible(Boolean.FALSE, new String[]{"accountowner", "supplierowner"});
        }
    }

    private void setKeeperVisible(IDataModel model, IFormView view, String keeperType) {
        if (StringUtils.isEmpty((CharSequence)keeperType)) {
            view.setVisible(Boolean.TRUE, new String[]{"invorgkeeper"});
            view.setVisible(Boolean.FALSE, new String[]{"supplierkeeper", "customerkeeper"});
            return;
        }
        if ("bos_org".equals(keeperType)) {
            view.setVisible(Boolean.TRUE, new String[]{"invorgkeeper"});
            view.setVisible(Boolean.FALSE, new String[]{"supplierkeeper", "customerkeeper"});
        } else if ("bd_supplier".equals(keeperType)) {
            view.setVisible(Boolean.TRUE, new String[]{"supplierkeeper"});
            view.setVisible(Boolean.FALSE, new String[]{"invorgkeeper", "customerkeeper"});
        } else if ("bd_customer".equals(keeperType)) {
            view.setVisible(Boolean.TRUE, new String[]{"customerkeeper"});
            view.setVisible(Boolean.FALSE, new String[]{"invorgkeeper", "supplierkeeper"});
        }
    }

    private void setNullValue(IDataModel model, String fieldKey) {
        if ("ownertype".equals(fieldKey)) {
            model.setValue("accountowner", null);
            model.setValue("supplierowner", null);
            model.setValue("customerowner", null);
        } else if ("keepertype".equals(fieldKey)) {
            model.setValue("invorgkeeper", null);
            model.setValue("supplierkeeper", null);
            model.setValue("customerkeeper", null);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        IFormView view = this.getView();
        switch (key) {
            case "org": {
                BeforeSelectF7Helper.beforeF7SelectOrg(showParameter, view);
                break;
            }
            case "accountowner": {
                BeforeSelectF7Helper.beforeF7AccountOwner(showParameter, "org", true, view);
                break;
            }
            case "warehouse": {
                BeforeSelectF7Helper.beforeF7Warehouse(showParameter, "org", true, view);
                break;
            }
            case "location": {
                BeforeSelectF7Helper.beforeF7Location(showParameter, "org", true, view);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String proKey = e.getProperty().getName();
        ChangeData changeSet = e.getChangeSet()[0];
        Object newValue = changeSet.getNewValue();
        Object oldValue = changeSet.getOldValue();
        switch (proKey) {
            case "org": {
                this.invOrgChanged(newValue, oldValue);
                break;
            }
            case "warehouse": {
                this.warehouseChanged(newValue, oldValue);
                break;
            }
            case "ownertype": {
                this.ownerTypeChanged(model, view, proKey);
                break;
            }
            case "keepertype": {
                this.keeperTypeChanged(model, view, proKey);
                break;
            }
        }
        this.setNullValue(model, proKey);
    }

    private void keeperTypeChanged(IDataModel model, IFormView view, String proKey) {
        String keeperType = (String)model.getValue(proKey);
        this.setKeeperEnable(model, view);
        this.setKeeperVisible(model, view, keeperType);
    }

    private void ownerTypeChanged(IDataModel model, IFormView view, String proKey) {
        String ownerType = (String)model.getValue(proKey);
        this.setOwnerEnable(model, view);
        this.setOwnerVisible(model, view, ownerType);
    }

    private void warehouseChanged(Object newValue, Object oldValue) {
        boolean isChanged = PropChangedHelper.isItemF7Changed(newValue, oldValue);
        if (!isChanged) {
            return;
        }
        DataChangeHelper.setValue((IDataModel)this.getModel(), (String)"location", null, (boolean)false);
    }

    private void invOrgChanged(Object newValue, Object oldValue) {
        boolean isChanged = PropChangedHelper.isItemF7Changed(newValue, oldValue);
        if (!isChanged) {
            return;
        }
        DataChangeHelper.setValue((IDataModel)this.getModel(), (String)"warehouse", null, (boolean)false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        switch (operateKey = FormUtils.getOpKey(e)) {
            case "save": {
                this.checkSchemeData(view, model, e);
                break;
            }
        }
    }

    private void checkSchemeData(IFormView view, IDataModel model, BeforeDoOperationEventArgs e) {
        boolean isExists;
        String schemeName = (String)model.getValue("schemename");
        if (StringUtils.isBlank((CharSequence)schemeName)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u65b9\u6848\u540d\u79f0\u3002", (String)"SieveDataMFormPlugin_2", (String)"scmc-mobim-form", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        Long currUserId = UserServiceHelper.getCurrentUserId();
        QFilter qFilter = new QFilter("creator", "=", (Object)currUserId);
        qFilter.and("name", "=", (Object)schemeName);
        String sieveId = this.getPageCache().get("sieveid");
        if (sieveId != null) {
            qFilter.and("id", "!=", (Object)Long.parseLong(sieveId));
        }
        if (isExists = QueryServiceHelper.exists((String)"mobim_sieveschemestore", (QFilter[])qFilter.toArray())) {
            view.showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"SieveDataMFormPlugin_3", (String)"scmc-mobim-form", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        OperationResult operationResult = e.getOperationResult();
        String operateKey = e.getOperateKey();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        switch (operateKey) {
            case "save": {
                if (operationResult == null || !operationResult.isSuccess()) break;
                this.doSaveOp(view, model);
                break;
            }
            case "delete": {
                this.doDeleteScheme(view);
                break;
            }
            case "query": {
                this.doQueryOp(view, model);
                break;
            }
        }
    }

    private void doDeleteScheme(IFormView view) {
        IPageCache pageCache = this.getPageCache();
        String sieveId = pageCache.get("sieveid");
        if (StringUtils.isEmpty((CharSequence)sieveId)) {
            return;
        }
        SieveOpHelper.deleteScheme(Long.valueOf(sieveId));
        HashMap<String, String> filterMap = new HashMap<String, String>(16);
        filterMap.put("opType", "delete");
        view.returnDataToParent(filterMap);
        view.close();
    }

    private void doSaveOp(IFormView view, IDataModel model) {
        IPageCache pageCache = this.getPageCache();
        String opType = pageCache.get("opType");
        Long currUserId = UserServiceHelper.getCurrentUserId();
        QFilter isSelectFilter = new QFilter("creator", "=", (Object)currUserId);
        if ("update".equals(opType)) {
            this.updSieveScheme(view, model, pageCache, opType, isSelectFilter);
        } else if ("add".equals(opType)) {
            this.addSieveScheme(view, model, opType, isSelectFilter);
        } else if ("firstquery".equals(opType)) {
            SieveOpHelper.saveFilterScheme(model, this.getPageCache());
            this.returnDataToParent(view, model, opType, Boolean.TRUE);
        }
        view.close();
    }

    private void addSieveScheme(IFormView view, IDataModel model, String opType, QFilter isSelectFilter) {
        isSelectFilter.and("isselected", "=", (Object)Boolean.TRUE);
        DynamicObject sieveScheme = BusinessDataServiceHelper.loadSingle((String)"mobim_sieveschemestore", (String)"id,isselected", (QFilter[])isSelectFilter.toArray());
        if (sieveScheme != null) {
            sieveScheme.set("isselected", (Object)Boolean.FALSE);
            SieveOpHelper.updSchemeData(Collections.singletonList(sieveScheme));
        }
        SieveOpHelper.saveFilterScheme(model, this.getPageCache());
        this.returnDataToParent(view, model, opType, Boolean.TRUE);
    }

    private void updSieveScheme(IFormView view, IDataModel model, IPageCache pageCache, String opType, QFilter isSelectFilter) {
        ArrayList<DynamicObject> updSieveSchemes = new ArrayList<DynamicObject>(10);
        String sieveId = pageCache.get("sieveid");
        Long id = Long.valueOf(sieveId);
        DynamicObject sieveScheme = SieveOpHelper.getUpdSchemeDyObj(model, id);
        boolean isSelected = sieveScheme.getBoolean("isselected");
        if (!isSelected) {
            isSelectFilter.and("isselected", "=", (Object)Boolean.TRUE);
            DynamicObject isSelSieveScheme = BusinessDataServiceHelper.loadSingle((String)"mobim_sieveschemestore", (String)SieveOpHelper.getAllFields(), (QFilter[])isSelectFilter.toArray());
            if (isSelSieveScheme != null) {
                isSelSieveScheme.set("isselected", (Object)Boolean.FALSE);
                updSieveSchemes.add(isSelSieveScheme);
            }
            sieveScheme.set("isselected", (Object)Boolean.TRUE);
        }
        updSieveSchemes.add(sieveScheme);
        int updSize = updSieveSchemes.size();
        SieveOpHelper.updSchemeData(updSieveSchemes.toArray(new DynamicObject[updSize]));
        this.returnDataToParent(view, model, opType, Boolean.TRUE);
    }

    private void doQueryOp(IFormView view, IDataModel model) {
        String opType = this.getPageCache().get("opType");
        this.returnDataToParent(view, model, opType, Boolean.FALSE);
        view.close();
    }

    private void returnDataToParent(IFormView view, IDataModel model, String opType, Boolean hasScheme) {
        HashMap<String, String> filterMap = new HashMap<String, String>(16);
        String qFilter = SieveFilterHelper.buildQFilter(model);
        filterMap.put("sieveFilter", qFilter);
        filterMap.put("hasscheme", hasScheme.toString());
        filterMap.put("opType", opType);
        filterMap.put("lotnumber", (String)model.getValue("lotnumber"));
        if (model.getValue("baseqtyfrom") != null) {
            filterMap.put("baseqtyfrom", model.getValue("baseqtyfrom").toString());
        }
        if (model.getValue("baseqtyto") != null) {
            filterMap.put("baseqtyto", model.getValue("baseqtyto").toString());
        }
        if (model.getValue("prodatefrom") != null) {
            filterMap.put("prodatefrom", model.getValue("prodatefrom").toString());
        }
        if (model.getValue("prodateto") != null) {
            filterMap.put("prodateto", model.getValue("prodateto").toString());
        }
        if (model.getValue("expirydatefrom") != null) {
            filterMap.put("expirydatefrom", model.getValue("expirydatefrom").toString());
        }
        if (model.getValue("expirydateto") != null) {
            filterMap.put("expirydateto", model.getValue("expirydateto").toString());
        }
        view.returnDataToParent(filterMap);
    }
}

