/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.invquery;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PagerClickEvent;
import kd.bos.form.events.PagerClickListener;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.mobim.business.helper.SieveFilterHelper;
import kd.scmc.mobim.business.helper.SieveOpHelper;

public class SieveSchemeMFormPlugin
extends AbstractMobFormPlugin
implements PagerClickListener,
RowClickEventListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry entry = (CardEntry)this.getControl("entryentity");
        entry.addPagerClickListener((PagerClickListener)this);
        entry.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initSieveScheme();
    }

    private void initSieveScheme() {
        Long currUserId;
        QFilter qFilter;
        Map sieveSchemes;
        int totalRowCount;
        IDataModel model = this.getModel();
        IPageCache pageCache = this.getPageCache();
        int currEntryRowCount = model.getEntryRowCount("entryentity");
        if (currEntryRowCount > 0) {
            model.deleteEntryData("entryentity");
        }
        if ((totalRowCount = (sieveSchemes = BusinessDataServiceHelper.loadFromCache((String)"mobim_sieveschemestore", (String)"id", (QFilter[])(qFilter = new QFilter("creator", "=", (Object)(currUserId = Long.valueOf(UserServiceHelper.getCurrentUserId())))).toArray())).size()) == 0) {
            return;
        }
        if (totalRowCount > 1000) {
            totalRowCount = 1000;
        }
        model.batchCreateNewEntryRow("entryentity", totalRowCount);
        this.queryAndSetInvData(model, qFilter, 1, 20, totalRowCount);
        pageCache.put("totalrowcount", String.valueOf(totalRowCount));
    }

    public void queryAndSetInvData(IDataModel model, QFilter qFilter, int currPageNum, int pageSize, int totalRowCount) {
        DynamicObject[] sieveSchemes = BusinessDataServiceHelper.load((String)"mobim_sieveschemestore", (String)"id", (QFilter[])qFilter.toArray(), (String)"isselected desc,modifytime desc", (int)(currPageNum - 1), (int)pageSize);
        int startRowIndex = pageSize * (currPageNum - 1);
        for (DynamicObject sieveScheme : sieveSchemes) {
            if (startRowIndex > totalRowCount - 1) break;
            Long id = sieveScheme.getLong("id");
            if (id == null || id.equals(0L)) continue;
            model.setValue("sievescheme", (Object)id, startRowIndex);
            ++startRowIndex;
        }
    }

    public void pagerClick(PagerClickEvent e) {
        IPageCache pageCache = this.getPageCache();
        int currentPageIndex = e.getCurrentPageIndex();
        int pageRows = e.getPageRows();
        Long currUserId = UserServiceHelper.getCurrentUserId();
        QFilter qFilter = new QFilter("creator", "=", (Object)currUserId);
        String totalRow = pageCache.get("totalrowcount");
        int totalRowCount = Integer.parseInt(totalRow);
        this.queryAndSetInvData(this.getModel(), qFilter, currentPageIndex, pageRows, totalRowCount);
    }

    public void entryRowClick(RowClickEvent e) {
        int updSize;
        IFormView view = this.getView();
        int rowIndex = e.getRow();
        HashMap<String, String> filterMap = new HashMap<String, String>();
        DynamicObject sieveSchemeObj = (DynamicObject)this.getModel().getValue("sievescheme", rowIndex);
        Long sieveId = sieveSchemeObj.getLong("id");
        ArrayList<DynamicObject> updSieveSchemes = new ArrayList<DynamicObject>(10);
        QFilter idFilter = new QFilter("id", "=", (Object)sieveId);
        String allFields = SieveOpHelper.getAllFields();
        DynamicObject sieveScheme = BusinessDataServiceHelper.loadSingle((String)"mobim_sieveschemestore", (String)allFields, (QFilter[])idFilter.toArray());
        boolean isSelected = sieveScheme.getBoolean("isselected");
        if (!isSelected) {
            Long currUserId = UserServiceHelper.getCurrentUserId();
            QFilter isSelectFilter = new QFilter("creator", "=", (Object)currUserId);
            isSelectFilter.and("isselected", "=", (Object)Boolean.TRUE);
            DynamicObject isSelSieveScheme = BusinessDataServiceHelper.loadSingle((String)"mobim_sieveschemestore", (String)allFields, (QFilter[])isSelectFilter.toArray());
            if (isSelSieveScheme != null) {
                isSelSieveScheme.set("isselected", (Object)Boolean.FALSE);
                updSieveSchemes.add(isSelSieveScheme);
            }
            sieveScheme.set("isselected", (Object)Boolean.TRUE);
            sieveScheme.set("modifytime", (Object)new Date());
            updSieveSchemes.add(sieveScheme);
        }
        if ((updSize = updSieveSchemes.size()) > 0) {
            SieveOpHelper.updSchemeData(updSieveSchemes.toArray(new DynamicObject[updSize]));
        }
        String mainFilter = SieveFilterHelper.buildQFilter(sieveScheme);
        filterMap.put("sieveFilter", mainFilter);
        filterMap.put("hasscheme", Boolean.TRUE.toString());
        view.returnDataToParent(filterMap);
        view.close();
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        switch (operateKey = e.getOperateKey()) {
            case "new": {
                this.openAddSieveCditPage();
                break;
            }
            case "modify": {
                this.openUpdSieveCditPage();
                break;
            }
        }
    }

    private void openAddSieveCditPage() {
        IFormView view = this.getView();
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setCustomParam("opType", (Object)"add");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addsievecditcb"));
        showParameter.setFormId("mobim_sievedata");
        view.showForm((FormShowParameter)showParameter);
    }

    private void openUpdSieveCditPage() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        MobileFormShowParameter showParameter = this.getFormShowParameter(model, "update");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "updsievecditcb"));
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setFormId("mobim_sievedata");
        view.showForm((FormShowParameter)showParameter);
    }

    private MobileFormShowParameter getFormShowParameter(IDataModel model, String opType) {
        int currRowIndex = model.getEntryCurrentRowIndex("entryentity");
        HashMap<String, Object> cusParams = new HashMap<String, Object>(16);
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        DynamicObject sieveObj = (DynamicObject)model.getValue("sievescheme", currRowIndex);
        long sieveId = sieveObj.getLong("id");
        String schemeName = sieveObj.getString("name");
        cusParams.put("opType", opType);
        cusParams.put("sieveid", sieveId);
        cusParams.put("schemename", schemeName);
        QFilter idFilter = new QFilter("id", "=", (Object)sieveId);
        DynamicObject sieveSchemeObj = BusinessDataServiceHelper.loadSingleFromCache((String)"mobim_sieveschemestore", (QFilter[])idFilter.toArray());
        DynamicObjectCollection entryObjs = sieveSchemeObj.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryObj : entryObjs) {
            HashMap<String, String> sieveDataMap = new HashMap<String, String>(16);
            String fieldKey = entryObj.getString("sievefieldkey");
            String fieldType = entryObj.getString("sievefieldtype");
            String fieldValue = entryObj.getString("sievefieldvalue_tag");
            sieveDataMap.put("datatype", fieldType);
            sieveDataMap.put("value", fieldValue);
            cusParams.put(fieldKey, sieveDataMap);
        }
        showParameter.setCustomParams(cusParams);
        return showParameter;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        IFormView view = this.getView();
        String actionId = e.getActionId();
        Map returnData = (Map)e.getReturnData();
        String opType = (String)returnData.get("opType");
        switch (actionId) {
            case "updsievecditcb": {
                if ("delete".equals(opType)) {
                    this.deleteSieveScheme(view);
                    break;
                }
                if (!"update".equals(opType)) break;
                this.saveCloseCallback(returnData, view);
                break;
            }
            case "addsievecditcb": {
                this.saveCloseCallback(returnData, view);
                break;
            }
        }
    }

    private void deleteSieveScheme(IFormView view) {
        Long currUserId = UserServiceHelper.getCurrentUserId();
        QFilter qFilter = new QFilter("creator", "=", (Object)currUserId);
        boolean isExists = QueryServiceHelper.exists((String)"mobim_sieveschemestore", (QFilter[])qFilter.toArray());
        if (!isExists) {
            HashMap<String, String> filterMap = new HashMap<String, String>(16);
            filterMap.put("hasscheme", Boolean.FALSE.toString());
            view.returnDataToParent(filterMap);
            view.close();
            return;
        }
        this.getView().invokeOperation("refresh");
    }

    private void saveCloseCallback(Map<String, String> returnData, IFormView view) {
        HashMap<String, String> filterMap = new HashMap<String, String>(16);
        String qFilter = returnData.get("sieveFilter");
        filterMap.put("sieveFilter", qFilter);
        filterMap.put("hasscheme", returnData.get("hasscheme"));
        filterMap.put("lotnumber", returnData.get("lotnumber"));
        filterMap.put("baseqtyfrom", returnData.get("baseqtyfrom"));
        filterMap.put("baseqtyto", returnData.get("baseqtyto"));
        filterMap.put("prodatefrom", returnData.get("prodatefrom"));
        filterMap.put("prodateto", returnData.get("prodateto"));
        filterMap.put("expirydatefrom", returnData.get("expirydatefrom"));
        filterMap.put("expirydateto", returnData.get("expirydateto"));
        view.returnDataToParent(filterMap);
        view.close();
    }
}

