/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.locationtransfer;

import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bd.sbd.enums.EnableStatusEnum;
import kd.bd.sbd.enums.OperatorGrpTypeEnum;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.im.business.helper.BizTypeHelper;
import kd.scmc.im.business.helper.CurrencyHelper;
import kd.scmc.im.business.helper.WareHouseIsolateHelper;
import kd.scmc.mobim.business.helper.InQueryHelper;
import kd.scmc.mobim.business.helper.MobImBillScanHelper;
import kd.scmc.mobim.business.helper.MobInvQueryHelper;
import kd.scmc.mobim.business.helper.QFilterHelper;
import kd.scmc.mobim.business.helper.scan.ImBarCodeHandleHelper;
import kd.scmc.mobim.plugin.form.handler.locationbill.LocationBillChangeHandler;
import kd.scmc.mobim.plugin.form.handler.locationbill.LocationBillNewEntryHandler;
import kd.scmc.mobim.plugin.form.locationtransfer.ILocationTransBillPagePlugin;
import kd.scmc.mobim.plugin.tpl.imtpl.handler.ImBillEntryBillPropertyChangedHandler;
import kd.scmc.msmob.business.helper.DataSourceConfigHelper;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import kd.scmc.msmob.business.helper.change.DataSourceHelper;
import kd.scmc.msmob.business.helper.change.IMobilePage;
import kd.scmc.msmob.common.consts.SCMCBaseBillMobConst;
import kd.scmc.msmob.common.enums.BillStatusEnum;
import kd.scmc.msmob.common.utils.FormUtils;
import kd.scmc.msmob.plugin.tpl.basetpl.IMobBillEditable;
import kd.scmc.msmob.plugin.tpl.basetpl.MobBizBillInfoTplPlugin;
import kd.scmc.msmob.plugin.tpl.basetpl.MobPushTargetBillInfoPlugin;
import kd.scmc.msmob.pojo.DataSourceConfig;

public class LocationTransEditPlugin
extends MobPushTargetBillInfoPlugin
implements ILocationTransBillPagePlugin,
IMobBillEditable,
BeforeF7SelectListener {
    private static final String IS_DEFAULT = "isdefault";
    private static final String BOOK_DATE = "bookdate";
    private static final String BILL_FORM_ID = "billformid";
    private static final String BD_OPERATOR_GROUP = "bd_operatorgroup";
    public static final String OUT_LOCATION = "outlocation";
    private static final String BIZTYPE = "biztype";
    private static final String[] F7_FIELD_KEYS = new String[]{"biztype"};

    public LocationTransEditPlugin() {
        this.registerPropertyChangedHandler(new LocationBillChangeHandler());
        this.registerEntryRowAddedHandler(new LocationBillNewEntryHandler());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener((AbstractFormPlugin)this, (String[])F7_FIELD_KEYS);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (EntityCacheHelper.isNew((Long)this.getBillId())) {
            String billTitle = ResManager.loadKDString((String)"\u65b0\u589e\u4ed3\u4f4d\u79fb\u52a8\u3002", (String)"LocationTransEditPlugin_1", (String)"scmc-mobim-form", (Object[])new Object[0]);
            this.getView().executeClientCommand("setCaption", new Object[]{billTitle});
        }
        this.handleSkill();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        this.registerPropertyChangedHandler(new ImBillEntryBillPropertyChangedHandler(this.getView(), this.getPcEntityKey()));
        super.propertyChanged(e);
    }

    public String getEditFormId() {
        return this.getBillEditFormKey();
    }

    public String getViewFormId() {
        return this.getBillViewFormKey();
    }

    private void handleSkill() {
        Boolean isSkill = (Boolean)this.getView().getFormShowParameter().getCustomParam("locationTransferSkill");
        if (Boolean.TRUE.equals(isSkill)) {
            QFilter qFilter = this.buildFilter();
            InQueryHelper.query((MobBizBillInfoTplPlugin)this, qFilter, "op_more", "scmcinvquery");
        }
    }

    protected void clickMobInvQueryOp(String operationKey, String opItemKey, String materialKey) {
        MobInvQueryHelper.clickMobInvQueryOp((MobBizBillInfoTplPlugin)this, operationKey, opItemKey, materialKey);
    }

    public void click(EventObject e) {
        this.editabilityPlugin.click(e);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        MobInvQueryHelper.closedCallBack((MobBizBillInfoTplPlugin)this, closedCallBackEvent);
        this.setMainEntryTitle();
    }

    public String getEntryFormKey() {
        return this.getEntryEditFormKey(this.getEntryEntity());
    }

    protected void initDataOfNewPcEntity(DynamicObject newPcEntity) {
        IDataModel model = this.getModel();
        String pcEntityKey = this.getPcEntityKey();
        MobileFormShowParameter param = (MobileFormShowParameter)this.getView().getFormShowParameter();
        Object orgId = param.getCustomParam("orgid");
        if (orgId == null) {
            orgId = RequestContext.get().getOrgId();
        }
        model.setValue("org", orgId);
        newPcEntity.set("org", this.getModel().getValue("org"));
        newPcEntity.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        long userId = UserServiceHelper.getCurrentUserId();
        model.setValue("creator", (Object)userId);
        newPcEntity.set("creator", model.getValue("creator"));
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        this.setSettleCurrency(org);
        DynamicObject currency = (DynamicObject)this.getModel().getValue("settlescurrency");
        newPcEntity.set("settlescurrency", (Object)currency);
        QFilter qFilter = new QFilter(BILL_FORM_ID, "=", (Object)pcEntityKey);
        qFilter.and(new QFilter(IS_DEFAULT, "=", (Object)"1"));
        DynamicObject billType = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_billtype", (QFilter[])qFilter.toArray());
        newPcEntity.set("billtype", (Object)billType);
        DynamicObject bizType = BizTypeHelper.getBizTypeByBillType((String)pcEntityKey, (DynamicObject)billType);
        newPcEntity.set(BIZTYPE, (Object)bizType);
        newPcEntity.set("biztime", (Object)new Date());
        newPcEntity.set(BOOK_DATE, newPcEntity.get("biztime"));
        Map<Object, DynamicObject> operatorGroupMap = this.getOperatorGroupMap(Long.valueOf(orgId.toString()));
        this.initDept(userId, Long.valueOf(orgId.toString()), operatorGroupMap, newPcEntity);
        this.initOperatorAndGroup(userId, operatorGroupMap, newPcEntity);
    }

    protected void newDefaultEntryRow(DynamicObject newPcEntity) {
        super.newDefaultEntryRow(newPcEntity);
        DynamicObject org = (DynamicObject)newPcEntity.get("org");
        String pcEntryKey = DataSourceConfigHelper.getPcEntryKey((DataSourceConfig)this.getDataSourceConfig(), (String)this.getEntryEntity());
        DynamicObjectCollection pcEntryCollection = newPcEntity.getDynamicObjectCollection(pcEntryKey);
        DynamicObject newPcEntryRow = pcEntryCollection.addNew();
        int currentEntryRowCount = pcEntryCollection.getRowCount();
        long generatedNewEntryId = DB.genLongId((String)pcEntryKey);
        newPcEntryRow.set("id", (Object)generatedNewEntryId);
        if (newPcEntryRow.containsProperty("seq")) {
            newPcEntryRow.set("seq", (Object)currentEntryRowCount);
        }
        Object warehouseId = this.getView().getFormShowParameter().getCustomParam("warehouseId");
        Object locationId = this.getView().getFormShowParameter().getCustomParam("locationId");
        if (warehouseId != null) {
            Long[] allWhs = MobImBillScanHelper.getAllWarehouseIds(this.getPcEntityKey(), Long.valueOf(org.getPkValue().toString()));
            QFilter warehouseF7Filter = WareHouseIsolateHelper.getCustomWarehouseF7Filter((String)String.valueOf(this.getPcEntityKey()), (DynamicObject)org) != null ? WareHouseIsolateHelper.getCustomWarehouseF7Filter((String)String.valueOf(this.getPcEntityKey()), (DynamicObject)org) : QFilterHelper.getIdentEqFilter();
            warehouseF7Filter.and(new QFilter("isopenlocation", "=", (Object)Boolean.TRUE));
            warehouseF7Filter.and(new QFilter("id", "in", (Object)allWhs));
            warehouseF7Filter.and(new QFilter("id", "=", warehouseId));
            DynamicObject warehouse = BusinessDataServiceHelper.loadSingle((String)"bd_warehouse", (QFilter[])warehouseF7Filter.toArray());
            newPcEntryRow.set("warehouse", (Object)warehouse);
            if (locationId != null && warehouse != null) {
                DynamicObjectCollection locationCol = warehouse.getDynamicObjectCollection("entryentity");
                List<Long> ids = ImBarCodeHandleHelper.getLocationIds(locationCol);
                QFilter locationFilter = new QFilter("id", "in", ids);
                newPcEntryRow.set(OUT_LOCATION, (Object)BusinessDataServiceHelper.loadSingle((String)"bd_location", (QFilter[])locationFilter.toArray()));
            }
        }
        LocationBillNewEntryHandler locationBillNewEntryHandler = new LocationBillNewEntryHandler();
        locationBillNewEntryHandler.initEntryRow(newPcEntity, newPcEntryRow, org);
    }

    private QFilter buildFilter() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Object warehouseId = this.getView().getFormShowParameter().getCustomParam("warehouseId");
        Object locationId = this.getView().getFormShowParameter().getCustomParam("locationId");
        QFilter invRealBalanceFilter = new QFilter("1", "=", (Object)SCMCBaseBillMobConst.IDENT_EQ_VAL);
        if (org != null) {
            invRealBalanceFilter.and(new QFilter("org.id", "=", org.getPkValue()));
        }
        if (warehouseId != null) {
            invRealBalanceFilter.and(new QFilter("warehouse.id", "=", warehouseId));
        }
        if (locationId != null) {
            invRealBalanceFilter.and(new QFilter("location.id", "=", locationId));
        }
        return invRealBalanceFilter;
    }

    private void initOperatorAndGroup(long userId, Map<Object, DynamicObject> operatorGroupMap, DynamicObject newPcEntity) {
        if (operatorGroupMap == null || operatorGroupMap.isEmpty()) {
            return;
        }
        QFilter qFilter = new QFilter("operatorgrpid", "in", operatorGroupMap.keySet());
        qFilter.and(new QFilter("operatorid", "=", (Object)userId));
        qFilter.and(new QFilter("invalid", "=", (Object)"0"));
        DynamicObject operator = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_operator", (QFilter[])new QFilter[]{qFilter});
        if (operator != null) {
            newPcEntity.set("operator", (Object)operator);
            QFilter filter = new QFilter("id", "=", (Object)operator.getLong("operatorgrpid"));
            DynamicObject operatorGroup = BusinessDataServiceHelper.loadSingleFromCache((String)BD_OPERATOR_GROUP, (QFilter[])new QFilter[]{filter});
            newPcEntity.set("operatorgroup", (Object)operatorGroup);
        }
    }

    private void initDept(long userId, Long orgId, Map<Object, DynamicObject> operatorGroupMap, DynamicObject newPcEntity) {
        if (operatorGroupMap.size() != 0) {
            QFilter qFilter11 = new QFilter("operatorgrpid", "in", operatorGroupMap.keySet());
            QFilter qFilter12 = new QFilter("operatorid", "=", (Object)userId);
            QFilter qFilter3 = new QFilter("invalid", "=", (Object)"0");
            DynamicObject operator = BusinessDataServiceHelper.loadSingle((String)"bd_operator", (String)"operatorid", (QFilter[])new QFilter[]{qFilter11, qFilter12, qFilter3});
            Long deptId = null == operator ? this.initDeptByOrg(orgId) : this.initDeptByOperator(operator, orgId);
            QFilter qFilter = new QFilter("id", "=", (Object)deptId);
            DynamicObject dept = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (QFilter[])new QFilter[]{qFilter});
            newPcEntity.set("dept", (Object)dept);
        }
    }

    private Long initDeptByOperator(DynamicObject operator, Long orgId) {
        List deptids = OrgUnitServiceHelper.getAllToOrg((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (String)OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType(), (Long)orgId, (boolean)true);
        if (deptids != null && !deptids.isEmpty()) {
            List userDeptIds = UserServiceHelper.getUserDepartment((long)((Long)operator.getDynamicObject("operatorid").getPkValue()), (boolean)Boolean.FALSE);
            if (userDeptIds != null && !userDeptIds.isEmpty()) {
                for (Long deptId : userDeptIds) {
                    if (!deptids.contains(deptId)) continue;
                    return deptId;
                }
            }
        } else {
            List userDeptIds = UserServiceHelper.getUserDepartment((long)((Long)operator.getDynamicObject("operatorid").getPkValue()), (boolean)Boolean.FALSE);
            if (userDeptIds != null && !userDeptIds.isEmpty()) {
                return (Long)userDeptIds.get(0);
            }
        }
        return null;
    }

    private Long initDeptByOrg(Long orgId) {
        List deptIds = OrgUnitServiceHelper.getAdminOrgRelation(Collections.singletonList(orgId), (boolean)true);
        if (deptIds != null && !deptIds.isEmpty()) {
            return (Long)deptIds.get(0);
        }
        deptIds = OrgUnitServiceHelper.getAllToOrg((String)OrgViewTypeEnum.IS_ORGUNIT.getViewType(), (String)OrgViewTypeEnum.IS_ADMINISTRATIVE.getViewType(), (Long)orgId, (boolean)true);
        if (deptIds != null && !deptIds.isEmpty() && deptIds.contains(orgId)) {
            return orgId;
        }
        return null;
    }

    private Map<Object, DynamicObject> getOperatorGroupMap(Long orgId) {
        String operatorGrpType = OperatorGrpTypeEnum.INVENTORYGRP.getValue();
        QFilter qFilter01 = BaseDataServiceHelper.getBaseDataFilter((String)BD_OPERATOR_GROUP, (Long)orgId);
        QFilter qFilter02 = new QFilter("operatorgrouptype", "=", (Object)operatorGrpType);
        qFilter02.and("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        return BusinessDataServiceHelper.loadFromCache((String)BD_OPERATOR_GROUP, (QFilter[])new QFilter[]{qFilter01, qFilter02});
    }

    private void setSettleCurrency(DynamicObject org) {
        Map currencyinfo;
        IDataModel model = this.getModel();
        if (org != null && (currencyinfo = CurrencyHelper.getCurrencyAndExRateTable((Long)org.getLong("id"))) != null) {
            model.setValue("settlescurrency", currencyinfo.get("baseCurrencyID"));
            return;
        }
        model.setValue("settlescurrency", (Object)1L);
    }

    public void updateData() {
        DynamicObject pcEntityCache = EntityCacheHelper.getPcEntityFromCache((IFormView)this.getView(), (String)this.getPcEntityKey());
        this.curData = new DynamicObject[]{pcEntityCache};
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        OperationResult operationResult = args.getOperationResult();
        switch (operateKey = args.getOperateKey()) {
            case "save": 
            case "submit": {
                if (args.getOperationResult().isSuccess()) {
                    if ("save".equals(operateKey)) {
                        this.updateBillId(args);
                        super.afterDoOperation(args);
                        this.afterSave(operationResult);
                        break;
                    }
                    super.afterDoOperation(args);
                    break;
                }
                this.updateData();
                break;
            }
            default: {
                super.afterDoOperation(args);
            }
        }
    }

    private void updateBillId(AfterDoOperationEventArgs args) {
        List successPkIds = args.getOperationResult().getSuccessPkIds();
        if (!successPkIds.isEmpty()) {
            Long currBillId = Long.valueOf(successPkIds.get(0).toString());
            IDataModel model = this.getModel();
            IPageCache pageCache = this.getPageCache();
            model.setValue("billid", (Object)currBillId);
            pageCache.put("pcId", String.valueOf(currBillId));
        }
    }

    private void afterSave(OperationResult operationResult) {
        if (operationResult.isSuccess()) {
            Boolean isModify = this.checkModifyPermission();
            if (Boolean.TRUE.equals(isModify)) {
                StringBuilder errMsg = new StringBuilder();
                Object pkId = operationResult.getSuccessPkIds().get(0);
                MutexHelper.require((IFormView)this.getView(), (String)this.getPcEntityKey(), pkId, (String)"modify", (boolean)Boolean.TRUE, (StringBuilder)errMsg);
                this.getPageCache().put("isFromList", "true");
            }
            DynamicObject pcEntityFromCache = EntityCacheHelper.getPcEntityFromCache((IMobilePage)this);
            DataSourceHelper.loadPcEntityToMobilePage((AbstractFormPlugin)this, (DynamicObject)pcEntityFromCache, (boolean)true);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (key) {
            case "biztype": {
                this.beforeBizTypeSelect(showParameter);
                break;
            }
        }
    }

    private void beforeBizTypeSelect(ListShowParameter showParameter) {
        DynamicObject entity = EntityCacheHelper.getPcEntityFromCache((IFormView)this.getView(), (String)this.getPcEntityKey());
        DynamicObject billType = entity.getDynamicObject("billtype");
        if (billType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u5355\u636e\u7c7b\u578b\u3002", (String)"select_biz_type", (String)"scmc-mobim-form", (Object[])new Object[0]));
        }
        List bizTypeIds = BizTypeHelper.getBizTypeIds((Object)billType.getPkValue(), (String)"im_locationtransfer");
        if (bizTypeIds != null) {
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)bizTypeIds));
        }
    }
}

