/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.locationtransfer;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scmc.im.business.helper.WareHouseIsolateHelper;
import kd.scmc.mobim.business.helper.QFilterHelper;
import kd.scmc.mobim.business.helper.scan.ImBarCodeHandleHelper;
import kd.scmc.mobim.common.utils.FormUtils;
import kd.scmc.mobim.plugin.form.handler.locationbill.LocationBillChangeHandler;
import kd.scmc.mobim.plugin.form.locationtransfer.ILocationTransBillPagePlugin;
import kd.scmc.mobim.plugin.form.tpl.MobImTransformBillBeforeF7Select;
import kd.scmc.mobim.plugin.tpl.imtpl.MobImBillEntryEditPlugin;

public class LocationTransferEntryEditPlugin
extends MobImBillEntryEditPlugin
implements ILocationTransBillPagePlugin,
BeforeF7SelectListener {
    private static final String OUT_LOCATION = "outlocation";
    public static final String LOCATION = "location";
    private static final String OUT_LOCATION_FLEX = "outscanlocationflex";
    private static final String SCANLOCATIONFLEX = "scanlocationflex";
    private static final String WAREHOUSE_SCAN = "warehousescan";
    private static final String OUT_LOCATION_SCAN = "outlocationscan";
    private static final String LOCATION_SCAN = "locationscan";

    public LocationTransferEntryEditPlugin() {
        this.registerPropertyChangedHandler(new LocationBillChangeHandler());
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener(this, LOCATION, OUT_LOCATION);
        this.addClickListeners(new String[]{WAREHOUSE_SCAN, OUT_LOCATION_SCAN, LOCATION_SCAN});
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject warehouse = (DynamicObject)this.getModel().getValue("warehouse");
        if (warehouse != null) {
            boolean isopenlocation = warehouse.getBoolean("isopenlocation");
            this.getView().setVisible(Boolean.valueOf(isopenlocation), new String[]{OUT_LOCATION_FLEX, SCANLOCATIONFLEX});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{OUT_LOCATION_FLEX, SCANLOCATIONFLEX});
        }
    }

    @Override
    public List<String> getFieldKeys() {
        List<String> fieldKeys = super.getFieldKeys();
        ArrayList<String> keys = new ArrayList<String>(8);
        keys.add("lotnumber");
        keys.add(OUT_LOCATION);
        keys.addAll(fieldKeys);
        return keys;
    }

    @Override
    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        IDataModel model = this.getModel();
        String eventName = e.getEventName();
        String value = e.getEventArgs();
        String key = e.getKey();
        IPageCache pageCache = this.getView().getPageCache();
        if ("callAppMethod".equals(key) && "scanQRCode".equals(eventName)) {
            Map result = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
            Object codeStr = result.get("qrcode_str");
            String scanKey = pageCache.get("scan_key");
            int rowindex = this.getModel().getEntryCurrentRowIndex(this.getEntryEntity());
            DynamicObject warehouse = (DynamicObject)model.getValue("warehouse", rowindex);
            switch (scanKey) {
                case "outlocationscan": {
                    DynamicObject inLocation = (DynamicObject)model.getValue(LOCATION);
                    QFilter inFilter = inLocation != null ? new QFilter("id", "!=", inLocation.getPkValue()) : QFilterHelper.getIdentEqFilter();
                    Object outLocationId = ImBarCodeHandleHelper.getLocationIdByBarCode(String.valueOf(codeStr), warehouse, inFilter);
                    model.setValue(OUT_LOCATION, outLocationId);
                    this.showScanSuccessTip();
                    break;
                }
            }
        }
    }

    @Override
    public QFilter getWarehouseFilter() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        QFilter warehouseF7Filter = WareHouseIsolateHelper.getCustomWarehouseF7Filter((String)String.valueOf(this.getPcEntityKey()), (DynamicObject)org) != null ? WareHouseIsolateHelper.getCustomWarehouseF7Filter((String)String.valueOf(this.getPcEntityKey()), (DynamicObject)org) : QFilterHelper.getIdentEqFilter();
        warehouseF7Filter.and(new QFilter("isopenlocation", "=", (Object)Boolean.TRUE));
        return warehouseF7Filter;
    }

    @Override
    public QFilter getLocationFilter() {
        DynamicObject outLocation = (DynamicObject)this.getModel().getValue(OUT_LOCATION);
        return outLocation != null ? new QFilter("id", "!=", outLocation.getPkValue()) : QFilterHelper.getIdentEqFilter();
    }

    public void beforeSelectLocation(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        int rowindex = this.getModel().getEntryCurrentRowIndex(this.getEntryEntity());
        DynamicObject warehouse = (DynamicObject)model.getValue("warehouse", rowindex);
        this.addSelectLocationFilter(e);
        this.commonLocationFilter(warehouse, e);
    }

    private void commonLocationFilter(DynamicObject warehouse, BeforeF7SelectEvent e) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if (warehouse == null) {
            e.setCancel(true);
        } else {
            DynamicObjectCollection locationCol = warehouse.getDynamicObjectCollection("entryentity");
            List<Long> ids = ImBarCodeHandleHelper.getLocationIds(locationCol);
            QFilter qFilter = new QFilter("id", "in", ids);
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put("scan_key", key);
    }

    private void addSelectLocationFilter(BeforeF7SelectEvent e) {
        int row = e.getRow();
        IDataModel model = this.getModel();
        String key = e.getProperty().getName();
        DynamicObject localtion = null;
        if (LOCATION.equals(key)) {
            localtion = (DynamicObject)model.getValue(OUT_LOCATION, row);
        } else if (OUT_LOCATION.equals(key)) {
            localtion = (DynamicObject)model.getValue(LOCATION, row);
        }
        if (localtion == null) {
            return;
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        QFilter qFilter = new QFilter("id", "!=", localtion.getPkValue());
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey;
        super.beforeF7Select(e);
        switch (fieldKey = e.getProperty().getName()) {
            case "location": 
            case "outlocation": {
                this.beforeSelectLocation(e);
                break;
            }
            case "warehouse": {
                ListShowParameter cardF7Param = (ListShowParameter)e.getFormShowParameter();
                ListFilterParameter listFilterParameter = cardF7Param.getListFilterParameter();
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                String formId = this.getPcEntityKey();
                MobImTransformBillBeforeF7Select f7Select = new MobImTransformBillBeforeF7Select(this.getView());
                f7Select.beforeF7Select(e, formId, org);
                listFilterParameter.getQFilters().add(new QFilter("isopenlocation", "=", (Object)Boolean.TRUE));
                WareHouseIsolateHelper.setWareHouseIsolateF7Filter((String)formId, (DynamicObject)org, (ListShowParameter)cardF7Param);
                break;
            }
            case "material": {
                super.beforeF7Select(e);
                break;
            }
        }
    }
}

