/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.materialpickoutbill;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.business.helper.LineTypeHelper;
import kd.scmc.mobim.plugin.form.handler.ImBillChangedHandler;
import kd.scmc.mobim.plugin.form.handler.ImBillNewEntryHandler;
import kd.scmc.mobim.plugin.form.handler.SettleCurrencyPropertyChangedHandler;
import kd.scmc.mobim.plugin.form.materialpickoutbill.IMaterialPickOutBillPagePlugin;
import kd.scmc.mobim.plugin.form.materialpickoutbill.InventoryChangedHandler;
import kd.scmc.mobim.plugin.form.tpl.MobImBillHandelQrCode;
import kd.scmc.mobim.plugin.tpl.imtpl.MobImBillInfoPlugin;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import kd.scmc.msmob.business.helper.change.handler.IEntryRowAddedHandler;
import kd.scmc.msmob.plugin.tpl.basetpl.IMobBillEditable;

public class MaterialPickOutBillEditPlugin
extends MobImBillInfoPlugin
implements IMaterialPickOutBillPagePlugin,
IMobBillEditable {
    public MaterialPickOutBillEditPlugin() {
        this.registerPropertyChangedHandler(new InventoryChangedHandler());
        this.registerPropertyChangedHandler(new SettleCurrencyPropertyChangedHandler());
        this.registerEntryRowAddedHandler(new ImBillNewEntryHandler());
        this.registerPropertyChangedHandler(new ImBillChangedHandler());
    }

    public Long getBillId() {
        IDataModel model = this.getModel();
        Object billId = model.getValue("billid");
        if (billId == null || billId.equals(0L)) {
            IFormView view = this.getView();
            FormShowParameter formShowParameter = view.getFormShowParameter();
            Map customParams = formShowParameter.getCustomParams();
            billId = customParams.get("billid");
        }
        return billId == null ? 0L : Long.parseLong(billId.toString());
    }

    public String getEntryFormKey() {
        String entryKey = this.getEntryEntity();
        return this.getEntryEditFormKey(entryKey);
    }

    protected void handleQrCode(Object code) {
        super.handleQrCode(code);
        String pcEntityKey = this.getPcEntityKey();
        String entryKey = this.getEntryEntity();
        IEntryRowAddedHandler entryRowAddedHandler = this.getEntryRowAddedHandler();
        MobImBillHandelQrCode.handleQrCode(code, pcEntityKey, entryKey, this, entryRowAddedHandler);
    }

    public String getViewFormId() {
        return this.getBillViewFormKey();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "newentry": {
                DynamicObject pcEntityFromCache = EntityCacheHelper.getPcEntityFromCache((IFormView)this.getView(), (String)this.getPcEntityKey());
                String pcEntryEntityKey = this.getView().getPageCache().get(this.getEntryEntity());
                DynamicObject newPcEntryRow = (DynamicObject)pcEntityFromCache.getDynamicObjectCollection(pcEntryEntityKey).get(this.getModel().getEntryCurrentRowIndex(this.getEntryEntity()));
                this.newEntrySetValue(newPcEntryRow, pcEntityFromCache);
                this.setMainEntryTitle();
                break;
            }
            case "save": 
            case "submit": {
                OperationResult operationResult = args.getOperationResult();
                if (!this.isPush() || !operationResult.isSuccess()) break;
                Long billId = (Long)operationResult.getSuccessPkIds().get(0);
                DynamicObject pushedPcEntity = EntityCacheHelper.getPcEntityObject((Long)billId, (String)this.getPcEntityKey());
                EntityCacheHelper.savePcEntityToPageCache((IFormView)this.getView(), (DynamicObject)pushedPcEntity);
                break;
            }
        }
    }

    private void newEntrySetValue(DynamicObject newPcEntryRow, DynamicObject pcEntity) {
        this.initNewEntryLineType(pcEntity, newPcEntryRow);
    }

    private void initNewEntryLineType(DynamicObject pcEntity, DynamicObject newPcEntryRow) {
        if (pcEntity == null) {
            return;
        }
        DynamicObject bizType = pcEntity.getDynamicObject("biztype");
        if (bizType == null) {
            return;
        }
        Long bizTypeId = bizType.getLong("id");
        Long lineTypeId = LineTypeHelper.getDefaultLineType((Long)bizTypeId);
        DynamicObject lineType = BusinessDataServiceHelper.loadSingleFromCache((Object)lineTypeId, (String)"bd_linetype");
        newPcEntryRow.set("linetype", (Object)lineType);
        EntityCacheHelper.savePcEntityToPageCache((IFormView)this.getView(), (DynamicObject)pcEntity);
    }
}

