/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.materialpickoutbill;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.scmc.im.business.helper.MaterialHelper;
import kd.scmc.mobim.common.utils.BotpUtils;
import kd.scmc.mobim.common.utils.FormUtils;
import kd.scmc.mobim.plugin.form.handler.ImBillChangedHandler;
import kd.scmc.mobim.plugin.form.handler.SettleCurrencyPropertyChangedHandler;
import kd.scmc.mobim.plugin.form.materialpickoutbill.IMaterialPickOutBillPagePlugin;
import kd.scmc.mobim.plugin.form.materialpickoutbill.InventoryChangedHandler;
import kd.scmc.mobim.plugin.form.materialpickoutbill.MaterialPickOutBillEntryViewPlugin;
import kd.scmc.mobim.plugin.form.tpl.MobImBillBeforeF7Select;
import kd.scmc.mobim.plugin.tpl.imtpl.handler.ImBillEntryExpirationDateChangeHandler;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import kd.scmc.msmob.business.helper.change.IMobilePage;
import kd.scmc.msmob.plugin.tpl.basetpl.IMobBillEditable;

public class MaterialPickOutBillEntryEditPlugin
extends MaterialPickOutBillEntryViewPlugin
implements BeforeF7SelectListener,
IMaterialPickOutBillPagePlugin,
IMobBillEditable {
    private static final String[] F7_FIELD_KEYS = new String[]{"warehouse", "location", "material"};

    public MaterialPickOutBillEntryEditPlugin() {
        this.registerPropertyChangedHandler(new InventoryChangedHandler());
        this.registerPropertyChangedHandler(new SettleCurrencyPropertyChangedHandler());
        this.registerPropertyChangedHandler(new ImBillChangedHandler());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addF7Listener(this, F7_FIELD_KEYS);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView pcEntityStorageView = this.getPcEntityStorageView();
        String pcEntityKey = this.getPcEntityKey();
        IFormView view = this.getView();
        BotpUtils.setEnableByBotp(view, pcEntityStorageView, pcEntityKey, "material");
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        MobImBillBeforeF7Select selector = new MobImBillBeforeF7Select(this.getView());
        DynamicObject bill = EntityCacheHelper.getPcEntityFromCache((IMobilePage)this);
        String pcEntityKey = this.getPcEntityKey();
        IPageCache pageCache = this.getView().getPageCache();
        int rowIndex = Integer.parseInt(pageCache.get("row"));
        selector.beforeF7Select(e, pcEntityKey, rowIndex, bill);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        this.registerPropertyChangedHandler(new ImBillEntryExpirationDateChangeHandler(this.getView(), this.getPcEntityKey()));
        super.propertyChanged(e);
        switch (fieldKey = e.getProperty().getName()) {
            case "material": {
                DynamicObject material = (DynamicObject)this.getModel().getValue("material");
                DynamicObject unit = MaterialHelper.getMaterialBizUnit((DynamicObject)material);
                this.getModel().setValue("unit", (Object)unit);
                break;
            }
        }
    }

    @Deprecated
    public DynamicObject getBill() {
        DynamicObject pcEntityFromCache = EntityCacheHelper.getPcEntityFromCache((IFormView)this.getParentView(), (String)this.getPcEntityKey());
        return pcEntityFromCache;
    }
}

