/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.materialpickoutbill;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.scmc.mobim.business.helper.InverseBillHelper;
import kd.scmc.mobim.business.helper.VisibleAbilityHelper;
import kd.scmc.mobim.common.utils.DateUtils;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import kd.scmc.msmob.business.helper.change.DataChangedHandlerHelper;
import kd.scmc.msmob.business.helper.change.IMobilePage;
import kd.scmc.msmob.plugin.tpl.basetpl.EntryEditTplPlugin;

public class MaterialPickOutBillEntryViewPlugin
extends EntryEditTplPlugin {
    private static final String FLEX_AUPXTY = "aupxtyflexpanel";
    private static final String[] MODEL_FIELD_KEYS = new String[]{"billid", "pcentitykey", "material", "qty", "unit", "lotnumber", "warehouse", "location", "producedate", "expirydate", "invscheme"};
    private static final String[] INVERSE_COLUMNS = new String[]{"qty"};
    private VisibleAbilityHelper visibleAbilityHelper;

    public void initialize() {
        super.initialize();
        this.visibleAbilityHelper = new VisibleAbilityHelper(this.getView(), this.getModel());
    }

    public String getEntryEntity() {
        return "entryentity";
    }

    public List<String> getFieldKeys() {
        return Arrays.asList(MODEL_FIELD_KEYS);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        InverseBillHelper.setInverseHeadColumnColorByPcEntity(this.getView(), EntityCacheHelper.getPcEntityFromCache((IMobilePage)this), INVERSE_COLUMNS);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.visibleAbilityHelper.setVisibleAbility();
    }

    public void click(EventObject evt) {
        super.click(evt);
        this.visibleAbilityHelper.setVisibleAbility();
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        MessageBoxResult result = e.getResult();
        switch (callBackId) {
            case "materialLifeDate": {
                this.materialDateChangedConfirmCallBack(result, e.getCustomVaule());
                break;
            }
        }
    }

    private void materialDateChangedConfirmCallBack(MessageBoxResult result, String customValue) {
        Map dateChangedConfirmMap = (Map)SerializationUtils.fromJsonString((String)customValue, Map.class);
        Date newExpiryDate = DateUtils.parseShortDate((String)dateChangedConfirmMap.get("newExpiryDate"), false);
        Date newProduceDate = DateUtils.parseShortDate((String)dateChangedConfirmMap.get("newProduceDate"), false);
        int changedRowIndex = (Integer)dateChangedConfirmMap.get("changedRowIndex");
        boolean confirmed = MessageBoxResult.Yes.equals((Object)result);
        DataChangedHandlerHelper.setEntryValueManual((AbstractMobFormPlugin)this, (String)this.getPcEntityKey(), (int)changedRowIndex, (pcEntityFromCache, changedEntry) -> {
            changedEntry.set("expirydate", (Object)(confirmed ? newExpiryDate : null));
            changedEntry.set("producedate", (Object)(confirmed ? newProduceDate : null));
        });
    }
}

