/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.mdc.inbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.mobim.plugin.form.handler.ManufactureChangedHandler;
import kd.scmc.mobim.plugin.tpl.imtpl.MobImBillEntryEditPlugin;

public class ManufactureOrderInBillEntryEditPlugin
extends MobImBillEntryEditPlugin {
    public ManufactureOrderInBillEntryEditPlugin() {
        this.registerPropertyChangedHandler(new ManufactureChangedHandler());
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"snflex", "vectorap"});
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.handleVisible();
    }

    private void handleVisible() {
        Object material = this.getModel().getValue("material");
        boolean isEnableSerial = material != null && ManufactureOrderInBillEntryEditPlugin.isEnableSerial((DynamicObject)material);
        this.getView().setVisible(Boolean.valueOf(isEnableSerial), new String[]{"snflex"});
    }

    @Override
    public List<String> getFieldKeys() {
        List<String> fieldKeys = super.getFieldKeys();
        ArrayList<String> keys = new ArrayList<String>(32);
        keys.add("manubill");
        keys.addAll(fieldKeys);
        return keys;
    }

    @Override
    public void click(EventObject e) {
        String key;
        this.getModel().beginInit();
        super.click(e);
        Control c = (Control)e.getSource();
        switch (key = c.getKey()) {
            case "snflex": 
            case "vectorap": {
                this.snClick();
                break;
            }
        }
    }

    protected void goPreviousOrGoNext(String key) {
        super.goPreviousOrGoNext(key);
        this.handleVisible();
        this.getModel().endInit();
        this.getView().updateView();
    }

    protected void snClick() {
        DynamicObject bill = this.getBill();
        Object pkValue = bill.getPkValue();
        String billtype = bill.getDataEntityType().getName();
        String entryName = "billentry";
        DynamicObject org = ManufactureOrderInBillEntryEditPlugin.getBillMainOrg(bill, billtype);
        String row = this.getPageCache().get("row");
        int index = Integer.parseInt(row);
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection(entryName);
        DynamicObject entry = (DynamicObject)entrys.get(index);
        DynamicObject material = entry.getDynamicObject("material");
        DynamicObject baseUnit = entry.getDynamicObject("baseunit");
        BigDecimal baseQty = entry.getBigDecimal("baseqty");
        IFormView view = this.getView();
        if (material == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7269\u6599\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u7269\u6599\u3002", (String)"MaterialIsNull", (String)"scmc-mobim-form", (Object[])new Object[0]));
            return;
        }
        if (!ManufactureOrderInBillEntryEditPlugin.isEnableSerial(material)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7269\u6599\u672a\u542f\u7528\u5e8f\u5217\u53f7\u7ba1\u7406\uff0c\u65e0\u6cd5\u5904\u7406\u5e8f\u5217\u53f7\u3002", (String)"UnEnableSerialCanNotHandleSerialNumber", (String)"scmc-mobim-form", (Object[])new Object[0]));
            return;
        }
        if (baseUnit == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u91cf\u5355\u4f4d\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u8ba1\u91cf\u5355\u4f4d\u3002", (String)"UnitIsNull", (String)"scmc-mobim-form", (Object[])new Object[0]));
            return;
        }
        boolean exists = QueryServiceHelper.exists((String)this.getPcEntityKey(), (Object)pkValue);
        if (!exists) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u672a\u4fdd\u5b58\uff0c\u65e0\u6cd5\u6dfb\u52a0\u5e8f\u5217\u53f7,\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"unSaveSerialNumber", (String)"scmc-mobim-form", (Object[])new Object[0]));
            return;
        }
        Object entryid = entry.getPkValue();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("material", material.getPkValue());
        param.put("unit", baseUnit.getPkValue());
        param.put("qty", baseQty.intValue());
        param.put("billid", pkValue);
        param.put("billtype", billtype);
        param.put("entryid", entryid);
        param.put("entrykey", entryName);
        param.put("invorg", org != null ? org.getPkValue() : null);
        MobileFormShowParameter billShowParameter = new MobileFormShowParameter();
        billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "snclose"));
        billShowParameter.setFormId("mobim_serialnumberedit");
        billShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        billShowParameter.setCustomParams(param);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    public static boolean isEnableSerial(DynamicObject material) {
        if (material == null) {
            return false;
        }
        return material.getBoolean("enableserial");
    }

    private static DynamicObject getBillMainOrg(DynamicObject bill, String billtype) {
        DynamicObject org = "im_transdirbill".equals(billtype) ? (DynamicObject)bill.get("outorg") : (DynamicObject)bill.get("org");
        return org;
    }
}

