/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.mdc.inbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.scmc.mobim.plugin.tpl.imtpl.MobImBillEntryViewPlugin;

public class ManufactureOrderInBillEntryViewPlugin
extends MobImBillEntryViewPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"snflex", "vectorap"});
    }

    @Override
    public List<String> getFieldKeys() {
        List<String> fieldKeys = super.getFieldKeys();
        ArrayList<String> keys = new ArrayList<String>(32);
        keys.add("manubill");
        keys.addAll(fieldKeys);
        return keys;
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.handleVisible();
    }

    private void handleVisible() {
        Object material = this.getModel().getValue("material");
        boolean isEnableSerial = material != null && ManufactureOrderInBillEntryViewPlugin.isEnableSerial((DynamicObject)material);
        this.getView().setVisible(Boolean.valueOf(isEnableSerial), new String[]{"snflex"});
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if ("godownuo".equals(key) || "goupop".equals(key)) {
            this.handleVisible();
        }
        if ("snflex".equals(key) || "vectorap".equals(key)) {
            DynamicObject bill = this.getBill();
            Object pkValue = bill.getPkValue();
            String billtype = bill.getDataEntityType().getName();
            String entryName = "billentry";
            DynamicObject org = ManufactureOrderInBillEntryViewPlugin.getBillMainOrg(bill, billtype);
            String row = this.getPageCache().get("row");
            int index = Integer.parseInt(row);
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            DynamicObject entry = (DynamicObject)entrys.get(index);
            DynamicObject material = entry.getDynamicObject("material");
            DynamicObject baseUnit = entry.getDynamicObject("baseunit");
            BigDecimal baseQty = entry.getBigDecimal("baseqty");
            IFormView view = this.getView();
            Object entryid = entry.getPkValue();
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("material", material.getPkValue());
            param.put("unit", baseUnit.getPkValue());
            param.put("qty", baseQty.intValue());
            param.put("billid", pkValue);
            param.put("billtype", billtype);
            param.put("entryid", entryid);
            param.put("entrykey", entryName);
            param.put("invorg", org != null ? org.getPkValue() : null);
            MobileFormShowParameter billShowParameter = new MobileFormShowParameter();
            billShowParameter.setFormId("mobim_serialnumberview");
            billShowParameter.getOpenStyle().setShowType(ShowType.Floating);
            billShowParameter.setCustomParams(param);
            view.showForm((FormShowParameter)billShowParameter);
        }
    }

    public static boolean isEnableSerial(DynamicObject material) {
        if (material == null) {
            return false;
        }
        return material.getBoolean("enableserial");
    }

    private static DynamicObject getBillMainOrg(DynamicObject bill, String billtype) {
        DynamicObject org = "im_transdirbill".equals(billtype) ? (DynamicObject)bill.get("outorg") : (DynamicObject)bill.get("org");
        return org;
    }
}

