/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.plugin.form.mdc.inbill;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.mobim.plugin.tpl.imtpl.MobImBillInfoPlugin;
import org.apache.commons.lang.StringUtils;

public class ManufactureOrderInBillViewPlugin
extends MobImBillInfoPlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"entersnnumber"});
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.handleVisible();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject bill = this.curData[0];
        DynamicObjectCollection enters = bill.getDynamicObjectCollection("billentry");
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        for (int i = 0; i < enters.size(); ++i) {
            this.countSNNumber(bill, enters, cardEntry, i);
        }
    }

    private void countSNNumber(DynamicObject bill, DynamicObjectCollection enters, CardEntry cardEntry, int i) {
        DynamicObject entry = (DynamicObject)enters.get(i);
        DynamicObject material = entry.getDynamicObject("material");
        boolean enableSerial = ManufactureOrderInBillViewPlugin.isEnableSerial(material);
        cardEntry.setChildVisible(enableSerial, i, new String[]{"serialnumber"});
        if (enableSerial) {
            Object pkValue = bill.getPkValue();
            String billType = bill.getDataEntityType().getName();
            String entryName = "billentry";
            Object entryId = entry.getPkValue();
            QFilter filter = new QFilter("billtype", "=", (Object)billType).and("entrykey", "=", (Object)entryName).and("billid", "=", pkValue).and("entryid", "=", entryId);
            DynamicObject billSNRelation = BusinessDataServiceHelper.loadSingle((String)"sbs_billsnrelation", (String)"id,entryentity,entryentity.snnumber", (QFilter[])filter.toArray());
            if (billSNRelation == null) {
                String str = ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\uff08\u5171%s\u4e2a\uff09\uff1a", (String)"MobBillSerialNumber_1", (String)"scmc-mobim-form", (Object[])new Object[0]);
                String text = String.format(str, 0);
                this.getModel().setValue("serialnumber", (Object)text, i);
            } else {
                DynamicObjectCollection snEnters = billSNRelation.getDynamicObjectCollection("entryentity");
                if (snEnters == null || snEnters.size() == 0) {
                    String str = ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\uff08\u5171%s\u4e2a\uff09\uff1a", (String)"MobBillSerialNumber_1", (String)"scmc-mobim-form", (Object[])new Object[0]);
                    String text = String.format(str, 0);
                    this.getModel().setValue("serialnumber", (Object)text, i);
                } else {
                    int size = snEnters.size();
                    ArrayList<String> numbers = new ArrayList<String>(size);
                    for (DynamicObject snEnter : snEnters) {
                        String snNumber = snEnter.getString("snnumber");
                        numbers.add(snNumber);
                    }
                    String str = ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\uff08\u5171%s\u4e2a\uff09\uff1a", (String)"MobBillSerialNumber_1", (String)"scmc-mobim-form", (Object[])new Object[0]);
                    String text = String.format(str, size);
                    this.getModel().setValue("serialnumber", (Object)(text + StringUtils.join(numbers, (String)",")), i);
                }
            }
        }
    }

    private void handleVisible() {
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        DynamicObject dyn = this.getModel().getDataEntity(true);
        DynamicObjectCollection enters = dyn.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < enters.size(); ++i) {
            DynamicObject entry = (DynamicObject)enters.get(i);
            DynamicObject material = entry.getDynamicObject("material");
            cardEntry.setChildVisible(ManufactureOrderInBillViewPlugin.isEnableSerial(material), i, new String[]{"entersnnumber"});
        }
    }

    public static boolean isEnableSerial(DynamicObject material) {
        if (material == null) {
            return false;
        }
        return material.getBoolean("enableserial");
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        this.handleVisible();
        DynamicObject bill = this.getBill();
        DynamicObjectCollection entries = bill.getDynamicObjectCollection("billentry");
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        for (int i = 0; i < entries.size(); ++i) {
            DynamicObject entry = (DynamicObject)entries.get(i);
            DynamicObject material = entry.getDynamicObject("material");
            boolean enableSerial = ManufactureOrderInBillViewPlugin.isEnableSerial(material);
            cardEntry.setChildVisible(enableSerial, i, new String[]{"serialnumber"});
        }
    }

    public String getEntryFormKey() {
        return "mobim_mftmanuinentryview";
    }

    public String getEditFormId() {
        return "mobim_mdc_mftmanuinedit";
    }
}

